# Sovereign Proteron Autarchy

Formed from the former Great House Proteron, the Sovereign Proteron Autarchy played a pivotal role in the history of the universe.
It arose from an Emperor's desire to create a revolution in the sphere of society and societal structure.
The project performed all too well, creating a Great House that surpassed its progenitor in nearly every way, and chafing at its restraints.
These tensions escalated into all-out war, with devastating consequences to both bodies, because neither have the Proteron heard of restraint nor the Emperor of caution.

## The Facts

* Leader: High Autarch Python
* Leading Structure: Circle of Autarchs
* Government: Autarchy
* Formation: UST 47
* Homeworld: <!-- TODO: find the actual homeworld-->
* Important Figures:
    * Autarchs
      * HA Python

### House Proteron Society

House Proteron worlds were governed by a totalitarian regime that required its citizens to follow their dictated daily routines, severely punishing transgressions under a zero-tolerance policy. A Proteron citizen was never their own person. They were an asset of the government, their life's labor neatly represented in a book keeping column somewhere. Even the details of their private life were managed and tallied by the authorities. Despite the lack of freedom and privacy, Proteron citizens were not slaves. The government kept them in top shape, providing an adequate supply of health care, relaxation, and entertainment, making sure all predispositions and tastes were catered for. This kept citizens happy to trade independence and privacy for comfort and security. As such, a subject was often able and willing to work at optimal performance. A Proteron citizen's life was thus quite a satisfying one, though excitement otherwise than the terminal kind was rare.

House Proteron's worlds were all specialist worlds. They were geared to performing a limited selection of tasks according to the planet's natural properties or location. The inhabitants on a world were placed there by the government. Each individual was measured and tested, then sent to the world where they could be of the most use. As such, Proteron society was built of individuals rather than families - a family would only have complicated the relocation process.

The local planetary governments were directly responsible to an Autarch. An Autarch managed many worlds as a sector, with the number depending on how densely populated and productive the worlds were. Once every four cycles all the Proteron Autarchs met in a Circle. During these meeting, the Autarchs would evaluate the development of each Proteron world individually as well as that of the greater Proteron body in general. Based on this evaluation, goals were set for the next four cycles. Each Autarch was expected to meet or exceed these goals, and those Autarchs who failed to do so were removed from office - in a very permanent manner.

For day-to-day and urgent decisions that could not wait for many cycles, and further to ensure that the Circle did not become complacent, the Proteron also had a High Autarch. They and the Circle were supposed to balance each other's power.

### History

When the Empire was still the undisputed power in the galaxy, it knew it could not last unless it was prepared to change with the times. As the people lived, adapted and expanded through the universe, there would undoubtedly be problems that could not be addressed by an antiquated regime. A repetition of the Faction Wars was to be avoided at all costs. Therefore, the Empire set up Project Proteron, an experimental environment to test new forms of government and galactic administration. The purpose of Project Proteron was to be the test-bed of the "next generation" Empire, an improved form of government that would keep the galaxy stable and under the rule of the Emperor.

Project Proteron was limited to a few worlds at first, on the basis that a galactic government could only succeed given stable planetary governments. Soon, however, the scope of the project expanded as its overseers came to the conclusion that planetary government needed to be designed simultaneously with galaxy-wide administration. Within a decade of its inception, the worlds assigned to Project Proteron numbered more than a dozen.

The Empire, eager to see results, continued to push the experiment to work faster and more efficiently. As a direct result of this, the more liberal, decentralised processes were eliminated from the test roster, and more emphasis was put on controlled, high-yield social structures. More and more planets were added to the project, its populations relocated, re-educated and re-assigned for a better turnout. The concepts of personal liberties and privacy became more and more secondary to the collective performance, and eventually were abandoned altogether by those who led the Project.

The expansion and results of the Project led the then Emperor to promote Project Proteron from an Empire-commissioned Project to a full-fledged, independent Great House. The philosophy was that House Proteron would eventually become a prototype for the New Empire, and once all the bugs were ironed out, its model would be implemented in the entire known galaxy and House Proteron would once again be part of the greater Empire.

#### The Sovereign Proteron Autarchy and the Incident

With its new title, House Proteron enjoyed more freedom and independence than it had so far, ironically. Its leaders eagerly made use of their increased authority, further fine-tuning House Proteron for economic and industrial efficiency as well as social control. Taxes were levied. Ships were built. A well-oiled military machine and intelligence agency were created from scratch, securing House Proteron from hostile influences from within and without. In only a few decades, House Proteron had become a powerful diplomatic and economic factor in the galaxy.

As time passed, House Proteron began to notice the cracks in the old Empire. Already unhappy with the Emperor's reticence in dealing decisively with the Sirii, the Empire's handling of the Dvaered disgusted the Proteron. Rather than reassigning the workers and improving their living standards to allow them to reach their true potential, the Empire gave up on them. In addition, it had been centuries since the Za'lek had given more than the cursory nod to Imperial authority. The House generally blamed the Empire's social structure for its inability to command the loyalty of its subjects. The House, on the other hand, had grown by leaps and bounds, claiming more and more space for their systems, even bordering Sol. The final straw was the Quarantine of Sorom, where the Empire simply laid down and let a disease claim a whole planet.

Some debate followed, but the consensus was that House Proteron had achieved its original goal, and now it was time for the weak Empire to make way for the new generation of galactic dominance. But when the Proteron High Autarch delivered this message to the Emperor, he was furious at the perceived insult and ordered all Autarchs executed. Appalled at this reaction, the Circle concluded in an emergency meeting that the Empire had no intention of honoring the original agreement, thereby forfeiting its claim to the loyalty of House Proteron. It was clear to the Circle that should the Empire insist on trying to turn the Proteron into another Dvaered incident or, worse still, turning them into Empire systems, there could be no peace with them.

Knowing that they could not at the time resist the entire might of the Empire's infrastructure, the Proteron decided to plant their agents in every major Imperial agency while publicly grovelling at the Empire's feet. Soon enough, the Proteron were even in charge of the Empire's covert operations against the Proteron. Now having loosened their leash greatly, they set out to prepare for a galaxy-scale war. While they worked, the shape of the galaxy was changing, so to speak.

New advances in quantum engineering led to the development of quantum transtators and translators, alternative travel engines capable of bypassing warp points and so changing conventional military doctrine, which recommended fortifying chokepoint systems on the warp network. Expecting correctly that the Empire had not even thought of this change, the Proteron decided to bypass their defences using the new hypergate being built in Sol. After all, once the Emperor and their successors were in their hands, the war would be essentially meaningless. They built a hypergate in secret in their home system, Protera. They seceded from Imperial authority as soon as the gate was built and moved a small fleet as a feint into the classical defences. When the Empire took the bait, the Sovereign Proteron Autarchy, as they now styled themselves, sent the most massive fleet ever seen through their hypergate.

Then the Incident occured.

After the dust settled, Protera was inaccessible, Sol was unreachable, their planets, factories and fleets had been decimated and the Circle was mostly gone. Thankfully, enough of the hierarchy remained that society did not dissolve. The Proteron scientists set out to determine the cause of the Incident, and their best answer is that the large number of ships travelling all at once through the hypergate overloaded it, causing Sol to explode with a huge mass of material, causing a chain reaction that obliterated systems and changed the warp network. On the other hand, Protera was visible with no occlusion by the Nebula, but every scout they sent started to behave erratically and eventually stop communicating. Seeing this, the new Circle issued a moratorium on exploring the systems toward Protera.

Armed with the knowledge of their situation and their error in the first attempt, the tenacious Sovereign Proteron Autarchy is back on track to take over the Empire. They are already on their way to build an improved hypergate that will not fail like the last one.

### Proteron military tactics

The Proteron favour pilots on the larger spaceships and keep smaller ships unmanned. Extensive simulations, dogfights and mock battles revealed that fighters and bombers were largely outclassed by a fleet of unmanned drones, being harder to replace and less maneuverable. This means that their fleet strategy is not easy to adjust on the fly, so they developed the Euler, a fast and stealthy scout ship to ensure that there are no surprises facing the fleet when it commits to an attack. Similarly, it is illogical to commit before probing the enemy's weaknesses, so fleets consisting of smaller ships harass and draw out enemy fleets until the capital ships and their fleets of drones can reduce the enemy to dust. At the same time, a ship must be either capable of damage or of movement, else it is merely a sitting duck. Thus their destroyers and corvettes are faster than expected for ships of their size.

Further, the fleet does not believe that the pilot should hesitate to sacrifice themself to help the fleet on the path to victory. As such, the Proteron largely follow a doctrine of no retreat to encourage pilots to fight to the death unless indicated otherwise ordered. The larger ships with the pilots are therefore also built to outlast any enemy in damage-dealing capability.
