/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SerializableExtension
implements GeneratorExtension {
    Set transientProperties;
    Map transientPropertyInitializers;

    public SerializableExtension(Set transientProperties, Map transientPropertyInitializers) {
        this.transientProperties = transientProperties;
        this.transientPropertyInitializers = transientPropertyInitializers;
    }

    public SerializableExtension() {
        this(Collections.EMPTY_SET, null);
    }

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.io.IOException");
        set.add("java.io.Serializable");
        set.add("java.io.ObjectOutputStream");
        set.add("java.io.ObjectInputStream");
        return set;
    }

    public Collection extraInterfaceNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("Serializable");
        return set;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw) throws IOException {
        Class propType;
        Property prop;
        int i;
        iw.println("private static final long serialVersionUID = 1;");
        iw.println("private static final short VERSION = 0x0001;");
        iw.println();
        iw.println("private void writeObject( ObjectOutputStream oos ) throws IOException");
        iw.println("{");
        iw.upIndent();
        iw.println("oos.writeShort( VERSION );");
        int len = props.length;
        for (i = 0; i < len; ++i) {
            prop = props[i];
            if (this.transientProperties.contains(prop.getName())) continue;
            propType = propTypes[i];
            if (propType != null && propType.isPrimitive()) {
                if (propType == Byte.TYPE) {
                    iw.println("oos.writeByte(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Character.TYPE) {
                    iw.println("oos.writeChar(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Short.TYPE) {
                    iw.println("oos.writeShort(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Integer.TYPE) {
                    iw.println("oos.writeInt(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Boolean.TYPE) {
                    iw.println("oos.writeBoolean(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Long.TYPE) {
                    iw.println("oos.writeLong(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Float.TYPE) {
                    iw.println("oos.writeFloat(" + prop.getName() + ");");
                    continue;
                }
                if (propType != Double.TYPE) continue;
                iw.println("oos.writeDouble(" + prop.getName() + ");");
                continue;
            }
            this.writeStoreObject(prop, propType, iw);
        }
        iw.downIndent();
        iw.println("}");
        iw.println();
        iw.println("private void readObject( ObjectInputStream ois ) throws IOException, ClassNotFoundException");
        iw.println("{");
        iw.upIndent();
        iw.println("short version = ois.readShort();");
        iw.println("switch (version)");
        iw.println("{");
        iw.upIndent();
        iw.println("case VERSION:");
        iw.upIndent();
        len = props.length;
        for (i = 0; i < len; ++i) {
            prop = props[i];
            if (!this.transientProperties.contains(prop.getName())) {
                propType = propTypes[i];
                if (propType != null && propType.isPrimitive()) {
                    if (propType == Byte.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readByte();");
                        continue;
                    }
                    if (propType == Character.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readChar();");
                        continue;
                    }
                    if (propType == Short.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readShort();");
                        continue;
                    }
                    if (propType == Integer.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readInt();");
                        continue;
                    }
                    if (propType == Boolean.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readBoolean();");
                        continue;
                    }
                    if (propType == Long.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readLong();");
                        continue;
                    }
                    if (propType == Float.TYPE) {
                        iw.println("this." + prop.getName() + " = ois.readFloat();");
                        continue;
                    }
                    if (propType != Double.TYPE) continue;
                    iw.println("this." + prop.getName() + " = ois.readDouble();");
                    continue;
                }
                this.writeUnstoreObject(prop, propType, iw);
                continue;
            }
            String initializer = (String)this.transientPropertyInitializers.get(prop.getName());
            if (initializer == null) continue;
            iw.println("this." + prop.getName() + " = " + initializer + ';');
        }
        iw.println("break;");
        iw.downIndent();
        iw.println("default:");
        iw.upIndent();
        iw.println("throw new IOException(\"Unsupported Serialized Version: \" + version);");
        iw.downIndent();
        iw.downIndent();
        iw.println("}");
        iw.downIndent();
        iw.println("}");
    }

    protected void writeStoreObject(Property prop, Class propType, IndentedWriter iw) throws IOException {
        iw.println("oos.writeObject( " + prop.getName() + " );");
    }

    protected void writeUnstoreObject(Property prop, Class propType, IndentedWriter iw) throws IOException {
        iw.println("this." + prop.getName() + " = (" + prop.getSimpleTypeName() + ") ois.readObject();");
    }
}

