/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.c3p0.impl.IdentityTokenizedCoalesceChecker;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class C3P0Registry {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$C3P0Registry == null ? (class$com$mchange$v2$c3p0$C3P0Registry = C3P0Registry.class$("com.mchange.v2.c3p0.C3P0Registry")) : class$com$mchange$v2$c3p0$C3P0Registry);
    static boolean banner_printed = false;
    private static CoalesceChecker CC = IdentityTokenizedCoalesceChecker.INSTANCE;
    private static Coalescer idtCoalescer = CoalescerFactory.createCoalescer(CC, false, true);
    private static HashSet topLevelPooledDataSources = new HashSet();
    private static Map classNamesToConnectionTesters = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$mchange$v2$c3p0$C3P0Registry;

    public static ConnectionTester getConnectionTester(String className) {
        try {
            ConnectionTester out = (ConnectionTester)classNamesToConnectionTesters.get(className);
            if (out == null) {
                out = (ConnectionTester)Class.forName(className).newInstance();
                classNamesToConnectionTesters.put(className, out);
            }
            return out;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find ConnectionTester with class name '" + className + "'. Using default.", e);
            }
            return C3P0Defaults.connectionTester();
        }
    }

    private static synchronized void banner() {
        if (!banner_printed) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0-0.9.1-pre6 [built 23-March-2006 16:11:59 +0200; debug? true; trace: 10]");
            }
            banner_printed = true;
        }
    }

    private static synchronized void addToTopLevelPooledDataSources(IdentityTokenized idt) {
        if (idt instanceof PoolBackedDataSource) {
            if (((PoolBackedDataSource)idt).owner() == null) {
                topLevelPooledDataSources.add(idt);
            }
        } else if (idt instanceof PooledDataSource) {
            topLevelPooledDataSources.add(idt);
        }
    }

    static void register(IdentityTokenized idt) {
        C3P0Registry.banner();
        if (idt.getIdentityToken() == null) {
            throw new RuntimeException("[c3p0 issue] The identityToken of a registered object should be set prior to registration.");
        }
        Object coalesceCheck = idtCoalescer.coalesce(idt);
        if (coalesceCheck != idt) {
            throw new RuntimeException("[c3p0 bug] Only brand new IdentityTokenized's, with their identities just set, should be registered!!! Attempted to register " + idt + " (with identity token " + idt.getIdentityToken() + ");" + " Coalesced to " + coalesceCheck + "(with identity token " + ((IdentityTokenized)coalesceCheck).getIdentityToken() + ").");
        }
        C3P0Registry.addToTopLevelPooledDataSources(idt);
    }

    public static synchronized Set getPooledDataSources() {
        return (Set)topLevelPooledDataSources.clone();
    }

    public static synchronized Set pooledDataSourcesByName(String dataSourceName) {
        HashSet<PooledDataSource> out = new HashSet<PooledDataSource>();
        Iterator ii = topLevelPooledDataSources.iterator();
        while (ii.hasNext()) {
            PooledDataSource pds = (PooledDataSource)ii.next();
            if (!pds.getDataSourceName().equals(dataSourceName)) continue;
            out.add(pds);
        }
        return out;
    }

    public static synchronized PooledDataSource pooledDataSourceByName(String dataSourceName) {
        Iterator ii = topLevelPooledDataSources.iterator();
        while (ii.hasNext()) {
            PooledDataSource pds = (PooledDataSource)ii.next();
            if (!pds.getDataSourceName().equals(dataSourceName)) continue;
            return pds;
        }
        return null;
    }

    public static Object coalesce(IdentityTokenized idt) {
        Object out = idtCoalescer.coalesce(idt);
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classNamesToConnectionTesters.put(C3P0Defaults.connectionTesterClassName(), C3P0Defaults.connectionTester());
    }
}

