/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ChildDocument;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.ParentChildMapping;
import org.eclipse.jface.text.Position;

public final class ChildDocumentManager
implements IDocumentListener,
ISlaveDocumentManager {
    public static final String CHILDDOCUMENTS = "__childdocuments";
    private IPositionUpdater fChildPositionUpdater;

    protected IPositionUpdater getChildPositionUpdater() {
        if (this.fChildPositionUpdater == null) {
            this.fChildPositionUpdater = new ChildPositionUpdater();
        }
        return this.fChildPositionUpdater;
    }

    public IDocument createSlaveDocument(IDocument master) {
        if (!master.containsPositionCategory(CHILDDOCUMENTS)) {
            master.addPositionCategory(CHILDDOCUMENTS);
            master.addPositionUpdater(this.getChildPositionUpdater());
            master.addDocumentListener(this);
        }
        ChildPosition pos = new ChildPosition(master, 0, 0);
        try {
            master.addPosition(CHILDDOCUMENTS, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        ChildDocument child = new ChildDocument(master, pos);
        if (master instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)master);
            String[] partitionings = extension3.getPartitionings();
            int i = 0;
            while (i < partitionings.length) {
                ChildPartitioner partitioner = new ChildPartitioner(partitionings[i]);
                child.setDocumentPartitioner(partitionings[i], partitioner);
                partitioner.connect(child);
                ++i;
            }
        } else {
            ChildPartitioner partitioner = new ChildPartitioner();
            child.setDocumentPartitioner(partitioner);
            partitioner.connect(child);
        }
        pos.fChildDocument = child;
        return child;
    }

    public void freeSlaveDocument(IDocument slave) {
        if (!(slave instanceof ChildDocument)) {
            return;
        }
        ChildDocument childDocument = (ChildDocument)slave;
        String[] partitionings = childDocument.getPartitionings();
        int i = 0;
        while (i < partitionings.length) {
            IDocumentPartitioner partitioner = childDocument.getDocumentPartitioner(partitionings[i]);
            if (partitioner != null) {
                partitioner.disconnect();
            }
            ++i;
        }
        ChildPosition pos = (ChildPosition)childDocument.getParentDocumentRange();
        IDocument parent = pos.fParentDocument;
        try {
            parent.removePosition(CHILDDOCUMENTS, pos);
            Position[] category = parent.getPositions(CHILDDOCUMENTS);
            if (category.length == 0) {
                parent.removeDocumentListener(this);
                parent.removePositionUpdater(this.getChildPositionUpdater());
                parent.removePositionCategory(CHILDDOCUMENTS);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public IDocumentInformationMapping createMasterSlaveMapping(IDocument slave) {
        if (slave instanceof ChildDocument) {
            return new ParentChildMapping((ChildDocument)slave);
        }
        return null;
    }

    public IDocument getMasterDocument(IDocument slave) {
        if (slave instanceof ChildDocument) {
            return ((ChildDocument)slave).getParentDocument();
        }
        return null;
    }

    public boolean isSlaveDocument(IDocument document) {
        return document instanceof ChildDocument;
    }

    protected void fireDocumentEvent(boolean about, DocumentEvent event) {
        try {
            IDocument parent = event.getDocument();
            Position[] children = parent.getPositions(CHILDDOCUMENTS);
            int i = 0;
            while (i < children.length) {
                Position o = children[i];
                if (o instanceof ChildPosition) {
                    ChildPosition pos = (ChildPosition)o;
                    if (about) {
                        pos.fChildDocument.parentDocumentAboutToBeChanged(event);
                    } else {
                        pos.fChildDocument.parentDocumentChanged(event);
                    }
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentChanged(DocumentEvent event) {
        this.fireDocumentEvent(false, event);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.fireDocumentEvent(true, event);
    }

    public void setAutoExpandMode(IDocument slaveDocument, boolean autoExpand) {
        if (slaveDocument instanceof ChildDocument) {
            ((ChildDocument)slaveDocument).setAutoExpandMode(autoExpand);
        }
    }

    static class ChildPosition
    extends Position {
        public IDocument fParentDocument;
        public ChildDocument fChildDocument;

        public ChildPosition(IDocument parentDocument, int offset, int length) {
            super(offset, length);
            this.fParentDocument = parentDocument;
        }

        public boolean overlapsWith(int offset, int length) {
            boolean append;
            boolean bl = append = offset == this.offset + this.length && length == 0;
            return append || super.overlapsWith(offset, length);
        }
    }

    static class ChildPositionUpdater
    extends DefaultPositionUpdater {
        private DocumentEvent fDocumentEvent;

        protected ChildPositionUpdater() {
            super(ChildDocumentManager.CHILDDOCUMENTS);
        }

        protected boolean notDeleted() {
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void update(DocumentEvent event) {
            try {
                this.fDocumentEvent = event;
                super.update(event);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fDocumentEvent = null;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fDocumentEvent = null;
                return;
            }
        }

        protected void adaptToInsert() {
            int myStart = this.fPosition.offset;
            int myEnd = this.fPosition.offset + this.fPosition.length;
            boolean isAutoExpanding = this.isAutoExpanding();
            if (this.fLength != 0 && this.fOffset < myEnd && !isAutoExpanding) {
                super.adaptToInsert();
                return;
            }
            int yoursStart = this.fOffset;
            int yoursEnd = this.fOffset + this.fReplaceLength - 1;
            yoursEnd = Math.max(yoursStart, yoursEnd);
            if (myEnd < yoursStart) {
                if (isAutoExpanding) {
                    this.fPosition.length = yoursEnd - myStart + 1;
                }
                return;
            }
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else if (isAutoExpanding) {
                this.fPosition.offset = yoursStart;
                this.fPosition.length += myStart - yoursStart + this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }

        private boolean isAutoExpanding() {
            if (this.fPosition instanceof ChildPosition) {
                ChildPosition position = (ChildPosition)this.fPosition;
                return position.fChildDocument.isAutoExpandEvent(this.fDocumentEvent);
            }
            return false;
        }
    }

    static class ChildPartitioner
    implements IDocumentPartitioner {
        protected ChildDocument fChildDocument;
        protected IDocument fParentDocument;
        protected IDocumentExtension3 fParentDocument3;
        protected String fPartitioning;

        protected ChildPartitioner(String partitioning) {
            this.fPartitioning = partitioning;
        }

        protected ChildPartitioner() {
            this.fPartitioning = null;
        }

        public ITypedRegion getPartition(int offset) {
            try {
                offset += this.fChildDocument.getParentDocumentRange().getOffset();
                if (this.fParentDocument3 != null) {
                    return this.fParentDocument3.getPartition(this.fPartitioning, offset);
                }
                return this.fParentDocument.getPartition(offset);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPartitioningException badPartitioningException) {}
            return null;
        }

        public ITypedRegion[] computePartitioning(int offset, int length) {
            try {
                offset += this.fChildDocument.getParentDocumentRange().getOffset();
                if (this.fParentDocument3 != null) {
                    return this.fParentDocument3.computePartitioning(this.fPartitioning, offset, length);
                }
                return this.fParentDocument.computePartitioning(offset, length);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPartitioningException badPartitioningException) {}
            return null;
        }

        public String getContentType(int offset) {
            try {
                offset += this.fChildDocument.getParentDocumentRange().getOffset();
                if (this.fParentDocument3 != null) {
                    return this.fParentDocument3.getContentType(this.fPartitioning, offset);
                }
                return this.fParentDocument.getContentType(offset);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPartitioningException badPartitioningException) {}
            return null;
        }

        public String[] getLegalContentTypes() {
            if (this.fParentDocument3 != null) {
                try {
                    return this.fParentDocument3.getLegalContentTypes(this.fPartitioning);
                }
                catch (BadPartitioningException badPartitioningException) {
                    return new String[0];
                }
            }
            return this.fParentDocument.getLegalContentTypes();
        }

        public boolean documentChanged(DocumentEvent event) {
            return false;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void disconnect() {
            this.fChildDocument = null;
            this.fParentDocument = null;
            this.fParentDocument3 = null;
        }

        public void connect(IDocument childDocument) {
            Assert.isTrue(childDocument instanceof ChildDocument);
            this.fChildDocument = (ChildDocument)childDocument;
            this.fParentDocument = this.fChildDocument.getParentDocument();
            if (this.fParentDocument instanceof IDocumentExtension3) {
                this.fParentDocument3 = (IDocumentExtension3)((Object)this.fParentDocument);
            }
        }
    }
}

