/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.internal.core.index.impl.Block;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.util.Util;

public class FileListBlock
extends Block {
    protected int offset = 0;
    protected String prevPath = null;
    protected String[] paths = null;

    public FileListBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addFile(IndexedFile indexedFile) {
        int currentOffset = this.offset;
        if (this.isEmpty()) {
            this.field.putInt4(currentOffset, indexedFile.getFileNumber());
            currentOffset += 4;
        }
        String path = indexedFile.getPath();
        int prefixLen = this.prevPath == null ? 0 : Util.prefixLength(this.prevPath, path);
        int sizeEstimate = 4 + (path.length() - prefixLen) * 3;
        if (currentOffset + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        this.field.putInt2(currentOffset, prefixLen);
        currentOffset += 2;
        char[] chars = new char[path.length() - prefixLen];
        path.getChars(prefixLen, path.length(), chars, 0);
        currentOffset += this.field.putUTF(currentOffset, chars);
        this.offset = currentOffset;
        this.prevPath = path;
        return true;
    }

    public void clear() {
        this.reset();
        super.clear();
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.field.putInt2(this.offset + 2, 0);
            this.offset = 0;
        }
    }

    public IndexedFile getFile(int fileNum) {
        IndexedFile resp = null;
        try {
            String[] currentPaths = this.getPaths();
            int i = fileNum - this.field.getInt4(0);
            resp = new IndexedFile(currentPaths[i], fileNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resp;
    }

    protected String[] getPaths() throws IOException {
        if (this.paths == null) {
            ArrayList<String> v = new ArrayList<String>();
            int currentOffset = 4;
            char[] previousPath = null;
            while (true) {
                int prefixLen = this.field.getUInt2(currentOffset);
                int utfLen = this.field.getUInt2(currentOffset += 2);
                char[] path = this.field.getUTF(currentOffset);
                currentOffset += 2 + utfLen;
                if (prefixLen != 0) {
                    char[] temp = new char[prefixLen + path.length];
                    System.arraycopy(previousPath, 0, temp, 0, prefixLen);
                    System.arraycopy(path, 0, temp, prefixLen, path.length);
                    path = temp;
                }
                if (path.length == 0) break;
                v.add(new String(path));
                previousPath = path;
            }
            this.paths = new String[v.size()];
            v.toArray(this.paths);
        }
        return this.paths;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void reset() {
        this.offset = 0;
        this.prevPath = null;
    }
}

