/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ClassFile classFile = null;

    ClassFileInfo(ClassFile classFile) {
        this.classFile = classFile;
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            BinaryField field = new BinaryField((JavaElement)((Object)type), new String(fieldInfo.getName()));
            newElements.put(field, fieldInfo);
            childrenHandles.add(field);
            ++i;
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile parentClassFile = ((IPackageFragment)this.classFile.getParent()).getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".class");
                BinaryType innerType = new BinaryType((JavaElement)((Object)parentClassFile), new String(ClassFile.simpleName(binaryType.getName())));
                childrenHandles.add(innerType);
                ++i;
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            String[] pNames = Signature.getParameterTypes(new String(methodInfo.getMethodDescriptor()));
            char[][] paramNames = new char[pNames.length][];
            int j = 0;
            while (j < pNames.length) {
                paramNames[j] = pNames[j].toCharArray();
                ++j;
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            String selector = new String(methodInfo.getSelector());
            if (methodInfo.isConstructor()) {
                selector = type.getElementName();
            }
            int j2 = 0;
            while (j2 < pNames.length) {
                pNames[j2] = new String(parameterTypes[j2]);
                ++j2;
            }
            BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
            childrenHandles.add(method);
            newElements.put(method, methodInfo);
            ++i;
        }
    }

    IJavaElement[] getBinaryChildren(HashMap newElements) {
        if (this.binaryChildren == null) {
            this.readBinaryChildren(newElements, null);
        }
        return this.binaryChildren;
    }

    boolean hasReadBinaryChildren() {
        return this.binaryChildren != null;
    }

    protected void readBinaryChildren(HashMap newElements, IBinaryType typeInfo) {
        ArrayList childrenHandles = new ArrayList();
        BinaryType type = null;
        try {
            type = (BinaryType)this.classFile.getType();
            if (typeInfo == null && (typeInfo = (IBinaryType)newElements.get(type)) == null) {
                typeInfo = this.classFile.getBinaryTypeInfo((IFile)this.classFile.getResource());
            }
        }
        catch (JavaModelException npe) {
            return;
        }
        if (typeInfo != null) {
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
    }

    void removeBinaryChildren() throws JavaModelException {
        if (this.binaryChildren != null) {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            int i = 0;
            while (i < this.binaryChildren.length) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)child.getParent());
                } else {
                    manager.removeInfoAndChildren(child);
                }
                ++i;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
    }
}

