/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;

public class PackageBinding
extends Binding
implements TypeConstants {
    public char[][] compoundName;
    PackageBinding parent;
    LookupEnvironment environment;
    HashtableOfType knownTypes;
    HashtableOfPackage knownPackages;

    protected PackageBinding() {
    }

    public PackageBinding(char[][] compoundName, PackageBinding parent, LookupEnvironment environment) {
        this.compoundName = compoundName;
        this.parent = parent;
        this.environment = environment;
        this.knownTypes = null;
        this.knownPackages = new HashtableOfPackage(3);
    }

    public PackageBinding(char[] topLevelPackageName, LookupEnvironment environment) {
        this(new char[][]{topLevelPackageName}, null, environment);
    }

    public PackageBinding(LookupEnvironment environment) {
        this(CharOperation.NO_CHAR_CHAR, null, environment);
    }

    private void addNotFoundPackage(char[] simpleName) {
        this.knownPackages.put(simpleName, LookupEnvironment.TheNotFoundPackage);
    }

    private void addNotFoundType(char[] simpleName) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(simpleName, LookupEnvironment.TheNotFoundType);
    }

    void addPackage(PackageBinding element) {
        this.knownPackages.put(element.compoundName[element.compoundName.length - 1], element);
    }

    void addType(ReferenceBinding element) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(element.compoundName[element.compoundName.length - 1], element);
    }

    public final int bindingType() {
        return 16;
    }

    private PackageBinding findPackage(char[] name) {
        if (!this.environment.isPackage(this.compoundName, name)) {
            return null;
        }
        char[][] subPkgCompoundName = CharOperation.arrayConcat(this.compoundName, name);
        PackageBinding subPackageBinding = new PackageBinding(subPkgCompoundName, this, this.environment);
        this.addPackage(subPackageBinding);
        return subPackageBinding;
    }

    PackageBinding getPackage(char[] name) {
        PackageBinding binding = this.getPackage0(name);
        if (binding != null) {
            if (binding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return binding;
        }
        binding = this.findPackage(name);
        if (binding != null) {
            return binding;
        }
        this.addNotFoundPackage(name);
        return null;
    }

    PackageBinding getPackage0(char[] name) {
        return this.knownPackages.get(name);
    }

    ReferenceBinding getType(char[] name) {
        ReferenceBinding binding = this.getType0(name);
        if (binding == null && (binding = this.environment.askForType(this, name)) == null) {
            this.addNotFoundType(name);
            return null;
        }
        if (binding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        if (binding instanceof UnresolvedReferenceBinding) {
            binding = ((UnresolvedReferenceBinding)binding).resolve(this.environment);
        }
        if (binding.isNestedType()) {
            return new ProblemReferenceBinding(name, 4);
        }
        return binding;
    }

    ReferenceBinding getType0(char[] name) {
        if (this.knownTypes == null) {
            return null;
        }
        return this.knownTypes.get(name);
    }

    public Binding getTypeOrPackage(char[] name) {
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            return packageBinding;
        }
        ReferenceBinding typeBinding = this.getType0(name);
        if (typeBinding != null && typeBinding != LookupEnvironment.TheNotFoundType) {
            if (typeBinding instanceof UnresolvedReferenceBinding) {
                typeBinding = ((UnresolvedReferenceBinding)typeBinding).resolve(this.environment);
            }
            if (typeBinding.isNestedType()) {
                return new ProblemReferenceBinding(name, 4);
            }
            return typeBinding;
        }
        if (packageBinding == null && (packageBinding = this.findPackage(name)) != null) {
            return packageBinding;
        }
        if (typeBinding == null) {
            typeBinding = this.environment.askForType(this, name);
            if (typeBinding != null) {
                if (typeBinding.isNestedType()) {
                    return new ProblemReferenceBinding(name, 4);
                }
                return typeBinding;
            }
            this.addNotFoundPackage(name);
            this.addNotFoundType(name);
        } else {
            if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
                packageBinding = null;
            }
            if (typeBinding == LookupEnvironment.TheNotFoundType) {
                typeBinding = null;
            }
        }
        if (packageBinding != null) {
            return packageBinding;
        }
        return typeBinding;
    }

    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        if (this.compoundName == CharOperation.NO_CHAR_CHAR) {
            return "The Default Package";
        }
        return "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }
}

