/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression {
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void aboutToResolve(Scope scope) {
    }

    public static final TypeReference baseTypeReference(int baseType, int dim) {
        if (dim == 0) {
            switch (baseType) {
                case 6: {
                    return new SingleTypeReference(BaseTypes.VoidBinding.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(BaseTypes.BooleanBinding.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(BaseTypes.CharBinding.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(BaseTypes.FloatBinding.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(BaseTypes.DoubleBinding.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(BaseTypes.ByteBinding.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(BaseTypes.ShortBinding.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(BaseTypes.IntBinding.simpleName, 0L);
                }
            }
            return new SingleTypeReference(BaseTypes.LongBinding.simpleName, 0L);
        }
        switch (baseType) {
            case 6: {
                return new ArrayTypeReference(BaseTypes.VoidBinding.simpleName, dim, 0L);
            }
            case 5: {
                return new ArrayTypeReference(BaseTypes.BooleanBinding.simpleName, dim, 0L);
            }
            case 2: {
                return new ArrayTypeReference(BaseTypes.CharBinding.simpleName, dim, 0L);
            }
            case 9: {
                return new ArrayTypeReference(BaseTypes.FloatBinding.simpleName, dim, 0L);
            }
            case 8: {
                return new ArrayTypeReference(BaseTypes.DoubleBinding.simpleName, dim, 0L);
            }
            case 3: {
                return new ArrayTypeReference(BaseTypes.ByteBinding.simpleName, dim, 0L);
            }
            case 4: {
                return new ArrayTypeReference(BaseTypes.ShortBinding.simpleName, dim, 0L);
            }
            case 10: {
                return new ArrayTypeReference(BaseTypes.IntBinding.simpleName, dim, 0L);
            }
        }
        return new ArrayTypeReference(BaseTypes.LongBinding.simpleName, dim, 0L);
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    public boolean isTypeReference() {
        return true;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = ASTNode.NotAConstant;
        if (this.resolvedType != null) {
            if (!this.resolvedType.isValidBinding()) {
                return null;
            }
        } else {
            this.resolvedType = this.getTypeBinding(blockScope);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(blockScope);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, blockScope)) {
                this.reportDeprecatedType(blockScope);
            }
        }
        return this.resolvedType;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        this.constant = ASTNode.NotAConstant;
        if (this.resolvedType != null) {
            if (!this.resolvedType.isValidBinding()) {
                return null;
            }
        } else {
            this.resolvedType = this.getTypeBinding(classScope);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(classScope);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, classScope)) {
                this.reportDeprecatedType(classScope);
            }
        }
        return this.resolvedType;
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportDeprecatedType(Scope scope) {
        scope.problemReporter().deprecatedType(this.resolvedType, this);
    }

    public abstract void traverse(ASTVisitor var1, ClassScope var2);
}

