/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class AssertStatement
extends Statement {
    private Expression expression = null;
    private Expression optionalMessageExpression = null;

    AssertStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 6;
    }

    ASTNode clone(AST target) {
        AssertStatement result = new AssertStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        result.setMessage((Expression)ASTNode.copySubtree(target, this.getMessage()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getMessage());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.expression, expression, true);
        this.expression = expression;
    }

    public Expression getMessage() {
        return this.optionalMessageExpression;
    }

    public void setMessage(Expression expression) {
        this.replaceChild(this.optionalMessageExpression, expression, true);
        this.optionalMessageExpression = expression;
    }

    int memSize() {
        return super.memSize() + 8;
    }

    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.optionalMessageExpression == null ? 0 : this.getMessage().treeSize());
    }
}

