/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.model.PluginModelObject;

public class LibraryModel
extends PluginModelObject {
    private String[] exports = null;
    private String type = "code";
    private String[] packagePrefixes = null;
    private boolean isExported = false;
    private boolean isFullyExported = false;
    public static final String CODE = "code";
    public static final String RESOURCE = "resource";

    public String[] getExports() {
        return this.exports;
    }

    public String getType() {
        return this.type;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean isFullyExported() {
        return this.isFullyExported;
    }

    public void setExports(String[] value) {
        this.assertIsWriteable();
        this.exports = value;
        if (value == null) {
            this.isExported = false;
            this.isFullyExported = false;
        } else {
            int i = 0;
            while (i < value.length) {
                if (!value[i].equals("")) {
                    this.isExported = true;
                }
                if (value[i].equals("*")) {
                    this.isFullyExported = true;
                }
                ++i;
            }
        }
    }

    public void setType(String value) {
        this.assertIsWriteable();
        String lcValue = value.toLowerCase();
        Assert.isTrue(lcValue.equals(CODE) || lcValue.equals(RESOURCE));
        this.type = lcValue;
    }

    public String[] getPackagePrefixes() {
        return this.packagePrefixes;
    }

    public void setPackagePrefixes(String[] packagePrefixes) {
        this.packagePrefixes = packagePrefixes;
    }
}

