/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class PlatformURLPluginHandlerFactory {
    IConfigurationElement ce = null;
    static final String URL_HANDLERS_POINT = "org.eclipse.core.runtime.urlHandlers";
    static final String PROTOCOL = "protocol";
    static final String HANDLER = "class";
    static /* synthetic */ Class class$0;

    public PlatformURLPluginHandlerFactory(IConfigurationElement ce) {
        this.ce = ce;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = null;
        try {
            handler = (URLStreamHandler)this.ce.createExecutableExtension(HANDLER);
        }
        catch (CoreException coreException) {}
        return handler;
    }

    public static void deregister(IExtension extension) {
    }

    public static void register(IExtension extension) {
        IConfigurationElement[] ce = extension.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            PlatformURLPluginHandlerFactory.installURL(ce[i]);
            ++i;
        }
    }

    public static void startup() {
        IExtensionRegistry r = InternalPlatform.getDefault().getRegistry();
        if (r != null) {
            IConfigurationElement[] ce = r.getConfigurationElementsFor(URL_HANDLERS_POINT);
            int i = 0;
            while (i < ce.length) {
                PlatformURLPluginHandlerFactory.installURL(ce[i]);
                ++i;
            }
        }
        PlatformURLPluginHandlerFactory.urlExtensionListener();
    }

    private static void urlExtensionListener() {
        InternalPlatform.getDefault().getRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.core.runtime", "urlHandlers");
                int i = 0;
                while (i < deltas.length) {
                    if (deltas[i].getKind() == 1) {
                        PlatformURLPluginHandlerFactory.register(deltas[i].getExtension());
                    } else if (deltas[i].getKind() == 2) {
                        PlatformURLPluginHandlerFactory.deregister(deltas[i].getExtension());
                    }
                    ++i;
                }
            }
        }, "org.eclipse.core.runtime");
    }

    private static void installURL(IConfigurationElement ce) {
        URLHandlerWrapper handlerInstance;
        String protocol = ce.getAttribute(PROTOCOL);
        if (protocol == null) {
            return;
        }
        try {
            handlerInstance = new URLHandlerWrapper((URLStreamHandler)ce.createExecutableExtension(HANDLER));
        }
        catch (CoreException e) {
            InternalPlatform.getDefault().log(new Status(1, "pluginId", 0, "error registering the URL" + protocol, e));
            return;
        }
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{protocol});
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.osgi.service.url.URLStreamHandlerService;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        bundleContext.registerService(clazz.getName(), (Object)handlerInstance, properties);
    }

    static class URLHandlerWrapper
    extends AbstractURLStreamHandlerService {
        private URLStreamHandler handler;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        public URLHandlerWrapper(URLStreamHandler handler) {
            this.handler = handler;
        }

        public void parseURL(URLStreamHandlerSetter realHandler, URL u, String spec, int start, int limit) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[4];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                classArray[2] = Integer.TYPE;
                classArray[3] = Integer.TYPE;
                Method m = clazz.getDeclaredMethod("parseURL", classArray);
                m.setAccessible(true);
                m.invoke((Object)this.handler, u, spec, new Integer(start), new Integer(limit));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public URLConnection openConnection(URL u) throws IOException {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method m = clazz.getDeclaredMethod("openConnection", classArray);
                m.setAccessible(true);
                return (URLConnection)m.invoke((Object)this.handler, u);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        }

        public boolean equals(URL u1, URL u2) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Method m = clazz.getDeclaredMethod("equals", classArray);
                m.setAccessible(true);
                return (Boolean)m.invoke((Object)this.handler, u1, u2);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public int hashCode(URL u) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method m = clazz.getDeclaredMethod("hashCode", classArray);
                m.setAccessible(true);
                return (Integer)m.invoke((Object)this.handler, u);
            }
            catch (Exception exception) {
                return super.hashCode(u);
            }
        }

        public int getDefaultPort() {
            try {
                Method m = this.handler.getClass().getDeclaredMethod("getDefaultPort", null);
                m.setAccessible(true);
                return (Integer)m.invoke((Object)this.handler, new Object[0]);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public synchronized InetAddress getHostAddress(URL u) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method m = clazz.getDeclaredMethod("getHostAddress", classArray);
                m.setAccessible(true);
                return (InetAddress)m.invoke((Object)this.handler, u);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean hostsEqual(URL u1, URL u2) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Method m = clazz.getDeclaredMethod("hostsEqual", classArray);
                m.setAccessible(true);
                return (Boolean)m.invoke((Object)this.handler, u1, u2);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean sameFile(URL u1, URL u2) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Method m = clazz.getDeclaredMethod("sameFile", classArray);
                m.setAccessible(true);
                return (Boolean)m.invoke((Object)this.handler, u1, u2);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[6];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz4;
                classArray[3] = Integer.TYPE;
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[4] = clazz5;
                Class<?> clazz6 = class$1;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[5] = clazz6;
                Method m = clazz.getDeclaredMethod("setURL", classArray);
                m.setAccessible(true);
                m.invoke((Object)this.handler, u, protocol, host, new Integer(port), file, ref);
            }
            catch (Exception exception) {}
        }

        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            try {
                Class<?> clazz = this.handler.getClass();
                Class[] classArray = new Class[9];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.net.URL;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz4;
                classArray[3] = Integer.TYPE;
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[4] = clazz5;
                Class<?> clazz6 = class$1;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[5] = clazz6;
                Class<?> clazz7 = class$1;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[6] = clazz7;
                Class<?> clazz8 = class$1;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[7] = clazz8;
                Class<?> clazz9 = class$1;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[8] = clazz9;
                Method m = clazz.getDeclaredMethod("setURL", classArray);
                m.setAccessible(true);
                m.invoke((Object)this.handler, u, protocol, host, new Integer(port), authority, userInfo, path, query, ref);
            }
            catch (Exception exception) {}
        }
    }
}

