/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Queue;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class OrderedLock
implements ILock,
ISchedulingRule {
    private static final boolean DEBUG = false;
    private static int nextLockNumber = 0;
    private volatile Thread currentOperationThread;
    private int depth;
    private final LockManager manager;
    private final int number;
    private final Queue operations = new Queue();

    OrderedLock(LockManager manager) {
        this.manager = manager;
        this.number = nextLockNumber++;
    }

    public void acquire() {
        while (true) {
            try {
                if (!this.acquire(Long.MAX_VALUE)) continue;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean acquire(long delay) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        if (delay <= 0L) {
            return this.attempt();
        }
        Semaphore semaphore = this.createSemaphore();
        if (semaphore == null) {
            return true;
        }
        success = this.doAcquire(semaphore, delay);
        this.manager.resumeSuspendedLocks(Thread.currentThread());
        return success;
    }

    private synchronized boolean attempt() {
        if (this.currentOperationThread == Thread.currentThread() || this.currentOperationThread == null && this.operations.isEmpty()) {
            ++this.depth;
            this.setCurrentOperationThread(Thread.currentThread());
            return true;
        }
        return false;
    }

    public boolean contains(ISchedulingRule rule) {
        return false;
    }

    private synchronized Semaphore createSemaphore() {
        return this.attempt() ? null : this.enqueue(new Semaphore(Thread.currentThread()));
    }

    private boolean doAcquire(Semaphore semaphore, long delay) throws InterruptedException {
        boolean success = false;
        if (this.manager.aboutToWait(this.currentOperationThread)) {
            this.operations.remove(semaphore);
            ++this.depth;
            this.manager.addLockThread(this.currentOperationThread, this);
            return true;
        }
        this.manager.addLockWaitThread(Thread.currentThread(), this);
        success = semaphore.acquire(delay);
        if (success) {
            ++this.depth;
            this.updateCurrentOperation();
        } else {
            this.operations.remove(semaphore);
            this.manager.removeLockWaitThread(Thread.currentThread(), this);
        }
        return success;
    }

    private synchronized void doRelease() {
        this.manager.aboutToRelease();
        this.depth = 0;
        Semaphore next = (Semaphore)this.operations.peek();
        this.setCurrentOperationThread(null);
        if (next != null) {
            next.release();
        }
    }

    private synchronized Semaphore enqueue(Semaphore newSemaphore) {
        Semaphore semaphore = (Semaphore)this.operations.get(newSemaphore);
        if (semaphore == null) {
            this.operations.enqueue(newSemaphore);
            return newSemaphore;
        }
        return semaphore;
    }

    protected int forceRelease() {
        int oldDepth = this.depth;
        this.doRelease();
        return oldDepth;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public void release() {
        if (this.depth == 0) {
            return;
        }
        Assert.isTrue(this.depth >= 0, "Lock released too many times");
        if (--this.depth == 0) {
            this.doRelease();
        } else {
            this.manager.removeLockThread(this.currentOperationThread, this);
        }
    }

    private void setCurrentOperationThread(Thread newThread) {
        if (this.currentOperationThread != null && newThread == null) {
            this.manager.removeLockThread(this.currentOperationThread, this);
        }
        this.currentOperationThread = newThread;
        if (this.currentOperationThread != null) {
            this.manager.addLockThread(this.currentOperationThread, this);
        }
    }

    protected void setDepth(int newDepth) {
        int i = this.depth;
        while (i < newDepth) {
            this.manager.addLockThread(this.currentOperationThread, this);
            ++i;
        }
        this.depth = newDepth;
    }

    public String toString() {
        return "OrderedLock (" + this.number + ")";
    }

    private synchronized void updateCurrentOperation() {
        this.operations.dequeue();
        this.setCurrentOperationThread(Thread.currentThread());
    }
}

