/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class ExactTypePattern
extends TypePattern {
    protected TypeX type;

    public ExactTypePattern(TypeX type, boolean includeSubtypes) {
        super(includeSubtypes);
        this.type = type;
    }

    protected boolean matchesExactly(ResolvedTypeX matchType) {
        return this.type.equals(matchType);
    }

    public TypeX getType() {
        return this.type;
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX matchType) {
        if (this.type.equals(TypeX.OBJECT)) {
            return FuzzyBoolean.YES;
        }
        if (this.type.isAssignableFrom(matchType, matchType.getWorld())) {
            return FuzzyBoolean.YES;
        }
        return matchType.isCoerceableFrom(this.type) ? FuzzyBoolean.MAYBE : FuzzyBoolean.NO;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExactTypePattern)) {
            return false;
        }
        ExactTypePattern o = (ExactTypePattern)other;
        return o.type.equals(this.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(2);
        this.type.write(out);
        out.writeBoolean(this.includeSubtypes);
        this.writeLocation(out);
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        ExactTypePattern ret = new ExactTypePattern(TypeX.read(s), s.readBoolean());
        ret.readLocation(context, s);
        return ret;
    }

    public String toString() {
        return this.type.toString() + (this.includeSubtypes ? "+" : "");
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        throw new BCException("trying to re-resolve");
    }
}

