/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

class SwingTreeViewNodeRenderer
extends DefaultTreeCellRenderer {
    SwingTreeViewNodeRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object treeNode, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (treeNode == null) {
            return null;
        }
        this.setFont(StructureTree.DEFAULT_FONT);
        SwingTreeViewNode viewNode = (SwingTreeViewNode)treeNode;
        IProgramElement node = viewNode.getStructureNode();
        if (viewNode.getKind() == IStructureViewNode.Kind.LINK) {
            ISourceLocation sourceLoc = node.getSourceLocation();
            if (null != sourceLoc && null != sourceLoc.getSourceFile().getAbsolutePath()) {
                this.setTextNonSelectionColor(AjdeWidgetStyles.LINK_NODE_COLOR);
            } else {
                this.setTextNonSelectionColor(AjdeWidgetStyles.LINK_NODE_NO_SOURCE_COLOR);
            }
        } else if (viewNode.getKind() == IStructureViewNode.Kind.RELATIONSHIP) {
            this.setFont(new Font(((Component)this).getFont().getName(), 2, ((Component)this).getFont().getSize()));
            this.setTextNonSelectionColor(new Color(0, 0, 0));
        } else if (viewNode.getKind() == IStructureViewNode.Kind.DECLARATION) {
            this.setTextNonSelectionColor(new Color(0, 0, 0));
        }
        super.getTreeCellRendererComponent(tree, treeNode, sel, expanded, leaf, row, hasFocus);
        if (viewNode.getIcon() != null && viewNode.getIcon().getIconResource() != null) {
            this.setIcon((Icon)viewNode.getIcon().getIconResource());
        } else {
            this.setIcon(null);
        }
        if (node != null) {
            if (node.isRunnable()) {
                this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getExecuteIcon());
            }
            if (node.getMessage() != null) {
                if (node.getMessage().getKind().equals(IMessage.WARNING)) {
                    this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getWarningIcon());
                } else if (node.getMessage().getKind().equals(IMessage.ERROR)) {
                    this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getErrorIcon());
                } else {
                    this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getInfoIcon());
                }
            }
        }
        return this;
    }
}

