/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.integration.jboss;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public final class MysqlValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 3258689922776119348L;
    private Method pingMethod;
    private static final Object[] NO_ARGS_OBJECT_ARRAY = new Object[0];

    public MysqlValidConnectionChecker() {
        try {
            Class<?> mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Connection");
            this.pingMethod = mysqlConnection.getMethod("ping", null);
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLException isValidConnection(Connection conn) {
        SQLException sQLException;
        if (this.pingMethod != null) {
            try {
                this.pingMethod.invoke((Object)conn, NO_ARGS_OBJECT_ARRAY);
                return null;
            }
            catch (Exception ex) {
                if (!(ex instanceof SQLException)) return new SQLException("Ping failed: " + ex.toString());
                return (SQLException)ex;
            }
        }
        Statement pingStatement = null;
        try {
            try {
                pingStatement.executeQuery("SELECT 1").close();
                sQLException = null;
                Object var4_6 = null;
                if (pingStatement == null) return sQLException;
            }
            catch (SQLException sqlEx) {
                SQLException sQLException3 = sqlEx;
                Object var4_7 = null;
                if (pingStatement == null) return sQLException3;
                try {
                    pingStatement.close();
                    return sQLException3;
                }
                catch (SQLException sQLException2) {}
                return sQLException3;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (pingStatement == null) throw throwable;
            try {}
            catch (SQLException sQLException3) {
                throw throwable;
            }
            pingStatement.close();
            throw throwable;
        }
        try {}
        catch (SQLException sQLException4) {}
        pingStatement.close();
        return sQLException;
    }
}

