/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new QualifiedTypeDeclarationPattern(null, null, ' ', 4);
        }
    };
    protected char[] qualification;

    public static QualifiedTypeDeclarationPattern getQualifiedTypeDeclarationRecord() {
        return (QualifiedTypeDeclarationPattern)indexRecord.get();
    }

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char classOrInterface, int matchRule) {
        super(matchRule);
        boolean isCaseSensitive = this.isCaseSensitive();
        this.qualification = isCaseSensitive ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.mustResolve = qualification != null;
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        this.classOrInterface = key[0];
        int oldSlash = 1;
        int slash = CharOperation.indexOf('/', key, oldSlash + 1);
        char[] pkgName = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray(key, oldSlash + 1, slash);
        int n = slash + 1;
        slash = CharOperation.indexOf('/', key, slash + 1);
        this.simpleName = CharOperation.subarray(key, n, slash);
        char[][] decodedEnclosingTypeNames = slash + 1 < size ? (slash + 3 == size && key[slash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO_CHAR : CharOperation.splitOn('/', CharOperation.subarray(key, slash + 1, size - 1))) : CharOperation.NO_CHAR_CHAR;
        this.qualification = CharOperation.concatWith(pkgName, decodedEnclosingTypeNames, '.');
    }

    public SearchPattern getIndexRecord() {
        return QualifiedTypeDeclarationPattern.getQualifiedTypeDeclarationRecord();
    }

    public boolean isMatchingIndexRecord() {
        QualifiedTypeDeclarationPattern record = QualifiedTypeDeclarationPattern.getQualifiedTypeDeclarationRecord();
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == record.classOrInterface) break;
                return false;
            }
        }
        if (!this.matchesName(this.pkg, record.qualification)) {
            return false;
        }
        return this.matchesName(this.simpleName, record.simpleName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            buffer.append(this.qualification);
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

