/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.jdt.internal.core.index.impl.IndexOutput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.IndexedFileHashedArray;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;
import org.eclipse.jdt.internal.core.index.impl.WordEntryHashedArray;
import org.eclipse.jdt.internal.core.util.Util;

public class InMemoryIndex {
    protected WordEntryHashedArray words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(SearchDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    protected void addRef(char[] word, int[] references) {
        int size = references.length;
        int i = 0;
        while (i < size) {
            if (references[i] != 0) {
                this.addRef(word, references[i]);
            }
            ++i;
        }
    }

    protected void addRef(char[] word, int fileNum) {
        WordEntry entry = this.words.get(word);
        if (entry == null) {
            entry = new WordEntry(word);
            entry.addRef(fileNum);
            this.words.add(entry);
            this.sortedWordEntries = null;
            this.footprint += (long)entry.footprint();
        } else {
            this.footprint += (long)entry.addRef(fileNum);
        }
    }

    public void addRef(IndexedFile indexedFile, char[] word) {
        this.addRef(word, indexedFile.getFileNumber());
    }

    public void addRef(IndexedFile indexedFile, String word) {
        this.addRef(word.toCharArray(), indexedFile.getFileNumber());
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.elementSize;
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            IndexedFile[] indexedFiles = this.files.asArray();
            Util.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            WordEntry[] wordEntries = this.words.asArray();
            Util.sort(wordEntries);
            this.sortedWordEntries = wordEntries;
        }
        return this.sortedWordEntries;
    }

    protected WordEntry getWordEntry(char[] word) {
        return this.words.get(word);
    }

    public void init() {
        this.words = new WordEntryHashedArray(501);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    /*
     * Exception decompiling
     */
    protected void save(IndexOutput output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 118->122)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

