/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class StringLiteral
extends Expression {
    private String escapedValue = "\"\"";

    StringLiteral(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 45;
    }

    ASTNode clone(AST target) {
        StringLiteral result = new StringLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.getAST().scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 60: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
        }
        this.modifying();
        this.escapedValue = token;
    }

    public String getLiteralValue() {
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.getAST().scanner;
        char[] source = s.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 60: {
                    return new String(scanner.getCurrentTokenSourceString());
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setLiteralValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int len = value.length();
        StringBuffer b = new StringBuffer(len + 2);
        b.append("\"");
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\'': {
                    b.append("\\'");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\u0000': {
                    b.append("\\0");
                    break;
                }
                case '\u0001': {
                    b.append("\\1");
                    break;
                }
                case '\u0002': {
                    b.append("\\2");
                    break;
                }
                case '\u0003': {
                    b.append("\\3");
                    break;
                }
                case '\u0004': {
                    b.append("\\4");
                    break;
                }
                case '\u0005': {
                    b.append("\\5");
                    break;
                }
                case '\u0006': {
                    b.append("\\6");
                    break;
                }
                case '\u0007': {
                    b.append("\\7");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append("\"");
        this.setEscapedValue(b.toString());
    }

    int memSize() {
        int size = 44;
        if (this.escapedValue != null) {
            size += 32 + 2 * this.escapedValue.length();
        }
        return size;
    }

    int treeSize() {
        return this.memSize();
    }
}

