/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceInfo
implements IElementTreeData,
ICoreConstants {
    protected int flags = 0;
    protected int contentId = 0;
    protected volatile long modificationStamp = -1L;
    protected volatile long nodeId = 0L;
    protected volatile long localInfo = -1L;
    protected int syncInfoGenerationCount = 0;
    protected ObjectMap syncInfo = null;
    protected ObjectMap sessionProperties = null;
    protected int markerGenerationCount = 0;
    protected MarkerSet markers = null;

    public void clear(int mask) {
        this.flags &= ~mask;
    }

    public synchronized void clearSessionProperties() {
        this.sessionProperties = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected static int getBits(int flags, int mask, int start) {
        return (flags & mask) >> start;
    }

    public int getContentId() {
        return this.contentId;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getLocalSyncInfo() {
        return this.localInfo;
    }

    public int getMarkerGenerationCount() {
        return this.markerGenerationCount;
    }

    public MarkerSet getMarkers() {
        return this.getMarkers(true);
    }

    public MarkerSet getMarkers(boolean makeCopy) {
        if (this.markers == null) {
            return null;
        }
        return makeCopy ? (MarkerSet)this.markers.clone() : this.markers;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public PropertyStore getPropertyStore() {
        return null;
    }

    public Object getSessionProperty(QualifiedName name) {
        ObjectMap temp = this.sessionProperties;
        if (temp == null) {
            return null;
        }
        return temp.get(name);
    }

    public synchronized byte[] getSyncInfo(QualifiedName id, boolean makeCopy) {
        if (this.syncInfo == null) {
            return null;
        }
        byte[] b = (byte[])this.syncInfo.get(id);
        return b == null ? null : (makeCopy ? (byte[])b.clone() : b);
    }

    public synchronized ObjectMap getSyncInfo(boolean makeCopy) {
        if (this.syncInfo == null) {
            return null;
        }
        return makeCopy ? (ObjectMap)this.syncInfo.clone() : this.syncInfo;
    }

    public int getSyncInfoGenerationCount() {
        return this.syncInfoGenerationCount;
    }

    public int getType() {
        return ResourceInfo.getType(this.flags);
    }

    public static int getType(int flags) {
        return ResourceInfo.getBits(flags, 3840, 8);
    }

    public void incrementContentId() {
        ++this.contentId;
    }

    public void incrementMarkerGenerationCount() {
        ++this.markerGenerationCount;
    }

    public void incrementSyncInfoGenerationCount() {
        ++this.syncInfoGenerationCount;
    }

    public boolean isSet(int mask) {
        return ResourceInfo.isSet(this.flags, mask);
    }

    public static boolean isSet(int flags, int mask) {
        return (flags & mask) != 0;
    }

    public void readFrom(int flags, DataInput input) throws IOException {
        this.flags = flags;
        this.localInfo = input.readLong();
        this.nodeId = input.readLong();
        this.contentId = input.readInt();
        this.modificationStamp = input.readLong();
    }

    public void set(int mask) {
        this.flags |= mask;
    }

    protected void setBits(int mask, int start, int value) {
        int baseMask = mask >> start;
        int newValue = (value & baseMask) << start;
        int temp = this.flags;
        temp &= ~mask;
        this.flags = temp |= newValue;
    }

    protected void setFlags(int value) {
        this.flags = value;
    }

    public void setLocalSyncInfo(long info) {
        this.localInfo = info;
    }

    public void setMarkers(MarkerSet value) {
        this.markers = value;
    }

    public void setModificationStamp(long stamp) {
        this.modificationStamp = stamp;
    }

    public void setNodeId(long id) {
        this.nodeId = id;
    }

    public void setPropertyStore(PropertyStore value) {
    }

    public synchronized void setSessionProperty(QualifiedName name, Object value) {
        if (value == null) {
            if (this.sessionProperties == null) {
                return;
            }
            ObjectMap temp = (ObjectMap)this.sessionProperties.clone();
            temp.remove(name);
            this.sessionProperties = temp.isEmpty() ? null : temp;
        } else {
            ObjectMap temp = this.sessionProperties;
            temp = temp == null ? new ObjectMap(5) : (ObjectMap)this.sessionProperties.clone();
            temp.put(name, value);
            this.sessionProperties = temp;
        }
    }

    protected void setSyncInfo(ObjectMap syncInfo) {
        this.syncInfo = syncInfo;
    }

    public synchronized void setSyncInfo(QualifiedName id, byte[] value) {
        if (value == null) {
            if (this.syncInfo == null) {
                return;
            }
            this.syncInfo.remove(id);
            if (this.syncInfo.isEmpty()) {
                this.syncInfo = null;
            }
        } else {
            if (this.syncInfo == null) {
                this.syncInfo = new ObjectMap(5);
            }
            this.syncInfo.put(id, value.clone());
        }
    }

    public void setType(int value) {
        this.setBits(3840, 8, value);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeLong(this.localInfo);
        output.writeLong(this.nodeId);
        output.writeInt(this.contentId);
        output.writeLong(this.modificationStamp);
    }
}

