/*!
	@file
	@author		Albert Semenov
	@date		08/2008
*/

#ifndef BASE_MANAGER_H_
#define BASE_MANAGER_H_

#include <MyGUI.h>

#include "InputManager.h"
#include "PointerManager.h"

namespace MyGUI
{
	class DummyPlatform;
}

namespace base
{
	class BaseManager :
		public input::InputManager,
		public input::PointerManager
	{
	public:
		BaseManager();

		virtual void prepare(); // инициализация коммандной строки
		bool create(int _width = 1024, int _height = 768); // создаем начальную точки каркаса приложения
		void destroy(); // очищаем все параметры каркаса приложения
		void run();
		void quit();

		void setWindowCaption(const std::wstring& _text);
		void makeScreenShot() { }

		const std::string& getRootMedia();
		void setResourceFilename(const std::string& _flename);
		void addResourceLocation(const std::string& _name, bool _recursive = false);

		MyGUI::MapString getStatistic() { return MyGUI::MapString(); }

		size_t getWindowHandle();

	/*internal:*/
		void _windowResized();

	protected:
		virtual void createScene() { }
		virtual void destroyScene() { }

		virtual void setupResources();

		virtual void injectMouseMove(int _absx, int _absy, int _absz);
		virtual void injectMousePress(int _absx, int _absy, MyGUI::MouseButton _id);
		virtual void injectMouseRelease(int _absx, int _absy, MyGUI::MouseButton _id);
		virtual void injectKeyPress(MyGUI::KeyCode _key, MyGUI::Char _text);
		virtual void injectKeyRelease(MyGUI::KeyCode _key);

		virtual void createGui();
		virtual void destroyGui();

		virtual void setWindowMaximized(bool _value);
		virtual bool getWindowMaximized();

		virtual void setWindowCoord(const MyGUI::IntCoord& _value);
		virtual MyGUI::IntCoord getWindowCoord();

	private:
		MyGUI::Gui* mGUI;
		MyGUI::DummyPlatform* mPlatform;

		HWND hWnd;
		HINSTANCE hInstance;

		bool mExit;
	};

} // namespace base

#endif // BASE_MANAGER_H_
