// Code generated by qtc from "auth.qtpl". DO NOT EDIT.
// See https://github.com/valyala/quicktemplate for details.

//line auth/auth.qtpl:1
package auth

//line auth/auth.qtpl:1
import "net/http"

//line auth/auth.qtpl:2
import "sort"

//line auth/auth.qtpl:3
import "github.com/bouncepaw/mycorrhiza/cfg"

//line auth/auth.qtpl:4
import "github.com/bouncepaw/mycorrhiza/l18n"

//line auth/auth.qtpl:5
import "github.com/bouncepaw/mycorrhiza/user"

//line auth/auth.qtpl:7
import (
	qtio422016 "io"

	qt422016 "github.com/valyala/quicktemplate"
)

//line auth/auth.qtpl:7
var (
	_ = qtio422016.Copy
	_ = qt422016.AcquireByteBuffer
)

//line auth/auth.qtpl:7
func StreamRegister(qw422016 *qt422016.Writer, rq *http.Request) {
//line auth/auth.qtpl:7
	qw422016.N().S(`
`)
//line auth/auth.qtpl:9
	lc := l18n.FromRequest(rq)

//line auth/auth.qtpl:10
	qw422016.N().S(`
<main class="main-width">
	<section>
	`)
//line auth/auth.qtpl:13
	if cfg.AllowRegistration {
//line auth/auth.qtpl:13
		qw422016.N().S(`
		<form class="modal" method="post" action="/register?`)
//line auth/auth.qtpl:14
		qw422016.E().S(rq.URL.RawQuery)
//line auth/auth.qtpl:14
		qw422016.N().S(`" id="register-form" enctype="multipart/form-data" autocomplete="off">
			<fieldset class="modal__fieldset">
				<legend class="modal__title">`)
//line auth/auth.qtpl:16
		qw422016.E().S(lc.Get("auth.register_header", &l18n.Replacements{"name": cfg.WikiName}))
//line auth/auth.qtpl:16
		qw422016.N().S(`</legend>

				<label for="register-form__username">`)
//line auth/auth.qtpl:18
		qw422016.E().S(lc.Get("auth.username"))
//line auth/auth.qtpl:18
		qw422016.N().S(`</label>
				<br>
				<input type="text" required autofocus id="login-form__username" name="username">
				<br>
				<label for="login-form__password">`)
//line auth/auth.qtpl:22
		qw422016.E().S(lc.Get("auth.password"))
//line auth/auth.qtpl:22
		qw422016.N().S(`</label>
				<br>
				<input type="password" required name="password">
				<p>`)
//line auth/auth.qtpl:25
		qw422016.E().S(lc.Get("auth.password_tip"))
//line auth/auth.qtpl:25
		qw422016.N().S(`</p>
				<p>`)
//line auth/auth.qtpl:26
		qw422016.E().S(lc.Get("auth.cookie_tip"))
//line auth/auth.qtpl:26
		qw422016.N().S(`</p>
				<button class="btn" type="submit" value="Register">`)
//line auth/auth.qtpl:27
		qw422016.E().S(lc.Get("auth.register_button"))
//line auth/auth.qtpl:27
		qw422016.N().S(`</button>
				<a class="btn btn_weak" href="/`)
//line auth/auth.qtpl:28
		qw422016.E().S(rq.URL.RawQuery)
//line auth/auth.qtpl:28
		qw422016.N().S(`">`)
//line auth/auth.qtpl:28
		qw422016.E().S(lc.Get("ui.cancel"))
//line auth/auth.qtpl:28
		qw422016.N().S(`</a>
			</fieldset>
		</form>
		`)
//line auth/auth.qtpl:31
		streamtelegramWidget(qw422016, lc)
//line auth/auth.qtpl:31
		qw422016.N().S(`
	`)
//line auth/auth.qtpl:32
	} else if cfg.UseAuth {
//line auth/auth.qtpl:32
		qw422016.N().S(`
		<p>`)
//line auth/auth.qtpl:33
		qw422016.E().S(lc.Get("auth.noregister"))
//line auth/auth.qtpl:33
		qw422016.N().S(`</p>
		<p><a href="/`)
//line auth/auth.qtpl:34
		qw422016.E().S(rq.URL.RawQuery)
//line auth/auth.qtpl:34
		qw422016.N().S(`">← `)
//line auth/auth.qtpl:34
		qw422016.E().S(lc.Get("auth.go_back"))
//line auth/auth.qtpl:34
		qw422016.N().S(`</a></p>
	`)
//line auth/auth.qtpl:35
	} else {
//line auth/auth.qtpl:35
		qw422016.N().S(`
		<p>`)
//line auth/auth.qtpl:36
		qw422016.E().S(lc.Get("auth.noauth"))
//line auth/auth.qtpl:36
		qw422016.N().S(`</p>
		<p><a href="/`)
//line auth/auth.qtpl:37
		qw422016.E().S(rq.URL.RawQuery)
//line auth/auth.qtpl:37
		qw422016.N().S(`">← `)
//line auth/auth.qtpl:37
		qw422016.E().S(lc.Get("auth.go_back"))
//line auth/auth.qtpl:37
		qw422016.N().S(`</a></p>
	`)
//line auth/auth.qtpl:38
	}
//line auth/auth.qtpl:38
	qw422016.N().S(`
	</section>
</main>
`)
//line auth/auth.qtpl:41
}

//line auth/auth.qtpl:41
func WriteRegister(qq422016 qtio422016.Writer, rq *http.Request) {
//line auth/auth.qtpl:41
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:41
	StreamRegister(qw422016, rq)
//line auth/auth.qtpl:41
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:41
}

//line auth/auth.qtpl:41
func Register(rq *http.Request) string {
//line auth/auth.qtpl:41
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:41
	WriteRegister(qb422016, rq)
//line auth/auth.qtpl:41
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:41
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:41
	return qs422016
//line auth/auth.qtpl:41
}

//line auth/auth.qtpl:43
func StreamLogin(qw422016 *qt422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:43
	qw422016.N().S(`
<main class="main-width">
	<section>
	`)
//line auth/auth.qtpl:46
	if cfg.UseAuth {
//line auth/auth.qtpl:46
		qw422016.N().S(`
		<form class="modal" method="post" action="/login" id="login-form" enctype="multipart/form-data" autocomplete="on">
			<fieldset class="modal__fieldset">
				<legend class="modal__title">`)
//line auth/auth.qtpl:49
		qw422016.E().S(lc.Get("auth.login_header", &l18n.Replacements{"name": cfg.WikiName}))
//line auth/auth.qtpl:49
		qw422016.N().S(`</legend>
				<label for="login-form__username">`)
//line auth/auth.qtpl:50
		qw422016.E().S(lc.Get("auth.username"))
//line auth/auth.qtpl:50
		qw422016.N().S(`</label>
				<br>
				<input type="text" required autofocus id="login-form__username" name="username" autocomplete="username">
				<br>
				<label for="login-form__password">`)
//line auth/auth.qtpl:54
		qw422016.E().S(lc.Get("auth.password"))
//line auth/auth.qtpl:54
		qw422016.N().S(`</label>
				<br>
				<input type="password" required name="password" autocomplete="current-password">
				<p>`)
//line auth/auth.qtpl:57
		qw422016.E().S(lc.Get("auth.cookie_tip"))
//line auth/auth.qtpl:57
		qw422016.N().S(`</p>
				<button class="btn" type="submit" value="Log in">`)
//line auth/auth.qtpl:58
		qw422016.E().S(lc.Get("auth.login_button"))
//line auth/auth.qtpl:58
		qw422016.N().S(`</button>
				<a class="btn btn_weak" href="/">`)
//line auth/auth.qtpl:59
		qw422016.E().S(lc.Get("ui.cancel"))
//line auth/auth.qtpl:59
		qw422016.N().S(`</a>
			</fieldset>
		</form>
		`)
//line auth/auth.qtpl:62
		streamtelegramWidget(qw422016, lc)
//line auth/auth.qtpl:62
		qw422016.N().S(`
	`)
//line auth/auth.qtpl:63
	} else {
//line auth/auth.qtpl:63
		qw422016.N().S(`
		<p>`)
//line auth/auth.qtpl:64
		qw422016.E().S(lc.Get("auth.noauth"))
//line auth/auth.qtpl:64
		qw422016.N().S(`</p>
		<p><a class="btn btn_weak" href="/">← `)
//line auth/auth.qtpl:65
		qw422016.E().S(lc.Get("auth.go_home"))
//line auth/auth.qtpl:65
		qw422016.N().S(`</a></p>
	`)
//line auth/auth.qtpl:66
	}
//line auth/auth.qtpl:66
	qw422016.N().S(`
	</section>
</main>
`)
//line auth/auth.qtpl:69
}

//line auth/auth.qtpl:69
func WriteLogin(qq422016 qtio422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:69
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:69
	StreamLogin(qw422016, lc)
//line auth/auth.qtpl:69
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:69
}

//line auth/auth.qtpl:69
func Login(lc *l18n.Localizer) string {
//line auth/auth.qtpl:69
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:69
	WriteLogin(qb422016, lc)
//line auth/auth.qtpl:69
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:69
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:69
	return qs422016
//line auth/auth.qtpl:69
}

// Telegram auth widget was requested by Yogurt. As you can see, we don't offer user administrators control over it. Of course we don't.

//line auth/auth.qtpl:72
func streamtelegramWidget(qw422016 *qt422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:72
	qw422016.N().S(`
`)
//line auth/auth.qtpl:73
	if cfg.TelegramEnabled {
//line auth/auth.qtpl:73
		qw422016.N().S(`
<p class="telegram-notice">`)
//line auth/auth.qtpl:74
		qw422016.E().S(lc.Get("auth.telegram_tip"))
//line auth/auth.qtpl:74
		qw422016.N().S(`</p>
<script async src="https://telegram.org/js/telegram-widget.js?15" data-telegram-login="`)
//line auth/auth.qtpl:75
		qw422016.E().S(cfg.TelegramBotName)
//line auth/auth.qtpl:75
		qw422016.N().S(`" data-size="medium" data-userpic="false" data-auth-url="`)
//line auth/auth.qtpl:75
		qw422016.E().S(cfg.URL)
//line auth/auth.qtpl:75
		qw422016.N().S(`/telegram-login"></script>
`)
//line auth/auth.qtpl:76
	}
//line auth/auth.qtpl:76
	qw422016.N().S(`
`)
//line auth/auth.qtpl:77
}

//line auth/auth.qtpl:77
func writetelegramWidget(qq422016 qtio422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:77
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:77
	streamtelegramWidget(qw422016, lc)
//line auth/auth.qtpl:77
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:77
}

//line auth/auth.qtpl:77
func telegramWidget(lc *l18n.Localizer) string {
//line auth/auth.qtpl:77
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:77
	writetelegramWidget(qb422016, lc)
//line auth/auth.qtpl:77
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:77
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:77
	return qs422016
//line auth/auth.qtpl:77
}

//line auth/auth.qtpl:79
func StreamLoginError(qw422016 *qt422016.Writer, err string, lc *l18n.Localizer) {
//line auth/auth.qtpl:79
	qw422016.N().S(`
<main class="main-width">
	<section>
	`)
//line auth/auth.qtpl:82
	switch err {
//line auth/auth.qtpl:83
	case "unknown username":
//line auth/auth.qtpl:83
		qw422016.N().S(`
		<p class="error">`)
//line auth/auth.qtpl:84
		qw422016.E().S(lc.Get("auth.error_username"))
//line auth/auth.qtpl:84
		qw422016.N().S(`</p>
	`)
//line auth/auth.qtpl:85
	case "wrong password":
//line auth/auth.qtpl:85
		qw422016.N().S(`
		<p class="error">`)
//line auth/auth.qtpl:86
		qw422016.E().S(lc.Get("auth.error_password"))
//line auth/auth.qtpl:86
		qw422016.N().S(`</p>
	`)
//line auth/auth.qtpl:87
	default:
//line auth/auth.qtpl:87
		qw422016.N().S(`
		<p class="error">`)
//line auth/auth.qtpl:88
		qw422016.E().S(err)
//line auth/auth.qtpl:88
		qw422016.N().S(`</p>
	`)
//line auth/auth.qtpl:89
	}
//line auth/auth.qtpl:89
	qw422016.N().S(`
		<p><a href="/login">← `)
//line auth/auth.qtpl:90
	qw422016.E().S(lc.Get("auth.try_again"))
//line auth/auth.qtpl:90
	qw422016.N().S(`</a></p>
	</section>
</main>
`)
//line auth/auth.qtpl:93
}

//line auth/auth.qtpl:93
func WriteLoginError(qq422016 qtio422016.Writer, err string, lc *l18n.Localizer) {
//line auth/auth.qtpl:93
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:93
	StreamLoginError(qw422016, err, lc)
//line auth/auth.qtpl:93
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:93
}

//line auth/auth.qtpl:93
func LoginError(err string, lc *l18n.Localizer) string {
//line auth/auth.qtpl:93
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:93
	WriteLoginError(qb422016, err, lc)
//line auth/auth.qtpl:93
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:93
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:93
	return qs422016
//line auth/auth.qtpl:93
}

//line auth/auth.qtpl:95
func StreamLogout(qw422016 *qt422016.Writer, can bool, lc *l18n.Localizer) {
//line auth/auth.qtpl:95
	qw422016.N().S(`
<main class="main-width">
	<section>
	`)
//line auth/auth.qtpl:98
	if can {
//line auth/auth.qtpl:98
		qw422016.N().S(`
		<h1>`)
//line auth/auth.qtpl:99
		qw422016.E().S(lc.Get("auth.logout_header"))
//line auth/auth.qtpl:99
		qw422016.N().S(`</h1>
		<form method="POST" action="/logout">
			<input class="btn btn_accent" type="submit" value="`)
//line auth/auth.qtpl:101
		qw422016.E().S(lc.Get("auth.logout_button"))
//line auth/auth.qtpl:101
		qw422016.N().S(`"/>
			<a class="btn btn_weak" href="/">`)
//line auth/auth.qtpl:102
		qw422016.E().S(lc.Get("auth.go_home"))
//line auth/auth.qtpl:102
		qw422016.N().S(`</a>
		</form>
	`)
//line auth/auth.qtpl:104
	} else {
//line auth/auth.qtpl:104
		qw422016.N().S(`
		<p>`)
//line auth/auth.qtpl:105
		qw422016.E().S(lc.Get("auth.logout_anon"))
//line auth/auth.qtpl:105
		qw422016.N().S(`</p>
		<p><a href="/login">`)
//line auth/auth.qtpl:106
		qw422016.E().S(lc.Get("auth.login_title"))
//line auth/auth.qtpl:106
		qw422016.N().S(`</a></p>
		<p><a href="/">← `)
//line auth/auth.qtpl:107
		qw422016.E().S(lc.Get("auth.go_home"))
//line auth/auth.qtpl:107
		qw422016.N().S(`</a></p>
	`)
//line auth/auth.qtpl:108
	}
//line auth/auth.qtpl:108
	qw422016.N().S(`
	</section>
</main>
`)
//line auth/auth.qtpl:111
}

//line auth/auth.qtpl:111
func WriteLogout(qq422016 qtio422016.Writer, can bool, lc *l18n.Localizer) {
//line auth/auth.qtpl:111
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:111
	StreamLogout(qw422016, can, lc)
//line auth/auth.qtpl:111
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:111
}

//line auth/auth.qtpl:111
func Logout(can bool, lc *l18n.Localizer) string {
//line auth/auth.qtpl:111
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:111
	WriteLogout(qb422016, can, lc)
//line auth/auth.qtpl:111
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:111
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:111
	return qs422016
//line auth/auth.qtpl:111
}

//line auth/auth.qtpl:113
func StreamLock(qw422016 *qt422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:113
	qw422016.N().S(`
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>🔒 `)
//line auth/auth.qtpl:119
	qw422016.E().S(lc.Get("auth.lock_title"))
//line auth/auth.qtpl:119
	qw422016.N().S(`</title>
	<link rel="shortcut icon" href="/static/favicon.ico">
	<link rel="stylesheet" href="/static/style.css">
</head>
<body>
	<main class="locked-notice main-width">
		<section class="locked-notice__message">
			<p class="locked-notice__lock">🔒</p>
			<h1 class="locked-notice__title">`)
//line auth/auth.qtpl:127
	qw422016.E().S(lc.Get("auth.lock_title"))
//line auth/auth.qtpl:127
	qw422016.N().S(`</h1>
			<form class="locked-notice__login-form" method="post" action="/login" id="login-form" enctype="multipart/form-data" autocomplete="on">
				<label for="login-form__username">`)
//line auth/auth.qtpl:129
	qw422016.E().S(lc.Get("auth.username"))
//line auth/auth.qtpl:129
	qw422016.N().S(`</label>
				<br>
				<input type="text" required autofocus id="login-form__username" name="username" autocomplete="username">
				<br>
				<label for="login-form__password">`)
//line auth/auth.qtpl:133
	qw422016.E().S(lc.Get("auth.password"))
//line auth/auth.qtpl:133
	qw422016.N().S(`</label>
				<br>
				<input type="password" required name="password" autocomplete="current-password">
				<br>
				<button class="btn" type="submit" value="Log in">`)
//line auth/auth.qtpl:137
	qw422016.E().S(lc.Get("auth.login_button"))
//line auth/auth.qtpl:137
	qw422016.N().S(`</button>
			</form>
			`)
//line auth/auth.qtpl:139
	streamtelegramWidget(qw422016, lc)
//line auth/auth.qtpl:139
	qw422016.N().S(`
		</section>
	</main>
</body>
</html>
`)
//line auth/auth.qtpl:144
}

//line auth/auth.qtpl:144
func WriteLock(qq422016 qtio422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:144
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:144
	StreamLock(qw422016, lc)
//line auth/auth.qtpl:144
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:144
}

//line auth/auth.qtpl:144
func Lock(lc *l18n.Localizer) string {
//line auth/auth.qtpl:144
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:144
	WriteLock(qb422016, lc)
//line auth/auth.qtpl:144
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:144
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:144
	return qs422016
//line auth/auth.qtpl:144
}

//line auth/auth.qtpl:147
var userListL10n = map[string]L10nEntry{
	"heading":        En("List of users").Ru("Список пользователей"),
	"administrators": En("Administrators").Ru("Администраторы"),
	"moderators":     En("Moderators").Ru("Модераторы"),
	"editors":        En("Editors").Ru("Редакторы"),
	"readers":        En("Readers").Ru("Читатели"),
}

//line auth/auth.qtpl:156
func StreamUserList(qw422016 *qt422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:156
	qw422016.N().S(`
<main class="main-width user-list">
`)
//line auth/auth.qtpl:159
	var get = func(key string) string {
		return userListL10n[key].Get(lc.Locale)
	}

	var (
		admins     = make([]string, 0)
		moderators = make([]string, 0)
		editors    = make([]string, 0)
		readers    = make([]string, 0)
	)
	for u := range user.YieldUsers() {
		switch u.Group {
		// What if we place the users into sorted slices?
		case "admin":
			admins = append(admins, u.Name)
		case "moderator":
			moderators = append(moderators, u.Name)
		case "editor", "trusted":
			editors = append(editors, u.Name)
		case "reader":
			readers = append(readers, u.Name)
		}
	}
	sort.Strings(admins)
	sort.Strings(moderators)
	sort.Strings(editors)
	sort.Strings(readers)

//line auth/auth.qtpl:186
	qw422016.N().S(`
	<h1>`)
//line auth/auth.qtpl:187
	qw422016.E().S(get("heading"))
//line auth/auth.qtpl:187
	qw422016.N().S(`</h1>
	<section>
		<h2>`)
//line auth/auth.qtpl:189
	qw422016.E().S(get("administrators"))
//line auth/auth.qtpl:189
	qw422016.N().S(`</h2>
		<ol>`)
//line auth/auth.qtpl:190
	for _, name := range admins {
//line auth/auth.qtpl:190
		qw422016.N().S(`
			<li><a href="/hypha/`)
//line auth/auth.qtpl:191
		qw422016.E().S(cfg.UserHypha)
//line auth/auth.qtpl:191
		qw422016.N().S(`/`)
//line auth/auth.qtpl:191
		qw422016.E().S(name)
//line auth/auth.qtpl:191
		qw422016.N().S(`">`)
//line auth/auth.qtpl:191
		qw422016.E().S(name)
//line auth/auth.qtpl:191
		qw422016.N().S(`</a></li>
		`)
//line auth/auth.qtpl:192
	}
//line auth/auth.qtpl:192
	qw422016.N().S(`</ol>
	</section>
	<section>
		<h2>`)
//line auth/auth.qtpl:195
	qw422016.E().S(get("moderators"))
//line auth/auth.qtpl:195
	qw422016.N().S(`</h2>
		<ol>`)
//line auth/auth.qtpl:196
	for _, name := range moderators {
//line auth/auth.qtpl:196
		qw422016.N().S(`
			<li><a href="/hypha/`)
//line auth/auth.qtpl:197
		qw422016.E().S(cfg.UserHypha)
//line auth/auth.qtpl:197
		qw422016.N().S(`/`)
//line auth/auth.qtpl:197
		qw422016.E().S(name)
//line auth/auth.qtpl:197
		qw422016.N().S(`">`)
//line auth/auth.qtpl:197
		qw422016.E().S(name)
//line auth/auth.qtpl:197
		qw422016.N().S(`</a></li>
		`)
//line auth/auth.qtpl:198
	}
//line auth/auth.qtpl:198
	qw422016.N().S(`</ol>
	</section>
	<section>
		<h2>`)
//line auth/auth.qtpl:201
	qw422016.E().S(get("editors"))
//line auth/auth.qtpl:201
	qw422016.N().S(`</h2>
		<ol>`)
//line auth/auth.qtpl:202
	for _, name := range editors {
//line auth/auth.qtpl:202
		qw422016.N().S(`
			<li><a href="/hypha/`)
//line auth/auth.qtpl:203
		qw422016.E().S(cfg.UserHypha)
//line auth/auth.qtpl:203
		qw422016.N().S(`/`)
//line auth/auth.qtpl:203
		qw422016.E().S(name)
//line auth/auth.qtpl:203
		qw422016.N().S(`">`)
//line auth/auth.qtpl:203
		qw422016.E().S(name)
//line auth/auth.qtpl:203
		qw422016.N().S(`</a></li>
		`)
//line auth/auth.qtpl:204
	}
//line auth/auth.qtpl:204
	qw422016.N().S(`</ol>
	</section>
	<section>
		<h2>`)
//line auth/auth.qtpl:207
	qw422016.E().S(get("readers"))
//line auth/auth.qtpl:207
	qw422016.N().S(`</h2>
		<ol>`)
//line auth/auth.qtpl:208
	for _, name := range readers {
//line auth/auth.qtpl:208
		qw422016.N().S(`
			<li><a href="/hypha/`)
//line auth/auth.qtpl:209
		qw422016.E().S(cfg.UserHypha)
//line auth/auth.qtpl:209
		qw422016.N().S(`/`)
//line auth/auth.qtpl:209
		qw422016.E().S(name)
//line auth/auth.qtpl:209
		qw422016.N().S(`">`)
//line auth/auth.qtpl:209
		qw422016.E().S(name)
//line auth/auth.qtpl:209
		qw422016.N().S(`</a></li>
		`)
//line auth/auth.qtpl:210
	}
//line auth/auth.qtpl:210
	qw422016.N().S(`</ol>
	</section>
</main>
`)
//line auth/auth.qtpl:213
}

//line auth/auth.qtpl:213
func WriteUserList(qq422016 qtio422016.Writer, lc *l18n.Localizer) {
//line auth/auth.qtpl:213
	qw422016 := qt422016.AcquireWriter(qq422016)
//line auth/auth.qtpl:213
	StreamUserList(qw422016, lc)
//line auth/auth.qtpl:213
	qt422016.ReleaseWriter(qw422016)
//line auth/auth.qtpl:213
}

//line auth/auth.qtpl:213
func UserList(lc *l18n.Localizer) string {
//line auth/auth.qtpl:213
	qb422016 := qt422016.AcquireByteBuffer()
//line auth/auth.qtpl:213
	WriteUserList(qb422016, lc)
//line auth/auth.qtpl:213
	qs422016 := string(qb422016.B)
//line auth/auth.qtpl:213
	qt422016.ReleaseByteBuffer(qb422016)
//line auth/auth.qtpl:213
	return qs422016
//line auth/auth.qtpl:213
}
