\page i18n Internationalization

This page gives an overview of options on how to translate a plugin to different languages.

### Reuse MuseScore translatable strings

If your plugin only needs strings that are already used within MuseScore (e.g. some musical terms or actions names) the simplest method to keep a plugin translated is to reuse translations that already exist in MuseScore. In order to do this you need to use [`qsTranslate()`](https://doc.qt.io/qt-5/qml-qtqml-qt.html#qsTranslate-method) function with appropriate translation contexts:
```
var t1 = qsTranslate("symUserNames", "Sharp"); // gets a translation for "Sharp" symbol name
console.log(t1);
var t2 = qsTranslate("action", "Export parts"); // gets a translation for "Export parts" action
console.log(t2);
```

Translation contexts for existing strings can be searched for on [Transifex](https://www.transifex.com/musescore/musescore) or directly in MuseScore [source code](https://github.com/musescore/MuseScore).

This method allows to quickly make a plugin translatable. Still it may not fit a particular plugin's needs. \n
Translation contexts are not guaranteed to remain unchanged between MuseScore releases. Also this method won't work if a plugin needs strings that are not used anywhere else in MuseScore.

### Add translation files to the plugin

To make plugin's strings translatable you need to use [`qsTr()`](https://doc.qt.io/qt-5/qml-qtqml-qt.html#qsTr-method) for all your "quoted strings" in the `.qml` files. `qsTr()` has 3 arguments, the 1st is the string to be translated, the 2nd (optional) argument is a comment to the translator (which is later visible in Qt Linguist), the 3rd (also optional) is intended to be used for handling plurals in translations. \n
It can work with placeholders, e.g. `qsTr("Pages: %1").arg(numberOfPages)`

For translating \ref Ms::PluginAPI::PluginAPI::menuPath "menu item" of the plugin it is better not to translate the top-level item of menu path (usually "Plugins"):
```
menuPath: "Plugins." + qsTr("Note Names")
```

In order to avoid conflicts with other plugins' translations it is recommended to have a separate directory for your plugin (that is, plugin's `.qml` files should *not* be put directly to Plugins directory but to a subdirectory created specifically for that plugin).

Then create a directory named `translations` in the plugin's directory. You need to put `locale_XX.qm` files in it. \n
To obtain a `.qm` file for your plugin run the following command: \n
(*replace XX by the targetted language (eg.: "de" for German) and include .qml and .js files*)
```
lupdate <your plugin files> translations/locale_XX.ts
```
This extracts all translatable strings from the `.qml` and `.js` files into that `.ts` file. \n
Repeat for other languages if needed.

Use Qt Linguist to put the translation into `locale_XX.ts`. Once done use *File* → *Release* in Qt Linguist or run the following:
```
lrelease translations/locale_XX.ts
```
That will create/update a `locale_XX.qm` file. \n
Now, run MuseScore in your language and your plugin should be translated!

More detailed information can be found in [Qt documentation](https://doc.qt.io/qt-5/qtquick-internationalization.html).

A working example of translation files usage can be found in [Batch Export](https://musescore.org/en/project/batch-convert) plugin.
