// Copyright 2016-2021 The Mumble Developers. All rights reserved.
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file at the root of the
// Mumble source tree or at <https://www.mumble.info/LICENSE>.

/*
 * This file was auto-generated by scripts/mklic.pl
 * DO NOT EDIT IT MANUALLY
 */
#ifndef MUMBLE_LICENSES_H_
#define MUMBLE_LICENSES_H_

#include <QtGlobal>

struct ThirdPartyLicense {
	const char *name;
	const char *url;
	const char *license;

	ThirdPartyLicense() : name(0), url(0), license(0) {}
	ThirdPartyLicense(const char *name_, const char *url_, const char *license_)
		: name(name_), url(url_), license(license_) {}
	bool isEmpty() const { return (name == 0 && url == 0 && license == 0); }
};

#define DOQUOTE(arg) #arg
#define QUOTE(arg) DOQUOTE(arg)

#ifdef MUMBLE_BUILD_YEAR
#	define COPYRIGHT_END QUOTE(MUMBLE_BUILD_YEAR)
#else
#	define COPYRIGHT_END "now"
#endif

static const char *licenseMumble = "Copyright (C) 2005-" COPYRIGHT_END " The Mumble Developers\n"
								   "\n"
								   "A list of The Mumble Developers can be found in the\n"
								   "AUTHORS file at the root of the Mumble source tree\n"
								   "or at <https://www.mumble.info/AUTHORS>.\n"
								   "\n"
								   "All rights reserved.\n"
								   "\n"
								   "Redistribution and use in source and binary forms, with or without\n"
								   "modification, are permitted provided that the following conditions\n"
								   "are met:\n"
								   "\n"
								   "- Redistributions of source code must retain the above copyright notice,\n"
								   "  this list of conditions and the following disclaimer.\n"
								   "- Redistributions in binary form must reproduce the above copyright notice,\n"
								   "  this list of conditions and the following disclaimer in the documentation\n"
								   "  and/or other materials provided with the distribution.\n"
								   "- Neither the name of The Mumble Developers nor the names of its\n"
								   "  contributors may be used to endorse or promote products derived from this\n"
								   "  software without specific prior written permission.\n"
								   "\n"
								   "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								   "`AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								   "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								   "A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR\n"
								   "CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
								   "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
								   "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
								   "PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
								   "LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								   "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								   "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
								   "\n"
								   "For questions and inquiries about Mumble's license,\n"
								   "please contact <license@mumble.info>.";


static const char *authorsMumble = "// This is the official list of people who have contributed\n"
								   "// to, and/or hold the copyright to Mumble.\n"
								   "//\n"
								   "// The use of Mumble source code is governed by a BSD-style\n"
								   "// license that can be found in the LICENSE file at the root\n"
								   "// of the Mumble source tree or at <https://www.mumble.info/LICENSE>.\n"
								   "//\n"
								   "// Contributions made on behalf of another entity, such as a\n"
								   "// company are indicated with the following suffix:\n"
								   "//\n"
								   "//     John Doe <jd@mumble.info> (on behalf of $COMPANY)\n"
								   "//\n"
								   "// It is possible to mix individual contributions with company\n"
								   "// contributions. For example, if a contributor, over time,\n"
								   "// has contributed code copyrighted by the contributor, as well\n"
								   "// as various companies:\n"
								   "//\n"
								   "//     John Doe <jd@mumble.info> (individually, on behalf of\n"
								   "//                                $COMPANY1, on behalf of\n"
								   "//                                $COMPANY2, [...]).\n"
								   "//\n"
								   "// Mumble's code is developed in a Git repository. A log of\n"
								   "// every contribution ever made to Mumble is available in the\n"
								   "// Git repository. The Git repository can be queried to get\n"
								   "// detailed authorship information for copyright and attribution\n"
								   "// purposes for each file that makes up the software. A detailed\n"
								   "// analysis of contributions made to Mumble is available via GitHub's\n"
								   "// contribution statistics:\n"
								   "//\n"
								   "// <https://github.com/mumble-voip/mumble/graphs/contributors>\n"
								   "\n"
								   "Abex <mii7303@gmail.com>\n"
								   "Alex Krishnan <akrishnan@twilio.com>\n"
								   "Alex Maclean <monkeh@monkeh.net>\n"
								   "Allan Nordhøy <epost@anotheragency.no>\n"
								   "Álvaro Manuel Recio Pérez <naproxeno@users.sourceforge.net>\n"
								   "Andreas Bibok <biboka@users.sourceforge.net>\n"
								   "Andreas Messer <andi@bupfen.de>\n"
								   "Andreas Sinz <andreas.sinz@aon.at>\n"
								   "Andrew Johnson <ajohnson@draster.com>\n"
								   "anonym <anonym@riseup.net>\n"
								   "Anthony Alves <cvballa3g0@gmail.com>\n"
								   "Antoine Bertin <diaoulael@users.sourceforge.net>\n"
								   "Anton Romanov <theli.ua@gmail.com>\n"
								   "Antonio Larrosa <larrosa@kde.org>\n"
								   "Arie <allochtoon@zonnet.nl>\n"
								   "Arne Fenske <arne_fenske@Yahoo.de>\n"
								   "arrai <array.of.intellect@gmail.com>\n"
								   "Arseniy Lartsev <ars3niy@users.sourceforge.net>\n"
								   "Artem Vorotnikov <skybon@gmail.com>\n"
								   "Arthur Moore <Arthur.Moore.git@cd-net.net>\n"
								   "asmolero <alsamolero@gmail.com>\n"
								   "Asura Lee <ashurta@gmail.com>\n"
								   "B0nuse <mumble@mumble.ru>\n"
								   "Balazs Nagy <julian7@users.sourceforge.net>\n"
								   "Bartek \"stranded\" Sumowski <sumowski@gmail.com>\n"
								   "Bas Wijnen <wijnen@debian.org>\n"
								   "BAYSSE Laurent <lolo_32@users.sourceforge.net>\n"
								   "bendem <online@bendem.be>\n"
								   "Benjamin Jemlich <pcgod@users.sourceforge.net>\n"
								   "Benjamin Neff <benjamin@coding4coffee.ch>\n"
								   "Bernhard M. Wiedemann <bernhardout@lsmod.de>\n"
								   "bogie <priivet@gmail.com>\n"
								   "Bojan <bogie@b02.a01.ca>\n"
								   "brooss <brooss.teambb@gmail.com>\n"
								   "BuddyButterfly <buddy.butterfly@web.de>\n"
								   "Cesare Tirabassi <cesare.tirabassi@gmail.com>\n"
								   "Charles Ricketts <githlar@gmail.com>\n"
								   "Chosi <chosi@choseh.de>\n"
								   "Christian Krause <chkr@plauener.de>\n"
								   "Christoph Hofmann <christoph.hofmann@vfc2.eu>\n"
								   "Christopher Knadle <Chris.Knadle@coredump.us>\n"
								   "concatime <https://github.com/concatime>\n"
								   "Cristian Gattamelati <cristian.gattamelati@gmail.com>\n"
								   "d-rez <dark.skeleton@gmail.com>\n"
								   "Davide Beatrici <davidebeatrici@gmail.com>\n"
								   "Davide Beatrici <https://github.com/davidebeatrici>\n"
								   "davidebeatrici <davidebeatrici@gmail.com>\n"
								   "dc6jgk <github.filter@gkware.com>\n"
								   "dennisschagt <dennisschagt@gmail.com>\n"
								   "derandi <derandi@users.sourceforge.net>\n"
								   "Derrick Dymock <actown@gmail.com>\n"
								   "DK <davidk@mail.org>\n"
								   "DNW <dnw.ftw@gmail.com>\n"
								   "doggone <rolf@metadata.be>\n"
								   "DWM|G <gallaghermumble@gmail.com>\n"
								   "EarlOfWenc <lorenz.schwittmann@gmail.com>\n"
								   "Eli Tallman <eli.github@gmail.com>\n"
								   "Entitaet <entitaet@users.sourceforge.net>\n"
								   "Erik Bouvin Pedersen <erikbp@users.sourceforge.net>\n"
								   "Evan Purkhiser <evanpurkhiser@gmail.com>\n"
								   "Ferdinand Thiessen <rpm@fthiessen.de>\n"
								   "Filip Hedman <hedman.filip@gmail.com>\n"
								   "Finessi Manuel <fino.manu@gmail.com>\n"
								   "Flumble <flumble@home.nl>\n"
								   "Frank Engler <https://github.com/9x6>\n"
								   "Frank Mueller <frmimue@gmail.com>\n"
								   "Fredrik Nordin <freedick@ludd.ltu.se>\n"
								   "Friedrich Uz-Valentin <uz_@users.sourceforge.net>\n"
								   "Generator <american.jesus.pt@gmail.com>\n"
								   "GoD-Tony <noreply@gmail.com>\n"
								   "Harry Gabriel <h.gabriel@nodefab.de>\n"
								   "haru_arc <arcenciel@users.sf.net>\n"
								   "He Tal <hetao29@users.sourceforge.net>\n"
								   "Hengqing Hu <esrms@users.sourceforge.net>\n"
								   "Henry Fallon <hjf288@gmail.com>\n"
								   "Iain Georgeson <debbugs@iain.georgeson.me.uk>\n"
								   "Ilmar Kruis <seaeagle1@users.sourceforge.net>\n"
								   "Imre Botos <zokny@users.sourceforge.net>\n"
								   "Jacob Peddicord <jacob@peddicord.net>\n"
								   "Jakob Dettner <jakobdettner@users.sourceforge.net>\n"
								   "James Fraser <fwaggle@fwaggle.org>\n"
								   "Jan Braun <janbraun@gmx.net>\n"
								   "Jan Klass <kissaki@posteo.de>\n"
								   "javitonino <javitonino@users.sourceforge.net>\n"
								   "Jeff Rogers <jeff@flyzipline.com>\n"
								   "Jérôme \"buggerone\" <buggerone@users.sourceforge.net>\n"
								   "Jerome Vidal <jerhum@users.sourceforge.net>\n"
								   "jgeboski <jgeboski@gmail.com>\n"
								   "Joel Kees <joelkees@gmail.com>\n"
								   "Joël Troch <joel.troch62@gmail.com>\n"
								   "John Marion <john@lmsn.net>\n"
								   "John P <johnhatestrash@gmail.com>\n"
								   "Jonathan E. Hansen <zentriple@users.sourceforge.net>\n"
								   "Jordan Cristiano <https://github.com/SizzlingCalamari>\n"
								   "Jordan Klassen <jordan@klassen.me.uk>\n"
								   "Joshua Kocinski <git@cl0secall.net>\n"
								   "Julien Pardons <j.pardons@redline-hosting.eu>\n"
								   "Justin M <justin.m.mcgrath@gmail.com>\n"
								   "Justin McGrath <justin.m.mcgrath@gmail.com>\n"
								   "Karl Dietz <dekarl@spaetfruehstuecken.org>\n"
								   "karokatona <karokatona@users.sourceforge.net>\n"
								   "Kevin Rohland <kevin@nascher.org>\n"
								   "Kevin Strasser <kevstras@gmail.com>\n"
								   "Kjetil Jørgensen <kjetijor@users.sourceforge.net>\n"
								   "Kyle Smith <askreet@gmail.com>\n"
								   "Kyle Wickens <kylewickens@gmail.com>\n"
								   "Lari Tikkanen <lartza@outlook.com>\n"
								   "Lartza <https://github.com/Lartza>\n"
								   "Lekensteyn <lekensteyn@users.sourceforge.net>\n"
								   "Leszek Godlewski <inequation@users.sourceforge.net>\n"
								   "lewisca04 <chris.lewis0094@gmail.com>\n"
								   "Ludwig Nussel <ludwig.nussel@suse.de>\n"
								   "Lukas Orsvärn <lucas.orsv@gmail.com>\n"
								   "Luke A Pitt <LukeAPitt@googlemail.com>\n"
								   "main() <main@ehvag.eu.org>\n"
								   "Marc Deslauriers <marc.deslauriers@canonical.com>\n"
								   "Marius Grannæs <grannas@users.sourceforge.net>\n"
								   "Mark Felder <feld@feld.me>\n"
								   "Mark Schreiber <mark7@users.sourceforge.net>\n"
								   "Mark-Willem Jansen <rawnar@users.sourceforge.net>\n"
								   "Markus S <Reaper@gmx.at>\n"
								   "Martijn Stolk <github@netripper.nl>\n"
								   "Martin Skilnand <cybknight@users.sourceforge.net>\n"
								   "Martin von Gagern <Martin.vGagern@gmx.net>\n"
								   "Matt Hamilton <m@tthamilton.com>\n"
								   "Matt Lewandowsky <matt@greenviolet.net>\n"
								   "Matt M. <mokomull@users.sourceforge.net>\n"
								   "Matthias Mailänder <matthias@mailaender.name>\n"
								   "Matthias Salzeder <mail@MatthiasSalzeder.de>\n"
								   "Matthias Vogelgesang <matthias.vogelgesang@gmail.com>\n"
								   "Max Weber <mii7303@gmail.com>\n"
								   "Maxwell Cody <roge@riseup.net>\n"
								   "meanracoon <racoon@meanclan.org>\n"
								   "Mew <Giratina493@mew151.net>\n"
								   "Micah Caldwell <micah@zoltu.net>\n"
								   "Michael Pavlyshko <me@mixaill.tk>\n"
								   "Michael Ziegler <diese-addy@funzt-halt.net>\n"
								   "Michał \"Zuko\" Żukowski <zuczeq@gmail.com>\n"
								   "Mike <mike@flomp.net>\n"
								   "Mikkel Krautz <mikkel@krautz.dk>\n"
								   "Mikko Rantanen <jubjub@jubjubnest.net>\n"
								   "mray <mail@mray.de>\n"
								   "mystic_sam <mystic_sam@users.sourceforge.net>\n"
								   "Natenom <natenom@natenom.com>\n"
								   "Nick Heindl <nheindl@wisc.edu>\n"
								   "Nicos Gollan <gtdev@spearhead.de>\n"
								   "Nik Johnson <nik@jnstw.us>\n"
								   "Nikita Puzyryov <https://github.com/NikitaPuzyryov>\n"
								   "Nikolaj Dombrow <nikolaj.dombrow@dombrow.de>\n"
								   "nomad <gmc_holle@users.sourceforge.net>\n"
								   "Opalium <opalium@users.sourceforge.net>\n"
								   "Otto Allmendinger <oallmendinger@users.sourceforge.net>\n"
								   "ozon <mumble-tower@users.sourceforge.net>\n"
								   "Patrick Matthäi <pmatthaei@debian.org>\n"
								   "Peter Vágner <pvdeejay@gmail.com>\n"
								   "Phil <synapse84@gmail.com>\n"
								   "Philip Cass <frymaster@127001.org>\n"
								   "Phrag <info@clanwars.cz>\n"
								   "Piratonym <piratonym@piratonym.cc>\n"
								   "Prosper_Spurius <prosper_spurius@users.sourceforge.net>\n"
								   "QuirB <quirb@gmx.net>\n"
								   "qwestduck <gsreceiver2@yahoo.com>\n"
								   "Rafael Correia <rafaeljpc@gmail.com>\n"
								   "Rafael Lopez <rafael@case.edu>\n"
								   "rdb <git@rdb.name>\n"
								   "Roman Priesol <roman@priesol.net>\n"
								   "ronoc <conor@forwind.net>\n"
								   "Ryan Austin <ryan.e.austin@gmail.com>\n"
								   "Sami Laine <sami.v.laine@gmail.com>\n"
								   "Samuel D. Leslie <sdl@nexiom.net>\n"
								   "scapula <rasmus.ry@gmail.com>\n"
								   "Sebastian Schlingmann <mit_service@users.sourceforge.net>\n"
								   "Semion Tsinman <Necromancer3333@gmail.com>\n"
								   "Sergey Ivanov <randomei@users.sourceforge.net>\n"
								   "Shen-Ta Hsieh <ibmibmibm.tw@gmail.com>\n"
								   "Spaccaossi <spaccaossi@gmail.com>\n"
								   "spede <spede@dota2.fi>\n"
								   "Stefan Gehn <mETz@gehn.net>\n"
								   "Stefan Hacker <dd0t@users.sourceforge.net>\n"
								   "Steve Hill <github@cheesy.sackheads.org>\n"
								   "Steven Noonan <steven@uplinklabs.net>\n"
								   "Sven-Hendrik Haase <sh@lutzhaase.com>\n"
								   "Svenne33 <svenne33@users.sourceforge.net>\n"
								   "Svyatoslav <razmyslov@viva64.com>\n"
								   "synapse84 <synapse84@gmail.com>\n"
								   "Thibault Capdevielled <theblackstorm@userse.sourceforge.net>\n"
								   "Thibaut Girka\n"
								   "Thorvald Natvig <slicer@users.sourceforge.net>\n"
								   "Tim Burke <tim.burke@gmail.com>\n"
								   "Tim Cooper <tim.cooper@layeh.com>\n"
								   "Tim Visée <timvisee@gmail.com>\n"
								   "Timo Gurr <timo.gurr@gmail.com>\n"
								   "Timo K <timer@dbclan.de>\n"
								   "tkmorris <mauricioarozi@gmail.com>\n"
								   "Tristan Matthews <tristan.matthews@savoirfairelinux.com>\n"
								   "Tsbook <tsbook@users.sourceforge.net>\n"
								   "Wesley W. Terpstra <terpstra@users.sourceforge.net>\n"
								   "Will Tange <bh34rt@gmail.com>\n"
								   "withgod <withgod@users.sourceforge.net>\n"
								   "x89 <napalm10@gmail.com>\n"
								   "zapman\n"
								   "zeroX-tj <tim.janssens@gmail.com>\n"
								   "Zorg <zorgiepoo@gmail.com>\n"
								   "\n"
								   "// Special thanks to:\n"
								   "//\n"
								   "//    Thorvald Natvig, for founding the Mumble project\n"
								   "//    and maintaining it during its formative years.";


static const char *licenseCELT = "Copyright 2001-2009 Jean-Marc Valin, Timothy B. Terriberry,\n"
								 "                    CSIRO, and other contributors\n"
								 "\n"
								 "Redistribution and use in source and binary forms, with or without\n"
								 "modification, are permitted provided that the following conditions\n"
								 "are met:\n"
								 "\n"
								 "- Redistributions of source code must retain the above copyright\n"
								 "notice, this list of conditions and the following disclaimer.\n"
								 "\n"
								 "- Redistributions in binary form must reproduce the above copyright\n"
								 "notice, this list of conditions and the following disclaimer in the\n"
								 "documentation and/or other materials provided with the distribution.\n"
								 "\n"
								 "- Neither the name of the Xiph.org Foundation nor the names of its\n"
								 "contributors may be used to endorse or promote products derived from\n"
								 "this software without specific prior written permission.\n"
								 "\n"
								 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								 "``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								 "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								 "A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR\n"
								 "CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
								 "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
								 "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
								 "PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
								 "LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								 "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								 "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseOpus = "Copyright 2001-2011 Xiph.Org, Skype Limited, Octasic,\n"
								 "                    Jean-Marc Valin, Timothy B. Terriberry,\n"
								 "                    CSIRO, Gregory Maxwell, Mark Borgerding,\n"
								 "                    Erik de Castro Lopo\n"
								 "\n"
								 "Redistribution and use in source and binary forms, with or without\n"
								 "modification, are permitted provided that the following conditions\n"
								 "are met:\n"
								 "\n"
								 "- Redistributions of source code must retain the above copyright\n"
								 "notice, this list of conditions and the following disclaimer.\n"
								 "\n"
								 "- Redistributions in binary form must reproduce the above copyright\n"
								 "notice, this list of conditions and the following disclaimer in the\n"
								 "documentation and/or other materials provided with the distribution.\n"
								 "\n"
								 "- Neither the name of Internet Society, IETF or IETF Trust, nor the\n"
								 "names of specific contributors, may be used to endorse or promote\n"
								 "products derived from this software without specific prior written\n"
								 "permission.\n"
								 "\n"
								 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								 "``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								 "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								 "A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER\n"
								 "OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
								 "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
								 "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
								 "PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
								 "LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								 "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								 "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
								 "\n"
								 "Opus is subject to the royalty-free patent licenses which are\n"
								 "specified at:\n"
								 "\n"
								 "Xiph.Org Foundation:\n"
								 "https://datatracker.ietf.org/ipr/1524/\n"
								 "\n"
								 "Microsoft Corporation:\n"
								 "https://datatracker.ietf.org/ipr/1914/\n"
								 "\n"
								 "Broadcom Corporation:\n"
								 "https://datatracker.ietf.org/ipr/1526/";


static const char *licenseSPEEX = "Copyright 2002-2008 	Xiph.org Foundation\n"
								  "Copyright 2002-2008 	Jean-Marc Valin\n"
								  "Copyright 2005-2007	Analog Devices Inc.\n"
								  "Copyright 2005-2008	Commonwealth Scientific and Industrial Research \n"
								  "                        Organisation (CSIRO)\n"
								  "Copyright 1993, 2002, 2006 David Rowe\n"
								  "Copyright 2003 		EpicGames\n"
								  "Copyright 1992-1994	Jutta Degener, Carsten Bormann\n"
								  "\n"
								  "Redistribution and use in source and binary forms, with or without\n"
								  "modification, are permitted provided that the following conditions\n"
								  "are met:\n"
								  "\n"
								  "- Redistributions of source code must retain the above copyright\n"
								  "notice, this list of conditions and the following disclaimer.\n"
								  "\n"
								  "- Redistributions in binary form must reproduce the above copyright\n"
								  "notice, this list of conditions and the following disclaimer in the\n"
								  "documentation and/or other materials provided with the distribution.\n"
								  "\n"
								  "- Neither the name of the Xiph.org Foundation nor the names of its\n"
								  "contributors may be used to endorse or promote products derived from\n"
								  "this software without specific prior written permission.\n"
								  "\n"
								  "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								  "``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								  "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								  "A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR\n"
								  "CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
								  "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
								  "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
								  "PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
								  "LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								  "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								  "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseOpenSSL = "====================================================================\n"
									"Copyright (c) 1998-2016 The OpenSSL Project.  All rights reserved.\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"\n"
									"1. Redistributions of source code must retain the above copyright\n"
									"   notice, this list of conditions and the following disclaimer. \n"
									"\n"
									"2. Redistributions in binary form must reproduce the above copyright\n"
									"   notice, this list of conditions and the following disclaimer in\n"
									"   the documentation and/or other materials provided with the\n"
									"   distribution.\n"
									"\n"
									"3. All advertising materials mentioning features or use of this\n"
									"   software must display the following acknowledgment:\n"
									"   \"This product includes software developed by the OpenSSL Project\n"
									"   for use in the OpenSSL Toolkit. (http://www.openssl.org/)\"\n"
									"\n"
									"4. The names \"OpenSSL Toolkit\" and \"OpenSSL Project\" must not be used to\n"
									"   endorse or promote products derived from this software without\n"
									"   prior written permission. For written permission, please contact\n"
									"   openssl-core@openssl.org.\n"
									"\n"
									"5. Products derived from this software may not be called \"OpenSSL\"\n"
									"   nor may \"OpenSSL\" appear in their names without prior written\n"
									"   permission of the OpenSSL Project.\n"
									"\n"
									"6. Redistributions of any form whatsoever must retain the following\n"
									"   acknowledgment:\n"
									"   \"This product includes software developed by the OpenSSL Project\n"
									"   for use in the OpenSSL Toolkit (http://www.openssl.org/)\"\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY\n"
									"EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
									"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
									"PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR\n"
									"ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
									"SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\n"
									"NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n"
									"LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
									"HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,\n"
									"STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
									"ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED\n"
									"OF THE POSSIBILITY OF SUCH DAMAGE.\n"
									"====================================================================\n"
									"\n"
									"This product includes cryptographic software written by Eric Young\n"
									"(eay@cryptsoft.com).  This product includes software written by Tim\n"
									"Hudson (tjh@cryptsoft.com).\n"
									"\n"
									"Original SSLeay License\n"
									"-----------------------\n"
									"\n"
									"Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)\n"
									"All rights reserved.\n"
									"\n"
									"This package is an SSL implementation written\n"
									"by Eric Young (eay@cryptsoft.com).\n"
									"The implementation was written so as to conform with Netscapes SSL.\n"
									"\n"
									"This library is free for commercial and non-commercial use as long as\n"
									"the following conditions are aheared to.  The following conditions\n"
									"apply to all code found in this distribution, be it the RC4, RSA,\n"
									"lhash, DES, etc., code; not just the SSL code.  The SSL documentation\n"
									"included with this distribution is covered by the same copyright terms\n"
									"except that the holder is Tim Hudson (tjh@cryptsoft.com).\n"
									"\n"
									"Copyright remains Eric Young's, and as such any Copyright notices in\n"
									"the code are not to be removed.\n"
									"If this package is used in a product, Eric Young should be given attribution\n"
									"as the author of the parts of the library used.\n"
									"This can be in the form of a textual message at program startup or\n"
									"in documentation (online or textual) provided with the package.\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"1. Redistributions of source code must retain the copyright\n"
									"   notice, this list of conditions and the following disclaimer.\n"
									"2. Redistributions in binary form must reproduce the above copyright\n"
									"   notice, this list of conditions and the following disclaimer in the\n"
									"   documentation and/or other materials provided with the distribution.\n"
									"3. All advertising materials mentioning features or use of this software\n"
									"   must display the following acknowledgement:\n"
									"   \"This product includes cryptographic software written by\n"
									"   Eric Young (eay@cryptsoft.com)\"\n"
									"   The word 'cryptographic' can be left out if the rouines from the library\n"
									"   being used are not cryptographic related :-).\n"
									"4. If you include any Windows specific code (or a derivative thereof) from \n"
									"   the apps directory (application code) you must include an acknowledgement:\n"
									"   \"This product includes software written by Tim Hudson (tjh@cryptsoft.com)\"\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND\n"
									"ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
									"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
									"ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE\n"
									"FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
									"DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
									"OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
									"HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
									"LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
									"OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
									"SUCH DAMAGE.\n"
									"\n"
									"The licence and distribution terms for any publically available version or\n"
									"derivative of this code cannot be changed.  i.e. this code cannot simply be\n"
									"copied and put under another distribution licence\n"
									"[including the GNU Public Licence.]";


static const char *licenseLibsndfile = "Copyright (C) 1999-2011 Erik de Castro Lopo <erikd@mega-nerd.com>\n"
									   "\n"
									   "This program is free software; you can redistribute it and/or modify\n"
									   "it under the terms of the GNU Lesser General Public License as published by\n"
									   "the Free Software Foundation; either version 2.1 of the License, or\n"
									   "(at your option) any later version.\n"
									   "\n"
									   "This program is distributed in the hope that it will be useful,\n"
									   "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
									   "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
									   "GNU Lesser General Public License for more details.\n"
									   "\n"
									   "You should have received a copy of the GNU Lesser General Public License\n"
									   "along with this program; if not, write to the Free Software\n"
									   "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.";


static const char *licenseOgg = "Copyright (c) 2002, Xiph.org Foundation\n"
								"\n"
								"Redistribution and use in source and binary forms, with or without\n"
								"modification, are permitted provided that the following conditions\n"
								"are met:\n"
								"\n"
								"- Redistributions of source code must retain the above copyright\n"
								"notice, this list of conditions and the following disclaimer.\n"
								"\n"
								"- Redistributions in binary form must reproduce the above copyright\n"
								"notice, this list of conditions and the following disclaimer in the\n"
								"documentation and/or other materials provided with the distribution.\n"
								"\n"
								"- Neither the name of the Xiph.org Foundation nor the names of its\n"
								"contributors may be used to endorse or promote products derived from\n"
								"this software without specific prior written permission.\n"
								"\n"
								"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								"``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								"LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								"A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION\n"
								"OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
								"SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
								"LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
								"DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
								"THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
								"(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
								"OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseVorbis = "Copyright (c) 2002-2008 Xiph.org Foundation\n"
								   "\n"
								   "Redistribution and use in source and binary forms, with or without\n"
								   "modification, are permitted provided that the following conditions\n"
								   "are met:\n"
								   "\n"
								   "- Redistributions of source code must retain the above copyright\n"
								   "notice, this list of conditions and the following disclaimer.\n"
								   "\n"
								   "- Redistributions in binary form must reproduce the above copyright\n"
								   "notice, this list of conditions and the following disclaimer in the\n"
								   "documentation and/or other materials provided with the distribution.\n"
								   "\n"
								   "- Neither the name of the Xiph.org Foundation nor the names of its\n"
								   "contributors may be used to endorse or promote products derived from\n"
								   "this software without specific prior written permission.\n"
								   "\n"
								   "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								   "``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								   "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								   "A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION\n"
								   "OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
								   "SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
								   "LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
								   "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
								   "THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
								   "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
								   "OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseFLAC = "Copyright (C) 2000,2001,2002,2003,2004,2005,2006,2007  Josh Coalson\n"
								 "\n"
								 "Redistribution and use in source and binary forms, with or without\n"
								 "modification, are permitted provided that the following conditions\n"
								 "are met:\n"
								 "\n"
								 "- Redistributions of source code must retain the above copyright\n"
								 "notice, this list of conditions and the following disclaimer.\n"
								 "\n"
								 "- Redistributions in binary form must reproduce the above copyright\n"
								 "notice, this list of conditions and the following disclaimer in the\n"
								 "documentation and/or other materials provided with the distribution.\n"
								 "\n"
								 "- Neither the name of the Xiph.org Foundation nor the names of its\n"
								 "contributors may be used to endorse or promote products derived from\n"
								 "this software without specific prior written permission.\n"
								 "\n"
								 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
								 "``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
								 "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
								 "A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR\n"
								 "CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
								 "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
								 "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
								 "PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
								 "LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								 "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								 "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


#ifdef Q_OS_MAC
static const char *licenseMachOverride =
	"Copyright (c) 2003-2009 Jonathan 'Wolf' Rentzsch <http://rentzsch.com>\n"
	"\n"
	"Permission is hereby granted, free of charge, to any person obtaining\n"
	"a copy of this software and associated documentation files (the \"Software\"),\n"
	"to deal in the Software without restriction, including without limitation\n"
	"the rights to use, copy, modify, merge, publish, distribute, sublicense,\n"
	"and/or sell copies of the Software, and to permit persons to whom the\n"
	"Software is furnished to do so, subject to the following conditions:\n"
	"\n"
	"The above copyright notice and this permission notice shall be\n"
	"included in all copies or substantial portions of the Software.\n"
	"\n"
	"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n"
	"OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
	"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL\n"
	"THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
	"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
	"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n"
	"THE SOFTWARE.";
#endif


#ifdef Q_OS_WIN64
static const char *licenseMinHook = "﻿MinHook - The Minimalistic API Hooking Library for x64/x86\n"
									"Copyright (C) 2009-2017 Tsuda Kageyu.\n"
									"All rights reserved.\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"\n"
									" 1. Redistributions of source code must retain the above copyright\n"
									"    notice, this list of conditions and the following disclaimer.\n"
									" 2. Redistributions in binary form must reproduce the above copyright\n"
									"    notice, this list of conditions and the following disclaimer in the\n"
									"    documentation and/or other materials provided with the distribution.\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
									"\"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\n"
									"TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A\n"
									"PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER\n"
									"OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
									"EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
									"PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
									"PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
									"LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
									"NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
									"SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
									"\n"
									"================================================================================\n"
									"Portions of this software are Copyright (c) 2008-2009, Vyacheslav Patkov.\n"
									"================================================================================\n"
									"Hacker Disassembler Engine 32 C\n"
									"Copyright (c) 2008-2009, Vyacheslav Patkov.\n"
									"All rights reserved.\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"\n"
									" 1. Redistributions of source code must retain the above copyright\n"
									"    notice, this list of conditions and the following disclaimer.\n"
									" 2. Redistributions in binary form must reproduce the above copyright\n"
									"    notice, this list of conditions and the following disclaimer in the\n"
									"    documentation and/or other materials provided with the distribution.\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
									"\"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\n"
									"TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A\n"
									"PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR\n"
									"CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
									"EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
									"PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
									"PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
									"LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
									"NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
									"SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
									"\n"
									"-------------------------------------------------------------------------------\n"
									"Hacker Disassembler Engine 64 C\n"
									"Copyright (c) 2008-2009, Vyacheslav Patkov.\n"
									"All rights reserved.\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"\n"
									" 1. Redistributions of source code must retain the above copyright\n"
									"    notice, this list of conditions and the following disclaimer.\n"
									" 2. Redistributions in binary form must reproduce the above copyright\n"
									"    notice, this list of conditions and the following disclaimer in the\n"
									"    documentation and/or other materials provided with the distribution.\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
									"\"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\n"
									"TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A\n"
									"PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR\n"
									"CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
									"EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
									"PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
									"PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
									"LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
									"NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
									"SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
#endif


#ifdef USING_BUNDLED_QT_TRANSLATIONS
static const char *licenseQtTranslations =
	"Mumble uses Qt translations created by the VirtualBox community\n"
	"under the MIT license. Files and copyright were obtained from:\n"
	"https://www.virtualbox.org/ticket/2018\n"
	"\n"
	"Turkish Qt translation (serdar, BouRock):\n"
	"  Copyright (c) 2007-2009 Serdar Soytetir\n"
	"  Copyright (c) 2012 Burak Yavuz\n"
	"Italian Qt translation (smart2128):\n"
	"  Copyright (c) 2009-2012 Vincenzo Reale\n"
	"Dutch Qt translation (geertseb, lxndr, nippur):\n"
	"  Copyright (c) 2009-2011 Ebel Geertsema\n"
	"  Copyright (c) 2007 Alexander L. de Goeij\n"
	"  Copyright (c) 2012 Richard E van der Luit\n"
	"\n"
	"Permission is hereby granted, free of charge, to any person obtaining a copy\n"
	"of this software and associated documentation files (the \"Software\"), to deal\n"
	"in the Software without restriction, including without limitation the rights\n"
	"to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
	"copies of the Software, and to permit persons to whom the Software is furnished\n"
	"to do so, subject to the following conditions:\n"
	"\n"
	"The above copyright notice and this permission notice shall be included in all\n"
	"copies or substantial portions of the Software.\n"
	"\n"
	"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
	"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
	"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
	"AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
	"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
	"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n"
	"SOFTWARE.";
#endif


static const char *licenseEmojiOne = "Creative Commons Attribution-ShareAlike 4.0 International Public\n"
									 "License\n"
									 "\n"
									 "By exercising the Licensed Rights (defined below), You accept and agree\n"
									 "to be bound by the terms and conditions of this Creative Commons\n"
									 "Attribution-ShareAlike 4.0 International Public License (\"Public\n"
									 "License\"). To the extent this Public License may be interpreted as a\n"
									 "contract, You are granted the Licensed Rights in consideration of Your\n"
									 "acceptance of these terms and conditions, and the Licensor grants You\n"
									 "such rights in consideration of benefits the Licensor receives from\n"
									 "making the Licensed Material available under these terms and\n"
									 "conditions.\n"
									 "\n"
									 "\n"
									 "Section 1 -- Definitions.\n"
									 "\n"
									 "  a. Adapted Material means material subject to Copyright and Similar\n"
									 "     Rights that is derived from or based upon the Licensed Material\n"
									 "     and in which the Licensed Material is translated, altered,\n"
									 "     arranged, transformed, or otherwise modified in a manner requiring\n"
									 "     permission under the Copyright and Similar Rights held by the\n"
									 "     Licensor. For purposes of this Public License, where the Licensed\n"
									 "     Material is a musical work, performance, or sound recording,\n"
									 "     Adapted Material is always produced where the Licensed Material is\n"
									 "     synched in timed relation with a moving image.\n"
									 "\n"
									 "  b. Adapter's License means the license You apply to Your Copyright\n"
									 "     and Similar Rights in Your contributions to Adapted Material in\n"
									 "     accordance with the terms and conditions of this Public License.\n"
									 "\n"
									 "  c. BY-SA Compatible License means a license listed at\n"
									 "     creativecommons.org/compatiblelicenses, approved by Creative\n"
									 "     Commons as essentially the equivalent of this Public License.\n"
									 "\n"
									 "  d. Copyright and Similar Rights means copyright and/or similar rights\n"
									 "     closely related to copyright including, without limitation,\n"
									 "     performance, broadcast, sound recording, and Sui Generis Database\n"
									 "     Rights, without regard to how the rights are labeled or\n"
									 "     categorized. For purposes of this Public License, the rights\n"
									 "     specified in Section 2(b)(1)-(2) are not Copyright and Similar\n"
									 "     Rights.\n"
									 "\n"
									 "  e. Effective Technological Measures means those measures that, in the\n"
									 "     absence of proper authority, may not be circumvented under laws\n"
									 "     fulfilling obligations under Article 11 of the WIPO Copyright\n"
									 "     Treaty adopted on December 20, 1996, and/or similar international\n"
									 "     agreements.\n"
									 "\n"
									 "  f. Exceptions and Limitations means fair use, fair dealing, and/or\n"
									 "     any other exception or limitation to Copyright and Similar Rights\n"
									 "     that applies to Your use of the Licensed Material.\n"
									 "\n"
									 "  g. License Elements means the license attributes listed in the name\n"
									 "     of a Creative Commons Public License. The License Elements of this\n"
									 "     Public License are Attribution and ShareAlike.\n"
									 "\n"
									 "  h. Licensed Material means the artistic or literary work, database,\n"
									 "     or other material to which the Licensor applied this Public\n"
									 "     License.\n"
									 "\n"
									 "  i. Licensed Rights means the rights granted to You subject to the\n"
									 "     terms and conditions of this Public License, which are limited to\n"
									 "     all Copyright and Similar Rights that apply to Your use of the\n"
									 "     Licensed Material and that the Licensor has authority to license.\n"
									 "\n"
									 "  j. Licensor means the individual(s) or entity(ies) granting rights\n"
									 "     under this Public License.\n"
									 "\n"
									 "  k. Share means to provide material to the public by any means or\n"
									 "     process that requires permission under the Licensed Rights, such\n"
									 "     as reproduction, public display, public performance, distribution,\n"
									 "     dissemination, communication, or importation, and to make material\n"
									 "     available to the public including in ways that members of the\n"
									 "     public may access the material from a place and at a time\n"
									 "     individually chosen by them.\n"
									 "\n"
									 "  l. Sui Generis Database Rights means rights other than copyright\n"
									 "     resulting from Directive 96/9/EC of the European Parliament and of\n"
									 "     the Council of 11 March 1996 on the legal protection of databases,\n"
									 "     as amended and/or succeeded, as well as other essentially\n"
									 "     equivalent rights anywhere in the world.\n"
									 "\n"
									 "  m. You means the individual or entity exercising the Licensed Rights\n"
									 "     under this Public License. Your has a corresponding meaning.\n"
									 "\n"
									 "\n"
									 "Section 2 -- Scope.\n"
									 "\n"
									 "  a. License grant.\n"
									 "\n"
									 "       1. Subject to the terms and conditions of this Public License,\n"
									 "          the Licensor hereby grants You a worldwide, royalty-free,\n"
									 "          non-sublicensable, non-exclusive, irrevocable license to\n"
									 "          exercise the Licensed Rights in the Licensed Material to:\n"
									 "\n"
									 "            a. reproduce and Share the Licensed Material, in whole or\n"
									 "               in part; and\n"
									 "\n"
									 "            b. produce, reproduce, and Share Adapted Material.\n"
									 "\n"
									 "       2. Exceptions and Limitations. For the avoidance of doubt, where\n"
									 "          Exceptions and Limitations apply to Your use, this Public\n"
									 "          License does not apply, and You do not need to comply with\n"
									 "          its terms and conditions.\n"
									 "\n"
									 "       3. Term. The term of this Public License is specified in Section\n"
									 "          6(a).\n"
									 "\n"
									 "       4. Media and formats; technical modifications allowed. The\n"
									 "          Licensor authorizes You to exercise the Licensed Rights in\n"
									 "          all media and formats whether now known or hereafter created,\n"
									 "          and to make technical modifications necessary to do so. The\n"
									 "          Licensor waives and/or agrees not to assert any right or\n"
									 "          authority to forbid You from making technical modifications\n"
									 "          necessary to exercise the Licensed Rights, including\n"
									 "          technical modifications necessary to circumvent Effective\n"
									 "          Technological Measures. For purposes of this Public License,\n"
									 "          simply making modifications authorized by this Section 2(a)\n"
									 "          (4) never produces Adapted Material.\n"
									 "\n"
									 "       5. Downstream recipients.\n"
									 "\n"
									 "            a. Offer from the Licensor -- Licensed Material. Every\n"
									 "               recipient of the Licensed Material automatically\n"
									 "               receives an offer from the Licensor to exercise the\n"
									 "               Licensed Rights under the terms and conditions of this\n"
									 "               Public License.\n"
									 "\n"
									 "            b. Additional offer from the Licensor -- Adapted Material.\n"
									 "               Every recipient of Adapted Material from You\n"
									 "               automatically receives an offer from the Licensor to\n"
									 "               exercise the Licensed Rights in the Adapted Material\n"
									 "               under the conditions of the Adapter's License You apply.\n"
									 "\n"
									 "            c. No downstream restrictions. You may not offer or impose\n"
									 "               any additional or different terms or conditions on, or\n"
									 "               apply any Effective Technological Measures to, the\n"
									 "               Licensed Material if doing so restricts exercise of the\n"
									 "               Licensed Rights by any recipient of the Licensed\n"
									 "               Material.\n"
									 "\n"
									 "       6. No endorsement. Nothing in this Public License constitutes or\n"
									 "          may be construed as permission to assert or imply that You\n"
									 "          are, or that Your use of the Licensed Material is, connected\n"
									 "          with, or sponsored, endorsed, or granted official status by,\n"
									 "          the Licensor or others designated to receive attribution as\n"
									 "          provided in Section 3(a)(1)(A)(i).\n"
									 "\n"
									 "  b. Other rights.\n"
									 "\n"
									 "       1. Moral rights, such as the right of integrity, are not\n"
									 "          licensed under this Public License, nor are publicity,\n"
									 "          privacy, and/or other similar personality rights; however, to\n"
									 "          the extent possible, the Licensor waives and/or agrees not to\n"
									 "          assert any such rights held by the Licensor to the limited\n"
									 "          extent necessary to allow You to exercise the Licensed\n"
									 "          Rights, but not otherwise.\n"
									 "\n"
									 "       2. Patent and trademark rights are not licensed under this\n"
									 "          Public License.\n"
									 "\n"
									 "       3. To the extent possible, the Licensor waives any right to\n"
									 "          collect royalties from You for the exercise of the Licensed\n"
									 "          Rights, whether directly or through a collecting society\n"
									 "          under any voluntary or waivable statutory or compulsory\n"
									 "          licensing scheme. In all other cases the Licensor expressly\n"
									 "          reserves any right to collect such royalties.\n"
									 "\n"
									 "\n"
									 "Section 3 -- License Conditions.\n"
									 "\n"
									 "Your exercise of the Licensed Rights is expressly made subject to the\n"
									 "following conditions.\n"
									 "\n"
									 "  a. Attribution.\n"
									 "\n"
									 "       1. If You Share the Licensed Material (including in modified\n"
									 "          form), You must:\n"
									 "\n"
									 "            a. retain the following if it is supplied by the Licensor\n"
									 "               with the Licensed Material:\n"
									 "\n"
									 "                 i. identification of the creator(s) of the Licensed\n"
									 "                    Material and any others designated to receive\n"
									 "                    attribution, in any reasonable manner requested by\n"
									 "                    the Licensor (including by pseudonym if\n"
									 "                    designated);\n"
									 "\n"
									 "                ii. a copyright notice;\n"
									 "\n"
									 "               iii. a notice that refers to this Public License;\n"
									 "\n"
									 "                iv. a notice that refers to the disclaimer of\n"
									 "                    warranties;\n"
									 "\n"
									 "                 v. a URI or hyperlink to the Licensed Material to the\n"
									 "                    extent reasonably practicable;\n"
									 "\n"
									 "            b. indicate if You modified the Licensed Material and\n"
									 "               retain an indication of any previous modifications; and\n"
									 "\n"
									 "            c. indicate the Licensed Material is licensed under this\n"
									 "               Public License, and include the text of, or the URI or\n"
									 "               hyperlink to, this Public License.\n"
									 "\n"
									 "       2. You may satisfy the conditions in Section 3(a)(1) in any\n"
									 "          reasonable manner based on the medium, means, and context in\n"
									 "          which You Share the Licensed Material. For example, it may be\n"
									 "          reasonable to satisfy the conditions by providing a URI or\n"
									 "          hyperlink to a resource that includes the required\n"
									 "          information.\n"
									 "\n"
									 "       3. If requested by the Licensor, You must remove any of the\n"
									 "          information required by Section 3(a)(1)(A) to the extent\n"
									 "          reasonably practicable.\n"
									 "\n"
									 "  b. ShareAlike.\n"
									 "\n"
									 "     In addition to the conditions in Section 3(a), if You Share\n"
									 "     Adapted Material You produce, the following conditions also apply.\n"
									 "\n"
									 "       1. The Adapter's License You apply must be a Creative Commons\n"
									 "          license with the same License Elements, this version or\n"
									 "          later, or a BY-SA Compatible License.\n"
									 "\n"
									 "       2. You must include the text of, or the URI or hyperlink to, the\n"
									 "          Adapter's License You apply. You may satisfy this condition\n"
									 "          in any reasonable manner based on the medium, means, and\n"
									 "          context in which You Share Adapted Material.\n"
									 "\n"
									 "       3. You may not offer or impose any additional or different terms\n"
									 "          or conditions on, or apply any Effective Technological\n"
									 "          Measures to, Adapted Material that restrict exercise of the\n"
									 "          rights granted under the Adapter's License You apply.\n"
									 "\n"
									 "\n"
									 "Section 4 -- Sui Generis Database Rights.\n"
									 "\n"
									 "Where the Licensed Rights include Sui Generis Database Rights that\n"
									 "apply to Your use of the Licensed Material:\n"
									 "\n"
									 "  a. for the avoidance of doubt, Section 2(a)(1) grants You the right\n"
									 "     to extract, reuse, reproduce, and Share all or a substantial\n"
									 "     portion of the contents of the database;\n"
									 "\n"
									 "  b. if You include all or a substantial portion of the database\n"
									 "     contents in a database in which You have Sui Generis Database\n"
									 "     Rights, then the database in which You have Sui Generis Database\n"
									 "     Rights (but not its individual contents) is Adapted Material,\n"
									 "\n"
									 "     including for purposes of Section 3(b); and\n"
									 "  c. You must comply with the conditions in Section 3(a) if You Share\n"
									 "     all or a substantial portion of the contents of the database.\n"
									 "\n"
									 "For the avoidance of doubt, this Section 4 supplements and does not\n"
									 "replace Your obligations under this Public License where the Licensed\n"
									 "Rights include other Copyright and Similar Rights.\n"
									 "\n"
									 "\n"
									 "Section 5 -- Disclaimer of Warranties and Limitation of Liability.\n"
									 "\n"
									 "  a. UNLESS OTHERWISE SEPARATELY UNDERTAKEN BY THE LICENSOR, TO THE\n"
									 "     EXTENT POSSIBLE, THE LICENSOR OFFERS THE LICENSED MATERIAL AS-IS\n"
									 "     AND AS-AVAILABLE, AND MAKES NO REPRESENTATIONS OR WARRANTIES OF\n"
									 "     ANY KIND CONCERNING THE LICENSED MATERIAL, WHETHER EXPRESS,\n"
									 "     IMPLIED, STATUTORY, OR OTHER. THIS INCLUDES, WITHOUT LIMITATION,\n"
									 "     WARRANTIES OF TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR\n"
									 "     PURPOSE, NON-INFRINGEMENT, ABSENCE OF LATENT OR OTHER DEFECTS,\n"
									 "     ACCURACY, OR THE PRESENCE OR ABSENCE OF ERRORS, WHETHER OR NOT\n"
									 "     KNOWN OR DISCOVERABLE. WHERE DISCLAIMERS OF WARRANTIES ARE NOT\n"
									 "     ALLOWED IN FULL OR IN PART, THIS DISCLAIMER MAY NOT APPLY TO YOU.\n"
									 "\n"
									 "  b. TO THE EXTENT POSSIBLE, IN NO EVENT WILL THE LICENSOR BE LIABLE\n"
									 "     TO YOU ON ANY LEGAL THEORY (INCLUDING, WITHOUT LIMITATION,\n"
									 "     NEGLIGENCE) OR OTHERWISE FOR ANY DIRECT, SPECIAL, INDIRECT,\n"
									 "     INCIDENTAL, CONSEQUENTIAL, PUNITIVE, EXEMPLARY, OR OTHER LOSSES,\n"
									 "     COSTS, EXPENSES, OR DAMAGES ARISING OUT OF THIS PUBLIC LICENSE OR\n"
									 "     USE OF THE LICENSED MATERIAL, EVEN IF THE LICENSOR HAS BEEN\n"
									 "     ADVISED OF THE POSSIBILITY OF SUCH LOSSES, COSTS, EXPENSES, OR\n"
									 "     DAMAGES. WHERE A LIMITATION OF LIABILITY IS NOT ALLOWED IN FULL OR\n"
									 "     IN PART, THIS LIMITATION MAY NOT APPLY TO YOU.\n"
									 "\n"
									 "  c. The disclaimer of warranties and limitation of liability provided\n"
									 "     above shall be interpreted in a manner that, to the extent\n"
									 "     possible, most closely approximates an absolute disclaimer and\n"
									 "     waiver of all liability.\n"
									 "\n"
									 "\n"
									 "Section 6 -- Term and Termination.\n"
									 "\n"
									 "  a. This Public License applies for the term of the Copyright and\n"
									 "     Similar Rights licensed here. However, if You fail to comply with\n"
									 "     this Public License, then Your rights under this Public License\n"
									 "     terminate automatically.\n"
									 "\n"
									 "  b. Where Your right to use the Licensed Material has terminated under\n"
									 "     Section 6(a), it reinstates:\n"
									 "\n"
									 "       1. automatically as of the date the violation is cured, provided\n"
									 "          it is cured within 30 days of Your discovery of the\n"
									 "          violation; or\n"
									 "\n"
									 "       2. upon express reinstatement by the Licensor.\n"
									 "\n"
									 "     For the avoidance of doubt, this Section 6(b) does not affect any\n"
									 "     right the Licensor may have to seek remedies for Your violations\n"
									 "     of this Public License.\n"
									 "\n"
									 "  c. For the avoidance of doubt, the Licensor may also offer the\n"
									 "     Licensed Material under separate terms or conditions or stop\n"
									 "     distributing the Licensed Material at any time; however, doing so\n"
									 "     will not terminate this Public License.\n"
									 "\n"
									 "  d. Sections 1, 5, 6, 7, and 8 survive termination of this Public\n"
									 "     License.\n"
									 "\n"
									 "\n"
									 "Section 7 -- Other Terms and Conditions.\n"
									 "\n"
									 "  a. The Licensor shall not be bound by any additional or different\n"
									 "     terms or conditions communicated by You unless expressly agreed.\n"
									 "\n"
									 "  b. Any arrangements, understandings, or agreements regarding the\n"
									 "     Licensed Material not stated herein are separate from and\n"
									 "     independent of the terms and conditions of this Public License.\n"
									 "\n"
									 "\n"
									 "Section 8 -- Interpretation.\n"
									 "\n"
									 "  a. For the avoidance of doubt, this Public License does not, and\n"
									 "     shall not be interpreted to, reduce, limit, restrict, or impose\n"
									 "     conditions on any use of the Licensed Material that could lawfully\n"
									 "     be made without permission under this Public License.\n"
									 "\n"
									 "  b. To the extent possible, if any provision of this Public License is\n"
									 "     deemed unenforceable, it shall be automatically reformed to the\n"
									 "     minimum extent necessary to make it enforceable. If the provision\n"
									 "     cannot be reformed, it shall be severed from this Public License\n"
									 "     without affecting the enforceability of the remaining terms and\n"
									 "     conditions.\n"
									 "\n"
									 "  c. No term or condition of this Public License will be waived and no\n"
									 "     failure to comply consented to unless expressly agreed to by the\n"
									 "     Licensor.\n"
									 "\n"
									 "  d. Nothing in this Public License constitutes or may be interpreted\n"
									 "     as a limitation upon, or waiver of, any privileges and immunities\n"
									 "     that apply to the Licensor or You, including from the legal\n"
									 "     processes of any jurisdiction or authority.";


static const char *licenseXInputCheck = "Simple DirectMedia Layer\n"
										"Copyright (C) 1997-2016 Sam Lantinga <slouken@libsdl.org>\n"
										"  \n"
										"This software is provided 'as-is', without any express or implied\n"
										"warranty.  In no event will the authors be held liable for any damages\n"
										"arising from the use of this software.\n"
										"\n"
										"Permission is granted to anyone to use this software for any purpose,\n"
										"including commercial applications, and to alter it and redistribute it\n"
										"freely, subject to the following restrictions:\n"
										"  \n"
										"1. The origin of this software must not be misrepresented; you must not\n"
										"   claim that you wrote the original software. If you use this software\n"
										"   in a product, an acknowledgment in the product documentation would be\n"
										"   appreciated but is not required. \n"
										"2. Altered source versions must be plainly marked as such, and must not be\n"
										"   misrepresented as being the original software.\n"
										"3. This notice may not be removed or altered from any source distribution.";


static const char *licenseQQBonjour = "Copyright (c) 2007, Trenton Schulz\n"
									  "\n"
									  "Redistribution and use in source and binary forms, with or without\n"
									  "modification, are permitted provided that the following conditions are met:\n"
									  "\n"
									  " 1. Redistributions of source code must retain the above copyright notice,\n"
									  "    this list of conditions and the following disclaimer.\n"
									  "\n"
									  " 2. Redistributions in binary form must reproduce the above copyright notice,\n"
									  "    this list of conditions and the following disclaimer in the documentation\n"
									  "    and/or other materials provided with the distribution.\n"
									  "\n"
									  " 3. The name of the author may not be used to endorse or promote products\n"
									  "    derived from this software without specific prior written permission.\n"
									  "\n"
									  "THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED\n"
									  "WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
									  "MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO\n"
									  "EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
									  "SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
									  "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;\n"
									  "OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n"
									  "WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n"
									  "OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\n"
									  "ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseSmallFT = "Copyright (c) 2002-2007 Xiph.org Foundation\n"
									"\n"
									"Redistribution and use in source and binary forms, with or without\n"
									"modification, are permitted provided that the following conditions\n"
									"are met:\n"
									"\n"
									"- Redistributions of source code must retain the above copyright\n"
									"notice, this list of conditions and the following disclaimer.\n"
									"\n"
									"- Redistributions in binary form must reproduce the above copyright\n"
									"notice, this list of conditions and the following disclaimer in the\n"
									"documentation and/or other materials provided with the distribution.\n"
									"\n"
									"- Neither the name of the Xiph.org Foundation nor the names of its\n"
									"contributors may be used to endorse or promote products derived from\n"
									"this software without specific prior written permission.\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
									"`AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
									"LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
									"A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION\n"
									"OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
									"SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
									"LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
									"DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
									"THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
									"(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
									"OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseOldStyleLicenseHeaders =
	"Mumble's AudioConfigDialog\n"
	"\n"
	"	src/mumble/AudioConfigDialog.cpp\n"
	"\n"
	"	Copyright (C) 2005-2011, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2008, Andreas Messer <andi@bupfen.de>\n"
	"\n"
	"Mumble's PortAudio support\n"
	"\n"
	"	src/mumble/PAAudio.cpp, src/mumble/PAAudio.h\n"
	"\n"
	"	Copyright (C) 2005-2011, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2007, Stefan Gehn <mETz AT gehn DOT net>\n"
	"\n"
	"Mumble's Text-to-Speech support on OS X\n"
	"\n"
	"	src/mumble/TextToSpeech_macx.mm\n"
	"\n"
	"	Copyright (C) 2005-2011, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2007, Sebastian Schlingmann <mit_service@users.sourceforge.net>\n"
	"	Copyright (C) 2008-2011, Mikkel Krautz <mikkel@krautz.dk>\n"
	"	Copyright (C) 2014, Mayur Pawashe <zorgiepoo@gmail.com>\n"
	"\n"
	"Mumble's UserLocalVolumeDialog\n"
	"\n"
	"	src/mumble/UserLocalVolumeDialog.cpp\n"
	"	src/mumble/UserLocalVolumeDialog.h\n"
	"\n"
	"	Copyright (C) 2015, Fredrik Nordin <freedick@ludd.ltu.se>\n"
	"\n"
	"Murmur's PBKDF2 support\n"
	"\n"
	"	src/murmur/PBKDF2.cpp\n"
	"	src/murmur/PBKDF2.h\n"
	"\n"
	"	Copyright (C) 2013, Morris Moraes <mauricioarozi@gmail.com>\n"
	"	Copyright (C) 2014, Stefan Hacker <dd0t@users.sourceforge.net>\n"
	"\n"
	"D11StateBlock in Mumble's Windows Overlay\n"
	"\n"
	"	overlay/D11StateBlock.cpp\n"
	"	overlay/D11StateBlock.h\n"
	"\n"
	"	Copyright (C) 2011-2013, Nye Liu <nyet@nyet.org>\n"
	"	Copyright (C) 2011-2013, Kissaki <kissaki@gmx.de>\n"
	"\n"
	"D3D11 HLSL shaders for Mumble's Windows Overlay\n"
	"\n"
	"	overlay/overlay11-common.hlsl\n"
	"	overlay/overlay11.ps\n"
	"	overlay/overlay11.vs\n"
	"\n"
	"	Copyright (C) 2011-2013, Nye Liu <nyet@nyet.org>\n"
	"\n"
	"D3D11 support for Mumble's Windows Overlay\n"
	"\n"
	"	overlay/d3d11.cpp\n"
	"\n"
	"	Copyright (C) 2010-2013, Benjamin Jemlich <pcgod@users.sourceforge.net>\n"
	"	Copyright (C) 2011-2013, Nye Liu <nyet@nyet.org>\n"
	"	Copyright (C) 2011-2013, Kissaki <kissaki@gmx.de>\n"
	"\n"
	"DXGI support for Mumble's Windows Overlay\n"
	"\n"
	"	overlay/dxgi.cpp\n"
	"\n"
	"	Copyright (C) 2005-2010, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2011, Kissaki <kissaki@gmx.de>\n"
	"	Copyright (C) 2011, Nye Liu <nyet@nyet.org>\n"
	"\n"
	"Mumble's \"Battlefield 3\" Plugin\n"
	"\n"
	"	plugins/bf3/bf3.cpp\n"
	"\n"
	"	Copyright (C) 2010-2011, Snares <snares@users.sourceforge.net>\n"
	"	Copyright (C) 2005-2011, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2011, Ryan Austin <ryan@gameforcecenters.com>\n"
	"	Copyright (C) 2012, Bojan Hartmann <bogie@bawki.de>\n"
	"\n"
	"Mumble's \"Blacklight\" Plugin\n"
	"\n"
	"	plugins/blacklight/blacklight.cpp\n"
	"\n"
	"	Copyright (C) 2012, dark_skeleton (d-rez) <dark.skeleton@gmail.com>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Borderlands\" Plugin\n"
	"\n"
	"	plugins/borderlands/borderlands.cpp\n"
	"\n"
	"	Copyright (C) 2010, Mark-Willem Jansen <rawnar@users.sourceforge.net>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Borderlands 2\" Plugin\n"
	"\n"
	"	plugins/borderlands2/borderlands2.cpp\n"
	"\n"
	"	Copyright (C) 2013, Steve Hill <github@cheesy.sackheads.org>\n"
	"	Copyright (C) 2013, Gabriel Risterucci <cleyfaye@gmail.com>\n"
	"	Copyright (C) 2005-2010, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Breach\" Plugin\n"
	"\n"
	"	plugins/breach/breach.cpp\n"
	"\n"
	"	Copyright (C) 2011, Mark-Willem Jansen <rawnar@users.sourceforge.net>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Counter-Strike\" Plugin\n"
	"\n"
	"	plugins/cs/cs.cpp\n"
	"\n"
	"	Copyright (C) 2009-2010, Imre Botos <zokny@users.sourceforge.net>\n"
	"	Copyright (C) 2009-2012, Snares <snares@users.sourceforge.net>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Grand Theft Auto IV\" Plugin\n"
	"\n"
	"	plugins/gtaiv/gtaiv.cpp\n"
	"\n"
	"	Copyright (C) 2011, Mike <mike@flomp.net>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Just Cause 2\" Plugin\n"
	"\n"
	"	plugins/jc2/jc2.cpp\n"
	"\n"
	"	Copyright (C) 2012, Mike <mike@flomp.net>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Left 4 Dead 2\" Plugin\n"
	"\n"
	"	plugins/l4d2/l4d2.cpp\n"
	"\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2012, dark_skeleton (d-rez) <dark.skeleton@gmail.com>\n"
	"\n"
	"Mumble's \"League of Legends\" Plugin\n"
	"\n"
	"	plugins/lol/lol.cpp\n"
	"\n"
	"	Copyright (C) 2012, dark_skeleton (d-rez) <dark.skeleton@gmail.com>\n"
	"	Copyright (C) 2005-2012, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"The Lord of The Rings Online\" Plugin\n"
	"\n"
	"	plugins/lotro/lotro.cpp\n"
	"\n"
	"	Copyright (c) 2009-2011 Ilmar 'Ingaras' Kruis (seaeagle1@users.sourceforge.net)\n"
	"\n"
	"Mumble's \"Sub Rosa\" Plugin\n"
	"\n"
	"	plugins/sr/sr.cpp\n"
	"\n"
	"	Copyright (C) 2012, Lukas Orsvärn <lucas.orsv@gmail.com>\n"
	"	Copyright (C) 2005-2010, Thorvald Natvig <thorvald@natvig.com>\n"
	"\n"
	"Mumble's \"Unreal Tournament\" Plugin\n"
	"\n"
	"	plugins/ut99/ut99.cpp\n"
	"\n"
	"	Copyright (C) 2005-2010, Thorvald Natvig <thorvald@natvig.com>\n"
	"	Copyright (C) 2012, Moritz Schneeweiss\n"
	"\n"
	"All rights reserved.\n"
	"\n"
	"Redistribution and use in source and binary forms, with or without\n"
	"modification, are permitted provided that the following conditions\n"
	"are met:\n"
	"\n"
	"- Redistributions of source code must retain the above copyright notice,\n"
	"  this list of conditions and the following disclaimer.\n"
	"- Redistributions in binary form must reproduce the above copyright notice,\n"
	"  this list of conditions and the following disclaimer in the documentation\n"
	"  and/or other materials provided with the distribution.\n"
	"- Neither the name of the Mumble Developers nor the names of its\n"
	"  contributors may be used to endorse or promote products derived from this\n"
	"  software without specific prior written permission.\n"
	"\n"
	"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR\n"
	"CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n"
	"EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n"
	"PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n"
	"PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
	"LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
	"NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
	"SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";


static const char *licenseArc4RandomUniform =
	"Copyright (c) 2008, Damien Miller <djm@openbsd.org>\n"
	"\n"
	"Permission to use, copy, modify, and distribute this software for any\n"
	"purpose with or without fee is hereby granted, provided that the above\n"
	"copyright notice and this permission notice appear in all copies.\n"
	"\n"
	"THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES\n"
	"WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF\n"
	"MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR\n"
	"ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES\n"
	"WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN\n"
	"ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF\n"
	"OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.";


#ifdef USE_BUILDENV
static const char *licenseMariaDBCConnector = "This library is free software; you can redistribute it and/or\n"
											  "modify it under the terms of the GNU Lesser General Public\n"
											  "License as published by the Free Software Foundation; either\n"
											  "version 2.1 of the License, or (at your option) any later version.\n"
											  "\n"
											  "This library is distributed in the hope that it will be useful,\n"
											  "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
											  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
											  "Lesser General Public License for more details.\n"
											  "\n"
											  "You should have received a copy of the GNU Lesser General Public\n"
											  "License along with this library; if not, write to the Free Software\n"
											  "Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA\n"
											  "02110-1301  USA";
#endif


#ifdef USE_BUILDENV
static const char *licenseZlib = "(C) 1995-2017 Jean-loup Gailly and Mark Adler\n"
								 "\n"
								 "This software is provided 'as-is', without any express or implied\n"
								 "warranty.  In no event will the authors be held liable for any damages\n"
								 "arising from the use of this software.\n"
								 "\n"
								 "Permission is granted to anyone to use this software for any purpose,\n"
								 "including commercial applications, and to alter it and redistribute it\n"
								 "freely, subject to the following restrictions:\n"
								 "\n"
								 "1. The origin of this software must not be misrepresented; you must not\n"
								 "   claim that you wrote the original software. If you use this software\n"
								 "   in a product, an acknowledgment in the product documentation would be\n"
								 "   appreciated but is not required.\n"
								 "2. Altered source versions must be plainly marked as such, and must not be\n"
								 "   misrepresented as being the original software.\n"
								 "3. This notice may not be removed or altered from any source distribution.\n"
								 "\n"
								 "Jean-loup Gailly        Mark Adler\n"
								 "jloup@gzip.org          madler@alumni.caltech.edu";
#endif


#ifdef USE_BUILDENV
static const char *licenseProtobuf = "This license applies to all parts of Protocol Buffers except the following:\n"
									 "\n"
									 "  - Atomicops support for generic gcc, located in\n"
									 "    src/google/protobuf/stubs/atomicops_internals_generic_gcc.h.\n"
									 "    This file is copyrighted by Red Hat Inc.\n"
									 "\n"
									 "  - Atomicops support for AIX/POWER, located in\n"
									 "    src/google/protobuf/stubs/atomicops_internals_power.h.\n"
									 "    This file is copyrighted by Bloomberg Finance LP.\n"
									 "\n"
									 "Copyright 2014, Google Inc.  All rights reserved.\n"
									 "\n"
									 "Redistribution and use in source and binary forms, with or without\n"
									 "modification, are permitted provided that the following conditions are\n"
									 "met:\n"
									 "\n"
									 "    * Redistributions of source code must retain the above copyright\n"
									 "notice, this list of conditions and the following disclaimer.\n"
									 "    * Redistributions in binary form must reproduce the above\n"
									 "copyright notice, this list of conditions and the following disclaimer\n"
									 "in the documentation and/or other materials provided with the\n"
									 "distribution.\n"
									 "    * Neither the name of Google Inc. nor the names of its\n"
									 "contributors may be used to endorse or promote products derived from\n"
									 "this software without specific prior written permission.\n"
									 "\n"
									 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
									 "\"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
									 "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
									 "A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
									 "OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
									 "SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
									 "LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
									 "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
									 "THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
									 "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
									 "OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
									 "\n"
									 "Code generated by the Protocol Buffer compiler is owned by the owner\n"
									 "of the input file used when generating it.  This code is not\n"
									 "standalone and requires a support library to be linked with it.  This\n"
									 "support library is itself covered by the above license.";
#endif


#ifdef USE_BUILDENV
static const char *licenseExpat = "Copyright (c) 1998-2000 Thai Open Source Software Center Ltd and Clark Cooper\n"
								  "Copyright (c) 2001-2016 Expat maintainers\n"
								  "\n"
								  "Permission is hereby granted, free of charge, to any person obtaining\n"
								  "a copy of this software and associated documentation files (the\n"
								  "\"Software\"), to deal in the Software without restriction, including\n"
								  "without limitation the rights to use, copy, modify, merge, publish,\n"
								  "distribute, sublicense, and/or sell copies of the Software, and to\n"
								  "permit persons to whom the Software is furnished to do so, subject to\n"
								  "the following conditions:\n"
								  "\n"
								  "The above copyright notice and this permission notice shall be included\n"
								  "in all copies or substantial portions of the Software.\n"
								  "\n"
								  "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
								  "EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
								  "MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
								  "IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\n"
								  "CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n"
								  "TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\n"
								  "SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.";
#endif


#ifdef USE_BUILDENV
static const char *licenseBoost = "Boost Software License - Version 1.0 - August 17th, 2003\n"
								  "\n"
								  "Permission is hereby granted, free of charge, to any person or organization\n"
								  "obtaining a copy of the software and accompanying documentation covered by\n"
								  "this license (the \"Software\") to use, reproduce, display, distribute,\n"
								  "execute, and transmit the Software, and to prepare derivative works of the\n"
								  "Software, and to permit third-parties to whom the Software is furnished to\n"
								  "do so, all subject to the following:\n"
								  "\n"
								  "The copyright notices in the Software and this entire statement, including\n"
								  "the above license grant, this restriction and the following disclaimer,\n"
								  "must be included in all copies of the Software, in whole or in part, and\n"
								  "all derivative works of the Software, unless such copies or derivative\n"
								  "works are solely in the form of machine-executable object code generated by\n"
								  "a source language processor.\n"
								  "\n"
								  "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
								  "IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
								  "FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT\n"
								  "SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE\n"
								  "FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,\n"
								  "ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n"
								  "DEALINGS IN THE SOFTWARE.";
#endif


#ifdef USE_BUILDENV
static const char *licenseBzip2 = "This program, \"bzip2\", the associated library \"libbzip2\", and all\n"
								  "documentation, are copyright (C) 1996-2010 Julian R Seward.  All\n"
								  "rights reserved.\n"
								  "\n"
								  "Redistribution and use in source and binary forms, with or without\n"
								  "modification, are permitted provided that the following conditions\n"
								  "are met:\n"
								  "\n"
								  "1. Redistributions of source code must retain the above copyright\n"
								  "   notice, this list of conditions and the following disclaimer.\n"
								  "\n"
								  "2. The origin of this software must not be misrepresented; you must \n"
								  "   not claim that you wrote the original software.  If you use this \n"
								  "   software in a product, an acknowledgment in the product \n"
								  "   documentation would be appreciated but is not required.\n"
								  "\n"
								  "3. Altered source versions must be plainly marked as such, and must\n"
								  "   not be misrepresented as being the original software.\n"
								  "\n"
								  "4. The name of the author may not be used to endorse or promote \n"
								  "   products derived from this software without specific prior written \n"
								  "   permission.\n"
								  "\n"
								  "THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS\n"
								  "OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n"
								  "WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
								  "ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY\n"
								  "DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
								  "DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE\n"
								  "GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
								  "INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n"
								  "WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n"
								  "NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n"
								  "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
								  "\n"
								  "Julian Seward, jseward@bzip.org\n"
								  "bzip2/libbzip2 version 1.0.6 of 6 September 2010";
#endif


#ifdef USE_BUILDENV
static const char *licenseBerkeleyDB =
	"/*\n"
	" * Copyright (c) 1990, 2013 Oracle and/or its affiliates.  All rights reserved.\n"
	" *\n"
	" * Redistribution and use in source and binary forms, with or without\n"
	" * modification, are permitted provided that the following conditions\n"
	" * are met:\n"
	" * 1. Redistributions of source code must retain the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer.\n"
	" * 2. Redistributions in binary form must reproduce the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer in the\n"
	" *    documentation and/or other materials provided with the distribution.\n"
	" * 3. Redistributions in any form must be accompanied by information on\n"
	" *    how to obtain complete source code for the DB software and any\n"
	" *    accompanying software that uses the DB software.  The source code\n"
	" *    must either be included in the distribution or be available for no\n"
	" *    more than the cost of distribution plus a nominal fee, and must be\n"
	" *    freely redistributable under reasonable conditions.  For an\n"
	" *    executable file, complete source code means the source code for all\n"
	" *    modules it contains.  It does not include source code for modules or\n"
	" *    files that typically accompany the major components of the operating\n"
	" *    system on which the executable file runs.\n"
	" *\n"
	" * THIS SOFTWARE IS PROVIDED BY ORACLE ``AS IS'' AND ANY EXPRESS OR\n"
	" * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n"
	" * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR\n"
	" * NON-INFRINGEMENT, ARE DISCLAIMED.  IN NO EVENT SHALL ORACLE BE LIABLE\n"
	" * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
	" * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
	" * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n"
	" * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n"
	" * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE\n"
	" * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN\n"
	" * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
	" */\n"
	"/*\n"
	" * Copyright (c) 1990, 1993, 1994, 1995\n"
	" *	The Regents of the University of California.  All rights reserved.\n"
	" *\n"
	" * Redistribution and use in source and binary forms, with or without\n"
	" * modification, are permitted provided that the following conditions\n"
	" * are met:\n"
	" * 1. Redistributions of source code must retain the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer.\n"
	" * 2. Redistributions in binary form must reproduce the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer in the\n"
	" *    documentation and/or other materials provided with the distribution.\n"
	" * 3. Neither the name of the University nor the names of its contributors\n"
	" *    may be used to endorse or promote products derived from this software\n"
	" *    without specific prior written permission.\n"
	" *\n"
	" * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND\n"
	" * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
	" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
	" * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE\n"
	" * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
	" * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
	" * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
	" * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
	" * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
	" * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
	" * SUCH DAMAGE.\n"
	" */\n"
	"/*\n"
	" * Copyright (c) 1995, 1996\n"
	" *	The President and Fellows of Harvard University.  All rights reserved.\n"
	" *\n"
	" * Redistribution and use in source and binary forms, with or without\n"
	" * modification, are permitted provided that the following conditions\n"
	" * are met:\n"
	" * 1. Redistributions of source code must retain the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer.\n"
	" * 2. Redistributions in binary form must reproduce the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer in the\n"
	" *    documentation and/or other materials provided with the distribution.\n"
	" * 3. Neither the name of the University nor the names of its contributors\n"
	" *    may be used to endorse or promote products derived from this software\n"
	" *    without specific prior written permission.\n"
	" *\n"
	" * THIS SOFTWARE IS PROVIDED BY HARVARD AND ITS CONTRIBUTORS ``AS IS'' AND\n"
	" * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
	" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
	" * ARE DISCLAIMED.  IN NO EVENT SHALL HARVARD OR ITS CONTRIBUTORS BE LIABLE\n"
	" * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
	" * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
	" * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
	" * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
	" * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
	" * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
	" * SUCH DAMAGE.\n"
	" */\n"
	"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n"
	"/***\n"
	" * ASM: a very small and fast Java bytecode manipulation framework\n"
	" * Copyright (c) 2000-2005 INRIA, France Telecom\n"
	" * All rights reserved.\n"
	" *\n"
	" * Redistribution and use in source and binary forms, with or without\n"
	" * modification, are permitted provided that the following conditions\n"
	" * are met:\n"
	" * 1. Redistributions of source code must retain the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer.\n"
	" * 2. Redistributions in binary form must reproduce the above copyright\n"
	" *    notice, this list of conditions and the following disclaimer in the\n"
	" *    documentation and/or other materials provided with the distribution.\n"
	" * 3. Neither the name of the copyright holders nor the names of its\n"
	" *    contributors may be used to endorse or promote products derived from\n"
	" *    this software without specific prior written permission.\n"
	" *\n"
	" * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n"
	" * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
	" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
	" * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE\n"
	" * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
	" * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
	" * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
	" * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n"
	" * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
	" * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF\n"
	" * THE POSSIBILITY OF SUCH DAMAGE.\n"
	" */";
#endif


#ifdef USE_BUILDENV
static const char *licenseFreetype = "                    The FreeType Project LICENSE\n"
									 "                    ----------------------------\n"
									 "\n"
									 "                            2006-Jan-27\n"
									 "\n"
									 "                    Copyright 1996-2002, 2006 by\n"
									 "          David Turner, Robert Wilhelm, and Werner Lemberg\n"
									 "\n"
									 "\n"
									 "\n"
									 "Introduction\n"
									 "============\n"
									 "\n"
									 "  The FreeType  Project is distributed in  several archive packages;\n"
									 "  some of them may contain, in addition to the FreeType font engine,\n"
									 "  various tools and  contributions which rely on, or  relate to, the\n"
									 "  FreeType Project.\n"
									 "\n"
									 "  This  license applies  to all  files found  in such  packages, and\n"
									 "  which do not  fall under their own explicit  license.  The license\n"
									 "  affects  thus  the  FreeType   font  engine,  the  test  programs,\n"
									 "  documentation and makefiles, at the very least.\n"
									 "\n"
									 "  This  license   was  inspired  by  the  BSD,   Artistic,  and  IJG\n"
									 "  (Independent JPEG  Group) licenses, which  all encourage inclusion\n"
									 "  and  use of  free  software in  commercial  and freeware  products\n"
									 "  alike.  As a consequence, its main points are that:\n"
									 "\n"
									 "    o We don't promise that this software works. However, we will be\n"
									 "      interested in any kind of bug reports. (`as is' distribution)\n"
									 "\n"
									 "    o You can  use this software for whatever you  want, in parts or\n"
									 "      full form, without having to pay us. (`royalty-free' usage)\n"
									 "\n"
									 "    o You may not pretend that  you wrote this software.  If you use\n"
									 "      it, or  only parts of it,  in a program,  you must acknowledge\n"
									 "      somewhere  in  your  documentation  that  you  have  used  the\n"
									 "      FreeType code. (`credits')\n"
									 "\n"
									 "  We  specifically  permit  and  encourage  the  inclusion  of  this\n"
									 "  software, with  or without modifications,  in commercial products.\n"
									 "  We  disclaim  all warranties  covering  The  FreeType Project  and\n"
									 "  assume no liability related to The FreeType Project.\n"
									 "\n"
									 "\n"
									 "  Finally,  many  people  asked  us  for  a  preferred  form  for  a\n"
									 "  credit/disclaimer to use in compliance with this license.  We thus\n"
									 "  encourage you to use the following text:\n"
									 "\n"
									 "   \"\"\"\n"
									 "    Portions of this software are copyright © <year> The FreeType\n"
									 "    Project (www.freetype.org).  All rights reserved.\n"
									 "   \"\"\"\n"
									 "\n"
									 "  Please replace <year> with the value from the FreeType version you\n"
									 "  actually use.\n"
									 "\n"
									 "\n"
									 "Legal Terms\n"
									 "===========\n"
									 "\n"
									 "0. Definitions\n"
									 "--------------\n"
									 "\n"
									 "  Throughout this license,  the terms `package', `FreeType Project',\n"
									 "  and  `FreeType  archive' refer  to  the  set  of files  originally\n"
									 "  distributed  by the  authors  (David Turner,  Robert Wilhelm,  and\n"
									 "  Werner Lemberg) as the `FreeType Project', be they named as alpha,\n"
									 "  beta or final release.\n"
									 "\n"
									 "  `You' refers to  the licensee, or person using  the project, where\n"
									 "  `using' is a generic term including compiling the project's source\n"
									 "  code as  well as linking it  to form a  `program' or `executable'.\n"
									 "  This  program is  referred to  as  `a program  using the  FreeType\n"
									 "  engine'.\n"
									 "\n"
									 "  This  license applies  to all  files distributed  in  the original\n"
									 "  FreeType  Project,   including  all  source   code,  binaries  and\n"
									 "  documentation,  unless  otherwise  stated   in  the  file  in  its\n"
									 "  original, unmodified form as  distributed in the original archive.\n"
									 "  If you are  unsure whether or not a particular  file is covered by\n"
									 "  this license, you must contact us to verify this.\n"
									 "\n"
									 "  The FreeType  Project is copyright (C) 1996-2000  by David Turner,\n"
									 "  Robert Wilhelm, and Werner Lemberg.  All rights reserved except as\n"
									 "  specified below.\n"
									 "\n"
									 "1. No Warranty\n"
									 "--------------\n"
									 "\n"
									 "  THE FREETYPE PROJECT  IS PROVIDED `AS IS' WITHOUT  WARRANTY OF ANY\n"
									 "  KIND, EITHER  EXPRESS OR IMPLIED,  INCLUDING, BUT NOT  LIMITED TO,\n"
									 "  WARRANTIES  OF  MERCHANTABILITY   AND  FITNESS  FOR  A  PARTICULAR\n"
									 "  PURPOSE.  IN NO EVENT WILL ANY OF THE AUTHORS OR COPYRIGHT HOLDERS\n"
									 "  BE LIABLE  FOR ANY DAMAGES CAUSED  BY THE USE OR  THE INABILITY TO\n"
									 "  USE, OF THE FREETYPE PROJECT.\n"
									 "\n"
									 "2. Redistribution\n"
									 "-----------------\n"
									 "\n"
									 "  This  license  grants  a  worldwide, royalty-free,  perpetual  and\n"
									 "  irrevocable right  and license to use,  execute, perform, compile,\n"
									 "  display,  copy,   create  derivative  works   of,  distribute  and\n"
									 "  sublicense the  FreeType Project (in  both source and  object code\n"
									 "  forms)  and  derivative works  thereof  for  any  purpose; and  to\n"
									 "  authorize others  to exercise  some or all  of the  rights granted\n"
									 "  herein, subject to the following conditions:\n"
									 "\n"
									 "    o Redistribution of  source code  must retain this  license file\n"
									 "      (`FTL.TXT') unaltered; any  additions, deletions or changes to\n"
									 "      the original  files must be clearly  indicated in accompanying\n"
									 "      documentation.   The  copyright   notices  of  the  unaltered,\n"
									 "      original  files must  be  preserved in  all  copies of  source\n"
									 "      files.\n"
									 "\n"
									 "    o Redistribution in binary form must provide a  disclaimer  that\n"
									 "      states  that  the software is based in part of the work of the\n"
									 "      FreeType Team,  in  the  distribution  documentation.  We also\n"
									 "      encourage you to put an URL to the FreeType web page  in  your\n"
									 "      documentation, though this isn't mandatory.\n"
									 "\n"
									 "  These conditions  apply to any  software derived from or  based on\n"
									 "  the FreeType Project,  not just the unmodified files.   If you use\n"
									 "  our work, you  must acknowledge us.  However, no  fee need be paid\n"
									 "  to us.\n"
									 "\n"
									 "3. Advertising\n"
									 "--------------\n"
									 "\n"
									 "  Neither the  FreeType authors and  contributors nor you  shall use\n"
									 "  the name of the  other for commercial, advertising, or promotional\n"
									 "  purposes without specific prior written permission.\n"
									 "\n"
									 "  We suggest,  but do not require, that  you use one or  more of the\n"
									 "  following phrases to refer  to this software in your documentation\n"
									 "  or advertising  materials: `FreeType Project',  `FreeType Engine',\n"
									 "  `FreeType library', or `FreeType Distribution'.\n"
									 "\n"
									 "  As  you have  not signed  this license,  you are  not  required to\n"
									 "  accept  it.   However,  as  the FreeType  Project  is  copyrighted\n"
									 "  material, only  this license, or  another one contracted  with the\n"
									 "  authors, grants you  the right to use, distribute,  and modify it.\n"
									 "  Therefore,  by  using,  distributing,  or modifying  the  FreeType\n"
									 "  Project, you indicate that you understand and accept all the terms\n"
									 "  of this license.\n"
									 "\n"
									 "4. Contacts\n"
									 "-----------\n"
									 "\n"
									 "  There are two mailing lists related to FreeType:\n"
									 "\n"
									 "    o freetype@nongnu.org\n"
									 "\n"
									 "      Discusses general use and applications of FreeType, as well as\n"
									 "      future and  wanted additions to the  library and distribution.\n"
									 "      If  you are looking  for support,  start in  this list  if you\n"
									 "      haven't found anything to help you in the documentation.\n"
									 "\n"
									 "    o freetype-devel@nongnu.org\n"
									 "\n"
									 "      Discusses bugs,  as well  as engine internals,  design issues,\n"
									 "      specific licenses, porting, etc.\n"
									 "\n"
									 "  Our home page can be found at\n"
									 "\n"
									 "    http://www.freetype.org\n"
									 "\n"
									 "\n"
									 "--- end of FTL.TXT ---";
#endif


#ifdef USE_BUILDENV
static const char *licenseHarfBuzzNG =
	"HarfBuzz is licensed under the so-called \"Old MIT\" license.  Details follow.\n"
	"For parts of HarfBuzz that are licensed under different licenses see individual\n"
	"files names COPYING in subdirectories where applicable.\n"
	"\n"
	"Copyright © 2010,2011,2012  Google, Inc.\n"
	"Copyright © 2012  Mozilla Foundation\n"
	"Copyright © 2011  Codethink Limited\n"
	"Copyright © 2008,2010  Nokia Corporation and/or its subsidiary(-ies)\n"
	"Copyright © 2009  Keith Stribley\n"
	"Copyright © 2009  Martin Hosken and SIL International\n"
	"Copyright © 2007  Chris Wilson\n"
	"Copyright © 2006  Behdad Esfahbod\n"
	"Copyright © 2005  David Turner\n"
	"Copyright © 2004,2007,2008,2009,2010  Red Hat, Inc.\n"
	"Copyright © 1998-2004  David Turner and Werner Lemberg\n"
	"\n"
	"For full copyright notices consult the individual files in the package.\n"
	"\n"
	"\n"
	"Permission is hereby granted, without written agreement and without\n"
	"license or royalty fees, to use, copy, modify, and distribute this\n"
	"software and its documentation for any purpose, provided that the\n"
	"above copyright notice and the following two paragraphs appear in\n"
	"all copies of this software.\n"
	"\n"
	"IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR\n"
	"DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES\n"
	"ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN\n"
	"IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH\n"
	"DAMAGE.\n"
	"\n"
	"THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,\n"
	"BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\n"
	"FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS\n"
	"ON AN \"AS IS\" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO\n"
	"PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibPNG = "\n"
								   "This copy of the libpng notices is provided for your convenience.  In case of\n"
								   "any discrepancy between this copy and the notices in the file png.h that is\n"
								   "included in the libpng distribution, the latter shall prevail.\n"
								   "\n"
								   "COPYRIGHT NOTICE, DISCLAIMER, and LICENSE:\n"
								   "\n"
								   "If you modify libpng you may insert additional notices immediately following\n"
								   "this sentence.\n"
								   "\n"
								   "This code is released under the libpng license.\n"
								   "\n"
								   "libpng versions 1.0.7, July 1, 2000 through 1.6.28, January 5, 2017 are\n"
								   "Copyright (c) 2000-2002, 2004, 2006-2017 Glenn Randers-Pehrson, are\n"
								   "derived from libpng-1.0.6, and are distributed according to the same\n"
								   "disclaimer and license as libpng-1.0.6 with the following individuals\n"
								   "added to the list of Contributing Authors:\n"
								   "\n"
								   "   Simon-Pierre Cadieux\n"
								   "   Eric S. Raymond\n"
								   "   Mans Rullgard\n"
								   "   Cosmin Truta\n"
								   "   Gilles Vollant\n"
								   "   James Yu\n"
								   "   Mandar Sahastrabuddhe\n"
								   "\n"
								   "and with the following additions to the disclaimer:\n"
								   "\n"
								   "   There is no warranty against interference with your enjoyment of the\n"
								   "   library or against infringement.  There is no warranty that our\n"
								   "   efforts or the library will fulfill any of your particular purposes\n"
								   "   or needs.  This library is provided with all faults, and the entire\n"
								   "   risk of satisfactory quality, performance, accuracy, and effort is with\n"
								   "   the user.\n"
								   "\n"
								   "Some files in the \"contrib\" directory and some configure-generated\n"
								   "files that are distributed with libpng have other copyright owners and\n"
								   "are released under other open source licenses.\n"
								   "\n"
								   "libpng versions 0.97, January 1998, through 1.0.6, March 20, 2000, are\n"
								   "Copyright (c) 1998-2000 Glenn Randers-Pehrson, are derived from\n"
								   "libpng-0.96, and are distributed according to the same disclaimer and\n"
								   "license as libpng-0.96, with the following individuals added to the list\n"
								   "of Contributing Authors:\n"
								   "\n"
								   "   Tom Lane\n"
								   "   Glenn Randers-Pehrson\n"
								   "   Willem van Schaik\n"
								   "\n"
								   "libpng versions 0.89, June 1996, through 0.96, May 1997, are\n"
								   "Copyright (c) 1996-1997 Andreas Dilger, are derived from libpng-0.88,\n"
								   "and are distributed according to the same disclaimer and license as\n"
								   "libpng-0.88, with the following individuals added to the list of\n"
								   "Contributing Authors:\n"
								   "\n"
								   "   John Bowler\n"
								   "   Kevin Bracey\n"
								   "   Sam Bushell\n"
								   "   Magnus Holmgren\n"
								   "   Greg Roelofs\n"
								   "   Tom Tanner\n"
								   "\n"
								   "Some files in the \"scripts\" directory have other copyright owners\n"
								   "but are released under this license.\n"
								   "\n"
								   "libpng versions 0.5, May 1995, through 0.88, January 1996, are\n"
								   "Copyright (c) 1995-1996 Guy Eric Schalnat, Group 42, Inc.\n"
								   "\n"
								   "For the purposes of this copyright and license, \"Contributing Authors\"\n"
								   "is defined as the following set of individuals:\n"
								   "\n"
								   "   Andreas Dilger\n"
								   "   Dave Martindale\n"
								   "   Guy Eric Schalnat\n"
								   "   Paul Schmidt\n"
								   "   Tim Wegner\n"
								   "\n"
								   "The PNG Reference Library is supplied \"AS IS\".  The Contributing Authors\n"
								   "and Group 42, Inc. disclaim all warranties, expressed or implied,\n"
								   "including, without limitation, the warranties of merchantability and of\n"
								   "fitness for any purpose.  The Contributing Authors and Group 42, Inc.\n"
								   "assume no liability for direct, indirect, incidental, special, exemplary,\n"
								   "or consequential damages, which may result from the use of the PNG\n"
								   "Reference Library, even if advised of the possibility of such damage.\n"
								   "\n"
								   "Permission is hereby granted to use, copy, modify, and distribute this\n"
								   "source code, or portions hereof, for any purpose, without fee, subject\n"
								   "to the following restrictions:\n"
								   "\n"
								   "  1. The origin of this source code must not be misrepresented.\n"
								   "\n"
								   "  2. Altered versions must be plainly marked as such and must not\n"
								   "     be misrepresented as being the original source.\n"
								   "\n"
								   "  3. This Copyright notice may not be removed or altered from any\n"
								   "     source or altered source distribution.\n"
								   "\n"
								   "The Contributing Authors and Group 42, Inc. specifically permit, without\n"
								   "fee, and encourage the use of this source code as a component to\n"
								   "supporting the PNG file format in commercial products.  If you use this\n"
								   "source code in a product, acknowledgment is not required but would be\n"
								   "appreciated.\n"
								   "\n"
								   "END OF COPYRIGHT NOTICE, DISCLAIMER, and LICENSE.\n"
								   "\n"
								   "TRADEMARK:\n"
								   "\n"
								   "The name \"libpng\" has not been registered by the Copyright owner\n"
								   "as a trademark in any jurisdiction.  However, because libpng has\n"
								   "been distributed and maintained world-wide, continually since 1995,\n"
								   "the Copyright owner claims \"common-law trademark protection\" in any\n"
								   "jurisdiction where common-law trademark is recognized.\n"
								   "\n"
								   "OSI CERTIFICATION:\n"
								   "\n"
								   "Libpng is OSI Certified Open Source Software.  OSI Certified Open Source is\n"
								   "a certification mark of the Open Source Initiative. OSI has not addressed\n"
								   "the additional disclaimers inserted at version 1.0.7.\n"
								   "\n"
								   "EXPORT CONTROL:\n"
								   "\n"
								   "The Copyright owner believes that the Export Control Classification\n"
								   "Number (ECCN) for libpng is EAR99, which means not subject to export\n"
								   "controls or International Traffic in Arms Regulations (ITAR) because\n"
								   "it is open source, publicly available software, that does not contain\n"
								   "any encryption software.  See the EAR, paragraphs 734.3(b)(3) and\n"
								   "734.7(b).\n"
								   "\n"
								   "Glenn Randers-Pehrson\n"
								   "glennrp at users.sourceforge.net\n"
								   "January 5, 2017";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibjpegTurbo =
	"libjpeg-turbo is covered by three compatible BSD-style open source licenses:\n"
	"\n"
	"1. The IJG (Independent JPEG Group) License.\n"
	"   This license applies to the libjpeg API library and associated programs\n"
	"   (any code inherited from libjpeg, and any modifications to that code.)\n"
	"\n"
	"2. The Modified (3-clause) BSD License\n"
	"   This license covers the TurboJPEG API library and associated programs.\n"
	"\n"
	"3. The zlib License\n"
	"   This license is a subset of the other two, and it covers the libjpeg-turbo\n"
	"   SIMD extensions.\n"
	"\n"
	"-----BEGIN IJG LICENSE-----\n"
	"libjpeg-turbo note:  This file has been modified by The libjpeg-turbo Project\n"
	"to include only information relevant to libjpeg-turbo, to wordsmith certain\n"
	"sections, and to remove impolitic language that existed in the libjpeg v8\n"
	"README.  It is included only for reference.  Please see README.md for\n"
	"information specific to libjpeg-turbo.\n"
	"\n"
	"\n"
	"The Independent JPEG Group's JPEG software\n"
	"==========================================\n"
	"\n"
	"This distribution contains a release of the Independent JPEG Group's free JPEG\n"
	"software.  You are welcome to redistribute this software and to use it for any\n"
	"purpose, subject to the conditions under LEGAL ISSUES, below.\n"
	"\n"
	"This software is the work of Tom Lane, Guido Vollbeding, Philip Gladstone,\n"
	"Bill Allombert, Jim Boucher, Lee Crocker, Bob Friesenhahn, Ben Jackson,\n"
	"Julian Minguillon, Luis Ortiz, George Phillips, Davide Rossi, Ge' Weijers,\n"
	"and other members of the Independent JPEG Group.\n"
	"\n"
	"IJG is not affiliated with the ISO/IEC JTC1/SC29/WG1 standards committee\n"
	"(also known as JPEG, together with ITU-T SG16).\n"
	"\n"
	"\n"
	"DOCUMENTATION ROADMAP\n"
	"=====================\n"
	"\n"
	"This file contains the following sections:\n"
	"\n"
	"OVERVIEW            General description of JPEG and the IJG software.\n"
	"LEGAL ISSUES        Copyright, lack of warranty, terms of distribution.\n"
	"REFERENCES          Where to learn more about JPEG.\n"
	"ARCHIVE LOCATIONS   Where to find newer versions of this software.\n"
	"FILE FORMAT WARS    Software *not* to get.\n"
	"TO DO               Plans for future IJG releases.\n"
	"\n"
	"Other documentation files in the distribution are:\n"
	"\n"
	"User documentation:\n"
	"  usage.txt         Usage instructions for cjpeg, djpeg, jpegtran,\n"
	"                    rdjpgcom, and wrjpgcom.\n"
	"  *.1               Unix-style man pages for programs (same info as usage.txt).\n"
	"  wizard.txt        Advanced usage instructions for JPEG wizards only.\n"
	"  change.log        Version-to-version change highlights.\n"
	"Programmer and internal documentation:\n"
	"  libjpeg.txt       How to use the JPEG library in your own programs.\n"
	"  example.c         Sample code for calling the JPEG library.\n"
	"  structure.txt     Overview of the JPEG library's internal structure.\n"
	"  coderules.txt     Coding style rules --- please read if you contribute code.\n"
	"\n"
	"Please read at least usage.txt.  Some information can also be found in the JPEG\n"
	"FAQ (Frequently Asked Questions) article.  See ARCHIVE LOCATIONS below to find\n"
	"out where to obtain the FAQ article.\n"
	"\n"
	"If you want to understand how the JPEG code works, we suggest reading one or\n"
	"more of the REFERENCES, then looking at the documentation files (in roughly\n"
	"the order listed) before diving into the code.\n"
	"\n"
	"\n"
	"OVERVIEW\n"
	"========\n"
	"\n"
	"This package contains C software to implement JPEG image encoding, decoding,\n"
	"and transcoding.  JPEG (pronounced \"jay-peg\") is a standardized compression\n"
	"method for full-color and grayscale images.  JPEG's strong suit is compressing\n"
	"photographic images or other types of images that have smooth color and\n"
	"brightness transitions between neighboring pixels.  Images with sharp lines or\n"
	"other abrupt features may not compress well with JPEG, and a higher JPEG\n"
	"quality may have to be used to avoid visible compression artifacts with such\n"
	"images.\n"
	"\n"
	"JPEG is lossy, meaning that the output pixels are not necessarily identical to\n"
	"the input pixels.  However, on photographic content and other \"smooth\" images,\n"
	"very good compression ratios can be obtained with no visible compression\n"
	"artifacts, and extremely high compression ratios are possible if you are\n"
	"willing to sacrifice image quality (by reducing the \"quality\" setting in the\n"
	"compressor.)\n"
	"\n"
	"This software implements JPEG baseline, extended-sequential, and progressive\n"
	"compression processes.  Provision is made for supporting all variants of these\n"
	"processes, although some uncommon parameter settings aren't implemented yet.\n"
	"We have made no provision for supporting the hierarchical or lossless\n"
	"processes defined in the standard.\n"
	"\n"
	"We provide a set of library routines for reading and writing JPEG image files,\n"
	"plus two sample applications \"cjpeg\" and \"djpeg\", which use the library to\n"
	"perform conversion between JPEG and some other popular image file formats.\n"
	"The library is intended to be reused in other applications.\n"
	"\n"
	"In order to support file conversion and viewing software, we have included\n"
	"considerable functionality beyond the bare JPEG coding/decoding capability;\n"
	"for example, the color quantization modules are not strictly part of JPEG\n"
	"decoding, but they are essential for output to colormapped file formats or\n"
	"colormapped displays.  These extra functions can be compiled out of the\n"
	"library if not required for a particular application.\n"
	"\n"
	"We have also included \"jpegtran\", a utility for lossless transcoding between\n"
	"different JPEG processes, and \"rdjpgcom\" and \"wrjpgcom\", two simple\n"
	"applications for inserting and extracting textual comments in JFIF files.\n"
	"\n"
	"The emphasis in designing this software has been on achieving portability and\n"
	"flexibility, while also making it fast enough to be useful.  In particular,\n"
	"the software is not intended to be read as a tutorial on JPEG.  (See the\n"
	"REFERENCES section for introductory material.)  Rather, it is intended to\n"
	"be reliable, portable, industrial-strength code.  We do not claim to have\n"
	"achieved that goal in every aspect of the software, but we strive for it.\n"
	"\n"
	"We welcome the use of this software as a component of commercial products.\n"
	"No royalty is required, but we do ask for an acknowledgement in product\n"
	"documentation, as described under LEGAL ISSUES.\n"
	"\n"
	"\n"
	"LEGAL ISSUES\n"
	"============\n"
	"\n"
	"In plain English:\n"
	"\n"
	"1. We don't promise that this software works.  (But if you find any bugs,\n"
	"   please let us know!)\n"
	"2. You can use this software for whatever you want.  You don't have to pay us.\n"
	"3. You may not pretend that you wrote this software.  If you use it in a\n"
	"   program, you must acknowledge somewhere in your documentation that\n"
	"   you've used the IJG code.\n"
	"\n"
	"In legalese:\n"
	"\n"
	"The authors make NO WARRANTY or representation, either express or implied,\n"
	"with respect to this software, its quality, accuracy, merchantability, or\n"
	"fitness for a particular purpose.  This software is provided \"AS IS\", and you,\n"
	"its user, assume the entire risk as to its quality and accuracy.\n"
	"\n"
	"This software is copyright (C) 1991-2016, Thomas G. Lane, Guido Vollbeding.\n"
	"All Rights Reserved except as specified below.\n"
	"\n"
	"Permission is hereby granted to use, copy, modify, and distribute this\n"
	"software (or portions thereof) for any purpose, without fee, subject to these\n"
	"conditions:\n"
	"(1) If any part of the source code for this software is distributed, then this\n"
	"README file must be included, with this copyright and no-warranty notice\n"
	"unaltered; and any additions, deletions, or changes to the original files\n"
	"must be clearly indicated in accompanying documentation.\n"
	"(2) If only executable code is distributed, then the accompanying\n"
	"documentation must state that \"this software is based in part on the work of\n"
	"the Independent JPEG Group\".\n"
	"(3) Permission for use of this software is granted only if the user accepts\n"
	"full responsibility for any undesirable consequences; the authors accept\n"
	"NO LIABILITY for damages of any kind.\n"
	"\n"
	"These conditions apply to any software derived from or based on the IJG code,\n"
	"not just to the unmodified library.  If you use our work, you ought to\n"
	"acknowledge us.\n"
	"\n"
	"Permission is NOT granted for the use of any IJG author's name or company name\n"
	"in advertising or publicity relating to this software or products derived from\n"
	"it.  This software may be referred to only as \"the Independent JPEG Group's\n"
	"software\".\n"
	"\n"
	"We specifically permit and encourage the use of this software as the basis of\n"
	"commercial products, provided that all warranty or liability claims are\n"
	"assumed by the product vendor.\n"
	"\n"
	"\n"
	"The Unix configuration script \"configure\" was produced with GNU Autoconf.\n"
	"It is copyright by the Free Software Foundation but is freely distributable.\n"
	"The same holds for its supporting scripts (config.guess, config.sub,\n"
	"ltmain.sh).  Another support script, install-sh, is copyright by X Consortium\n"
	"but is also freely distributable.\n"
	"\n"
	"The IJG distribution formerly included code to read and write GIF files.\n"
	"To avoid entanglement with the Unisys LZW patent (now expired), GIF reading\n"
	"support has been removed altogether, and the GIF writer has been simplified\n"
	"to produce \"uncompressed GIFs\".  This technique does not use the LZW\n"
	"algorithm; the resulting GIF files are larger than usual, but are readable\n"
	"by all standard GIF decoders.\n"
	"\n"
	"We are required to state that\n"
	"    \"The Graphics Interchange Format(c) is the Copyright property of\n"
	"    CompuServe Incorporated.  GIF(sm) is a Service Mark property of\n"
	"    CompuServe Incorporated.\"\n"
	"\n"
	"\n"
	"REFERENCES\n"
	"==========\n"
	"\n"
	"We recommend reading one or more of these references before trying to\n"
	"understand the innards of the JPEG software.\n"
	"\n"
	"The best short technical introduction to the JPEG compression algorithm is\n"
	"	Wallace, Gregory K.  \"The JPEG Still Picture Compression Standard\",\n"
	"	Communications of the ACM, April 1991 (vol. 34 no. 4), pp. 30-44.\n"
	"(Adjacent articles in that issue discuss MPEG motion picture compression,\n"
	"applications of JPEG, and related topics.)  If you don't have the CACM issue\n"
	"handy, a PDF file containing a revised version of Wallace's article is\n"
	"available at http://www.ijg.org/files/Wallace.JPEG.pdf.  The file (actually\n"
	"a preprint for an article that appeared in IEEE Trans. Consumer Electronics)\n"
	"omits the sample images that appeared in CACM, but it includes corrections\n"
	"and some added material.  Note: the Wallace article is copyright ACM and IEEE,\n"
	"and it may not be used for commercial purposes.\n"
	"\n"
	"A somewhat less technical, more leisurely introduction to JPEG can be found in\n"
	"\"The Data Compression Book\" by Mark Nelson and Jean-loup Gailly, published by\n"
	"M&T Books (New York), 2nd ed. 1996, ISBN 1-55851-434-1.  This book provides\n"
	"good explanations and example C code for a multitude of compression methods\n"
	"including JPEG.  It is an excellent source if you are comfortable reading C\n"
	"code but don't know much about data compression in general.  The book's JPEG\n"
	"sample code is far from industrial-strength, but when you are ready to look\n"
	"at a full implementation, you've got one here...\n"
	"\n"
	"The best currently available description of JPEG is the textbook \"JPEG Still\n"
	"Image Data Compression Standard\" by William B. Pennebaker and Joan L.\n"
	"Mitchell, published by Van Nostrand Reinhold, 1993, ISBN 0-442-01272-1.\n"
	"Price US$59.95, 638 pp.  The book includes the complete text of the ISO JPEG\n"
	"standards (DIS 10918-1 and draft DIS 10918-2).\n"
	"\n"
	"The original JPEG standard is divided into two parts, Part 1 being the actual\n"
	"specification, while Part 2 covers compliance testing methods.  Part 1 is\n"
	"titled \"Digital Compression and Coding of Continuous-tone Still Images,\n"
	"Part 1: Requirements and guidelines\" and has document numbers ISO/IEC IS\n"
	"10918-1, ITU-T T.81.  Part 2 is titled \"Digital Compression and Coding of\n"
	"Continuous-tone Still Images, Part 2: Compliance testing\" and has document\n"
	"numbers ISO/IEC IS 10918-2, ITU-T T.83.\n"
	"\n"
	"The JPEG standard does not specify all details of an interchangeable file\n"
	"format.  For the omitted details we follow the \"JFIF\" conventions, revision\n"
	"1.02.  JFIF 1.02 has been adopted as an Ecma International Technical Report\n"
	"and thus received a formal publication status.  It is available as a free\n"
	"download in PDF format from\n"
	"http://www.ecma-international.org/publications/techreports/E-TR-098.htm.\n"
	"A PostScript version of the JFIF document is available at\n"
	"http://www.ijg.org/files/jfif.ps.gz.  There is also a plain text version at\n"
	"http://www.ijg.org/files/jfif.txt.gz, but it is missing the figures.\n"
	"\n"
	"The TIFF 6.0 file format specification can be obtained by FTP from\n"
	"ftp://ftp.sgi.com/graphics/tiff/TIFF6.ps.gz.  The JPEG incorporation scheme\n"
	"found in the TIFF 6.0 spec of 3-June-92 has a number of serious problems.\n"
	"IJG does not recommend use of the TIFF 6.0 design (TIFF Compression tag 6).\n"
	"Instead, we recommend the JPEG design proposed by TIFF Technical Note #2\n"
	"(Compression tag 7).  Copies of this Note can be obtained from\n"
	"http://www.ijg.org/files/.  It is expected that the next revision\n"
	"of the TIFF spec will replace the 6.0 JPEG design with the Note's design.\n"
	"Although IJG's own code does not support TIFF/JPEG, the free libtiff library\n"
	"uses our library to implement TIFF/JPEG per the Note.\n"
	"\n"
	"\n"
	"ARCHIVE LOCATIONS\n"
	"=================\n"
	"\n"
	"The \"official\" archive site for this software is www.ijg.org.\n"
	"The most recent released version can always be found there in\n"
	"directory \"files\".\n"
	"\n"
	"The JPEG FAQ (Frequently Asked Questions) article is a source of some\n"
	"general information about JPEG.\n"
	"It is available on the World Wide Web at http://www.faqs.org/faqs/jpeg-faq/\n"
	"and other news.answers archive sites, including the official news.answers\n"
	"archive at rtfm.mit.edu: ftp://rtfm.mit.edu/pub/usenet/news.answers/jpeg-faq/.\n"
	"If you don't have Web or FTP access, send e-mail to mail-server@rtfm.mit.edu\n"
	"with body\n"
	"	send usenet/news.answers/jpeg-faq/part1\n"
	"	send usenet/news.answers/jpeg-faq/part2\n"
	"\n"
	"\n"
	"FILE FORMAT WARS\n"
	"================\n"
	"\n"
	"The ISO/IEC JTC1/SC29/WG1 standards committee (also known as JPEG, together\n"
	"with ITU-T SG16) currently promotes different formats containing the name\n"
	"\"JPEG\" which are incompatible with original DCT-based JPEG.  IJG therefore does\n"
	"not support these formats (see REFERENCES).  Indeed, one of the original\n"
	"reasons for developing this free software was to help force convergence on\n"
	"common, interoperable format standards for JPEG files.\n"
	"Don't use an incompatible file format!\n"
	"(In any case, our decoder will remain capable of reading existing JPEG\n"
	"image files indefinitely.)\n"
	"\n"
	"\n"
	"TO DO\n"
	"=====\n"
	"\n"
	"Please send bug reports, offers of help, etc. to jpeg-info@jpegclub.org.\n"
	"-----END IJG LICENSE-----\n"
	"\n"
	"-----BEGIN TURBOJPEG LICENSE-----\n"
	"/*\n"
	" * Copyright (C)2009-2016 D. R. Commander.  All Rights Reserved.\n"
	" *\n"
	" * Redistribution and use in source and binary forms, with or without\n"
	" * modification, are permitted provided that the following conditions are met:\n"
	" *\n"
	" * - Redistributions of source code must retain the above copyright notice,\n"
	" *   this list of conditions and the following disclaimer.\n"
	" * - Redistributions in binary form must reproduce the above copyright notice,\n"
	" *   this list of conditions and the following disclaimer in the documentation\n"
	" *   and/or other materials provided with the distribution.\n"
	" * - Neither the name of the libjpeg-turbo Project nor the names of its\n"
	" *   contributors may be used to endorse or promote products derived from this\n"
	" *   software without specific prior written permission.\n"
	" *\n"
	" * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\",\n"
	" * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
	" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
	" * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE\n"
	" * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
	" * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
	" * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
	" * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n"
	" * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
	" * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE\n"
	" * POSSIBILITY OF SUCH DAMAGE.\n"
	" */\n"
	"-----END TURBOJPEG LICENSE-----\n"
	"\n"
	"\n"
	"-----BEGIN ZLIB LICENSE-----\n"
	"; Copyright 2009 Pierre Ossman <ossman@cendio.se> for Cendio AB\n"
	"; Copyright (C) 2010, D. R. Commander.\n"
	";\n"
	"; Based on the x86 SIMD extension for IJG JPEG library - version 1.02\n"
	";\n"
	"; Copyright (C) 1999-2006, MIYASAKA Masaru.\n"
	";\n"
	"; This software is provided 'as-is', without any express or implied\n"
	"; warranty.  In no event will the authors be held liable for any damages\n"
	"; arising from the use of this software.\n"
	";\n"
	"; Permission is granted to anyone to use this software for any purpose,\n"
	"; including commercial applications, and to alter it and redistribute it\n"
	"; freely, subject to the following restrictions:\n"
	";\n"
	"; 1. The origin of this software must not be misrepresented; you must not\n"
	";    claim that you wrote the original software. If you use this software\n"
	";    in a product, an acknowledgment in the product documentation would be\n"
	";    appreciated but is not required.\n"
	"; 2. Altered source versions must be plainly marked as such, and must not be\n"
	";    misrepresented as being the original software.\n"
	"; 3. This notice may not be removed or altered from any source distribution.\n"
	"-----END ZLIB LICENSE-----";
#endif


#ifdef USE_BUILDENV
static const char *licenseZeroCIce = "Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.\n"
									 "\n"
									 "This copy of Ice is free software; you can redistribute it and/or modify\n"
									 "it under the terms of the GNU General Public License version 2 as\n"
									 "published by the Free Software Foundation.\n"
									 "\n"
									 "Ice is distributed in the hope that it will be useful, but WITHOUT ANY\n"
									 "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n"
									 "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more\n"
									 "details.\n"
									 "\n"
									 "You should have received a copy of the GNU General Public License version\n"
									 "2 along with this program; if not, see http://www.gnu.org/licenses.\n"
									 "\n"
									 "Linking Ice statically or dynamically with other software (such as a \n"
									 "library, module or application) is making a combined work based on Ice. \n"
									 "Thus, the terms and conditions of the GNU General Public License version\n"
									 "2 cover this combined work.\n"
									 "\n"
									 "If such software can only be used together with Ice, then not only the \n"
									 "combined work but the software itself is a work derived from Ice and as\n"
									 "such shall be licensed under the terms of the GNU General Public License \n"
									 "version 2. This includes the situation where Ice is only being used \n"
									 "through an abstraction layer.\n"
									 "\n"
									 "As a special exception to the above, ZeroC grants to the copyright \n"
									 "holders and contributors of the Mumble project (http://www.mumble.info) \n"
									 "the permission to license the Ice-based software they contribute to \n"
									 "Mumble under the terms of the BSD license. This exception does not extend\n"
									 "to the parts of Ice used by Mumble, or to any other derived work: as a \n"
									 "whole, any work based on Ice shall be licensed under the terms and \n"
									 "conditions of the GNU General Public License version 2.\n"
									 "\n"
									 "You may also combine Ice with any software not derived from Ice, provided\n"
									 "the license of such software is compatible with the GNU General Public \n"
									 "License version 2. In addition, as a special exception, ZeroC grants you\n"
									 "permission to combine Ice with:\n"
									 " \n"
									 " - the OpenSSL library, or with a modified version of the OpenSSL library\n"
									 "   that uses the same license as OpenSSL\n"
									 "\n"
									 " - any library not derived from Ice and licensed under the terms of\n"
									 "   the Apache License, version 2.0 \n"
									 "   (http://www.apache.org/licenses/LICENSE-2.0.html) \n"
									 "\n"
									 "If you modify this copy of Ice, you may extend any of the exceptions \n"
									 "provided above to your version of Ice, but you are not obligated to \n"
									 "do so.";
#endif


#ifdef USE_BUILDENV
static const char *licenseMcpp = "/*-\n"
								 " * Copyright (c) 1998, 2002-2008 Kiyoshi Matsui <kmatsui@t3.rim.or.jp>\n"
								 " * All rights reserved.\n"
								 " *\n"
								 " * This software including the files in this directory is provided under\n"
								 " * the following license.\n"
								 " *\n"
								 " * Redistribution and use in source and binary forms, with or without\n"
								 " * modification, are permitted provided that the following conditions\n"
								 " * are met:\n"
								 " * 1. Redistributions of source code must retain the above copyright\n"
								 " *    notice, this list of conditions and the following disclaimer.\n"
								 " * 2. Redistributions in binary form must reproduce the above copyright\n"
								 " *    notice, this list of conditions and the following disclaimer in the\n"
								 " *    documentation and/or other materials provided with the distribution.\n"
								 " *\n"
								 " * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND\n"
								 " * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
								 " * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
								 " * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE\n"
								 " * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
								 " * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS\n"
								 " * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
								 " * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
								 " * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
								 " * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
								 " * SUCH DAMAGE.\n"
								 " */";
#endif


#ifdef USE_BUILDENV
static const char *licenseMDNSResponder = "The majority of the source code in the mDNSResponder project is licensed\n"
										  "under the terms of the Apache License, Version 2.0, available from:\n"
										  "   <http://www.apache.org/licenses/LICENSE-2.0>\n"
										  "\n"
										  "To accommodate license compatibility with the widest possible range\n"
										  "of client code licenses, the shared library code, which is linked\n"
										  "at runtime into the same address space as the client using it, is\n"
										  "licensed under the terms of the \"Three-Clause BSD License\".\n"
										  "\n"
										  "The Linux Name Service Switch code, contributed by National ICT\n"
										  "Australia Ltd (NICTA) is licensed under the terms of the NICTA Public\n"
										  "Software Licence (which is substantially similar to the \"Three-Clause\n"
										  "BSD License\", with some additional language pertaining to Australian law).";
#endif


#ifdef USE_BUILDENV
static const char *licensePCRE = "PCRE LICENCE\n"
								 "------------\n"
								 "\n"
								 "PCRE is a library of functions to support regular expressions whose syntax\n"
								 "and semantics are as close as possible to those of the Perl 5 language.\n"
								 "\n"
								 "Release 8 of PCRE is distributed under the terms of the \"BSD\" licence, as\n"
								 "specified below. The documentation for PCRE, supplied in the \"doc\"\n"
								 "directory, is distributed under the same terms as the software itself. The data\n"
								 "in the testdata directory is not copyrighted and is in the public domain.\n"
								 "\n"
								 "The basic library functions are written in C and are freestanding. Also\n"
								 "included in the distribution is a set of C++ wrapper functions, and a\n"
								 "just-in-time compiler that can be used to optimize pattern matching. These\n"
								 "are both optional features that can be omitted when the library is built.\n"
								 "\n"
								 "\n"
								 "THE BASIC LIBRARY FUNCTIONS\n"
								 "---------------------------\n"
								 "\n"
								 "Written by:       Philip Hazel\n"
								 "Email local part: ph10\n"
								 "Email domain:     cam.ac.uk\n"
								 "\n"
								 "University of Cambridge Computing Service,\n"
								 "Cambridge, England.\n"
								 "\n"
								 "Copyright (c) 1997-2017 University of Cambridge\n"
								 "All rights reserved.\n"
								 "\n"
								 "\n"
								 "PCRE JUST-IN-TIME COMPILATION SUPPORT\n"
								 "-------------------------------------\n"
								 "\n"
								 "Written by:       Zoltan Herczeg\n"
								 "Email local part: hzmester\n"
								 "Emain domain:     freemail.hu\n"
								 "\n"
								 "Copyright(c) 2010-2017 Zoltan Herczeg\n"
								 "All rights reserved.\n"
								 "\n"
								 "\n"
								 "STACK-LESS JUST-IN-TIME COMPILER\n"
								 "--------------------------------\n"
								 "\n"
								 "Written by:       Zoltan Herczeg\n"
								 "Email local part: hzmester\n"
								 "Emain domain:     freemail.hu\n"
								 "\n"
								 "Copyright(c) 2009-2017 Zoltan Herczeg\n"
								 "All rights reserved.\n"
								 "\n"
								 "\n"
								 "THE C++ WRAPPER FUNCTIONS\n"
								 "-------------------------\n"
								 "\n"
								 "Contributed by:   Google Inc.\n"
								 "\n"
								 "Copyright (c) 2007-2012, Google Inc.\n"
								 "All rights reserved.\n"
								 "\n"
								 "\n"
								 "THE \"BSD\" LICENCE\n"
								 "-----------------\n"
								 "\n"
								 "Redistribution and use in source and binary forms, with or without\n"
								 "modification, are permitted provided that the following conditions are met:\n"
								 "\n"
								 "    * Redistributions of source code must retain the above copyright notice,\n"
								 "      this list of conditions and the following disclaimer.\n"
								 "\n"
								 "    * Redistributions in binary form must reproduce the above copyright\n"
								 "      notice, this list of conditions and the following disclaimer in the\n"
								 "      documentation and/or other materials provided with the distribution.\n"
								 "\n"
								 "    * Neither the name of the University of Cambridge nor the name of Google\n"
								 "      Inc. nor the names of their contributors may be used to endorse or\n"
								 "      promote products derived from this software without specific prior\n"
								 "      written permission.\n"
								 "\n"
								 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n"
								 "AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
								 "IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
								 "ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE\n"
								 "LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
								 "CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
								 "SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
								 "INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n"
								 "CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
								 "ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE\n"
								 "POSSIBILITY OF SUCH DAMAGE.\n"
								 "\n"
								 "End";
#endif


#ifdef USE_BUILDENV
static const char *licenseQt = "            GNU LESSER GENERAL PUBLIC LICENSE\n"
							   "\n"
							   " The Qt Toolkit is Copyright (C) 2015 The Qt Company Ltd.\n"
							   " Contact: http://www.qt.io/licensing/\n"
							   "\n"
							   " You may use, distribute and copy the Qt Toolkit under the terms of\n"
							   " GNU Lesser General Public License version 2.1, which is displayed below.\n"
							   "\n"
							   "-------------------------------------------------------------------------\n"
							   "\n"
							   "            GNU LESSER GENERAL PUBLIC LICENSE\n"
							   "                Version 2.1, February 1999\n"
							   "\n"
							   " Copyright (C) 1991, 1999 Free Software Foundation, Inc.\n"
							   " 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
							   " Everyone is permitted to copy and distribute verbatim copies\n"
							   " of this license document, but changing it is not allowed.\n"
							   "\n"
							   "[This is the first released version of the Lesser GPL.  It also counts\n"
							   " as the successor of the GNU Library Public License, version 2, hence\n"
							   " the version number 2.1.]\n"
							   "\n"
							   " Preamble\n"
							   "\n"
							   "  The licenses for most software are designed to take away your\n"
							   "freedom to share and change it.  By contrast, the GNU General Public\n"
							   "Licenses are intended to guarantee your freedom to share and change\n"
							   "free software--to make sure the software is free for all its users.\n"
							   "\n"
							   "  This license, the Lesser General Public License, applies to some\n"
							   "specially designated software packages--typically libraries--of the\n"
							   "Free Software Foundation and other authors who decide to use it.  You\n"
							   "can use it too, but we suggest you first think carefully about whether\n"
							   "this license or the ordinary General Public License is the better\n"
							   "strategy to use in any particular case, based on the explanations below.\n"
							   "\n"
							   "  When we speak of free software, we are referring to freedom of use,\n"
							   "not price.  Our General Public Licenses are designed to make sure that\n"
							   "you have the freedom to distribute copies of free software (and charge\n"
							   "for this service if you wish); that you receive source code or can get\n"
							   "it if you want it; that you can change the software and use pieces of\n"
							   "it in new free programs; and that you are informed that you can do\n"
							   "these things.\n"
							   "\n"
							   "  To protect your rights, we need to make restrictions that forbid\n"
							   "distributors to deny you these rights or to ask you to surrender these\n"
							   "rights.  These restrictions translate to certain responsibilities for\n"
							   "you if you distribute copies of the library or if you modify it.\n"
							   "\n"
							   "  For example, if you distribute copies of the library, whether gratis\n"
							   "or for a fee, you must give the recipients all the rights that we gave\n"
							   "you.  You must make sure that they, too, receive or can get the source\n"
							   "code.  If you link other code with the library, you must provide\n"
							   "complete object files to the recipients, so that they can relink them\n"
							   "with the library after making changes to the library and recompiling\n"
							   "it.  And you must show them these terms so they know their rights.\n"
							   "\n"
							   "  We protect your rights with a two-step method: (1) we copyright the\n"
							   "library, and (2) we offer you this license, which gives you legal\n"
							   "permission to copy, distribute and/or modify the library.\n"
							   "\n"
							   "  To protect each distributor, we want to make it very clear that\n"
							   "there is no warranty for the free library.  Also, if the library is\n"
							   "modified by someone else and passed on, the recipients should know\n"
							   "that what they have is not the original version, so that the original\n"
							   "author's reputation will not be affected by problems that might be\n"
							   "introduced by others.\n"
							   "\n"
							   "  Finally, software patents pose a constant threat to the existence of\n"
							   "any free program.  We wish to make sure that a company cannot\n"
							   "effectively restrict the users of a free program by obtaining a\n"
							   "restrictive license from a patent holder.  Therefore, we insist that\n"
							   "any patent license obtained for a version of the library must be\n"
							   "consistent with the full freedom of use specified in this license.\n"
							   "\n"
							   "  Most GNU software, including some libraries, is covered by the\n"
							   "ordinary GNU General Public License.  This license, the GNU Lesser\n"
							   "General Public License, applies to certain designated libraries, and\n"
							   "is quite different from the ordinary General Public License.  We use\n"
							   "this license for certain libraries in order to permit linking those\n"
							   "libraries into non-free programs.\n"
							   "\n"
							   "  When a program is linked with a library, whether statically or using\n"
							   "a shared library, the combination of the two is legally speaking a\n"
							   "combined work, a derivative of the original library.  The ordinary\n"
							   "General Public License therefore permits such linking only if the\n"
							   "entire combination fits its criteria of freedom.  The Lesser General\n"
							   "Public License permits more lax criteria for linking other code with\n"
							   "the library.\n"
							   "\n"
							   "  We call this license the \"Lesser\" General Public License because it\n"
							   "does Less to protect the user's freedom than the ordinary General\n"
							   "Public License.  It also provides other free software developers Less\n"
							   "of an advantage over competing non-free programs.  These disadvantages\n"
							   "are the reason we use the ordinary General Public License for many\n"
							   "libraries.  However, the Lesser license provides advantages in certain\n"
							   "special circumstances.\n"
							   "\n"
							   "  For example, on rare occasions, there may be a special need to\n"
							   "encourage the widest possible use of a certain library, so that it becomes\n"
							   "a de-facto standard.  To achieve this, non-free programs must be\n"
							   "allowed to use the library.  A more frequent case is that a free\n"
							   "library does the same job as widely used non-free libraries.  In this\n"
							   "case, there is little to gain by limiting the free library to free\n"
							   "software only, so we use the Lesser General Public License.\n"
							   "\n"
							   "  In other cases, permission to use a particular library in non-free\n"
							   "programs enables a greater number of people to use a large body of\n"
							   "free software.  For example, permission to use the GNU C Library in\n"
							   "non-free programs enables many more people to use the whole GNU\n"
							   "operating system, as well as its variant, the GNU/Linux operating\n"
							   "system.\n"
							   "\n"
							   "  Although the Lesser General Public License is Less protective of the\n"
							   "users' freedom, it does ensure that the user of a program that is\n"
							   "linked with the Library has the freedom and the wherewithal to run\n"
							   "that program using a modified version of the Library.\n"
							   "\n"
							   "  The precise terms and conditions for copying, distribution and\n"
							   "modification follow.  Pay close attention to the difference between a\n"
							   "\"work based on the library\" and a \"work that uses the library\".  The\n"
							   "former contains code derived from the library, whereas the latter must\n"
							   "be combined with the library in order to run.\n"
							   "\n"
							   "        GNU LESSER GENERAL PUBLIC LICENSE\n"
							   "    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
							   "\n"
							   "  0. This License Agreement applies to any software library or other\n"
							   "program which contains a notice placed by the copyright holder or\n"
							   "other authorized party saying it may be distributed under the terms of\n"
							   "this Lesser General Public License (also called \"this License\").\n"
							   "Each licensee is addressed as \"you\".\n"
							   "\n"
							   "  A \"library\" means a collection of software functions and/or data\n"
							   "prepared so as to be conveniently linked with application programs\n"
							   "(which use some of those functions and data) to form executables.\n"
							   "\n"
							   "  The \"Library\", below, refers to any such software library or work\n"
							   "which has been distributed under these terms.  A \"work based on the\n"
							   "Library\" means either the Library or any derivative work under\n"
							   "copyright law: that is to say, a work containing the Library or a\n"
							   "portion of it, either verbatim or with modifications and/or translated\n"
							   "straightforwardly into another language.  (Hereinafter, translation is\n"
							   "included without limitation in the term \"modification\".)\n"
							   "\n"
							   "  \"Source code\" for a work means the preferred form of the work for\n"
							   "making modifications to it.  For a library, complete source code means\n"
							   "all the source code for all modules it contains, plus any associated\n"
							   "interface definition files, plus the scripts used to control compilation\n"
							   "and installation of the library.\n"
							   "\n"
							   "  Activities other than copying, distribution and modification are not\n"
							   "covered by this License; they are outside its scope.  The act of\n"
							   "running a program using the Library is not restricted, and output from\n"
							   "such a program is covered only if its contents constitute a work based\n"
							   "on the Library (independent of the use of the Library in a tool for\n"
							   "writing it).  Whether that is true depends on what the Library does\n"
							   "and what the program that uses the Library does.\n"
							   "\n"
							   "  1. You may copy and distribute verbatim copies of the Library's\n"
							   "complete source code as you receive it, in any medium, provided that\n"
							   "you conspicuously and appropriately publish on each copy an\n"
							   "appropriate copyright notice and disclaimer of warranty; keep intact\n"
							   "all the notices that refer to this License and to the absence of any\n"
							   "warranty; and distribute a copy of this License along with the\n"
							   "Library.\n"
							   "\n"
							   "  You may charge a fee for the physical act of transferring a copy,\n"
							   "and you may at your option offer warranty protection in exchange for a\n"
							   "fee.\n"
							   "\n"
							   "  2. You may modify your copy or copies of the Library or any portion\n"
							   "of it, thus forming a work based on the Library, and copy and\n"
							   "distribute such modifications or work under the terms of Section 1\n"
							   "above, provided that you also meet all of these conditions:\n"
							   "\n"
							   "    a) The modified work must itself be a software library.\n"
							   "\n"
							   "    b) You must cause the files modified to carry prominent notices\n"
							   "    stating that you changed the files and the date of any change.\n"
							   "\n"
							   "    c) You must cause the whole of the work to be licensed at no\n"
							   "    charge to all third parties under the terms of this License.\n"
							   "\n"
							   "    d) If a facility in the modified Library refers to a function or a\n"
							   "    table of data to be supplied by an application program that uses\n"
							   "    the facility, other than as an argument passed when the facility\n"
							   "    is invoked, then you must make a good faith effort to ensure that,\n"
							   "    in the event an application does not supply such function or\n"
							   "    table, the facility still operates, and performs whatever part of\n"
							   "    its purpose remains meaningful.\n"
							   "\n"
							   "    (For example, a function in a library to compute square roots has\n"
							   "    a purpose that is entirely well-defined independent of the\n"
							   "    application.  Therefore, Subsection 2d requires that any\n"
							   "    application-supplied function or table used by this function must\n"
							   "    be optional: if the application does not supply it, the square\n"
							   "    root function must still compute square roots.)\n"
							   "\n"
							   "These requirements apply to the modified work as a whole.  If\n"
							   "identifiable sections of that work are not derived from the Library,\n"
							   "and can be reasonably considered independent and separate works in\n"
							   "themselves, then this License, and its terms, do not apply to those\n"
							   "sections when you distribute them as separate works.  But when you\n"
							   "distribute the same sections as part of a whole which is a work based\n"
							   "on the Library, the distribution of the whole must be on the terms of\n"
							   "this License, whose permissions for other licensees extend to the\n"
							   "entire whole, and thus to each and every part regardless of who wrote\n"
							   "it.\n"
							   "\n"
							   "Thus, it is not the intent of this section to claim rights or contest\n"
							   "your rights to work written entirely by you; rather, the intent is to\n"
							   "exercise the right to control the distribution of derivative or\n"
							   "collective works based on the Library.\n"
							   "\n"
							   "In addition, mere aggregation of another work not based on the Library\n"
							   "with the Library (or with a work based on the Library) on a volume of\n"
							   "a storage or distribution medium does not bring the other work under\n"
							   "the scope of this License.\n"
							   "\n"
							   "  3. You may opt to apply the terms of the ordinary GNU General Public\n"
							   "License instead of this License to a given copy of the Library.  To do\n"
							   "this, you must alter all the notices that refer to this License, so\n"
							   "that they refer to the ordinary GNU General Public License, version 2,\n"
							   "instead of to this License.  (If a newer version than version 2 of the\n"
							   "ordinary GNU General Public License has appeared, then you can specify\n"
							   "that version instead if you wish.)  Do not make any other change in\n"
							   "these notices.\n"
							   "\n"
							   "  Once this change is made in a given copy, it is irreversible for\n"
							   "that copy, so the ordinary GNU General Public License applies to all\n"
							   "subsequent copies and derivative works made from that copy.\n"
							   "\n"
							   "  This option is useful when you wish to copy part of the code of\n"
							   "the Library into a program that is not a library.\n"
							   "\n"
							   "  4. You may copy and distribute the Library (or a portion or\n"
							   "derivative of it, under Section 2) in object code or executable form\n"
							   "under the terms of Sections 1 and 2 above provided that you accompany\n"
							   "it with the complete corresponding machine-readable source code, which\n"
							   "must be distributed under the terms of Sections 1 and 2 above on a\n"
							   "medium customarily used for software interchange.\n"
							   "\n"
							   "  If distribution of object code is made by offering access to copy\n"
							   "from a designated place, then offering equivalent access to copy the\n"
							   "source code from the same place satisfies the requirement to\n"
							   "distribute the source code, even though third parties are not\n"
							   "compelled to copy the source along with the object code.\n"
							   "\n"
							   "  5. A program that contains no derivative of any portion of the\n"
							   "Library, but is designed to work with the Library by being compiled or\n"
							   "linked with it, is called a \"work that uses the Library\".  Such a\n"
							   "work, in isolation, is not a derivative work of the Library, and\n"
							   "therefore falls outside the scope of this License.\n"
							   "\n"
							   "  However, linking a \"work that uses the Library\" with the Library\n"
							   "creates an executable that is a derivative of the Library (because it\n"
							   "contains portions of the Library), rather than a \"work that uses the\n"
							   "library\".  The executable is therefore covered by this License.\n"
							   "Section 6 states terms for distribution of such executables.\n"
							   "\n"
							   "  When a \"work that uses the Library\" uses material from a header file\n"
							   "that is part of the Library, the object code for the work may be a\n"
							   "derivative work of the Library even though the source code is not.\n"
							   "Whether this is true is especially significant if the work can be\n"
							   "linked without the Library, or if the work is itself a library.  The\n"
							   "threshold for this to be true is not precisely defined by law.\n"
							   "\n"
							   "  If such an object file uses only numerical parameters, data\n"
							   "structure layouts and accessors, and small macros and small inline\n"
							   "functions (ten lines or less in length), then the use of the object\n"
							   "file is unrestricted, regardless of whether it is legally a derivative\n"
							   "work.  (Executables containing this object code plus portions of the\n"
							   "Library will still fall under Section 6.)\n"
							   "\n"
							   "  Otherwise, if the work is a derivative of the Library, you may\n"
							   "distribute the object code for the work under the terms of Section 6.\n"
							   "Any executables containing that work also fall under Section 6,\n"
							   "whether or not they are linked directly with the Library itself.\n"
							   "\n"
							   "  6. As an exception to the Sections above, you may also combine or\n"
							   "link a \"work that uses the Library\" with the Library to produce a\n"
							   "work containing portions of the Library, and distribute that work\n"
							   "under terms of your choice, provided that the terms permit\n"
							   "modification of the work for the customer's own use and reverse\n"
							   "engineering for debugging such modifications.\n"
							   "\n"
							   "  You must give prominent notice with each copy of the work that the\n"
							   "Library is used in it and that the Library and its use are covered by\n"
							   "this License.  You must supply a copy of this License.  If the work\n"
							   "during execution displays copyright notices, you must include the\n"
							   "copyright notice for the Library among them, as well as a reference\n"
							   "directing the user to the copy of this License.  Also, you must do one\n"
							   "of these things:\n"
							   "\n"
							   "    a) Accompany the work with the complete corresponding\n"
							   "    machine-readable source code for the Library including whatever\n"
							   "    changes were used in the work (which must be distributed under\n"
							   "    Sections 1 and 2 above); and, if the work is an executable linked\n"
							   "    with the Library, with the complete machine-readable \"work that\n"
							   "    uses the Library\", as object code and/or source code, so that the\n"
							   "    user can modify the Library and then relink to produce a modified\n"
							   "    executable containing the modified Library.  (It is understood\n"
							   "    that the user who changes the contents of definitions files in the\n"
							   "    Library will not necessarily be able to recompile the application\n"
							   "    to use the modified definitions.)\n"
							   "\n"
							   "    b) Use a suitable shared library mechanism for linking with the\n"
							   "    Library.  A suitable mechanism is one that (1) uses at run time a\n"
							   "    copy of the library already present on the user's computer system,\n"
							   "    rather than copying library functions into the executable, and (2)\n"
							   "    will operate properly with a modified version of the library, if\n"
							   "    the user installs one, as long as the modified version is\n"
							   "    interface-compatible with the version that the work was made with.\n"
							   "\n"
							   "    c) Accompany the work with a written offer, valid for at\n"
							   "    least three years, to give the same user the materials\n"
							   "    specified in Subsection 6a, above, for a charge no more\n"
							   "    than the cost of performing this distribution.\n"
							   "\n"
							   "    d) If distribution of the work is made by offering access to copy\n"
							   "    from a designated place, offer equivalent access to copy the above\n"
							   "    specified materials from the same place.\n"
							   "\n"
							   "    e) Verify that the user has already received a copy of these\n"
							   "    materials or that you have already sent this user a copy.\n"
							   "\n"
							   "  For an executable, the required form of the \"work that uses the\n"
							   "Library\" must include any data and utility programs needed for\n"
							   "reproducing the executable from it.  However, as a special exception,\n"
							   "the materials to be distributed need not include anything that is\n"
							   "normally distributed (in either source or binary form) with the major\n"
							   "components (compiler, kernel, and so on) of the operating system on\n"
							   "which the executable runs, unless that component itself accompanies\n"
							   "the executable.\n"
							   "\n"
							   "  It may happen that this requirement contradicts the license\n"
							   "restrictions of other proprietary libraries that do not normally\n"
							   "accompany the operating system.  Such a contradiction means you cannot\n"
							   "use both them and the Library together in an executable that you\n"
							   "distribute.\n"
							   "\n"
							   "  7. You may place library facilities that are a work based on the\n"
							   "Library side-by-side in a single library together with other library\n"
							   "facilities not covered by this License, and distribute such a combined\n"
							   "library, provided that the separate distribution of the work based on\n"
							   "the Library and of the other library facilities is otherwise\n"
							   "permitted, and provided that you do these two things:\n"
							   "\n"
							   "    a) Accompany the combined library with a copy of the same work\n"
							   "    based on the Library, uncombined with any other library\n"
							   "    facilities.  This must be distributed under the terms of the\n"
							   "    Sections above.\n"
							   "\n"
							   "    b) Give prominent notice with the combined library of the fact\n"
							   "    that part of it is a work based on the Library, and explaining\n"
							   "    where to find the accompanying uncombined form of the same work.\n"
							   "\n"
							   "  8. You may not copy, modify, sublicense, link with, or distribute\n"
							   "the Library except as expressly provided under this License.  Any\n"
							   "attempt otherwise to copy, modify, sublicense, link with, or\n"
							   "distribute the Library is void, and will automatically terminate your\n"
							   "rights under this License.  However, parties who have received copies,\n"
							   "or rights, from you under this License will not have their licenses\n"
							   "terminated so long as such parties remain in full compliance.\n"
							   "\n"
							   "  9. You are not required to accept this License, since you have not\n"
							   "signed it.  However, nothing else grants you permission to modify or\n"
							   "distribute the Library or its derivative works.  These actions are\n"
							   "prohibited by law if you do not accept this License.  Therefore, by\n"
							   "modifying or distributing the Library (or any work based on the\n"
							   "Library), you indicate your acceptance of this License to do so, and\n"
							   "all its terms and conditions for copying, distributing or modifying\n"
							   "the Library or works based on it.\n"
							   "\n"
							   "  10. Each time you redistribute the Library (or any work based on the\n"
							   "Library), the recipient automatically receives a license from the\n"
							   "original licensor to copy, distribute, link with or modify the Library\n"
							   "subject to these terms and conditions.  You may not impose any further\n"
							   "restrictions on the recipients' exercise of the rights granted herein.\n"
							   "You are not responsible for enforcing compliance by third parties with\n"
							   "this License.\n"
							   "\n"
							   "  11. If, as a consequence of a court judgment or allegation of patent\n"
							   "infringement or for any other reason (not limited to patent issues),\n"
							   "conditions are imposed on you (whether by court order, agreement or\n"
							   "otherwise) that contradict the conditions of this License, they do not\n"
							   "excuse you from the conditions of this License.  If you cannot\n"
							   "distribute so as to satisfy simultaneously your obligations under this\n"
							   "License and any other pertinent obligations, then as a consequence you\n"
							   "may not distribute the Library at all.  For example, if a patent\n"
							   "license would not permit royalty-free redistribution of the Library by\n"
							   "all those who receive copies directly or indirectly through you, then\n"
							   "the only way you could satisfy both it and this License would be to\n"
							   "refrain entirely from distribution of the Library.\n"
							   "\n"
							   "If any portion of this section is held invalid or unenforceable under any\n"
							   "particular circumstance, the balance of the section is intended to apply,\n"
							   "and the section as a whole is intended to apply in other circumstances.\n"
							   "\n"
							   "It is not the purpose of this section to induce you to infringe any\n"
							   "patents or other property right claims or to contest validity of any\n"
							   "such claims; this section has the sole purpose of protecting the\n"
							   "integrity of the free software distribution system which is\n"
							   "implemented by public license practices.  Many people have made\n"
							   "generous contributions to the wide range of software distributed\n"
							   "through that system in reliance on consistent application of that\n"
							   "system; it is up to the author/donor to decide if he or she is willing\n"
							   "to distribute software through any other system and a licensee cannot\n"
							   "impose that choice.\n"
							   "\n"
							   "This section is intended to make thoroughly clear what is believed to\n"
							   "be a consequence of the rest of this License.\n"
							   "\n"
							   "  12. If the distribution and/or use of the Library is restricted in\n"
							   "certain countries either by patents or by copyrighted interfaces, the\n"
							   "original copyright holder who places the Library under this License may add\n"
							   "an explicit geographical distribution limitation excluding those countries,\n"
							   "so that distribution is permitted only in or among countries not thus\n"
							   "excluded.  In such case, this License incorporates the limitation as if\n"
							   "written in the body of this License.\n"
							   "\n"
							   "  13. The Free Software Foundation may publish revised and/or new\n"
							   "versions of the Lesser General Public License from time to time.\n"
							   "Such new versions will be similar in spirit to the present version,\n"
							   "but may differ in detail to address new problems or concerns.\n"
							   "\n"
							   "Each version is given a distinguishing version number.  If the Library\n"
							   "specifies a version number of this License which applies to it and\n"
							   "\"any later version\", you have the option of following the terms and\n"
							   "conditions either of that version or of any later version published by\n"
							   "the Free Software Foundation.  If the Library does not specify a\n"
							   "license version number, you may choose any version ever published by\n"
							   "the Free Software Foundation.\n"
							   "\n"
							   "  14. If you wish to incorporate parts of the Library into other free\n"
							   "programs whose distribution conditions are incompatible with these,\n"
							   "write to the author to ask for permission.  For software which is\n"
							   "copyrighted by the Free Software Foundation, write to the Free\n"
							   "Software Foundation; we sometimes make exceptions for this.  Our\n"
							   "decision will be guided by the two goals of preserving the free status\n"
							   "of all derivatives of our free software and of promoting the sharing\n"
							   "and reuse of software generally.\n"
							   "\n"
							   "                NO WARRANTY\n"
							   "\n"
							   "  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO\n"
							   "WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.\n"
							   "EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR\n"
							   "OTHER PARTIES PROVIDE THE LIBRARY \"AS IS\" WITHOUT WARRANTY OF ANY\n"
							   "KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE\n"
							   "IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
							   "PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE\n"
							   "LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME\n"
							   "THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n"
							   "\n"
							   "  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN\n"
							   "WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY\n"
							   "AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU\n"
							   "FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR\n"
							   "CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE\n"
							   "LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING\n"
							   "RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A\n"
							   "FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF\n"
							   "SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH\n"
							   "DAMAGES.\n"
							   "\n"
							   "                END OF TERMS AND CONDITIONS\n"
							   "\n"
							   "           How to Apply These Terms to Your New Libraries\n"
							   "\n"
							   "  If you develop a new library, and you want it to be of the greatest\n"
							   "possible use to the public, we recommend making it free software that\n"
							   "everyone can redistribute and change.  You can do so by permitting\n"
							   "redistribution under these terms (or, alternatively, under the terms of the\n"
							   "ordinary General Public License).\n"
							   "\n"
							   "  To apply these terms, attach the following notices to the library.  It is\n"
							   "safest to attach them to the start of each source file to most effectively\n"
							   "convey the exclusion of warranty; and each file should have at least the\n"
							   "\"copyright\" line and a pointer to where the full notice is found.\n"
							   "\n"
							   "    <one line to give the library's name and a brief idea of what it does.>\n"
							   "    Copyright (C) <year>  <name of author>\n"
							   "\n"
							   "    This library is free software; you can redistribute it and/or\n"
							   "    modify it under the terms of the GNU Lesser General Public\n"
							   "    License as published by the Free Software Foundation; either\n"
							   "    version 2.1 of the License, or (at your option) any later version.\n"
							   "\n"
							   "    This library is distributed in the hope that it will be useful,\n"
							   "    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
							   "    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
							   "    Lesser General Public License for more details.\n"
							   "\n"
							   "    You should have received a copy of the GNU Lesser General Public\n"
							   "    License along with this library; if not, write to the Free Software\n"
							   "    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
							   "\n"
							   "Also add information on how to contact you by electronic and paper mail.\n"
							   "\n"
							   "You should also get your employer (if you work as a programmer) or your\n"
							   "school, if any, to sign a \"copyright disclaimer\" for the library, if\n"
							   "necessary.  Here is a sample; alter the names:\n"
							   "\n"
							   "  Yoyodyne, Inc., hereby disclaims all copyright interest in the\n"
							   "  library `Frob' (a library for tweaking knobs) written by James Random Hacker.\n"
							   "\n"
							   "  <signature of Ty Coon>, 1 April 1990\n"
							   "  Ty Coon, President of Vice\n"
							   "\n"
							   "That's all there is to it!";
#endif


#ifdef USE_BUILDENV
static const char *licenseSQLite3 = "The author disclaims copyright to this source code.  In place of\n"
									"a legal notice, here is a blessing:\n"
									"\n"
									"   May you do good and not evil.\n"
									"   May you find forgiveness for yourself and forgive others.\n"
									"   May you share freely, never taking more than you give.";
#endif


#ifdef USE_BUILDENV
static const char *licenseXar = "/*\n"
								" * Copyright (c) 2005-2007 Rob Braun\n"
								" * All rights reserved.\n"
								" *\n"
								" * Redistribution and use in source and binary forms, with or without\n"
								" * modification, are permitted provided that the following conditions\n"
								" * are met:\n"
								" * 1. Redistributions of source code must retain the above copyright\n"
								" *    notice, this list of conditions and the following disclaimer.\n"
								" * 2. Redistributions in binary form must reproduce the above copyright\n"
								" *    notice, this list of conditions and the following disclaimer in the\n"
								" *    documentation and/or other materials provided with the distribution.\n"
								" * 3. Neither the name of Rob Braun nor the names of his contributors\n"
								" *    may be used to endorse or promote products derived from this software\n"
								" *    without specific prior written permission.\n"
								" *\n"
								" * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n"
								" * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
								" * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
								" * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE\n"
								" * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
								" * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
								" * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
								" * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n"
								" * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
								" * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE\n"
								" * POSSIBILITY OF SUCH DAMAGE.\n"
								" */\n"
								"/*\n"
								" * 03-Apr-2005\n"
								" * DRI: Rob Braun <bbraun@synack.net>\n"
								" */";
#endif


#ifdef USE_BUILDENV
static const char *licenseAvahi = "Copyright 2004-2015 by the Avahi developers.\n"
								  "\n"
								  "avahi is free software; you can redistribute it and/or modify it\n"
								  "under the terms of the GNU Lesser General Public License as\n"
								  "published by the Free Software Foundation; either version 2.1 of the\n"
								  "License, or (at your option) any later version.\n"
								  "\n"
								  "avahi is distributed in the hope that it will be useful, but WITHOUT\n"
								  "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY\n"
								  "or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General\n"
								  "Public License for more details.\n"
								  "\n"
								  "You should have received a copy of the GNU Lesser General Public\n"
								  "License along with avahi; if not, write to the Free Software\n"
								  "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307\n"
								  "USA.";
#endif


#ifdef USE_BUILDENV
static const char *licenseDBus = "D-Bus is licensed to you under your choice of the Academic Free\n"
								 "License version 2.1, or the GNU General Public License version 2\n"
								 "(or, at your option any later version).\n"
								 "\n"
								 "Both licenses are included here. Some of the standalone binaries are\n"
								 "under the GPL only; in particular, but not limited to,\n"
								 "tools/dbus-cleanup-sockets.c and test/decode-gcov.c. Each source code\n"
								 "file is marked with the proper copyright information - if you find a\n"
								 "file that isn't marked please bring it to our attention.\n"
								 "\n"
								 "The Academic Free License\n"
								 "v. 2.1\n"
								 "\n"
								 "This Academic Free License (the \"License\") applies to any original work of "
								 "authorship (the \"Original Work\") whose owner (the \"Licensor\") has placed the "
								 "following notice immediately following the copyright notice for the Original Work:\n"
								 "\n"
								 "Licensed under the Academic Free License version 2.1\n"
								 "\n"
								 "1) Grant of Copyright License. Licensor hereby grants You a\n"
								 "world-wide, royalty-free, non-exclusive, perpetual, sublicenseable\n"
								 "license to do the following:\n"
								 "\n"
								 "a) to reproduce the Original Work in copies;\n"
								 "\n"
								 "b) to prepare derivative works (\"Derivative Works\") based upon the Original Work;\n"
								 "\n"
								 "c) to distribute copies of the Original Work and Derivative Works to the public;\n"
								 "\n"
								 "d) to perform the Original Work publicly; and\n"
								 "\n"
								 "e) to display the Original Work publicly.\n"
								 "\n"
								 "2) Grant of Patent License. Licensor hereby grants You a world-wide,\n"
								 "royalty-free, non-exclusive, perpetual, sublicenseable license, under\n"
								 "patent claims owned or controlled by the Licensor that are embodied in\n"
								 "the Original Work as furnished by the Licensor, to make, use, sell and\n"
								 "offer for sale the Original Work and Derivative Works.\n"
								 "\n"
								 "3) Grant of Source Code License. The term \"Source Code\" means the\n"
								 "preferred form of the Original Work for making modifications to it and\n"
								 "all available documentation describing how to modify the Original\n"
								 "Work. Licensor hereby agrees to provide a machine-readable copy of the\n"
								 "Source Code of the Original Work along with each copy of the Original\n"
								 "Work that Licensor distributes. Licensor reserves the right to satisfy\n"
								 "this obligation by placing a machine-readable copy of the Source Code\n"
								 "in an information repository reasonably calculated to permit\n"
								 "inexpensive and convenient access by You for as long as Licensor\n"
								 "continues to distribute the Original Work, and by publishing the\n"
								 "address of that information repository in a notice immediately\n"
								 "following the copyright notice that applies to the Original Work.\n"
								 "\n"
								 "4) Exclusions From License Grant. Neither the names of Licensor, nor\n"
								 "the names of any contributors to the Original Work, nor any of their\n"
								 "trademarks or service marks, may be used to endorse or promote\n"
								 "products derived from this Original Work without express prior written\n"
								 "permission of the Licensor. Nothing in this License shall be deemed to\n"
								 "grant any rights to trademarks, copyrights, patents, trade secrets or\n"
								 "any other intellectual property of Licensor except as expressly stated\n"
								 "herein. No patent license is granted to make, use, sell or offer to\n"
								 "sell embodiments of any patent claims other than the licensed claims\n"
								 "defined in Section 2. No right is granted to the trademarks of\n"
								 "Licensor even if such marks are included in the Original Work. Nothing\n"
								 "in this License shall be interpreted to prohibit Licensor from\n"
								 "licensing under different terms from this License any Original Work\n"
								 "that Licensor otherwise would have a right to license.\n"
								 "\n"
								 "5) This section intentionally omitted.\n"
								 "\n"
								 "6) Attribution Rights. You must retain, in the Source Code of any\n"
								 "Derivative Works that You create, all copyright, patent or trademark\n"
								 "notices from the Source Code of the Original Work, as well as any\n"
								 "notices of licensing and any descriptive text identified therein as an\n"
								 "\"Attribution Notice.\" You must cause the Source Code for any\n"
								 "Derivative Works that You create to carry a prominent Attribution\n"
								 "Notice reasonably calculated to inform recipients that You have\n"
								 "modified the Original Work.\n"
								 "\n"
								 "7) Warranty of Provenance and Disclaimer of Warranty. Licensor\n"
								 "warrants that the copyright in and to the Original Work and the patent\n"
								 "rights granted herein by Licensor are owned by the Licensor or are\n"
								 "sublicensed to You under the terms of this License with the permission\n"
								 "of the contributor(s) of those copyrights and patent rights. Except as\n"
								 "expressly stated in the immediately proceeding sentence, the Original\n"
								 "Work is provided under this License on an \"AS IS\" BASIS and WITHOUT\n"
								 "WARRANTY, either express or implied, including, without limitation,\n"
								 "the warranties of NON-INFRINGEMENT, MERCHANTABILITY or FITNESS FOR A\n"
								 "PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY OF THE ORIGINAL\n"
								 "WORK IS WITH YOU. This DISCLAIMER OF WARRANTY constitutes an essential\n"
								 "part of this License. No license to Original Work is granted hereunder\n"
								 "except under this disclaimer.\n"
								 "\n"
								 "8) Limitation of Liability. Under no circumstances and under no legal\n"
								 "theory, whether in tort (including negligence), contract, or\n"
								 "otherwise, shall the Licensor be liable to any person for any direct,\n"
								 "indirect, special, incidental, or consequential damages of any\n"
								 "character arising as a result of this License or the use of the\n"
								 "Original Work including, without limitation, damages for loss of\n"
								 "goodwill, work stoppage, computer failure or malfunction, or any and\n"
								 "all other commercial damages or losses. This limitation of liability\n"
								 "shall not apply to liability for death or personal injury resulting\n"
								 "from Licensor's negligence to the extent applicable law prohibits such\n"
								 "limitation. Some jurisdictions do not allow the exclusion or\n"
								 "limitation of incidental or consequential damages, so this exclusion\n"
								 "and limitation may not apply to You.\n"
								 "\n"
								 "9) Acceptance and Termination. If You distribute copies of the\n"
								 "Original Work or a Derivative Work, You must make a reasonable effort\n"
								 "under the circumstances to obtain the express assent of recipients to\n"
								 "the terms of this License. Nothing else but this License (or another\n"
								 "written agreement between Licensor and You) grants You permission to\n"
								 "create Derivative Works based upon the Original Work or to exercise\n"
								 "any of the rights granted in Section 1 herein, and any attempt to do\n"
								 "so except under the terms of this License (or another written\n"
								 "agreement between Licensor and You) is expressly prohibited by\n"
								 "U.S. copyright law, the equivalent laws of other countries, and by\n"
								 "international treaty. Therefore, by exercising any of the rights\n"
								 "granted to You in Section 1 herein, You indicate Your acceptance of\n"
								 "this License and all of its terms and conditions.\n"
								 "\n"
								 "10) Termination for Patent Action. This License shall terminate\n"
								 "automatically and You may no longer exercise any of the rights granted\n"
								 "to You by this License as of the date You commence an action,\n"
								 "including a cross-claim or counterclaim, against Licensor or any\n"
								 "licensee alleging that the Original Work infringes a patent. This\n"
								 "termination provision shall not apply for an action alleging patent\n"
								 "infringement by combinations of the Original Work with other software\n"
								 "or hardware.\n"
								 "\n"
								 "11) Jurisdiction, Venue and Governing Law. Any action or suit relating\n"
								 "to this License may be brought only in the courts of a jurisdiction\n"
								 "wherein the Licensor resides or in which Licensor conducts its primary\n"
								 "business, and under the laws of that jurisdiction excluding its\n"
								 "conflict-of-law provisions. The application of the United Nations\n"
								 "Convention on Contracts for the International Sale of Goods is\n"
								 "expressly excluded. Any use of the Original Work outside the scope of\n"
								 "this License or after its termination shall be subject to the\n"
								 "requirements and penalties of the U.S. Copyright Act, 17 U.S.C. Â§ 101\n"
								 "et seq., the equivalent laws of other countries, and international\n"
								 "treaty. This section shall survive the termination of this License.\n"
								 "\n"
								 "12) Attorneys Fees. In any action to enforce the terms of this License\n"
								 "or seeking damages relating thereto, the prevailing party shall be\n"
								 "entitled to recover its costs and expenses, including, without\n"
								 "limitation, reasonable attorneys' fees and costs incurred in\n"
								 "connection with such action, including any appeal of such action. This\n"
								 "section shall survive the termination of this License.\n"
								 "\n"
								 "13) Miscellaneous. This License represents the complete agreement\n"
								 "concerning the subject matter hereof. If any provision of this License\n"
								 "is held to be unenforceable, such provision shall be reformed only to\n"
								 "the extent necessary to make it enforceable.\n"
								 "\n"
								 "14) Definition of \"You\" in This License. \"You\" throughout this\n"
								 "License, whether in upper or lower case, means an individual or a\n"
								 "legal entity exercising rights under, and complying with all of the\n"
								 "terms of, this License. For legal entities, \"You\" includes any entity\n"
								 "that controls, is controlled by, or is under common control with\n"
								 "you. For purposes of this definition, \"control\" means (i) the power,\n"
								 "direct or indirect, to cause the direction or management of such\n"
								 "entity, whether by contract or otherwise, or (ii) ownership of fifty\n"
								 "percent (50%) or more of the outstanding shares, or (iii) beneficial\n"
								 "ownership of such entity.\n"
								 "\n"
								 "15) Right to Use. You may use the Original Work in all ways not\n"
								 "otherwise restricted or conditioned by this License or by law, and\n"
								 "Licensor promises not to interfere with or be responsible for such\n"
								 "uses by You.\n"
								 "\n"
								 "This license is Copyright (C) 2003-2004 Lawrence E. Rosen. All rights\n"
								 "reserved. Permission is hereby granted to copy and distribute this\n"
								 "license without modification. This license may not be modified without\n"
								 "the express written permission of its copyright owner.\n"
								 "\n"
								 "\n"
								 "-- \n"
								 "END OF ACADEMIC FREE LICENSE. The following is intended to describe the essential \n"
								 "differences between the Academic Free License (AFL) version 1.0 and other \n"
								 "open source licenses:\n"
								 "\n"
								 "The Academic Free License is similar to the BSD, MIT, UoI/NCSA and Apache \n"
								 "licenses in many respects but it is intended to solve a few problems with \n"
								 "those licenses.\n"
								 "    \n"
								 "* The AFL is written so as to make it clear what software is being \n"
								 "licensed (by the inclusion of a statement following the copyright notice \n"
								 "in the software). This way, the license functions better than a template \n"
								 "license. The BSD, MIT and UoI/NCSA licenses apply to unidentified software.\n"
								 "    \n"
								 "* The AFL contains a complete copyright grant to the software. The BSD \n"
								 "and Apache licenses are vague and incomplete in that respect.\n"
								 "    \n"
								 "* The AFL contains a complete patent grant to the software. The BSD, MIT, \n"
								 "UoI/NCSA and Apache licenses rely on an implied patent license and contain \n"
								 "no explicit patent grant.\n"
								 "    \n"
								 "* The AFL makes it clear that no trademark rights are granted to the \n"
								 "licensor's trademarks. The Apache license contains such a provision, but the \n"
								 "BSD, MIT and UoI/NCSA licenses do not.\n"
								 "    \n"
								 "* The AFL includes the warranty by the licensor that it either owns the \n"
								 "copyright or that it is distributing the software under a license. None of \n"
								 "the other licenses contain that warranty. All other warranties are disclaimed, \n"
								 "as is the case for the other licenses.\n"
								 "\n"
								 "* The AFL is itself copyrighted (with the right granted to copy and distribute \n"
								 "without modification). This ensures that the owner of the copyright to the \n"
								 "license will control changes. The Apache license contains a copyright notice, \n"
								 "but the BSD, MIT and UoI/NCSA licenses do not. \n"
								 "--\n"
								 "START OF GNU GENERAL PUBLIC LICENSE\n"
								 "--\n"
								 "\n"
								 "		    GNU GENERAL PUBLIC LICENSE\n"
								 "		       Version 2, June 1991\n"
								 "\n"
								 " Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"
								 " 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
								 "\n"
								 " Everyone is permitted to copy and distribute verbatim copies\n"
								 " of this license document, but changing it is not allowed.\n"
								 "\n"
								 "			    Preamble\n"
								 "\n"
								 "  The licenses for most software are designed to take away your\n"
								 "freedom to share and change it.  By contrast, the GNU General Public\n"
								 "License is intended to guarantee your freedom to share and change free\n"
								 "software--to make sure the software is free for all its users.  This\n"
								 "General Public License applies to most of the Free Software\n"
								 "Foundation's software and to any other program whose authors commit to\n"
								 "using it.  (Some other Free Software Foundation software is covered by\n"
								 "the GNU Library General Public License instead.)  You can apply it to\n"
								 "your programs, too.\n"
								 "\n"
								 "  When we speak of free software, we are referring to freedom, not\n"
								 "price.  Our General Public Licenses are designed to make sure that you\n"
								 "have the freedom to distribute copies of free software (and charge for\n"
								 "this service if you wish), that you receive source code or can get it\n"
								 "if you want it, that you can change the software or use pieces of it\n"
								 "in new free programs; and that you know you can do these things.\n"
								 "\n"
								 "  To protect your rights, we need to make restrictions that forbid\n"
								 "anyone to deny you these rights or to ask you to surrender the rights.\n"
								 "These restrictions translate to certain responsibilities for you if you\n"
								 "distribute copies of the software, or if you modify it.\n"
								 "\n"
								 "  For example, if you distribute copies of such a program, whether\n"
								 "gratis or for a fee, you must give the recipients all the rights that\n"
								 "you have.  You must make sure that they, too, receive or can get the\n"
								 "source code.  And you must show them these terms so they know their\n"
								 "rights.\n"
								 "\n"
								 "  We protect your rights with two steps: (1) copyright the software, and\n"
								 "(2) offer you this license which gives you legal permission to copy,\n"
								 "distribute and/or modify the software.\n"
								 "\n"
								 "  Also, for each author's protection and ours, we want to make certain\n"
								 "that everyone understands that there is no warranty for this free\n"
								 "software.  If the software is modified by someone else and passed on, we\n"
								 "want its recipients to know that what they have is not the original, so\n"
								 "that any problems introduced by others will not reflect on the original\n"
								 "authors' reputations.\n"
								 "\n"
								 "  Finally, any free program is threatened constantly by software\n"
								 "patents.  We wish to avoid the danger that redistributors of a free\n"
								 "program will individually obtain patent licenses, in effect making the\n"
								 "program proprietary.  To prevent this, we have made it clear that any\n"
								 "patent must be licensed for everyone's free use or not licensed at all.\n"
								 "\n"
								 "  The precise terms and conditions for copying, distribution and\n"
								 "modification follow.\n"
								 "\n"
								 "		    GNU GENERAL PUBLIC LICENSE\n"
								 "   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
								 "\n"
								 "  0. This License applies to any program or other work which contains\n"
								 "a notice placed by the copyright holder saying it may be distributed\n"
								 "under the terms of this General Public License.  The \"Program\", below,\n"
								 "refers to any such program or work, and a \"work based on the Program\"\n"
								 "means either the Program or any derivative work under copyright law:\n"
								 "that is to say, a work containing the Program or a portion of it,\n"
								 "either verbatim or with modifications and/or translated into another\n"
								 "language.  (Hereinafter, translation is included without limitation in\n"
								 "the term \"modification\".)  Each licensee is addressed as \"you\".\n"
								 "\n"
								 "Activities other than copying, distribution and modification are not\n"
								 "covered by this License; they are outside its scope.  The act of\n"
								 "running the Program is not restricted, and the output from the Program\n"
								 "is covered only if its contents constitute a work based on the\n"
								 "Program (independent of having been made by running the Program).\n"
								 "Whether that is true depends on what the Program does.\n"
								 "\n"
								 "  1. You may copy and distribute verbatim copies of the Program's\n"
								 "source code as you receive it, in any medium, provided that you\n"
								 "conspicuously and appropriately publish on each copy an appropriate\n"
								 "copyright notice and disclaimer of warranty; keep intact all the\n"
								 "notices that refer to this License and to the absence of any warranty;\n"
								 "and give any other recipients of the Program a copy of this License\n"
								 "along with the Program.\n"
								 "\n"
								 "You may charge a fee for the physical act of transferring a copy, and\n"
								 "you may at your option offer warranty protection in exchange for a fee.\n"
								 "\n"
								 "  2. You may modify your copy or copies of the Program or any portion\n"
								 "of it, thus forming a work based on the Program, and copy and\n"
								 "distribute such modifications or work under the terms of Section 1\n"
								 "above, provided that you also meet all of these conditions:\n"
								 "\n"
								 "    a) You must cause the modified files to carry prominent notices\n"
								 "    stating that you changed the files and the date of any change.\n"
								 "\n"
								 "    b) You must cause any work that you distribute or publish, that in\n"
								 "    whole or in part contains or is derived from the Program or any\n"
								 "    part thereof, to be licensed as a whole at no charge to all third\n"
								 "    parties under the terms of this License.\n"
								 "\n"
								 "    c) If the modified program normally reads commands interactively\n"
								 "    when run, you must cause it, when started running for such\n"
								 "    interactive use in the most ordinary way, to print or display an\n"
								 "    announcement including an appropriate copyright notice and a\n"
								 "    notice that there is no warranty (or else, saying that you provide\n"
								 "    a warranty) and that users may redistribute the program under\n"
								 "    these conditions, and telling the user how to view a copy of this\n"
								 "    License.  (Exception: if the Program itself is interactive but\n"
								 "    does not normally print such an announcement, your work based on\n"
								 "    the Program is not required to print an announcement.)\n"
								 "\n"
								 "These requirements apply to the modified work as a whole.  If\n"
								 "identifiable sections of that work are not derived from the Program,\n"
								 "and can be reasonably considered independent and separate works in\n"
								 "themselves, then this License, and its terms, do not apply to those\n"
								 "sections when you distribute them as separate works.  But when you\n"
								 "distribute the same sections as part of a whole which is a work based\n"
								 "on the Program, the distribution of the whole must be on the terms of\n"
								 "this License, whose permissions for other licensees extend to the\n"
								 "entire whole, and thus to each and every part regardless of who wrote it.\n"
								 "\n"
								 "Thus, it is not the intent of this section to claim rights or contest\n"
								 "your rights to work written entirely by you; rather, the intent is to\n"
								 "exercise the right to control the distribution of derivative or\n"
								 "collective works based on the Program.\n"
								 "\n"
								 "In addition, mere aggregation of another work not based on the Program\n"
								 "with the Program (or with a work based on the Program) on a volume of\n"
								 "a storage or distribution medium does not bring the other work under\n"
								 "the scope of this License.\n"
								 "\n"
								 "  3. You may copy and distribute the Program (or a work based on it,\n"
								 "under Section 2) in object code or executable form under the terms of\n"
								 "Sections 1 and 2 above provided that you also do one of the following:\n"
								 "\n"
								 "    a) Accompany it with the complete corresponding machine-readable\n"
								 "    source code, which must be distributed under the terms of Sections\n"
								 "    1 and 2 above on a medium customarily used for software interchange; or,\n"
								 "\n"
								 "    b) Accompany it with a written offer, valid for at least three\n"
								 "    years, to give any third party, for a charge no more than your\n"
								 "    cost of physically performing source distribution, a complete\n"
								 "    machine-readable copy of the corresponding source code, to be\n"
								 "    distributed under the terms of Sections 1 and 2 above on a medium\n"
								 "    customarily used for software interchange; or,\n"
								 "\n"
								 "    c) Accompany it with the information you received as to the offer\n"
								 "    to distribute corresponding source code.  (This alternative is\n"
								 "    allowed only for noncommercial distribution and only if you\n"
								 "    received the program in object code or executable form with such\n"
								 "    an offer, in accord with Subsection b above.)\n"
								 "\n"
								 "The source code for a work means the preferred form of the work for\n"
								 "making modifications to it.  For an executable work, complete source\n"
								 "code means all the source code for all modules it contains, plus any\n"
								 "associated interface definition files, plus the scripts used to\n"
								 "control compilation and installation of the executable.  However, as a\n"
								 "special exception, the source code distributed need not include\n"
								 "anything that is normally distributed (in either source or binary\n"
								 "form) with the major components (compiler, kernel, and so on) of the\n"
								 "operating system on which the executable runs, unless that component\n"
								 "itself accompanies the executable.\n"
								 "\n"
								 "If distribution of executable or object code is made by offering\n"
								 "access to copy from a designated place, then offering equivalent\n"
								 "access to copy the source code from the same place counts as\n"
								 "distribution of the source code, even though third parties are not\n"
								 "compelled to copy the source along with the object code.\n"
								 "\n"
								 "  4. You may not copy, modify, sublicense, or distribute the Program\n"
								 "except as expressly provided under this License.  Any attempt\n"
								 "otherwise to copy, modify, sublicense or distribute the Program is\n"
								 "void, and will automatically terminate your rights under this License.\n"
								 "However, parties who have received copies, or rights, from you under\n"
								 "this License will not have their licenses terminated so long as such\n"
								 "parties remain in full compliance.\n"
								 "\n"
								 "  5. You are not required to accept this License, since you have not\n"
								 "signed it.  However, nothing else grants you permission to modify or\n"
								 "distribute the Program or its derivative works.  These actions are\n"
								 "prohibited by law if you do not accept this License.  Therefore, by\n"
								 "modifying or distributing the Program (or any work based on the\n"
								 "Program), you indicate your acceptance of this License to do so, and\n"
								 "all its terms and conditions for copying, distributing or modifying\n"
								 "the Program or works based on it.\n"
								 "\n"
								 "  6. Each time you redistribute the Program (or any work based on the\n"
								 "Program), the recipient automatically receives a license from the\n"
								 "original licensor to copy, distribute or modify the Program subject to\n"
								 "these terms and conditions.  You may not impose any further\n"
								 "restrictions on the recipients' exercise of the rights granted herein.\n"
								 "You are not responsible for enforcing compliance by third parties to\n"
								 "this License.\n"
								 "\n"
								 "  7. If, as a consequence of a court judgment or allegation of patent\n"
								 "infringement or for any other reason (not limited to patent issues),\n"
								 "conditions are imposed on you (whether by court order, agreement or\n"
								 "otherwise) that contradict the conditions of this License, they do not\n"
								 "excuse you from the conditions of this License.  If you cannot\n"
								 "distribute so as to satisfy simultaneously your obligations under this\n"
								 "License and any other pertinent obligations, then as a consequence you\n"
								 "may not distribute the Program at all.  For example, if a patent\n"
								 "license would not permit royalty-free redistribution of the Program by\n"
								 "all those who receive copies directly or indirectly through you, then\n"
								 "the only way you could satisfy both it and this License would be to\n"
								 "refrain entirely from distribution of the Program.\n"
								 "\n"
								 "If any portion of this section is held invalid or unenforceable under\n"
								 "any particular circumstance, the balance of the section is intended to\n"
								 "apply and the section as a whole is intended to apply in other\n"
								 "circumstances.\n"
								 "\n"
								 "It is not the purpose of this section to induce you to infringe any\n"
								 "patents or other property right claims or to contest validity of any\n"
								 "such claims; this section has the sole purpose of protecting the\n"
								 "integrity of the free software distribution system, which is\n"
								 "implemented by public license practices.  Many people have made\n"
								 "generous contributions to the wide range of software distributed\n"
								 "through that system in reliance on consistent application of that\n"
								 "system; it is up to the author/donor to decide if he or she is willing\n"
								 "to distribute software through any other system and a licensee cannot\n"
								 "impose that choice.\n"
								 "\n"
								 "This section is intended to make thoroughly clear what is believed to\n"
								 "be a consequence of the rest of this License.\n"
								 "\n"
								 "  8. If the distribution and/or use of the Program is restricted in\n"
								 "certain countries either by patents or by copyrighted interfaces, the\n"
								 "original copyright holder who places the Program under this License\n"
								 "may add an explicit geographical distribution limitation excluding\n"
								 "those countries, so that distribution is permitted only in or among\n"
								 "countries not thus excluded.  In such case, this License incorporates\n"
								 "the limitation as if written in the body of this License.\n"
								 "\n"
								 "  9. The Free Software Foundation may publish revised and/or new versions\n"
								 "of the General Public License from time to time.  Such new versions will\n"
								 "be similar in spirit to the present version, but may differ in detail to\n"
								 "address new problems or concerns.\n"
								 "\n"
								 "Each version is given a distinguishing version number.  If the Program\n"
								 "specifies a version number of this License which applies to it and \"any\n"
								 "later version\", you have the option of following the terms and conditions\n"
								 "either of that version or of any later version published by the Free\n"
								 "Software Foundation.  If the Program does not specify a version number of\n"
								 "this License, you may choose any version ever published by the Free Software\n"
								 "Foundation.\n"
								 "\n"
								 "  10. If you wish to incorporate parts of the Program into other free\n"
								 "programs whose distribution conditions are different, write to the author\n"
								 "to ask for permission.  For software which is copyrighted by the Free\n"
								 "Software Foundation, write to the Free Software Foundation; we sometimes\n"
								 "make exceptions for this.  Our decision will be guided by the two goals\n"
								 "of preserving the free status of all derivatives of our free software and\n"
								 "of promoting the sharing and reuse of software generally.\n"
								 "\n"
								 "			    NO WARRANTY\n"
								 "\n"
								 "  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
								 "FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"
								 "OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
								 "PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
								 "OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
								 "MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"
								 "TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"
								 "PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
								 "REPAIR OR CORRECTION.\n"
								 "\n"
								 "  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
								 "WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
								 "REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
								 "INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
								 "OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
								 "TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
								 "YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
								 "PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
								 "POSSIBILITY OF SUCH DAMAGES.\n"
								 "\n"
								 "		     END OF TERMS AND CONDITIONS\n"
								 "\n"
								 "	    How to Apply These Terms to Your New Programs\n"
								 "\n"
								 "  If you develop a new program, and you want it to be of the greatest\n"
								 "possible use to the public, the best way to achieve this is to make it\n"
								 "free software which everyone can redistribute and change under these terms.\n"
								 "\n"
								 "  To do so, attach the following notices to the program.  It is safest\n"
								 "to attach them to the start of each source file to most effectively\n"
								 "convey the exclusion of warranty; and each file should have at least\n"
								 "the \"copyright\" line and a pointer to where the full notice is found.\n"
								 "\n"
								 "    <one line to give the program's name and a brief idea of what it does.>\n"
								 "    Copyright (C) <year>  <name of author>\n"
								 "\n"
								 "    This program is free software; you can redistribute it and/or modify\n"
								 "    it under the terms of the GNU General Public License as published by\n"
								 "    the Free Software Foundation; either version 2 of the License, or\n"
								 "    (at your option) any later version.\n"
								 "\n"
								 "    This program is distributed in the hope that it will be useful,\n"
								 "    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
								 "    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
								 "    GNU General Public License for more details.\n"
								 "\n"
								 "    You should have received a copy of the GNU General Public License\n"
								 "    along with this program; if not, write to the Free Software\n"
								 "    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
								 "\n"
								 "\n"
								 "Also add information on how to contact you by electronic and paper mail.\n"
								 "\n"
								 "If the program is interactive, make it output a short notice like this\n"
								 "when it starts in an interactive mode:\n"
								 "\n"
								 "    Gnomovision version 69, Copyright (C) year name of author\n"
								 "    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n"
								 "    This is free software, and you are welcome to redistribute it\n"
								 "    under certain conditions; type `show c' for details.\n"
								 "\n"
								 "The hypothetical commands `show w' and `show c' should show the appropriate\n"
								 "parts of the General Public License.  Of course, the commands you use may\n"
								 "be called something other than `show w' and `show c'; they could even be\n"
								 "mouse-clicks or menu items--whatever suits your program.\n"
								 "\n"
								 "You should also get your employer (if you work as a programmer) or your\n"
								 "school, if any, to sign a \"copyright disclaimer\" for the program, if\n"
								 "necessary.  Here is a sample; alter the names:\n"
								 "\n"
								 "  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n"
								 "  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n"
								 "\n"
								 "  <signature of Ty Coon>, 1 April 1989\n"
								 "  Ty Coon, President of Vice\n"
								 "\n"
								 "This General Public License does not permit incorporating your program into\n"
								 "proprietary programs.  If your program is a subroutine library, you may\n"
								 "consider it more useful to permit linking proprietary applications with the\n"
								 "library.  If this is what you want to do, use the GNU Library General\n"
								 "Public License instead of this License.";
#endif


#ifdef USE_BUILDENV
static const char *licenseAppImageRuntime =
	"Copyright (c) 2004-17 Simon Peter\n"
	"Portions Copyright (c) 2007 Alexander Larsson\n"
	"\n"
	"All Rights Reserved.\n"
	"\n"
	"Permission is hereby granted, free of charge, to any person obtaining a copy\n"
	"of this software and associated documentation files (the \"Software\"), to deal\n"
	"in the Software without restriction, including without limitation the rights\n"
	"to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
	"copies of the Software, and to permit persons to whom the Software is\n"
	"furnished to do so, subject to the following conditions:\n"
	"\n"
	"The above copyright notice and this permission notice shall be included in\n"
	"all copies or substantial portions of the Software.\n"
	"\n"
	"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
	"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
	"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
	"AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
	"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
	"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n"
	"THE SOFTWARE.";
#endif


#ifdef USE_BUILDENV
static const char *licenseSquashfuse = "The squashfuse distribution as a whole is copyright Dave\n"
									   "Vasilevsky and is subject to the copyright notice reproduced at\n"
									   "the bottom of this file.\n"
									   "\n"
									   "The file squashfs_fs.h is copyright Phillip Lougher and, with his permission,\n"
									   "subject to the same license.\n"
									   "\n"
									   "\n"
									   "Copyright (c) 2012 Dave Vasilevsky <dave@vasilevsky.ca>\n"
									   "                   Phillip Lougher <phillip@squashfs.org.uk>\n"
									   "All rights reserved.\n"
									   "\n"
									   "Redistribution and use in source and binary forms, with or without\n"
									   "modification, are permitted provided that the following conditions\n"
									   "are met:\n"
									   "1. Redistributions of source code must retain the above copyright\n"
									   "   notice, this list of conditions and the following disclaimer.\n"
									   "2. Redistributions in binary form must reproduce the above copyright\n"
									   "   notice, this list of conditions and the following disclaimer in the\n"
									   "   documentation and/or other materials provided with the distribution.\n"
									   "\n"
									   "THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS OR\n"
									   "IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\n"
									   "OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\n"
									   "IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,\n"
									   "INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\n"
									   "NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
									   "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
									   "THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
									   "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n"
									   "THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibfuse =
	"FUSE: Filesystem in Userspace\n"
	"Copyright (C) 2001-2007  Miklos Szeredi <miklos@szeredi.hu>\n"
	"\n"
	"This program can be distributed under the terms of the GNU LGPLv2.\n"
	"\n"
	"                  GNU LESSER GENERAL PUBLIC LICENSE\n"
	"                       Version 2.1, February 1999\n"
	"\n"
	" Copyright (C) 1991, 1999 Free Software Foundation, Inc.\n"
	" 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
	" Everyone is permitted to copy and distribute verbatim copies\n"
	" of this license document, but changing it is not allowed.\n"
	"\n"
	"[This is the first released version of the Lesser GPL.  It also counts\n"
	" as the successor of the GNU Library Public License, version 2, hence\n"
	" the version number 2.1.]\n"
	"\n"
	"                            Preamble\n"
	"\n"
	"  The licenses for most software are designed to take away your\n"
	"freedom to share and change it.  By contrast, the GNU General Public\n"
	"Licenses are intended to guarantee your freedom to share and change\n"
	"free software--to make sure the software is free for all its users.\n"
	"\n"
	"  This license, the Lesser General Public License, applies to some\n"
	"specially designated software packages--typically libraries--of the\n"
	"Free Software Foundation and other authors who decide to use it.  You\n"
	"can use it too, but we suggest you first think carefully about whether\n"
	"this license or the ordinary General Public License is the better\n"
	"strategy to use in any particular case, based on the explanations below.\n"
	"\n"
	"  When we speak of free software, we are referring to freedom of use,\n"
	"not price.  Our General Public Licenses are designed to make sure that\n"
	"you have the freedom to distribute copies of free software (and charge\n"
	"for this service if you wish); that you receive source code or can get\n"
	"it if you want it; that you can change the software and use pieces of\n"
	"it in new free programs; and that you are informed that you can do\n"
	"these things.\n"
	"\n"
	"  To protect your rights, we need to make restrictions that forbid\n"
	"distributors to deny you these rights or to ask you to surrender these\n"
	"rights.  These restrictions translate to certain responsibilities for\n"
	"you if you distribute copies of the library or if you modify it.\n"
	"\n"
	"  For example, if you distribute copies of the library, whether gratis\n"
	"or for a fee, you must give the recipients all the rights that we gave\n"
	"you.  You must make sure that they, too, receive or can get the source\n"
	"code.  If you link other code with the library, you must provide\n"
	"complete object files to the recipients, so that they can relink them\n"
	"with the library after making changes to the library and recompiling\n"
	"it.  And you must show them these terms so they know their rights.\n"
	"\n"
	"  We protect your rights with a two-step method: (1) we copyright the\n"
	"library, and (2) we offer you this license, which gives you legal\n"
	"permission to copy, distribute and/or modify the library.\n"
	"\n"
	"  To protect each distributor, we want to make it very clear that\n"
	"there is no warranty for the free library.  Also, if the library is\n"
	"modified by someone else and passed on, the recipients should know\n"
	"that what they have is not the original version, so that the original\n"
	"author's reputation will not be affected by problems that might be\n"
	"introduced by others.\n"
	"\n"
	"  Finally, software patents pose a constant threat to the existence of\n"
	"any free program.  We wish to make sure that a company cannot\n"
	"effectively restrict the users of a free program by obtaining a\n"
	"restrictive license from a patent holder.  Therefore, we insist that\n"
	"any patent license obtained for a version of the library must be\n"
	"consistent with the full freedom of use specified in this license.\n"
	"\n"
	"  Most GNU software, including some libraries, is covered by the\n"
	"ordinary GNU General Public License.  This license, the GNU Lesser\n"
	"General Public License, applies to certain designated libraries, and\n"
	"is quite different from the ordinary General Public License.  We use\n"
	"this license for certain libraries in order to permit linking those\n"
	"libraries into non-free programs.\n"
	"\n"
	"  When a program is linked with a library, whether statically or using\n"
	"a shared library, the combination of the two is legally speaking a\n"
	"combined work, a derivative of the original library.  The ordinary\n"
	"General Public License therefore permits such linking only if the\n"
	"entire combination fits its criteria of freedom.  The Lesser General\n"
	"Public License permits more lax criteria for linking other code with\n"
	"the library.\n"
	"\n"
	"  We call this license the \"Lesser\" General Public License because it\n"
	"does Less to protect the user's freedom than the ordinary General\n"
	"Public License.  It also provides other free software developers Less\n"
	"of an advantage over competing non-free programs.  These disadvantages\n"
	"are the reason we use the ordinary General Public License for many\n"
	"libraries.  However, the Lesser license provides advantages in certain\n"
	"special circumstances.\n"
	"\n"
	"  For example, on rare occasions, there may be a special need to\n"
	"encourage the widest possible use of a certain library, so that it becomes\n"
	"a de-facto standard.  To achieve this, non-free programs must be\n"
	"allowed to use the library.  A more frequent case is that a free\n"
	"library does the same job as widely used non-free libraries.  In this\n"
	"case, there is little to gain by limiting the free library to free\n"
	"software only, so we use the Lesser General Public License.\n"
	"\n"
	"  In other cases, permission to use a particular library in non-free\n"
	"programs enables a greater number of people to use a large body of\n"
	"free software.  For example, permission to use the GNU C Library in\n"
	"non-free programs enables many more people to use the whole GNU\n"
	"operating system, as well as its variant, the GNU/Linux operating\n"
	"system.\n"
	"\n"
	"  Although the Lesser General Public License is Less protective of the\n"
	"users' freedom, it does ensure that the user of a program that is\n"
	"linked with the Library has the freedom and the wherewithal to run\n"
	"that program using a modified version of the Library.\n"
	"\n"
	"  The precise terms and conditions for copying, distribution and\n"
	"modification follow.  Pay close attention to the difference between a\n"
	"\"work based on the library\" and a \"work that uses the library\".  The\n"
	"former contains code derived from the library, whereas the latter must\n"
	"be combined with the library in order to run.\n"
	"\n"
	"                  GNU LESSER GENERAL PUBLIC LICENSE\n"
	"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
	"\n"
	"  0. This License Agreement applies to any software library or other\n"
	"program which contains a notice placed by the copyright holder or\n"
	"other authorized party saying it may be distributed under the terms of\n"
	"this Lesser General Public License (also called \"this License\").\n"
	"Each licensee is addressed as \"you\".\n"
	"\n"
	"  A \"library\" means a collection of software functions and/or data\n"
	"prepared so as to be conveniently linked with application programs\n"
	"(which use some of those functions and data) to form executables.\n"
	"\n"
	"  The \"Library\", below, refers to any such software library or work\n"
	"which has been distributed under these terms.  A \"work based on the\n"
	"Library\" means either the Library or any derivative work under\n"
	"copyright law: that is to say, a work containing the Library or a\n"
	"portion of it, either verbatim or with modifications and/or translated\n"
	"straightforwardly into another language.  (Hereinafter, translation is\n"
	"included without limitation in the term \"modification\".)\n"
	"\n"
	"  \"Source code\" for a work means the preferred form of the work for\n"
	"making modifications to it.  For a library, complete source code means\n"
	"all the source code for all modules it contains, plus any associated\n"
	"interface definition files, plus the scripts used to control compilation\n"
	"and installation of the library.\n"
	"\n"
	"  Activities other than copying, distribution and modification are not\n"
	"covered by this License; they are outside its scope.  The act of\n"
	"running a program using the Library is not restricted, and output from\n"
	"such a program is covered only if its contents constitute a work based\n"
	"on the Library (independent of the use of the Library in a tool for\n"
	"writing it).  Whether that is true depends on what the Library does\n"
	"and what the program that uses the Library does.\n"
	"\n"
	"  1. You may copy and distribute verbatim copies of the Library's\n"
	"complete source code as you receive it, in any medium, provided that\n"
	"you conspicuously and appropriately publish on each copy an\n"
	"appropriate copyright notice and disclaimer of warranty; keep intact\n"
	"all the notices that refer to this License and to the absence of any\n"
	"warranty; and distribute a copy of this License along with the\n"
	"Library.\n"
	"\n"
	"  You may charge a fee for the physical act of transferring a copy,\n"
	"and you may at your option offer warranty protection in exchange for a\n"
	"fee.\n"
	"\n"
	"  2. You may modify your copy or copies of the Library or any portion\n"
	"of it, thus forming a work based on the Library, and copy and\n"
	"distribute such modifications or work under the terms of Section 1\n"
	"above, provided that you also meet all of these conditions:\n"
	"\n"
	"    a) The modified work must itself be a software library.\n"
	"\n"
	"    b) You must cause the files modified to carry prominent notices\n"
	"    stating that you changed the files and the date of any change.\n"
	"\n"
	"    c) You must cause the whole of the work to be licensed at no\n"
	"    charge to all third parties under the terms of this License.\n"
	"\n"
	"    d) If a facility in the modified Library refers to a function or a\n"
	"    table of data to be supplied by an application program that uses\n"
	"    the facility, other than as an argument passed when the facility\n"
	"    is invoked, then you must make a good faith effort to ensure that,\n"
	"    in the event an application does not supply such function or\n"
	"    table, the facility still operates, and performs whatever part of\n"
	"    its purpose remains meaningful.\n"
	"\n"
	"    (For example, a function in a library to compute square roots has\n"
	"    a purpose that is entirely well-defined independent of the\n"
	"    application.  Therefore, Subsection 2d requires that any\n"
	"    application-supplied function or table used by this function must\n"
	"    be optional: if the application does not supply it, the square\n"
	"    root function must still compute square roots.)\n"
	"\n"
	"These requirements apply to the modified work as a whole.  If\n"
	"identifiable sections of that work are not derived from the Library,\n"
	"and can be reasonably considered independent and separate works in\n"
	"themselves, then this License, and its terms, do not apply to those\n"
	"sections when you distribute them as separate works.  But when you\n"
	"distribute the same sections as part of a whole which is a work based\n"
	"on the Library, the distribution of the whole must be on the terms of\n"
	"this License, whose permissions for other licensees extend to the\n"
	"entire whole, and thus to each and every part regardless of who wrote\n"
	"it.\n"
	"\n"
	"Thus, it is not the intent of this section to claim rights or contest\n"
	"your rights to work written entirely by you; rather, the intent is to\n"
	"exercise the right to control the distribution of derivative or\n"
	"collective works based on the Library.\n"
	"\n"
	"In addition, mere aggregation of another work not based on the Library\n"
	"with the Library (or with a work based on the Library) on a volume of\n"
	"a storage or distribution medium does not bring the other work under\n"
	"the scope of this License.\n"
	"\n"
	"  3. You may opt to apply the terms of the ordinary GNU General Public\n"
	"License instead of this License to a given copy of the Library.  To do\n"
	"this, you must alter all the notices that refer to this License, so\n"
	"that they refer to the ordinary GNU General Public License, version 2,\n"
	"instead of to this License.  (If a newer version than version 2 of the\n"
	"ordinary GNU General Public License has appeared, then you can specify\n"
	"that version instead if you wish.)  Do not make any other change in\n"
	"these notices.\n"
	"\n"
	"  Once this change is made in a given copy, it is irreversible for\n"
	"that copy, so the ordinary GNU General Public License applies to all\n"
	"subsequent copies and derivative works made from that copy.\n"
	"\n"
	"  This option is useful when you wish to copy part of the code of\n"
	"the Library into a program that is not a library.\n"
	"\n"
	"  4. You may copy and distribute the Library (or a portion or\n"
	"derivative of it, under Section 2) in object code or executable form\n"
	"under the terms of Sections 1 and 2 above provided that you accompany\n"
	"it with the complete corresponding machine-readable source code, which\n"
	"must be distributed under the terms of Sections 1 and 2 above on a\n"
	"medium customarily used for software interchange.\n"
	"\n"
	"  If distribution of object code is made by offering access to copy\n"
	"from a designated place, then offering equivalent access to copy the\n"
	"source code from the same place satisfies the requirement to\n"
	"distribute the source code, even though third parties are not\n"
	"compelled to copy the source along with the object code.\n"
	"\n"
	"  5. A program that contains no derivative of any portion of the\n"
	"Library, but is designed to work with the Library by being compiled or\n"
	"linked with it, is called a \"work that uses the Library\".  Such a\n"
	"work, in isolation, is not a derivative work of the Library, and\n"
	"therefore falls outside the scope of this License.\n"
	"\n"
	"  However, linking a \"work that uses the Library\" with the Library\n"
	"creates an executable that is a derivative of the Library (because it\n"
	"contains portions of the Library), rather than a \"work that uses the\n"
	"library\".  The executable is therefore covered by this License.\n"
	"Section 6 states terms for distribution of such executables.\n"
	"\n"
	"  When a \"work that uses the Library\" uses material from a header file\n"
	"that is part of the Library, the object code for the work may be a\n"
	"derivative work of the Library even though the source code is not.\n"
	"Whether this is true is especially significant if the work can be\n"
	"linked without the Library, or if the work is itself a library.  The\n"
	"threshold for this to be true is not precisely defined by law.\n"
	"\n"
	"  If such an object file uses only numerical parameters, data\n"
	"structure layouts and accessors, and small macros and small inline\n"
	"functions (ten lines or less in length), then the use of the object\n"
	"file is unrestricted, regardless of whether it is legally a derivative\n"
	"work.  (Executables containing this object code plus portions of the\n"
	"Library will still fall under Section 6.)\n"
	"\n"
	"  Otherwise, if the work is a derivative of the Library, you may\n"
	"distribute the object code for the work under the terms of Section 6.\n"
	"Any executables containing that work also fall under Section 6,\n"
	"whether or not they are linked directly with the Library itself.\n"
	"\n"
	"  6. As an exception to the Sections above, you may also combine or\n"
	"link a \"work that uses the Library\" with the Library to produce a\n"
	"work containing portions of the Library, and distribute that work\n"
	"under terms of your choice, provided that the terms permit\n"
	"modification of the work for the customer's own use and reverse\n"
	"engineering for debugging such modifications.\n"
	"\n"
	"  You must give prominent notice with each copy of the work that the\n"
	"Library is used in it and that the Library and its use are covered by\n"
	"this License.  You must supply a copy of this License.  If the work\n"
	"during execution displays copyright notices, you must include the\n"
	"copyright notice for the Library among them, as well as a reference\n"
	"directing the user to the copy of this License.  Also, you must do one\n"
	"of these things:\n"
	"\n"
	"    a) Accompany the work with the complete corresponding\n"
	"    machine-readable source code for the Library including whatever\n"
	"    changes were used in the work (which must be distributed under\n"
	"    Sections 1 and 2 above); and, if the work is an executable linked\n"
	"    with the Library, with the complete machine-readable \"work that\n"
	"    uses the Library\", as object code and/or source code, so that the\n"
	"    user can modify the Library and then relink to produce a modified\n"
	"    executable containing the modified Library.  (It is understood\n"
	"    that the user who changes the contents of definitions files in the\n"
	"    Library will not necessarily be able to recompile the application\n"
	"    to use the modified definitions.)\n"
	"\n"
	"    b) Use a suitable shared library mechanism for linking with the\n"
	"    Library.  A suitable mechanism is one that (1) uses at run time a\n"
	"    copy of the library already present on the user's computer system,\n"
	"    rather than copying library functions into the executable, and (2)\n"
	"    will operate properly with a modified version of the library, if\n"
	"    the user installs one, as long as the modified version is\n"
	"    interface-compatible with the version that the work was made with.\n"
	"\n"
	"    c) Accompany the work with a written offer, valid for at\n"
	"    least three years, to give the same user the materials\n"
	"    specified in Subsection 6a, above, for a charge no more\n"
	"    than the cost of performing this distribution.\n"
	"\n"
	"    d) If distribution of the work is made by offering access to copy\n"
	"    from a designated place, offer equivalent access to copy the above\n"
	"    specified materials from the same place.\n"
	"\n"
	"    e) Verify that the user has already received a copy of these\n"
	"    materials or that you have already sent this user a copy.\n"
	"\n"
	"  For an executable, the required form of the \"work that uses the\n"
	"Library\" must include any data and utility programs needed for\n"
	"reproducing the executable from it.  However, as a special exception,\n"
	"the materials to be distributed need not include anything that is\n"
	"normally distributed (in either source or binary form) with the major\n"
	"components (compiler, kernel, and so on) of the operating system on\n"
	"which the executable runs, unless that component itself accompanies\n"
	"the executable.\n"
	"\n"
	"  It may happen that this requirement contradicts the license\n"
	"restrictions of other proprietary libraries that do not normally\n"
	"accompany the operating system.  Such a contradiction means you cannot\n"
	"use both them and the Library together in an executable that you\n"
	"distribute.\n"
	"\n"
	"  7. You may place library facilities that are a work based on the\n"
	"Library side-by-side in a single library together with other library\n"
	"facilities not covered by this License, and distribute such a combined\n"
	"library, provided that the separate distribution of the work based on\n"
	"the Library and of the other library facilities is otherwise\n"
	"permitted, and provided that you do these two things:\n"
	"\n"
	"    a) Accompany the combined library with a copy of the same work\n"
	"    based on the Library, uncombined with any other library\n"
	"    facilities.  This must be distributed under the terms of the\n"
	"    Sections above.\n"
	"\n"
	"    b) Give prominent notice with the combined library of the fact\n"
	"    that part of it is a work based on the Library, and explaining\n"
	"    where to find the accompanying uncombined form of the same work.\n"
	"\n"
	"  8. You may not copy, modify, sublicense, link with, or distribute\n"
	"the Library except as expressly provided under this License.  Any\n"
	"attempt otherwise to copy, modify, sublicense, link with, or\n"
	"distribute the Library is void, and will automatically terminate your\n"
	"rights under this License.  However, parties who have received copies,\n"
	"or rights, from you under this License will not have their licenses\n"
	"terminated so long as such parties remain in full compliance.\n"
	"\n"
	"  9. You are not required to accept this License, since you have not\n"
	"signed it.  However, nothing else grants you permission to modify or\n"
	"distribute the Library or its derivative works.  These actions are\n"
	"prohibited by law if you do not accept this License.  Therefore, by\n"
	"modifying or distributing the Library (or any work based on the\n"
	"Library), you indicate your acceptance of this License to do so, and\n"
	"all its terms and conditions for copying, distributing or modifying\n"
	"the Library or works based on it.\n"
	"\n"
	"  10. Each time you redistribute the Library (or any work based on the\n"
	"Library), the recipient automatically receives a license from the\n"
	"original licensor to copy, distribute, link with or modify the Library\n"
	"subject to these terms and conditions.  You may not impose any further\n"
	"restrictions on the recipients' exercise of the rights granted herein.\n"
	"You are not responsible for enforcing compliance by third parties with\n"
	"this License.\n"
	"\n"
	"  11. If, as a consequence of a court judgment or allegation of patent\n"
	"infringement or for any other reason (not limited to patent issues),\n"
	"conditions are imposed on you (whether by court order, agreement or\n"
	"otherwise) that contradict the conditions of this License, they do not\n"
	"excuse you from the conditions of this License.  If you cannot\n"
	"distribute so as to satisfy simultaneously your obligations under this\n"
	"License and any other pertinent obligations, then as a consequence you\n"
	"may not distribute the Library at all.  For example, if a patent\n"
	"license would not permit royalty-free redistribution of the Library by\n"
	"all those who receive copies directly or indirectly through you, then\n"
	"the only way you could satisfy both it and this License would be to\n"
	"refrain entirely from distribution of the Library.\n"
	"\n"
	"If any portion of this section is held invalid or unenforceable under any\n"
	"particular circumstance, the balance of the section is intended to apply,\n"
	"and the section as a whole is intended to apply in other circumstances.\n"
	"\n"
	"It is not the purpose of this section to induce you to infringe any\n"
	"patents or other property right claims or to contest validity of any\n"
	"such claims; this section has the sole purpose of protecting the\n"
	"integrity of the free software distribution system which is\n"
	"implemented by public license practices.  Many people have made\n"
	"generous contributions to the wide range of software distributed\n"
	"through that system in reliance on consistent application of that\n"
	"system; it is up to the author/donor to decide if he or she is willing\n"
	"to distribute software through any other system and a licensee cannot\n"
	"impose that choice.\n"
	"\n"
	"This section is intended to make thoroughly clear what is believed to\n"
	"be a consequence of the rest of this License.\n"
	"\n"
	"  12. If the distribution and/or use of the Library is restricted in\n"
	"certain countries either by patents or by copyrighted interfaces, the\n"
	"original copyright holder who places the Library under this License may add\n"
	"an explicit geographical distribution limitation excluding those countries,\n"
	"so that distribution is permitted only in or among countries not thus\n"
	"excluded.  In such case, this License incorporates the limitation as if\n"
	"written in the body of this License.\n"
	"\n"
	"  13. The Free Software Foundation may publish revised and/or new\n"
	"versions of the Lesser General Public License from time to time.\n"
	"Such new versions will be similar in spirit to the present version,\n"
	"but may differ in detail to address new problems or concerns.\n"
	"\n"
	"Each version is given a distinguishing version number.  If the Library\n"
	"specifies a version number of this License which applies to it and\n"
	"\"any later version\", you have the option of following the terms and\n"
	"conditions either of that version or of any later version published by\n"
	"the Free Software Foundation.  If the Library does not specify a\n"
	"license version number, you may choose any version ever published by\n"
	"the Free Software Foundation.\n"
	"\n"
	"  14. If you wish to incorporate parts of the Library into other free\n"
	"programs whose distribution conditions are incompatible with these,\n"
	"write to the author to ask for permission.  For software which is\n"
	"copyrighted by the Free Software Foundation, write to the Free\n"
	"Software Foundation; we sometimes make exceptions for this.  Our\n"
	"decision will be guided by the two goals of preserving the free status\n"
	"of all derivatives of our free software and of promoting the sharing\n"
	"and reuse of software generally.\n"
	"\n"
	"                            NO WARRANTY\n"
	"\n"
	"  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO\n"
	"WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.\n"
	"EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR\n"
	"OTHER PARTIES PROVIDE THE LIBRARY \"AS IS\" WITHOUT WARRANTY OF ANY\n"
	"KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE\n"
	"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
	"PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE\n"
	"LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME\n"
	"THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n"
	"\n"
	"  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN\n"
	"WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY\n"
	"AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU\n"
	"FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR\n"
	"CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE\n"
	"LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING\n"
	"RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A\n"
	"FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF\n"
	"SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH\n"
	"DAMAGES.\n"
	"\n"
	"                     END OF TERMS AND CONDITIONS\n"
	"\n"
	"           How to Apply These Terms to Your New Libraries\n"
	"\n"
	"  If you develop a new library, and you want it to be of the greatest\n"
	"possible use to the public, we recommend making it free software that\n"
	"everyone can redistribute and change.  You can do so by permitting\n"
	"redistribution under these terms (or, alternatively, under the terms of the\n"
	"ordinary General Public License).\n"
	"\n"
	"  To apply these terms, attach the following notices to the library.  It is\n"
	"safest to attach them to the start of each source file to most effectively\n"
	"convey the exclusion of warranty; and each file should have at least the\n"
	"\"copyright\" line and a pointer to where the full notice is found.\n"
	"\n"
	"    <one line to give the library's name and a brief idea of what it does.>\n"
	"    Copyright (C) <year>  <name of author>\n"
	"\n"
	"    This library is free software; you can redistribute it and/or\n"
	"    modify it under the terms of the GNU Lesser General Public\n"
	"    License as published by the Free Software Foundation; either\n"
	"    version 2.1 of the License, or (at your option) any later version.\n"
	"\n"
	"    This library is distributed in the hope that it will be useful,\n"
	"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
	"    Lesser General Public License for more details.\n"
	"\n"
	"    You should have received a copy of the GNU Lesser General Public\n"
	"    License along with this library; if not, write to the Free Software\n"
	"    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
	"\n"
	"Also add information on how to contact you by electronic and paper mail.\n"
	"\n"
	"You should also get your employer (if you work as a programmer) or your\n"
	"school, if any, to sign a \"copyright disclaimer\" for the library, if\n"
	"necessary.  Here is a sample; alter the names:\n"
	"\n"
	"  Yoyodyne, Inc., hereby disclaims all copyright interest in the\n"
	"  library `Frob' (a library for tweaking knobs) written by James Random Hacker.\n"
	"\n"
	"  <signature of Ty Coon>, 1 April 1990\n"
	"  Ty Coon, President of Vice\n"
	"\n"
	"That's all there is to it!";
#endif


#ifdef USE_BUILDENV
static const char *licenseGlib = "		  GNU LIBRARY GENERAL PUBLIC LICENSE\n"
								 "		       Version 2, June 1991\n"
								 "\n"
								 " Copyright (C) 1991 Free Software Foundation, Inc.\n"
								 "    		    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
								 " Everyone is permitted to copy and distribute verbatim copies\n"
								 " of this license document, but changing it is not allowed.\n"
								 "\n"
								 "[This is the first released version of the library GPL.  It is\n"
								 " numbered 2 because it goes with version 2 of the ordinary GPL.]\n"
								 "\n"
								 "			    Preamble\n"
								 "\n"
								 "  The licenses for most software are designed to take away your\n"
								 "freedom to share and change it.  By contrast, the GNU General Public\n"
								 "Licenses are intended to guarantee your freedom to share and change\n"
								 "free software--to make sure the software is free for all its users.\n"
								 "\n"
								 "  This license, the Library General Public License, applies to some\n"
								 "specially designated Free Software Foundation software, and to any\n"
								 "other libraries whose authors decide to use it.  You can use it for\n"
								 "your libraries, too.\n"
								 "\n"
								 "  When we speak of free software, we are referring to freedom, not\n"
								 "price.  Our General Public Licenses are designed to make sure that you\n"
								 "have the freedom to distribute copies of free software (and charge for\n"
								 "this service if you wish), that you receive source code or can get it\n"
								 "if you want it, that you can change the software or use pieces of it\n"
								 "in new free programs; and that you know you can do these things.\n"
								 "\n"
								 "  To protect your rights, we need to make restrictions that forbid\n"
								 "anyone to deny you these rights or to ask you to surrender the rights.\n"
								 "These restrictions translate to certain responsibilities for you if\n"
								 "you distribute copies of the library, or if you modify it.\n"
								 "\n"
								 "  For example, if you distribute copies of the library, whether gratis\n"
								 "or for a fee, you must give the recipients all the rights that we gave\n"
								 "you.  You must make sure that they, too, receive or can get the source\n"
								 "code.  If you link a program with the library, you must provide\n"
								 "complete object files to the recipients so that they can relink them\n"
								 "with the library, after making changes to the library and recompiling\n"
								 "it.  And you must show them these terms so they know their rights.\n"
								 "\n"
								 "  Our method of protecting your rights has two steps: (1) copyright\n"
								 "the library, and (2) offer you this license which gives you legal\n"
								 "permission to copy, distribute and/or modify the library.\n"
								 "\n"
								 "  Also, for each distributor's protection, we want to make certain\n"
								 "that everyone understands that there is no warranty for this free\n"
								 "library.  If the library is modified by someone else and passed on, we\n"
								 "want its recipients to know that what they have is not the original\n"
								 "version, so that any problems introduced by others will not reflect on\n"
								 "the original authors' reputations.\n"
								 "\n"
								 "  Finally, any free program is threatened constantly by software\n"
								 "patents.  We wish to avoid the danger that companies distributing free\n"
								 "software will individually obtain patent licenses, thus in effect\n"
								 "transforming the program into proprietary software.  To prevent this,\n"
								 "we have made it clear that any patent must be licensed for everyone's\n"
								 "free use or not licensed at all.\n"
								 "\n"
								 "  Most GNU software, including some libraries, is covered by the ordinary\n"
								 "GNU General Public License, which was designed for utility programs.  This\n"
								 "license, the GNU Library General Public License, applies to certain\n"
								 "designated libraries.  This license is quite different from the ordinary\n"
								 "one; be sure to read it in full, and don't assume that anything in it is\n"
								 "the same as in the ordinary license.\n"
								 "\n"
								 "  The reason we have a separate public license for some libraries is that\n"
								 "they blur the distinction we usually make between modifying or adding to a\n"
								 "program and simply using it.  Linking a program with a library, without\n"
								 "changing the library, is in some sense simply using the library, and is\n"
								 "analogous to running a utility program or application program.  However, in\n"
								 "a textual and legal sense, the linked executable is a combined work, a\n"
								 "derivative of the original library, and the ordinary General Public License\n"
								 "treats it as such.\n"
								 "\n"
								 "  Because of this blurred distinction, using the ordinary General\n"
								 "Public License for libraries did not effectively promote software\n"
								 "sharing, because most developers did not use the libraries.  We\n"
								 "concluded that weaker conditions might promote sharing better.\n"
								 "\n"
								 "  However, unrestricted linking of non-free programs would deprive the\n"
								 "users of those programs of all benefit from the free status of the\n"
								 "libraries themselves.  This Library General Public License is intended to\n"
								 "permit developers of non-free programs to use free libraries, while\n"
								 "preserving your freedom as a user of such programs to change the free\n"
								 "libraries that are incorporated in them.  (We have not seen how to achieve\n"
								 "this as regards changes in header files, but we have achieved it as regards\n"
								 "changes in the actual functions of the Library.)  The hope is that this\n"
								 "will lead to faster development of free libraries.\n"
								 "\n"
								 "  The precise terms and conditions for copying, distribution and\n"
								 "modification follow.  Pay close attention to the difference between a\n"
								 "\"work based on the library\" and a \"work that uses the library\".  The\n"
								 "former contains code derived from the library, while the latter only\n"
								 "works together with the library.\n"
								 "\n"
								 "  Note that it is possible for a library to be covered by the ordinary\n"
								 "General Public License rather than by this special one.\n"
								 "\n"
								 "		  GNU LIBRARY GENERAL PUBLIC LICENSE\n"
								 "   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
								 "\n"
								 "  0. This License Agreement applies to any software library which\n"
								 "contains a notice placed by the copyright holder or other authorized\n"
								 "party saying it may be distributed under the terms of this Library\n"
								 "General Public License (also called \"this License\").  Each licensee is\n"
								 "addressed as \"you\".\n"
								 "\n"
								 "  A \"library\" means a collection of software functions and/or data\n"
								 "prepared so as to be conveniently linked with application programs\n"
								 "(which use some of those functions and data) to form executables.\n"
								 "\n"
								 "  The \"Library\", below, refers to any such software library or work\n"
								 "which has been distributed under these terms.  A \"work based on the\n"
								 "Library\" means either the Library or any derivative work under\n"
								 "copyright law: that is to say, a work containing the Library or a\n"
								 "portion of it, either verbatim or with modifications and/or translated\n"
								 "straightforwardly into another language.  (Hereinafter, translation is\n"
								 "included without limitation in the term \"modification\".)\n"
								 "\n"
								 "  \"Source code\" for a work means the preferred form of the work for\n"
								 "making modifications to it.  For a library, complete source code means\n"
								 "all the source code for all modules it contains, plus any associated\n"
								 "interface definition files, plus the scripts used to control compilation\n"
								 "and installation of the library.\n"
								 "\n"
								 "  Activities other than copying, distribution and modification are not\n"
								 "covered by this License; they are outside its scope.  The act of\n"
								 "running a program using the Library is not restricted, and output from\n"
								 "such a program is covered only if its contents constitute a work based\n"
								 "on the Library (independent of the use of the Library in a tool for\n"
								 "writing it).  Whether that is true depends on what the Library does\n"
								 "and what the program that uses the Library does.\n"
								 "  \n"
								 "  1. You may copy and distribute verbatim copies of the Library's\n"
								 "complete source code as you receive it, in any medium, provided that\n"
								 "you conspicuously and appropriately publish on each copy an\n"
								 "appropriate copyright notice and disclaimer of warranty; keep intact\n"
								 "all the notices that refer to this License and to the absence of any\n"
								 "warranty; and distribute a copy of this License along with the\n"
								 "Library.\n"
								 "\n"
								 "  You may charge a fee for the physical act of transferring a copy,\n"
								 "and you may at your option offer warranty protection in exchange for a\n"
								 "fee.\n"
								 "\n"
								 "  2. You may modify your copy or copies of the Library or any portion\n"
								 "of it, thus forming a work based on the Library, and copy and\n"
								 "distribute such modifications or work under the terms of Section 1\n"
								 "above, provided that you also meet all of these conditions:\n"
								 "\n"
								 "    a) The modified work must itself be a software library.\n"
								 "\n"
								 "    b) You must cause the files modified to carry prominent notices\n"
								 "    stating that you changed the files and the date of any change.\n"
								 "\n"
								 "    c) You must cause the whole of the work to be licensed at no\n"
								 "    charge to all third parties under the terms of this License.\n"
								 "\n"
								 "    d) If a facility in the modified Library refers to a function or a\n"
								 "    table of data to be supplied by an application program that uses\n"
								 "    the facility, other than as an argument passed when the facility\n"
								 "    is invoked, then you must make a good faith effort to ensure that,\n"
								 "    in the event an application does not supply such function or\n"
								 "    table, the facility still operates, and performs whatever part of\n"
								 "    its purpose remains meaningful.\n"
								 "\n"
								 "    (For example, a function in a library to compute square roots has\n"
								 "    a purpose that is entirely well-defined independent of the\n"
								 "    application.  Therefore, Subsection 2d requires that any\n"
								 "    application-supplied function or table used by this function must\n"
								 "    be optional: if the application does not supply it, the square\n"
								 "    root function must still compute square roots.)\n"
								 "\n"
								 "These requirements apply to the modified work as a whole.  If\n"
								 "identifiable sections of that work are not derived from the Library,\n"
								 "and can be reasonably considered independent and separate works in\n"
								 "themselves, then this License, and its terms, do not apply to those\n"
								 "sections when you distribute them as separate works.  But when you\n"
								 "distribute the same sections as part of a whole which is a work based\n"
								 "on the Library, the distribution of the whole must be on the terms of\n"
								 "this License, whose permissions for other licensees extend to the\n"
								 "entire whole, and thus to each and every part regardless of who wrote\n"
								 "it.\n"
								 "\n"
								 "Thus, it is not the intent of this section to claim rights or contest\n"
								 "your rights to work written entirely by you; rather, the intent is to\n"
								 "exercise the right to control the distribution of derivative or\n"
								 "collective works based on the Library.\n"
								 "\n"
								 "In addition, mere aggregation of another work not based on the Library\n"
								 "with the Library (or with a work based on the Library) on a volume of\n"
								 "a storage or distribution medium does not bring the other work under\n"
								 "the scope of this License.\n"
								 "\n"
								 "  3. You may opt to apply the terms of the ordinary GNU General Public\n"
								 "License instead of this License to a given copy of the Library.  To do\n"
								 "this, you must alter all the notices that refer to this License, so\n"
								 "that they refer to the ordinary GNU General Public License, version 2,\n"
								 "instead of to this License.  (If a newer version than version 2 of the\n"
								 "ordinary GNU General Public License has appeared, then you can specify\n"
								 "that version instead if you wish.)  Do not make any other change in\n"
								 "these notices.\n"
								 "\n"
								 "  Once this change is made in a given copy, it is irreversible for\n"
								 "that copy, so the ordinary GNU General Public License applies to all\n"
								 "subsequent copies and derivative works made from that copy.\n"
								 "\n"
								 "  This option is useful when you wish to copy part of the code of\n"
								 "the Library into a program that is not a library.\n"
								 "\n"
								 "  4. You may copy and distribute the Library (or a portion or\n"
								 "derivative of it, under Section 2) in object code or executable form\n"
								 "under the terms of Sections 1 and 2 above provided that you accompany\n"
								 "it with the complete corresponding machine-readable source code, which\n"
								 "must be distributed under the terms of Sections 1 and 2 above on a\n"
								 "medium customarily used for software interchange.\n"
								 "\n"
								 "  If distribution of object code is made by offering access to copy\n"
								 "from a designated place, then offering equivalent access to copy the\n"
								 "source code from the same place satisfies the requirement to\n"
								 "distribute the source code, even though third parties are not\n"
								 "compelled to copy the source along with the object code.\n"
								 "\n"
								 "  5. A program that contains no derivative of any portion of the\n"
								 "Library, but is designed to work with the Library by being compiled or\n"
								 "linked with it, is called a \"work that uses the Library\".  Such a\n"
								 "work, in isolation, is not a derivative work of the Library, and\n"
								 "therefore falls outside the scope of this License.\n"
								 "\n"
								 "  However, linking a \"work that uses the Library\" with the Library\n"
								 "creates an executable that is a derivative of the Library (because it\n"
								 "contains portions of the Library), rather than a \"work that uses the\n"
								 "library\".  The executable is therefore covered by this License.\n"
								 "Section 6 states terms for distribution of such executables.\n"
								 "\n"
								 "  When a \"work that uses the Library\" uses material from a header file\n"
								 "that is part of the Library, the object code for the work may be a\n"
								 "derivative work of the Library even though the source code is not.\n"
								 "Whether this is true is especially significant if the work can be\n"
								 "linked without the Library, or if the work is itself a library.  The\n"
								 "threshold for this to be true is not precisely defined by law.\n"
								 "\n"
								 "  If such an object file uses only numerical parameters, data\n"
								 "structure layouts and accessors, and small macros and small inline\n"
								 "functions (ten lines or less in length), then the use of the object\n"
								 "file is unrestricted, regardless of whether it is legally a derivative\n"
								 "work.  (Executables containing this object code plus portions of the\n"
								 "Library will still fall under Section 6.)\n"
								 "\n"
								 "  Otherwise, if the work is a derivative of the Library, you may\n"
								 "distribute the object code for the work under the terms of Section 6.\n"
								 "Any executables containing that work also fall under Section 6,\n"
								 "whether or not they are linked directly with the Library itself.\n"
								 "\n"
								 "  6. As an exception to the Sections above, you may also compile or\n"
								 "link a \"work that uses the Library\" with the Library to produce a\n"
								 "work containing portions of the Library, and distribute that work\n"
								 "under terms of your choice, provided that the terms permit\n"
								 "modification of the work for the customer's own use and reverse\n"
								 "engineering for debugging such modifications.\n"
								 "\n"
								 "  You must give prominent notice with each copy of the work that the\n"
								 "Library is used in it and that the Library and its use are covered by\n"
								 "this License.  You must supply a copy of this License.  If the work\n"
								 "during execution displays copyright notices, you must include the\n"
								 "copyright notice for the Library among them, as well as a reference\n"
								 "directing the user to the copy of this License.  Also, you must do one\n"
								 "of these things:\n"
								 "\n"
								 "    a) Accompany the work with the complete corresponding\n"
								 "    machine-readable source code for the Library including whatever\n"
								 "    changes were used in the work (which must be distributed under\n"
								 "    Sections 1 and 2 above); and, if the work is an executable linked\n"
								 "    with the Library, with the complete machine-readable \"work that\n"
								 "    uses the Library\", as object code and/or source code, so that the\n"
								 "    user can modify the Library and then relink to produce a modified\n"
								 "    executable containing the modified Library.  (It is understood\n"
								 "    that the user who changes the contents of definitions files in the\n"
								 "    Library will not necessarily be able to recompile the application\n"
								 "    to use the modified definitions.)\n"
								 "\n"
								 "    b) Accompany the work with a written offer, valid for at\n"
								 "    least three years, to give the same user the materials\n"
								 "    specified in Subsection 6a, above, for a charge no more\n"
								 "    than the cost of performing this distribution.\n"
								 "\n"
								 "    c) If distribution of the work is made by offering access to copy\n"
								 "    from a designated place, offer equivalent access to copy the above\n"
								 "    specified materials from the same place.\n"
								 "\n"
								 "    d) Verify that the user has already received a copy of these\n"
								 "    materials or that you have already sent this user a copy.\n"
								 "\n"
								 "  For an executable, the required form of the \"work that uses the\n"
								 "Library\" must include any data and utility programs needed for\n"
								 "reproducing the executable from it.  However, as a special exception,\n"
								 "the source code distributed need not include anything that is normally\n"
								 "distributed (in either source or binary form) with the major\n"
								 "components (compiler, kernel, and so on) of the operating system on\n"
								 "which the executable runs, unless that component itself accompanies\n"
								 "the executable.\n"
								 "\n"
								 "  It may happen that this requirement contradicts the license\n"
								 "restrictions of other proprietary libraries that do not normally\n"
								 "accompany the operating system.  Such a contradiction means you cannot\n"
								 "use both them and the Library together in an executable that you\n"
								 "distribute.\n"
								 "\n"
								 "  7. You may place library facilities that are a work based on the\n"
								 "Library side-by-side in a single library together with other library\n"
								 "facilities not covered by this License, and distribute such a combined\n"
								 "library, provided that the separate distribution of the work based on\n"
								 "the Library and of the other library facilities is otherwise\n"
								 "permitted, and provided that you do these two things:\n"
								 "\n"
								 "    a) Accompany the combined library with a copy of the same work\n"
								 "    based on the Library, uncombined with any other library\n"
								 "    facilities.  This must be distributed under the terms of the\n"
								 "    Sections above.\n"
								 "\n"
								 "    b) Give prominent notice with the combined library of the fact\n"
								 "    that part of it is a work based on the Library, and explaining\n"
								 "    where to find the accompanying uncombined form of the same work.\n"
								 "\n"
								 "  8. You may not copy, modify, sublicense, link with, or distribute\n"
								 "the Library except as expressly provided under this License.  Any\n"
								 "attempt otherwise to copy, modify, sublicense, link with, or\n"
								 "distribute the Library is void, and will automatically terminate your\n"
								 "rights under this License.  However, parties who have received copies,\n"
								 "or rights, from you under this License will not have their licenses\n"
								 "terminated so long as such parties remain in full compliance.\n"
								 "\n"
								 "  9. You are not required to accept this License, since you have not\n"
								 "signed it.  However, nothing else grants you permission to modify or\n"
								 "distribute the Library or its derivative works.  These actions are\n"
								 "prohibited by law if you do not accept this License.  Therefore, by\n"
								 "modifying or distributing the Library (or any work based on the\n"
								 "Library), you indicate your acceptance of this License to do so, and\n"
								 "all its terms and conditions for copying, distributing or modifying\n"
								 "the Library or works based on it.\n"
								 "\n"
								 "  10. Each time you redistribute the Library (or any work based on the\n"
								 "Library), the recipient automatically receives a license from the\n"
								 "original licensor to copy, distribute, link with or modify the Library\n"
								 "subject to these terms and conditions.  You may not impose any further\n"
								 "restrictions on the recipients' exercise of the rights granted herein.\n"
								 "You are not responsible for enforcing compliance by third parties to\n"
								 "this License.\n"
								 "\n"
								 "  11. If, as a consequence of a court judgment or allegation of patent\n"
								 "infringement or for any other reason (not limited to patent issues),\n"
								 "conditions are imposed on you (whether by court order, agreement or\n"
								 "otherwise) that contradict the conditions of this License, they do not\n"
								 "excuse you from the conditions of this License.  If you cannot\n"
								 "distribute so as to satisfy simultaneously your obligations under this\n"
								 "License and any other pertinent obligations, then as a consequence you\n"
								 "may not distribute the Library at all.  For example, if a patent\n"
								 "license would not permit royalty-free redistribution of the Library by\n"
								 "all those who receive copies directly or indirectly through you, then\n"
								 "the only way you could satisfy both it and this License would be to\n"
								 "refrain entirely from distribution of the Library.\n"
								 "\n"
								 "If any portion of this section is held invalid or unenforceable under any\n"
								 "particular circumstance, the balance of the section is intended to apply,\n"
								 "and the section as a whole is intended to apply in other circumstances.\n"
								 "\n"
								 "It is not the purpose of this section to induce you to infringe any\n"
								 "patents or other property right claims or to contest validity of any\n"
								 "such claims; this section has the sole purpose of protecting the\n"
								 "integrity of the free software distribution system which is\n"
								 "implemented by public license practices.  Many people have made\n"
								 "generous contributions to the wide range of software distributed\n"
								 "through that system in reliance on consistent application of that\n"
								 "system; it is up to the author/donor to decide if he or she is willing\n"
								 "to distribute software through any other system and a licensee cannot\n"
								 "impose that choice.\n"
								 "\n"
								 "This section is intended to make thoroughly clear what is believed to\n"
								 "be a consequence of the rest of this License.\n"
								 "\n"
								 "  12. If the distribution and/or use of the Library is restricted in\n"
								 "certain countries either by patents or by copyrighted interfaces, the\n"
								 "original copyright holder who places the Library under this License may add\n"
								 "an explicit geographical distribution limitation excluding those countries,\n"
								 "so that distribution is permitted only in or among countries not thus\n"
								 "excluded.  In such case, this License incorporates the limitation as if\n"
								 "written in the body of this License.\n"
								 "\n"
								 "  13. The Free Software Foundation may publish revised and/or new\n"
								 "versions of the Library General Public License from time to time.\n"
								 "Such new versions will be similar in spirit to the present version,\n"
								 "but may differ in detail to address new problems or concerns.\n"
								 "\n"
								 "Each version is given a distinguishing version number.  If the Library\n"
								 "specifies a version number of this License which applies to it and\n"
								 "\"any later version\", you have the option of following the terms and\n"
								 "conditions either of that version or of any later version published by\n"
								 "the Free Software Foundation.  If the Library does not specify a\n"
								 "license version number, you may choose any version ever published by\n"
								 "the Free Software Foundation.\n"
								 "\n"
								 "  14. If you wish to incorporate parts of the Library into other free\n"
								 "programs whose distribution conditions are incompatible with these,\n"
								 "write to the author to ask for permission.  For software which is\n"
								 "copyrighted by the Free Software Foundation, write to the Free\n"
								 "Software Foundation; we sometimes make exceptions for this.  Our\n"
								 "decision will be guided by the two goals of preserving the free status\n"
								 "of all derivatives of our free software and of promoting the sharing\n"
								 "and reuse of software generally.\n"
								 "\n"
								 "			    NO WARRANTY\n"
								 "\n"
								 "  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO\n"
								 "WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.\n"
								 "EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR\n"
								 "OTHER PARTIES PROVIDE THE LIBRARY \"AS IS\" WITHOUT WARRANTY OF ANY\n"
								 "KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE\n"
								 "IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
								 "PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE\n"
								 "LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME\n"
								 "THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n"
								 "\n"
								 "  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN\n"
								 "WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY\n"
								 "AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU\n"
								 "FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR\n"
								 "CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE\n"
								 "LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING\n"
								 "RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A\n"
								 "FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF\n"
								 "SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH\n"
								 "DAMAGES.\n"
								 "\n"
								 "		     END OF TERMS AND CONDITIONS\n"
								 "\n"
								 "           How to Apply These Terms to Your New Libraries\n"
								 "\n"
								 "  If you develop a new library, and you want it to be of the greatest\n"
								 "possible use to the public, we recommend making it free software that\n"
								 "everyone can redistribute and change.  You can do so by permitting\n"
								 "redistribution under these terms (or, alternatively, under the terms of the\n"
								 "ordinary General Public License).\n"
								 "\n"
								 "  To apply these terms, attach the following notices to the library.  It is\n"
								 "safest to attach them to the start of each source file to most effectively\n"
								 "convey the exclusion of warranty; and each file should have at least the\n"
								 "\"copyright\" line and a pointer to where the full notice is found.\n"
								 "\n"
								 "    <one line to give the library's name and a brief idea of what it does.>\n"
								 "    Copyright (C) <year>  <name of author>\n"
								 "\n"
								 "    This library is free software; you can redistribute it and/or\n"
								 "    modify it under the terms of the GNU Library General Public\n"
								 "    License as published by the Free Software Foundation; either\n"
								 "    version 2 of the License, or (at your option) any later version.\n"
								 "\n"
								 "    This library is distributed in the hope that it will be useful,\n"
								 "    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
								 "    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
								 "    Library General Public License for more details.\n"
								 "\n"
								 "    You should have received a copy of the GNU Library General Public\n"
								 "    License along with this library; if not, write to the \n"
								 "    Free Software Foundation, Inc., 59 Temple Place - Suite 330, \n"
								 "    Boston, MA  02111-1307  USA.\n"
								 "\n"
								 "Also add information on how to contact you by electronic and paper mail.\n"
								 "\n"
								 "You should also get your employer (if you work as a programmer) or your\n"
								 "school, if any, to sign a \"copyright disclaimer\" for the library, if\n"
								 "necessary.  Here is a sample; alter the names:\n"
								 "\n"
								 "  Yoyodyne, Inc., hereby disclaims all copyright interest in the\n"
								 "  library `Frob' (a library for tweaking knobs) written by James Random Hacker.\n"
								 "\n"
								 "  <signature of Ty Coon>, 1 April 1990\n"
								 "  Ty Coon, President of Vice\n"
								 "\n"
								 "That's all there is to it!";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibcap2 = "Unless otherwise *explicitly* stated, the following text describes the\n"
									"licensed conditions under which the contents of this libcap release\n"
									"may be used and distributed:\n"
									"\n"
									"-------------------------------------------------------------------------\n"
									"Redistribution and use in source and binary forms of libcap, with\n"
									"or without modification, are permitted provided that the following\n"
									"conditions are met:\n"
									"\n"
									"1. Redistributions of source code must retain any existing copyright\n"
									"   notice, and this entire permission notice in its entirety,\n"
									"   including the disclaimer of warranties.\n"
									"\n"
									"2. Redistributions in binary form must reproduce all prior and current\n"
									"   copyright notices, this list of conditions, and the following\n"
									"   disclaimer in the documentation and/or other materials provided\n"
									"   with the distribution.\n"
									"\n"
									"3. The name of any author may not be used to endorse or promote\n"
									"   products derived from this software without their specific prior\n"
									"   written permission.\n"
									"\n"
									"ALTERNATIVELY, this product may be distributed under the terms of the\n"
									"GNU General Public License (v2.0 - see below), in which case the\n"
									"provisions of the GNU GPL are required INSTEAD OF the above\n"
									"restrictions.  (This clause is necessary due to a potential conflict\n"
									"between the GNU GPL and the restrictions contained in a BSD-style\n"
									"copyright.)\n"
									"\n"
									"THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED\n"
									"WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
									"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\n"
									"IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,\n"
									"INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,\n"
									"BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS\n"
									"OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n"
									"ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n"
									"TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE\n"
									"USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH\n"
									"DAMAGE.\n"
									"-------------------------------------------------------------------------\n"
									"\n"
									"-------------------------\n"
									"Full text of gpl-2.0.txt:\n"
									"-------------------------\n"
									"\n"
									"                    GNU GENERAL PUBLIC LICENSE\n"
									"                       Version 2, June 1991\n"
									"\n"
									" Copyright (C) 1989, 1991 Free Software Foundation, Inc.,\n"
									" 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
									" Everyone is permitted to copy and distribute verbatim copies\n"
									" of this license document, but changing it is not allowed.\n"
									"\n"
									"                            Preamble\n"
									"\n"
									"  The licenses for most software are designed to take away your\n"
									"freedom to share and change it.  By contrast, the GNU General Public\n"
									"License is intended to guarantee your freedom to share and change free\n"
									"software--to make sure the software is free for all its users.  This\n"
									"General Public License applies to most of the Free Software\n"
									"Foundation's software and to any other program whose authors commit to\n"
									"using it.  (Some other Free Software Foundation software is covered by\n"
									"the GNU Lesser General Public License instead.)  You can apply it to\n"
									"your programs, too.\n"
									"\n"
									"  When we speak of free software, we are referring to freedom, not\n"
									"price.  Our General Public Licenses are designed to make sure that you\n"
									"have the freedom to distribute copies of free software (and charge for\n"
									"this service if you wish), that you receive source code or can get it\n"
									"if you want it, that you can change the software or use pieces of it\n"
									"in new free programs; and that you know you can do these things.\n"
									"\n"
									"  To protect your rights, we need to make restrictions that forbid\n"
									"anyone to deny you these rights or to ask you to surrender the rights.\n"
									"These restrictions translate to certain responsibilities for you if you\n"
									"distribute copies of the software, or if you modify it.\n"
									"\n"
									"  For example, if you distribute copies of such a program, whether\n"
									"gratis or for a fee, you must give the recipients all the rights that\n"
									"you have.  You must make sure that they, too, receive or can get the\n"
									"source code.  And you must show them these terms so they know their\n"
									"rights.\n"
									"\n"
									"  We protect your rights with two steps: (1) copyright the software, and\n"
									"(2) offer you this license which gives you legal permission to copy,\n"
									"distribute and/or modify the software.\n"
									"\n"
									"  Also, for each author's protection and ours, we want to make certain\n"
									"that everyone understands that there is no warranty for this free\n"
									"software.  If the software is modified by someone else and passed on, we\n"
									"want its recipients to know that what they have is not the original, so\n"
									"that any problems introduced by others will not reflect on the original\n"
									"authors' reputations.\n"
									"\n"
									"  Finally, any free program is threatened constantly by software\n"
									"patents.  We wish to avoid the danger that redistributors of a free\n"
									"program will individually obtain patent licenses, in effect making the\n"
									"program proprietary.  To prevent this, we have made it clear that any\n"
									"patent must be licensed for everyone's free use or not licensed at all.\n"
									"\n"
									"  The precise terms and conditions for copying, distribution and\n"
									"modification follow.\n"
									"\n"
									"                    GNU GENERAL PUBLIC LICENSE\n"
									"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
									"\n"
									"  0. This License applies to any program or other work which contains\n"
									"a notice placed by the copyright holder saying it may be distributed\n"
									"under the terms of this General Public License.  The \"Program\", below,\n"
									"refers to any such program or work, and a \"work based on the Program\"\n"
									"means either the Program or any derivative work under copyright law:\n"
									"that is to say, a work containing the Program or a portion of it,\n"
									"either verbatim or with modifications and/or translated into another\n"
									"language.  (Hereinafter, translation is included without limitation in\n"
									"the term \"modification\".)  Each licensee is addressed as \"you\".\n"
									"\n"
									"Activities other than copying, distribution and modification are not\n"
									"covered by this License; they are outside its scope.  The act of\n"
									"running the Program is not restricted, and the output from the Program\n"
									"is covered only if its contents constitute a work based on the\n"
									"Program (independent of having been made by running the Program).\n"
									"Whether that is true depends on what the Program does.\n"
									"\n"
									"  1. You may copy and distribute verbatim copies of the Program's\n"
									"source code as you receive it, in any medium, provided that you\n"
									"conspicuously and appropriately publish on each copy an appropriate\n"
									"copyright notice and disclaimer of warranty; keep intact all the\n"
									"notices that refer to this License and to the absence of any warranty;\n"
									"and give any other recipients of the Program a copy of this License\n"
									"along with the Program.\n"
									"\n"
									"You may charge a fee for the physical act of transferring a copy, and\n"
									"you may at your option offer warranty protection in exchange for a fee.\n"
									"\n"
									"  2. You may modify your copy or copies of the Program or any portion\n"
									"of it, thus forming a work based on the Program, and copy and\n"
									"distribute such modifications or work under the terms of Section 1\n"
									"above, provided that you also meet all of these conditions:\n"
									"\n"
									"    a) You must cause the modified files to carry prominent notices\n"
									"    stating that you changed the files and the date of any change.\n"
									"\n"
									"    b) You must cause any work that you distribute or publish, that in\n"
									"    whole or in part contains or is derived from the Program or any\n"
									"    part thereof, to be licensed as a whole at no charge to all third\n"
									"    parties under the terms of this License.\n"
									"\n"
									"    c) If the modified program normally reads commands interactively\n"
									"    when run, you must cause it, when started running for such\n"
									"    interactive use in the most ordinary way, to print or display an\n"
									"    announcement including an appropriate copyright notice and a\n"
									"    notice that there is no warranty (or else, saying that you provide\n"
									"    a warranty) and that users may redistribute the program under\n"
									"    these conditions, and telling the user how to view a copy of this\n"
									"    License.  (Exception: if the Program itself is interactive but\n"
									"    does not normally print such an announcement, your work based on\n"
									"    the Program is not required to print an announcement.)\n"
									"\n"
									"These requirements apply to the modified work as a whole.  If\n"
									"identifiable sections of that work are not derived from the Program,\n"
									"and can be reasonably considered independent and separate works in\n"
									"themselves, then this License, and its terms, do not apply to those\n"
									"sections when you distribute them as separate works.  But when you\n"
									"distribute the same sections as part of a whole which is a work based\n"
									"on the Program, the distribution of the whole must be on the terms of\n"
									"this License, whose permissions for other licensees extend to the\n"
									"entire whole, and thus to each and every part regardless of who wrote it.\n"
									"\n"
									"Thus, it is not the intent of this section to claim rights or contest\n"
									"your rights to work written entirely by you; rather, the intent is to\n"
									"exercise the right to control the distribution of derivative or\n"
									"collective works based on the Program.\n"
									"\n"
									"In addition, mere aggregation of another work not based on the Program\n"
									"with the Program (or with a work based on the Program) on a volume of\n"
									"a storage or distribution medium does not bring the other work under\n"
									"the scope of this License.\n"
									"\n"
									"  3. You may copy and distribute the Program (or a work based on it,\n"
									"under Section 2) in object code or executable form under the terms of\n"
									"Sections 1 and 2 above provided that you also do one of the following:\n"
									"\n"
									"    a) Accompany it with the complete corresponding machine-readable\n"
									"    source code, which must be distributed under the terms of Sections\n"
									"    1 and 2 above on a medium customarily used for software interchange; or,\n"
									"\n"
									"    b) Accompany it with a written offer, valid for at least three\n"
									"    years, to give any third party, for a charge no more than your\n"
									"    cost of physically performing source distribution, a complete\n"
									"    machine-readable copy of the corresponding source code, to be\n"
									"    distributed under the terms of Sections 1 and 2 above on a medium\n"
									"    customarily used for software interchange; or,\n"
									"\n"
									"    c) Accompany it with the information you received as to the offer\n"
									"    to distribute corresponding source code.  (This alternative is\n"
									"    allowed only for noncommercial distribution and only if you\n"
									"    received the program in object code or executable form with such\n"
									"    an offer, in accord with Subsection b above.)\n"
									"\n"
									"The source code for a work means the preferred form of the work for\n"
									"making modifications to it.  For an executable work, complete source\n"
									"code means all the source code for all modules it contains, plus any\n"
									"associated interface definition files, plus the scripts used to\n"
									"control compilation and installation of the executable.  However, as a\n"
									"special exception, the source code distributed need not include\n"
									"anything that is normally distributed (in either source or binary\n"
									"form) with the major components (compiler, kernel, and so on) of the\n"
									"operating system on which the executable runs, unless that component\n"
									"itself accompanies the executable.\n"
									"\n"
									"If distribution of executable or object code is made by offering\n"
									"access to copy from a designated place, then offering equivalent\n"
									"access to copy the source code from the same place counts as\n"
									"distribution of the source code, even though third parties are not\n"
									"compelled to copy the source along with the object code.\n"
									"\n"
									"  4. You may not copy, modify, sublicense, or distribute the Program\n"
									"except as expressly provided under this License.  Any attempt\n"
									"otherwise to copy, modify, sublicense or distribute the Program is\n"
									"void, and will automatically terminate your rights under this License.\n"
									"However, parties who have received copies, or rights, from you under\n"
									"this License will not have their licenses terminated so long as such\n"
									"parties remain in full compliance.\n"
									"\n"
									"  5. You are not required to accept this License, since you have not\n"
									"signed it.  However, nothing else grants you permission to modify or\n"
									"distribute the Program or its derivative works.  These actions are\n"
									"prohibited by law if you do not accept this License.  Therefore, by\n"
									"modifying or distributing the Program (or any work based on the\n"
									"Program), you indicate your acceptance of this License to do so, and\n"
									"all its terms and conditions for copying, distributing or modifying\n"
									"the Program or works based on it.\n"
									"\n"
									"  6. Each time you redistribute the Program (or any work based on the\n"
									"Program), the recipient automatically receives a license from the\n"
									"original licensor to copy, distribute or modify the Program subject to\n"
									"these terms and conditions.  You may not impose any further\n"
									"restrictions on the recipients' exercise of the rights granted herein.\n"
									"You are not responsible for enforcing compliance by third parties to\n"
									"this License.\n"
									"\n"
									"  7. If, as a consequence of a court judgment or allegation of patent\n"
									"infringement or for any other reason (not limited to patent issues),\n"
									"conditions are imposed on you (whether by court order, agreement or\n"
									"otherwise) that contradict the conditions of this License, they do not\n"
									"excuse you from the conditions of this License.  If you cannot\n"
									"distribute so as to satisfy simultaneously your obligations under this\n"
									"License and any other pertinent obligations, then as a consequence you\n"
									"may not distribute the Program at all.  For example, if a patent\n"
									"license would not permit royalty-free redistribution of the Program by\n"
									"all those who receive copies directly or indirectly through you, then\n"
									"the only way you could satisfy both it and this License would be to\n"
									"refrain entirely from distribution of the Program.\n"
									"\n"
									"If any portion of this section is held invalid or unenforceable under\n"
									"any particular circumstance, the balance of the section is intended to\n"
									"apply and the section as a whole is intended to apply in other\n"
									"circumstances.\n"
									"\n"
									"It is not the purpose of this section to induce you to infringe any\n"
									"patents or other property right claims or to contest validity of any\n"
									"such claims; this section has the sole purpose of protecting the\n"
									"integrity of the free software distribution system, which is\n"
									"implemented by public license practices.  Many people have made\n"
									"generous contributions to the wide range of software distributed\n"
									"through that system in reliance on consistent application of that\n"
									"system; it is up to the author/donor to decide if he or she is willing\n"
									"to distribute software through any other system and a licensee cannot\n"
									"impose that choice.\n"
									"\n"
									"This section is intended to make thoroughly clear what is believed to\n"
									"be a consequence of the rest of this License.\n"
									"\n"
									"  8. If the distribution and/or use of the Program is restricted in\n"
									"certain countries either by patents or by copyrighted interfaces, the\n"
									"original copyright holder who places the Program under this License\n"
									"may add an explicit geographical distribution limitation excluding\n"
									"those countries, so that distribution is permitted only in or among\n"
									"countries not thus excluded.  In such case, this License incorporates\n"
									"the limitation as if written in the body of this License.\n"
									"\n"
									"  9. The Free Software Foundation may publish revised and/or new versions\n"
									"of the General Public License from time to time.  Such new versions will\n"
									"be similar in spirit to the present version, but may differ in detail to\n"
									"address new problems or concerns.\n"
									"\n"
									"Each version is given a distinguishing version number.  If the Program\n"
									"specifies a version number of this License which applies to it and \"any\n"
									"later version\", you have the option of following the terms and conditions\n"
									"either of that version or of any later version published by the Free\n"
									"Software Foundation.  If the Program does not specify a version number of\n"
									"this License, you may choose any version ever published by the Free Software\n"
									"Foundation.\n"
									"\n"
									"  10. If you wish to incorporate parts of the Program into other free\n"
									"programs whose distribution conditions are different, write to the author\n"
									"to ask for permission.  For software which is copyrighted by the Free\n"
									"Software Foundation, write to the Free Software Foundation; we sometimes\n"
									"make exceptions for this.  Our decision will be guided by the two goals\n"
									"of preserving the free status of all derivatives of our free software and\n"
									"of promoting the sharing and reuse of software generally.\n"
									"\n"
									"                            NO WARRANTY\n"
									"\n"
									"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
									"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"
									"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
									"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
									"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
									"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"
									"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"
									"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
									"REPAIR OR CORRECTION.\n"
									"\n"
									"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
									"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
									"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
									"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
									"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
									"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
									"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
									"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
									"POSSIBILITY OF SUCH DAMAGES.\n"
									"\n"
									"                     END OF TERMS AND CONDITIONS\n"
									"\n"
									"            How to Apply These Terms to Your New Programs\n"
									"\n"
									"  If you develop a new program, and you want it to be of the greatest\n"
									"possible use to the public, the best way to achieve this is to make it\n"
									"free software which everyone can redistribute and change under these terms.\n"
									"\n"
									"  To do so, attach the following notices to the program.  It is safest\n"
									"to attach them to the start of each source file to most effectively\n"
									"convey the exclusion of warranty; and each file should have at least\n"
									"the \"copyright\" line and a pointer to where the full notice is found.\n"
									"\n"
									"    <one line to give the program's name and a brief idea of what it does.>\n"
									"    Copyright (C) <year>  <name of author>\n"
									"\n"
									"    This program is free software; you can redistribute it and/or modify\n"
									"    it under the terms of the GNU General Public License as published by\n"
									"    the Free Software Foundation; either version 2 of the License, or\n"
									"    (at your option) any later version.\n"
									"\n"
									"    This program is distributed in the hope that it will be useful,\n"
									"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
									"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
									"    GNU General Public License for more details.\n"
									"\n"
									"    You should have received a copy of the GNU General Public License along\n"
									"    with this program; if not, write to the Free Software Foundation, Inc.,\n"
									"    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n"
									"\n"
									"Also add information on how to contact you by electronic and paper mail.\n"
									"\n"
									"If the program is interactive, make it output a short notice like this\n"
									"when it starts in an interactive mode:\n"
									"\n"
									"    Gnomovision version 69, Copyright (C) year name of author\n"
									"    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n"
									"    This is free software, and you are welcome to redistribute it\n"
									"    under certain conditions; type `show c' for details.\n"
									"\n"
									"The hypothetical commands `show w' and `show c' should show the appropriate\n"
									"parts of the General Public License.  Of course, the commands you use may\n"
									"be called something other than `show w' and `show c'; they could even be\n"
									"mouse-clicks or menu items--whatever suits your program.\n"
									"\n"
									"You should also get your employer (if you work as a programmer) or your\n"
									"school, if any, to sign a \"copyright disclaimer\" for the program, if\n"
									"necessary.  Here is a sample; alter the names:\n"
									"\n"
									"  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n"
									"  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n"
									"\n"
									"  <signature of Ty Coon>, 1 April 1989\n"
									"  Ty Coon, President of Vice\n"
									"\n"
									"This General Public License does not permit incorporating your program into\n"
									"proprietary programs.  If your program is a subroutine library, you may\n"
									"consider it more useful to permit linking proprietary applications with the\n"
									"library.  If this is what you want to do, use the GNU Lesser General\n"
									"Public License instead of this License.";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibdaemon = "Copyright 2003-2009 Lennart Poettering <mzqnrzba (at) 0pointer (dot) de>\n"
									  "\n"
									  "This program is free software; you can redistribute it and/or modify it\n"
									  "under the terms of the GNU Lesser General Public License as published\n"
									  "by the Free Software Foundation, either version 2.1 of the License, or\n"
									  "(at your option) any later version.\n"
									  "\n"
									  "This program is distributed in the hope that it will be useful, but\n"
									  "WITHOUT ANY WARRANTY; without even the implied warranty of\n"
									  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser\n"
									  "General Public License for more details.\n"
									  "\n"
									  "\n"
									  "                  GNU LESSER GENERAL PUBLIC LICENSE\n"
									  "                       Version 2.1, February 1999\n"
									  "\n"
									  " Copyright (C) 1991, 1999 Free Software Foundation, Inc.\n"
									  "	51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n"
									  " Everyone is permitted to copy and distribute verbatim copies\n"
									  " of this license document, but changing it is not allowed.\n"
									  "\n"
									  "[This is the first released version of the Lesser GPL.  It also counts\n"
									  " as the successor of the GNU Library Public License, version 2, hence\n"
									  " the version number 2.1.]\n"
									  "\n"
									  "                            Preamble\n"
									  "\n"
									  "  The licenses for most software are designed to take away your\n"
									  "freedom to share and change it.  By contrast, the GNU General Public\n"
									  "Licenses are intended to guarantee your freedom to share and change\n"
									  "free software--to make sure the software is free for all its users.\n"
									  "\n"
									  "  This license, the Lesser General Public License, applies to some\n"
									  "specially designated software packages--typically libraries--of the\n"
									  "Free Software Foundation and other authors who decide to use it.  You\n"
									  "can use it too, but we suggest you first think carefully about whether\n"
									  "this license or the ordinary General Public License is the better\n"
									  "strategy to use in any particular case, based on the explanations\n"
									  "below.\n"
									  "\n"
									  "  When we speak of free software, we are referring to freedom of use,\n"
									  "not price.  Our General Public Licenses are designed to make sure that\n"
									  "you have the freedom to distribute copies of free software (and charge\n"
									  "for this service if you wish); that you receive source code or can get\n"
									  "it if you want it; that you can change the software and use pieces of\n"
									  "it in new free programs; and that you are informed that you can do\n"
									  "these things.\n"
									  "\n"
									  "  To protect your rights, we need to make restrictions that forbid\n"
									  "distributors to deny you these rights or to ask you to surrender these\n"
									  "rights.  These restrictions translate to certain responsibilities for\n"
									  "you if you distribute copies of the library or if you modify it.\n"
									  "\n"
									  "  For example, if you distribute copies of the library, whether gratis\n"
									  "or for a fee, you must give the recipients all the rights that we gave\n"
									  "you.  You must make sure that they, too, receive or can get the source\n"
									  "code.  If you link other code with the library, you must provide\n"
									  "complete object files to the recipients, so that they can relink them\n"
									  "with the library after making changes to the library and recompiling\n"
									  "it.  And you must show them these terms so they know their rights.\n"
									  "\n"
									  "  We protect your rights with a two-step method: (1) we copyright the\n"
									  "library, and (2) we offer you this license, which gives you legal\n"
									  "permission to copy, distribute and/or modify the library.\n"
									  "\n"
									  "  To protect each distributor, we want to make it very clear that\n"
									  "there is no warranty for the free library.  Also, if the library is\n"
									  "modified by someone else and passed on, the recipients should know\n"
									  "that what they have is not the original version, so that the original\n"
									  "author's reputation will not be affected by problems that might be\n"
									  "introduced by others.\n"
									  "\n"
									  "  Finally, software patents pose a constant threat to the existence of\n"
									  "any free program.  We wish to make sure that a company cannot\n"
									  "effectively restrict the users of a free program by obtaining a\n"
									  "restrictive license from a patent holder.  Therefore, we insist that\n"
									  "any patent license obtained for a version of the library must be\n"
									  "consistent with the full freedom of use specified in this license.\n"
									  "\n"
									  "  Most GNU software, including some libraries, is covered by the\n"
									  "ordinary GNU General Public License.  This license, the GNU Lesser\n"
									  "General Public License, applies to certain designated libraries, and\n"
									  "is quite different from the ordinary General Public License.  We use\n"
									  "this license for certain libraries in order to permit linking those\n"
									  "libraries into non-free programs.\n"
									  "\n"
									  "  When a program is linked with a library, whether statically or using\n"
									  "a shared library, the combination of the two is legally speaking a\n"
									  "combined work, a derivative of the original library.  The ordinary\n"
									  "General Public License therefore permits such linking only if the\n"
									  "entire combination fits its criteria of freedom.  The Lesser General\n"
									  "Public License permits more lax criteria for linking other code with\n"
									  "the library.\n"
									  "\n"
									  "  We call this license the \"Lesser\" General Public License because it\n"
									  "does Less to protect the user's freedom than the ordinary General\n"
									  "Public License.  It also provides other free software developers Less\n"
									  "of an advantage over competing non-free programs.  These disadvantages\n"
									  "are the reason we use the ordinary General Public License for many\n"
									  "libraries.  However, the Lesser license provides advantages in certain\n"
									  "special circumstances.\n"
									  "\n"
									  "  For example, on rare occasions, there may be a special need to\n"
									  "encourage the widest possible use of a certain library, so that it\n"
									  "becomes a de-facto standard.  To achieve this, non-free programs must\n"
									  "be allowed to use the library.  A more frequent case is that a free\n"
									  "library does the same job as widely used non-free libraries.  In this\n"
									  "case, there is little to gain by limiting the free library to free\n"
									  "software only, so we use the Lesser General Public License.\n"
									  "\n"
									  "  In other cases, permission to use a particular library in non-free\n"
									  "programs enables a greater number of people to use a large body of\n"
									  "free software.  For example, permission to use the GNU C Library in\n"
									  "non-free programs enables many more people to use the whole GNU\n"
									  "operating system, as well as its variant, the GNU/Linux operating\n"
									  "system.\n"
									  "\n"
									  "  Although the Lesser General Public License is Less protective of the\n"
									  "users' freedom, it does ensure that the user of a program that is\n"
									  "linked with the Library has the freedom and the wherewithal to run\n"
									  "that program using a modified version of the Library.\n"
									  "\n"
									  "  The precise terms and conditions for copying, distribution and\n"
									  "modification follow.  Pay close attention to the difference between a\n"
									  "\"work based on the library\" and a \"work that uses the library\".  The\n"
									  "former contains code derived from the library, whereas the latter must\n"
									  "be combined with the library in order to run.\n"
									  "\n"
									  "                  GNU LESSER GENERAL PUBLIC LICENSE\n"
									  "   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
									  "\n"
									  "  0. This License Agreement applies to any software library or other\n"
									  "program which contains a notice placed by the copyright holder or\n"
									  "other authorized party saying it may be distributed under the terms of\n"
									  "this Lesser General Public License (also called \"this License\").\n"
									  "Each licensee is addressed as \"you\".\n"
									  "\n"
									  "  A \"library\" means a collection of software functions and/or data\n"
									  "prepared so as to be conveniently linked with application programs\n"
									  "(which use some of those functions and data) to form executables.\n"
									  "\n"
									  "  The \"Library\", below, refers to any such software library or work\n"
									  "which has been distributed under these terms.  A \"work based on the\n"
									  "Library\" means either the Library or any derivative work under\n"
									  "copyright law: that is to say, a work containing the Library or a\n"
									  "portion of it, either verbatim or with modifications and/or translated\n"
									  "straightforwardly into another language.  (Hereinafter, translation is\n"
									  "included without limitation in the term \"modification\".)\n"
									  "\n"
									  "  \"Source code\" for a work means the preferred form of the work for\n"
									  "making modifications to it.  For a library, complete source code means\n"
									  "all the source code for all modules it contains, plus any associated\n"
									  "interface definition files, plus the scripts used to control\n"
									  "compilation and installation of the library.\n"
									  "\n"
									  "  Activities other than copying, distribution and modification are not\n"
									  "covered by this License; they are outside its scope.  The act of\n"
									  "running a program using the Library is not restricted, and output from\n"
									  "such a program is covered only if its contents constitute a work based\n"
									  "on the Library (independent of the use of the Library in a tool for\n"
									  "writing it).  Whether that is true depends on what the Library does\n"
									  "and what the program that uses the Library does.\n"
									  "\n"
									  "  1. You may copy and distribute verbatim copies of the Library's\n"
									  "complete source code as you receive it, in any medium, provided that\n"
									  "you conspicuously and appropriately publish on each copy an\n"
									  "appropriate copyright notice and disclaimer of warranty; keep intact\n"
									  "all the notices that refer to this License and to the absence of any\n"
									  "warranty; and distribute a copy of this License along with the\n"
									  "Library.\n"
									  "\n"
									  "  You may charge a fee for the physical act of transferring a copy,\n"
									  "and you may at your option offer warranty protection in exchange for a\n"
									  "fee.\n"
									  "\n"
									  "  2. You may modify your copy or copies of the Library or any portion\n"
									  "of it, thus forming a work based on the Library, and copy and\n"
									  "distribute such modifications or work under the terms of Section 1\n"
									  "above, provided that you also meet all of these conditions:\n"
									  "\n"
									  "    a) The modified work must itself be a software library.\n"
									  "\n"
									  "    b) You must cause the files modified to carry prominent notices\n"
									  "    stating that you changed the files and the date of any change.\n"
									  "\n"
									  "    c) You must cause the whole of the work to be licensed at no\n"
									  "    charge to all third parties under the terms of this License.\n"
									  "\n"
									  "    d) If a facility in the modified Library refers to a function or a\n"
									  "    table of data to be supplied by an application program that uses\n"
									  "    the facility, other than as an argument passed when the facility\n"
									  "    is invoked, then you must make a good faith effort to ensure that,\n"
									  "    in the event an application does not supply such function or\n"
									  "    table, the facility still operates, and performs whatever part of\n"
									  "    its purpose remains meaningful.\n"
									  "\n"
									  "    (For example, a function in a library to compute square roots has\n"
									  "    a purpose that is entirely well-defined independent of the\n"
									  "    application.  Therefore, Subsection 2d requires that any\n"
									  "    application-supplied function or table used by this function must\n"
									  "    be optional: if the application does not supply it, the square\n"
									  "    root function must still compute square roots.)\n"
									  "\n"
									  "These requirements apply to the modified work as a whole.  If\n"
									  "identifiable sections of that work are not derived from the Library,\n"
									  "and can be reasonably considered independent and separate works in\n"
									  "themselves, then this License, and its terms, do not apply to those\n"
									  "sections when you distribute them as separate works.  But when you\n"
									  "distribute the same sections as part of a whole which is a work based\n"
									  "on the Library, the distribution of the whole must be on the terms of\n"
									  "this License, whose permissions for other licensees extend to the\n"
									  "entire whole, and thus to each and every part regardless of who wrote\n"
									  "it.\n"
									  "\n"
									  "Thus, it is not the intent of this section to claim rights or contest\n"
									  "your rights to work written entirely by you; rather, the intent is to\n"
									  "exercise the right to control the distribution of derivative or\n"
									  "collective works based on the Library.\n"
									  "\n"
									  "In addition, mere aggregation of another work not based on the Library\n"
									  "with the Library (or with a work based on the Library) on a volume of\n"
									  "a storage or distribution medium does not bring the other work under\n"
									  "the scope of this License.\n"
									  "\n"
									  "  3. You may opt to apply the terms of the ordinary GNU General Public\n"
									  "License instead of this License to a given copy of the Library.  To do\n"
									  "this, you must alter all the notices that refer to this License, so\n"
									  "that they refer to the ordinary GNU General Public License, version 2,\n"
									  "instead of to this License.  (If a newer version than version 2 of the\n"
									  "ordinary GNU General Public License has appeared, then you can specify\n"
									  "that version instead if you wish.)  Do not make any other change in\n"
									  "these notices.\n"
									  "\n"
									  "  Once this change is made in a given copy, it is irreversible for\n"
									  "that copy, so the ordinary GNU General Public License applies to all\n"
									  "subsequent copies and derivative works made from that copy.\n"
									  "\n"
									  "  This option is useful when you wish to copy part of the code of\n"
									  "the Library into a program that is not a library.\n"
									  "\n"
									  "  4. You may copy and distribute the Library (or a portion or\n"
									  "derivative of it, under Section 2) in object code or executable form\n"
									  "under the terms of Sections 1 and 2 above provided that you accompany\n"
									  "it with the complete corresponding machine-readable source code, which\n"
									  "must be distributed under the terms of Sections 1 and 2 above on a\n"
									  "medium customarily used for software interchange.\n"
									  "\n"
									  "  If distribution of object code is made by offering access to copy\n"
									  "from a designated place, then offering equivalent access to copy the\n"
									  "source code from the same place satisfies the requirement to\n"
									  "distribute the source code, even though third parties are not\n"
									  "compelled to copy the source along with the object code.\n"
									  "\n"
									  "  5. A program that contains no derivative of any portion of the\n"
									  "Library, but is designed to work with the Library by being compiled or\n"
									  "linked with it, is called a \"work that uses the Library\".  Such a\n"
									  "work, in isolation, is not a derivative work of the Library, and\n"
									  "therefore falls outside the scope of this License.\n"
									  "\n"
									  "  However, linking a \"work that uses the Library\" with the Library\n"
									  "creates an executable that is a derivative of the Library (because it\n"
									  "contains portions of the Library), rather than a \"work that uses the\n"
									  "library\".  The executable is therefore covered by this License.\n"
									  "Section 6 states terms for distribution of such executables.\n"
									  "\n"
									  "  When a \"work that uses the Library\" uses material from a header file\n"
									  "that is part of the Library, the object code for the work may be a\n"
									  "derivative work of the Library even though the source code is not.\n"
									  "Whether this is true is especially significant if the work can be\n"
									  "linked without the Library, or if the work is itself a library.  The\n"
									  "threshold for this to be true is not precisely defined by law.\n"
									  "\n"
									  "  If such an object file uses only numerical parameters, data\n"
									  "structure layouts and accessors, and small macros and small inline\n"
									  "functions (ten lines or less in length), then the use of the object\n"
									  "file is unrestricted, regardless of whether it is legally a derivative\n"
									  "work.  (Executables containing this object code plus portions of the\n"
									  "Library will still fall under Section 6.)\n"
									  "\n"
									  "  Otherwise, if the work is a derivative of the Library, you may\n"
									  "distribute the object code for the work under the terms of Section 6.\n"
									  "Any executables containing that work also fall under Section 6,\n"
									  "whether or not they are linked directly with the Library itself.\n"
									  "\n"
									  "  6. As an exception to the Sections above, you may also combine or\n"
									  "link a \"work that uses the Library\" with the Library to produce a\n"
									  "work containing portions of the Library, and distribute that work\n"
									  "under terms of your choice, provided that the terms permit\n"
									  "modification of the work for the customer's own use and reverse\n"
									  "engineering for debugging such modifications.\n"
									  "\n"
									  "  You must give prominent notice with each copy of the work that the\n"
									  "Library is used in it and that the Library and its use are covered by\n"
									  "this License.  You must supply a copy of this License.  If the work\n"
									  "during execution displays copyright notices, you must include the\n"
									  "copyright notice for the Library among them, as well as a reference\n"
									  "directing the user to the copy of this License.  Also, you must do one\n"
									  "of these things:\n"
									  "\n"
									  "    a) Accompany the work with the complete corresponding\n"
									  "    machine-readable source code for the Library including whatever\n"
									  "    changes were used in the work (which must be distributed under\n"
									  "    Sections 1 and 2 above); and, if the work is an executable linked\n"
									  "    with the Library, with the complete machine-readable \"work that\n"
									  "    uses the Library\", as object code and/or source code, so that the\n"
									  "    user can modify the Library and then relink to produce a modified\n"
									  "    executable containing the modified Library.  (It is understood\n"
									  "    that the user who changes the contents of definitions files in the\n"
									  "    Library will not necessarily be able to recompile the application\n"
									  "    to use the modified definitions.)\n"
									  "\n"
									  "    b) Use a suitable shared library mechanism for linking with the\n"
									  "    Library.  A suitable mechanism is one that (1) uses at run time a\n"
									  "    copy of the library already present on the user's computer system,\n"
									  "    rather than copying library functions into the executable, and (2)\n"
									  "    will operate properly with a modified version of the library, if\n"
									  "    the user installs one, as long as the modified version is\n"
									  "    interface-compatible with the version that the work was made with.\n"
									  "\n"
									  "    c) Accompany the work with a written offer, valid for at least\n"
									  "    three years, to give the same user the materials specified in\n"
									  "    Subsection 6a, above, for a charge no more than the cost of\n"
									  "    performing this distribution.\n"
									  "\n"
									  "    d) If distribution of the work is made by offering access to copy\n"
									  "    from a designated place, offer equivalent access to copy the above\n"
									  "    specified materials from the same place.\n"
									  "\n"
									  "    e) Verify that the user has already received a copy of these\n"
									  "    materials or that you have already sent this user a copy.\n"
									  "\n"
									  "  For an executable, the required form of the \"work that uses the\n"
									  "Library\" must include any data and utility programs needed for\n"
									  "reproducing the executable from it.  However, as a special exception,\n"
									  "the materials to be distributed need not include anything that is\n"
									  "normally distributed (in either source or binary form) with the major\n"
									  "components (compiler, kernel, and so on) of the operating system on\n"
									  "which the executable runs, unless that component itself accompanies\n"
									  "the executable.\n"
									  "\n"
									  "  It may happen that this requirement contradicts the license\n"
									  "restrictions of other proprietary libraries that do not normally\n"
									  "accompany the operating system.  Such a contradiction means you cannot\n"
									  "use both them and the Library together in an executable that you\n"
									  "distribute.\n"
									  "\n"
									  "  7. You may place library facilities that are a work based on the\n"
									  "Library side-by-side in a single library together with other library\n"
									  "facilities not covered by this License, and distribute such a combined\n"
									  "library, provided that the separate distribution of the work based on\n"
									  "the Library and of the other library facilities is otherwise\n"
									  "permitted, and provided that you do these two things:\n"
									  "\n"
									  "    a) Accompany the combined library with a copy of the same work\n"
									  "    based on the Library, uncombined with any other library\n"
									  "    facilities.  This must be distributed under the terms of the\n"
									  "    Sections above.\n"
									  "\n"
									  "    b) Give prominent notice with the combined library of the fact\n"
									  "    that part of it is a work based on the Library, and explaining\n"
									  "    where to find the accompanying uncombined form of the same work.\n"
									  "\n"
									  "  8. You may not copy, modify, sublicense, link with, or distribute\n"
									  "the Library except as expressly provided under this License.  Any\n"
									  "attempt otherwise to copy, modify, sublicense, link with, or\n"
									  "distribute the Library is void, and will automatically terminate your\n"
									  "rights under this License.  However, parties who have received copies,\n"
									  "or rights, from you under this License will not have their licenses\n"
									  "terminated so long as such parties remain in full compliance.\n"
									  "\n"
									  "  9. You are not required to accept this License, since you have not\n"
									  "signed it.  However, nothing else grants you permission to modify or\n"
									  "distribute the Library or its derivative works.  These actions are\n"
									  "prohibited by law if you do not accept this License.  Therefore, by\n"
									  "modifying or distributing the Library (or any work based on the\n"
									  "Library), you indicate your acceptance of this License to do so, and\n"
									  "all its terms and conditions for copying, distributing or modifying\n"
									  "the Library or works based on it.\n"
									  "\n"
									  "  10. Each time you redistribute the Library (or any work based on the\n"
									  "Library), the recipient automatically receives a license from the\n"
									  "original licensor to copy, distribute, link with or modify the Library\n"
									  "subject to these terms and conditions.  You may not impose any further\n"
									  "restrictions on the recipients' exercise of the rights granted herein.\n"
									  "You are not responsible for enforcing compliance by third parties with\n"
									  "this License.\n"
									  "\n"
									  "  11. If, as a consequence of a court judgment or allegation of patent\n"
									  "infringement or for any other reason (not limited to patent issues),\n"
									  "conditions are imposed on you (whether by court order, agreement or\n"
									  "otherwise) that contradict the conditions of this License, they do not\n"
									  "excuse you from the conditions of this License.  If you cannot\n"
									  "distribute so as to satisfy simultaneously your obligations under this\n"
									  "License and any other pertinent obligations, then as a consequence you\n"
									  "may not distribute the Library at all.  For example, if a patent\n"
									  "license would not permit royalty-free redistribution of the Library by\n"
									  "all those who receive copies directly or indirectly through you, then\n"
									  "the only way you could satisfy both it and this License would be to\n"
									  "refrain entirely from distribution of the Library.\n"
									  "\n"
									  "If any portion of this section is held invalid or unenforceable under\n"
									  "any particular circumstance, the balance of the section is intended to\n"
									  "apply, and the section as a whole is intended to apply in other\n"
									  "circumstances.\n"
									  "\n"
									  "It is not the purpose of this section to induce you to infringe any\n"
									  "patents or other property right claims or to contest validity of any\n"
									  "such claims; this section has the sole purpose of protecting the\n"
									  "integrity of the free software distribution system which is\n"
									  "implemented by public license practices.  Many people have made\n"
									  "generous contributions to the wide range of software distributed\n"
									  "through that system in reliance on consistent application of that\n"
									  "system; it is up to the author/donor to decide if he or she is willing\n"
									  "to distribute software through any other system and a licensee cannot\n"
									  "impose that choice.\n"
									  "\n"
									  "This section is intended to make thoroughly clear what is believed to\n"
									  "be a consequence of the rest of this License.\n"
									  "\n"
									  "  12. If the distribution and/or use of the Library is restricted in\n"
									  "certain countries either by patents or by copyrighted interfaces, the\n"
									  "original copyright holder who places the Library under this License\n"
									  "may add an explicit geographical distribution limitation excluding those\n"
									  "countries, so that distribution is permitted only in or among\n"
									  "countries not thus excluded.  In such case, this License incorporates\n"
									  "the limitation as if written in the body of this License.\n"
									  "\n"
									  "  13. The Free Software Foundation may publish revised and/or new\n"
									  "versions of the Lesser General Public License from time to time.\n"
									  "Such new versions will be similar in spirit to the present version,\n"
									  "but may differ in detail to address new problems or concerns.\n"
									  "\n"
									  "Each version is given a distinguishing version number.  If the Library\n"
									  "specifies a version number of this License which applies to it and\n"
									  "\"any later version\", you have the option of following the terms and\n"
									  "conditions either of that version or of any later version published by\n"
									  "the Free Software Foundation.  If the Library does not specify a\n"
									  "license version number, you may choose any version ever published by\n"
									  "the Free Software Foundation.\n"
									  "\n"
									  "  14. If you wish to incorporate parts of the Library into other free\n"
									  "programs whose distribution conditions are incompatible with these,\n"
									  "write to the author to ask for permission.  For software which is\n"
									  "copyrighted by the Free Software Foundation, write to the Free\n"
									  "Software Foundation; we sometimes make exceptions for this.  Our\n"
									  "decision will be guided by the two goals of preserving the free status\n"
									  "of all derivatives of our free software and of promoting the sharing\n"
									  "and reuse of software generally.\n"
									  "\n"
									  "                            NO WARRANTY\n"
									  "\n"
									  "  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO\n"
									  "WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.\n"
									  "EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR\n"
									  "OTHER PARTIES PROVIDE THE LIBRARY \"AS IS\" WITHOUT WARRANTY OF ANY\n"
									  "KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE\n"
									  "IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
									  "PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE\n"
									  "LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME\n"
									  "THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n"
									  "\n"
									  "  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN\n"
									  "WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY\n"
									  "AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU\n"
									  "FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR\n"
									  "CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE\n"
									  "LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING\n"
									  "RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A\n"
									  "FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF\n"
									  "SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH\n"
									  "DAMAGES.\n"
									  "\n"
									  "                     END OF TERMS AND CONDITIONS\n"
									  "\n"
									  "           How to Apply These Terms to Your New Libraries\n"
									  "\n"
									  "  If you develop a new library, and you want it to be of the greatest\n"
									  "possible use to the public, we recommend making it free software that\n"
									  "everyone can redistribute and change.  You can do so by permitting\n"
									  "redistribution under these terms (or, alternatively, under the terms\n"
									  "of the ordinary General Public License).\n"
									  "\n"
									  "  To apply these terms, attach the following notices to the library.\n"
									  "It is safest to attach them to the start of each source file to most\n"
									  "effectively convey the exclusion of warranty; and each file should\n"
									  "have at least the \"copyright\" line and a pointer to where the full\n"
									  "notice is found.\n"
									  "\n"
									  "\n"
									  "    <one line to give the library's name and a brief idea of what it does.>\n"
									  "    Copyright (C) <year>  <name of author>\n"
									  "\n"
									  "    This library is free software; you can redistribute it and/or\n"
									  "    modify it under the terms of the GNU Lesser General Public\n"
									  "    License as published by the Free Software Foundation; either\n"
									  "    version 2.1 of the License, or (at your option) any later version.\n"
									  "\n"
									  "    This library is distributed in the hope that it will be useful,\n"
									  "    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
									  "    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
									  "    Lesser General Public License for more details.\n"
									  "\n"
									  "    You should have received a copy of the GNU Lesser General Public\n"
									  "    License along with this library; if not, write to the Free Software\n"
									  "    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n"
									  "\n"
									  "Also add information on how to contact you by electronic and paper mail.\n"
									  "\n"
									  "You should also get your employer (if you work as a programmer) or\n"
									  "your school, if any, to sign a \"copyright disclaimer\" for the library,\n"
									  "if necessary.  Here is a sample; alter the names:\n"
									  "\n"
									  "  Yoyodyne, Inc., hereby disclaims all copyright interest in the\n"
									  "  library `Frob' (a library for tweaking knobs) written by James\n"
									  "  Random Hacker.\n"
									  "\n"
									  "  <signature of Ty Coon>, 1 April 1990\n"
									  "  Ty Coon, President of Vice\n"
									  "\n"
									  "That's all there is to it!";
#endif


#ifdef USE_BUILDENV
static const char *licenseLibffi = "libffi - Copyright (c) 1996-2014  Anthony Green, Red Hat, Inc and others.\n"
								   "See source files for details.\n"
								   "\n"
								   "Permission is hereby granted, free of charge, to any person obtaining\n"
								   "a copy of this software and associated documentation files (the\n"
								   "``Software''), to deal in the Software without restriction, including\n"
								   "without limitation the rights to use, copy, modify, merge, publish,\n"
								   "distribute, sublicense, and/or sell copies of the Software, and to\n"
								   "permit persons to whom the Software is furnished to do so, subject to\n"
								   "the following conditions:\n"
								   "\n"
								   "The above copyright notice and this permission notice shall be\n"
								   "included in all copies or substantial portions of the Software.\n"
								   "\n"
								   "THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,\n"
								   "EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
								   "MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
								   "IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\n"
								   "CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n"
								   "TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\n"
								   "SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.";
#endif


static const ThirdPartyLicense licenses3rdParties[] = {
	ThirdPartyLicense("CELT", "http://www.celt-codec.org/", licenseCELT),
	ThirdPartyLicense("Opus", "https://www.opus-codec.org/", licenseOpus),
	ThirdPartyLicense("Speex", "https://www.speex.org/", licenseSPEEX),
	ThirdPartyLicense("OpenSSL", "https://www.openssl.org/", licenseOpenSSL),
	ThirdPartyLicense("libsndfile", "http://www.mega-nerd.com/libsndfile/", licenseLibsndfile),
	ThirdPartyLicense("libogg", "https://www.xiph.org/", licenseOgg),
	ThirdPartyLicense("libvorbis", "https://www.xiph.org/", licenseVorbis),
	ThirdPartyLicense("libFLAC", "http://flac.sourceforge.net/", licenseFLAC),
#ifdef Q_OS_MAC
	ThirdPartyLicense("mach_override", "https://github.com/rentzsch/mach_star", licenseMachOverride),
#endif
#ifdef Q_OS_WIN64
	ThirdPartyLicense("MinHook", "https://github.com/TsudaKageyu/minhook", licenseMinHook),
#endif
#ifdef USING_BUNDLED_QT_TRANSLATIONS
	ThirdPartyLicense("Additional Qt translations", "https://www.virtualbox.org/ticket/2018", licenseQtTranslations),
#endif
	ThirdPartyLicense("Emoji One artwork", "http://emojione.com/", licenseEmojiOne),
	ThirdPartyLicense("XInputCheck (SDL_IsXInput function)", "https://www.libsdl.org/", licenseXInputCheck),
	ThirdPartyLicense("QQBonjour", "https://doc.qt.io/archives/qq/qq23-bonjour.html", licenseQQBonjour),
	ThirdPartyLicense("smallft", "https://www.xiph.org", licenseSmallFT),
	ThirdPartyLicense("Old-style Mumble license headers", "https://www.mumble.info", licenseOldStyleLicenseHeaders),
	ThirdPartyLicense("arc4random_uniform", "https://www.openbsd.org", licenseArc4RandomUniform),
#ifdef USE_BUILDENV
	ThirdPartyLicense("MariaDB Connector/C", "https://www.mariadb.org", licenseMariaDBCConnector),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("ZLIB", "https://www.zlib.net", licenseZlib),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Protobuf", "https://developers.google.com/protocol-buffers", licenseProtobuf),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Expat", "http://libexpat.org", licenseExpat),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Boost C++ Libraries", "https://www.boost.org/", licenseBoost),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("bzip2", "http://www.bzip.org", licenseBzip2),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("BerkeleyDB", "https://www.oracle.com/database/berkeley-db", licenseBerkeleyDB),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Freetype", "https://www.freetype.org/", licenseFreetype),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("HarfBuzz", "https://www.freedesktop.org/wiki/Software/HarfBuzz", licenseHarfBuzzNG),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("LibPNG", "http://www.libpng.org/pub/png/libpng.html", licenseLibPNG),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("libjpeg-turbo", "http://www.libjpeg-turbo.org", licenseLibjpegTurbo),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("ZeroC Ice", "https://zeroc.com/", licenseZeroCIce),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("mcpp", "http://mcpp.sourceforge.net/", licenseMcpp),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("mDNSResponder", "https://opensource.apple.com/tarballs/mDNSResponder/", licenseMDNSResponder),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("PCRE", "http://www.pcre.org/", licensePCRE),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Qt", "https://www.qt.io/", licenseQt),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("SQLite3", "http://sqlite.org", licenseSQLite3),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("XAR", "https://opensource.apple.com/source/xar/", licenseXar),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("Avahi", "https://www.avahi.org/", licenseAvahi),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("D-Bus", "https://www.freedesktop.org/wiki/Software/dbus", licenseDBus),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("AppImage Runtime", "http://www.appimage.org", licenseAppImageRuntime),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("squashfuse", "https://github.com/vasi/squashfuse", licenseSquashfuse),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("libfuse", "https://github.com/libfuse/libfuse/", licenseLibfuse),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("glib", "https://developer.gnome.org/glib/", licenseGlib),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("libcap2", "https://sites.google.com/site/fullycapable/", licenseLibcap2),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("libdaemon", "http://0pointer.de/lennart/projects/libdaemon/", licenseLibdaemon),
#endif
#ifdef USE_BUILDENV
	ThirdPartyLicense("libffi", "https://sourceware.org/libffi/", licenseLibffi),
#endif
	ThirdPartyLicense(),
};


#endif
