/* $NetBSD$ */

/*-
 * Copyright (C) 2006 Jared D. McNeill <jmcneill@invisible.ca>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jared D. McNeill.
 * 4. Neither the name of the author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MTFTPD_CONF_H
#define _MTFTPD_CONF_H

#include <sys/param.h>
#include <sys/queue.h>
#include <netinet/in.h>
#include <prop/proplib.h>

typedef struct mtftpd_file {
	/* configuration */
	char		mf_filename[MAXPATHLEN];
	char		mf_filepath[MAXPATHLEN];
	struct in_addr	mf_inetaddr;
	uint16_t	mf_port;
	uint32_t	mf_packetdelay;
	uint32_t	mf_retry;
	uint32_t	mf_burst;
	/* private members */
	pthread_mutex_t	mf_lock;
	pthread_t	mf_thread;
	int		mf_sendcnt;
	int		mf_running;
	int		mf_sock;
	char *		mf_buf;
	int		mf_fd;
	/* list */
	TAILQ_ENTRY(mtftpd_file) mf_files;
} mtftpd_file_t;

typedef struct mtftpd_conf {
	uint16_t	mc_port;
	uint16_t	mc_blksize;
	char		mc_tftproot[MAXPATHLEN];
	uint8_t		mc_ttl;
	TAILQ_HEAD(mf_listhead, mtftpd_file) mc_mf;
} mtftpd_conf_t;

void			conf_init(void);
mtftpd_conf_t *		conf_reload(const char *);

#endif /* !_MTFTPD_CONF_H */
