// Code generated by yy. DO NOT EDIT.

// Copyright 2017 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc

import (
	"fmt"
)

func ExampleAbstractDeclarator_pointer() {
	fmt.Println(exampleAST(177, "\U00100000 ( _Bool * )"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Pointer: &cc.Pointer{
	// · · Token: '*',
	// · },
	// }
}

func ExampleAbstractDeclarator_abstract() {
	fmt.Println(exampleAST(178, "\U00100000 ( _Bool ( ) )"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Case: 1,
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 1,
	// · · Token: '(',
	// · · Token2: ')',
	// · },
	// }
}

func ExampleAbstractDeclaratorOpt_case0() {
	fmt.Println(exampleAST(179, "\U00100000 ( _Bool )") == (*AbstractDeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleAbstractDeclaratorOpt_case1() {
	fmt.Println(exampleAST(180, "\U00100000 ( _Bool * )"))
	// Output:
	// &cc.AbstractDeclaratorOpt{
	// · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · Pointer: &cc.Pointer{
	// · · · Token: '*',
	// · · },
	// · },
	// }
}

func ExampleArgumentExprList_case0() {
	fmt.Println(exampleAST(4, "\U00100000 'a' ( 'b' )"))
	// Output:
	// &cc.ArgumentExprList{
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// }
}

func ExampleArgumentExprList_case1() {
	fmt.Println(exampleAST(5, "\U00100000 'a' ( 'b' , 'c' )"))
	// Output:
	// &cc.ArgumentExprList{
	// · ArgumentExprList: &cc.ArgumentExprList{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'c'",
	// · · },
	// · · Token: ',',
	// · },
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// }
}

func ExampleArgumentExprListOpt_case0() {
	fmt.Println(exampleAST(6, "\U00100000 'a' ( )") == (*ArgumentExprListOpt)(nil))
	// Output:
	// true
}

func ExampleArgumentExprListOpt_case1() {
	fmt.Println(exampleAST(7, "\U00100000 'a' ( 'b' )"))
	// Output:
	// &cc.ArgumentExprListOpt{
	// · ArgumentExprList: &cc.ArgumentExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// }
}

func ExampleBlockItem_decl() {
	fmt.Println(exampleAST(219, "\U00100001 a { auto ; !"))
	// Output:
	// &cc.BlockItem{
	// · Declaration: &cc.Declaration{
	// · · Scope: &cc.Scope{
	// · · },
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: 2,
	// · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · Case: 3,
	// · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · Case: 2,
	// · · · · · · · · Token: CHAR "char",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · Token: CONST "const",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: STATIC "static",
	// · · · },
	// · · },
	// · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · Case: 1,
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · Linkage: LinkageNone,
	// · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · },
	// · · · · · · · Token: '[',
	// · · · · · · · Token2: ']',
	// · · · · · · },
	// · · · · · },
	// · · · · · Initializer: &cc.Initializer{
	// · · · · · · Case: 1,
	// · · · · · · Expr: &cc.Expr{
	// · · · · · · · Case: ExprString,
	// · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · },
	// · · · · · },
	// · · · · · Token: '=',
	// · · · · },
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// }
}

func ExampleBlockItem_stmt() {
	fmt.Println(exampleAST(220, "\U00100001 a { ; !"))
	// Output:
	// &cc.BlockItem{
	// · Case: 1,
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleBlockItemList_case0() {
	fmt.Println(exampleAST(215, "\U00100001 a { ; !"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Declaration: &cc.Declaration{
	// · · · Scope: &cc.Scope{
	// · · · },
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · Case: 2,
	// · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · Case: 3,
	// · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · Case: 2,
	// · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · Token: CONST "const",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: STATIC "static",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · Case: 1,
	// · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · Linkage: LinkageNone,
	// · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · },
	// · · · · · · · · Token: '[',
	// · · · · · · · · Token2: ']',
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · Case: 1,
	// · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · Case: ExprString,
	// · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Token: '=',
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleBlockItemList_case1() {
	fmt.Println(exampleAST(216, "\U00100001 a { ; ; !"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Declaration: &cc.Declaration{
	// · · · Scope: &cc.Scope{
	// · · · },
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · Case: 2,
	// · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · Case: 3,
	// · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · Case: 2,
	// · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · Token: CONST "const",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: STATIC "static",
	// · · · · },
	// · · · },
	// · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · Case: 1,
	// · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · Linkage: LinkageNone,
	// · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · },
	// · · · · · · · · Token: '[',
	// · · · · · · · · Token2: ']',
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · Case: 1,
	// · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · Case: ExprString,
	// · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Token: '=',
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Case: 1,
	// · · · Stmt: &cc.Stmt{
	// · · · · Case: 1,
	// · · · · ExprStmt: &cc.ExprStmt{
	// · · · · · Token: ';',
	// · · · · },
	// · · · },
	// · · },
	// · · Case: 1,
	// · },
	// }
}

func ExampleBlockItemListOpt_case0() {
	fmt.Println(exampleAST(217, "\U00100001 a { }") == (*BlockItemListOpt)(nil))
	// Output:
	// false
}

func ExampleBlockItemListOpt_case1() {
	fmt.Println(exampleAST(218, "\U00100001 a { ; }"))
	// Output:
	// &cc.BlockItemListOpt{
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Declaration: &cc.Declaration{
	// · · · · Scope: &cc.Scope{
	// · · · · },
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: 1,
	// · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · Case: 2,
	// · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · Case: 3,
	// · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · Case: 2,
	// · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · Token: CONST "const",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Case: 3,
	// · · · · · · Token: STATIC "static",
	// · · · · · },
	// · · · · },
	// · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · Case: 1,
	// · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · },
	// · · · · · · · · · Token: '[',
	// · · · · · · · · · Token2: ']',
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · Case: 1,
	// · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · Case: ExprString,
	// · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Token: '=',
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: ';',
	// · · · },
	// · · },
	// · · BlockItemList: &cc.BlockItemList{
	// · · · BlockItem: &cc.BlockItem{
	// · · · · Case: 1,
	// · · · · Stmt: &cc.Stmt{
	// · · · · · Case: 1,
	// · · · · · ExprStmt: &cc.ExprStmt{
	// · · · · · · Token: ';',
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Case: 1,
	// · · },
	// · },
	// }
}

func ExampleCommaOpt_case0() {
	fmt.Println(exampleAST(129, "\U00100000 ( _Bool ) { }") == (*CommaOpt)(nil))
	// Output:
	// true
}

func ExampleCommaOpt_case1() {
	fmt.Println(exampleAST(130, "\U00100001 auto a = { , }"))
	// Output:
	// &cc.CommaOpt{
	// · Token: ',',
	// }
}

func ExampleCompoundStmt_case0() {
	fmt.Println(exampleAST(214, "\U00100001 a { }"))
	// Output:
	// &cc.CompoundStmt{
	// · BlockItemListOpt: &cc.BlockItemListOpt{
	// · · BlockItemList: &cc.BlockItemList{
	// · · · BlockItem: &cc.BlockItem{
	// · · · · Declaration: &cc.Declaration{
	// · · · · · Scope: &cc.Scope{
	// · · · · · },
	// · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · Case: 1,
	// · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · Case: 2,
	// · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · Case: 3,
	// · · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · · Token: CONST "const",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · · Case: 3,
	// · · · · · · · Token: STATIC "static",
	// · · · · · · },
	// · · · · · },
	// · · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · · Case: 1,
	// · · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · · },
	// · · · · · · · · · · Token: '[',
	// · · · · · · · · · · Token2: ']',
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · · Case: 1,
	// · · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · · Case: ExprString,
	// · · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Token: '=',
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · · Token: ';',
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleConstExpr_case0() {
	fmt.Println(exampleAST(73, "\U00100000 'a'"))
	// Output:
	// &cc.ConstExpr{
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// }
}

func ExampleDeclaration_case0() {
	fmt.Println(exampleAST(75, "\U00100001 auto ;"))
	// Output:
	// &cc.Declaration{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: 1,
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Token: AUTO "auto",
	// · · },
	// · },
	// · Token: ';',
	// }
}

func ExampleDeclarationList_case0() {
	fmt.Println(exampleAST(243, "\U00100001 a auto ; {"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// }
}

func ExampleDeclarationList_case1() {
	fmt.Println(exampleAST(244, "\U00100001 a auto ; auto ; {"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// · DeclarationList: &cc.DeclarationList{
	// · · Case: 1,
	// · · Declaration: &cc.Declaration{
	// · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleDeclarationListOpt_case0() {
	fmt.Println(exampleAST(245, "\U00100001 a {") == (*DeclarationListOpt)(nil))
	// Output:
	// true
}

func ExampleDeclarationListOpt_case1() {
	fmt.Println(exampleAST(246, "\U00100001 a auto ; {"))
	// Output:
	// &cc.DeclarationListOpt{
	// · DeclarationList: &cc.DeclarationList{
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleDeclarationSpecifiers_func() {
	fmt.Println(exampleAST(76, "\U00100001 inline ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · FunctionSpecifier: &cc.FunctionSpecifier{
	// · · Token: INLINE "inline",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_storage() {
	fmt.Println(exampleAST(77, "\U00100001 auto ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 1,
	// · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · Token: AUTO "auto",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_qualifier() {
	fmt.Println(exampleAST(78, "\U00100001 const ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 2,
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: CONST "const",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_specifier() {
	fmt.Println(exampleAST(79, "\U00100001 _Bool ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 3,
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Token: BOOL "_Bool",
	// · },
	// }
}

func ExampleDeclarationSpecifiersOpt_case0() {
	fmt.Println(exampleAST(80, "\U00100001 inline (") == (*DeclarationSpecifiersOpt)(nil))
	// Output:
	// true
}

func ExampleDeclarationSpecifiersOpt_case1() {
	fmt.Println(exampleAST(81, "\U00100001 const auto ("))
	// Output:
	// &cc.DeclarationSpecifiersOpt{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: 1,
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Token: AUTO "auto",
	// · · },
	// · },
	// }
}

func ExampleDeclarator_case0() {
	fmt.Println(exampleAST(141, "\U00100001 a )"))
	// Output:
	// &cc.Declarator{
	// · Linkage: LinkageNone,
	// · StorageDuration: StorageDurationAutomatic,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// }
}

func ExampleDeclaratorOpt_case0() {
	fmt.Println(exampleAST(142, "\U00100001 struct { _Bool :") == (*DeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleDeclaratorOpt_case1() {
	fmt.Println(exampleAST(143, "\U00100001 struct { _Bool a :"))
	// Output:
	// &cc.DeclaratorOpt{
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · Scope: &cc.Scope{
	// · · },
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleDesignation_case0() {
	fmt.Println(exampleAST(198, "\U00100000 ( _Bool ) { . a = !"))
	// Output:
	// &cc.Designation{
	// · DesignatorList: &cc.DesignatorList{
	// · · Designator: &cc.Designator{
	// · · · Token: '.',
	// · · · Token2: IDENTIFIER "a",
	// · · },
	// · },
	// · Token: '=',
	// }
}

func ExampleDesignator_field() {
	fmt.Println(exampleAST(201, "\U00100000 ( _Bool ) { . a ."))
	// Output:
	// &cc.Designator{
	// · Token: '.',
	// · Token2: IDENTIFIER "a",
	// }
}

func ExampleDesignator_index() {
	fmt.Println(exampleAST(202, "\U00100000 ( _Bool ) { [ 'a' ] ."))
	// Output:
	// &cc.Designator{
	// · Case: 1,
	// · ConstExpr: &cc.ConstExpr{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleDesignatorList_case0() {
	fmt.Println(exampleAST(199, "\U00100000 ( _Bool ) { . a ."))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Token: '.',
	// · · Token2: IDENTIFIER "a",
	// · },
	// }
}

func ExampleDesignatorList_case1() {
	fmt.Println(exampleAST(200, "\U00100000 ( _Bool ) { . a . b ."))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Token: '.',
	// · · Token2: IDENTIFIER "a",
	// · },
	// · DesignatorList: &cc.DesignatorList{
	// · · Case: 1,
	// · · Designator: &cc.Designator{
	// · · · Token: '.',
	// · · · Token2: IDENTIFIER "b",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_abstract() {
	fmt.Println(exampleAST(181, "\U00100000 ( _Bool ( * ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · Pointer: &cc.Pointer{
	// · · · Token: '*',
	// · · },
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectAbstractDeclarator_paramList() {
	fmt.Println(exampleAST(182, "\U00100000 ( _Bool ( ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 1,
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectAbstractDeclarator_dFn() {
	fmt.Println(exampleAST(183, "\U00100000 ( _Bool ( ) ( ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 2,
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 1,
	// · · Token: '(',
	// · · Token2: ')',
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectAbstractDeclarator_dArrSize() {
	fmt.Println(exampleAST(184, "\U00100000 ( _Bool [ static 'a' ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 3,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '[',
	// · Token2: STATIC "static",
	// · Token3: ']',
	// }
}

func ExampleDirectAbstractDeclarator_dArrVL() {
	fmt.Println(exampleAST(185, "\U00100000 ( _Bool [ * ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 4,
	// · Token: '[',
	// · Token2: '*',
	// · Token3: ']',
	// }
}

func ExampleDirectAbstractDeclarator_dArr() {
	fmt.Println(exampleAST(186, "\U00100000 ( _Bool [ ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 5,
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleDirectAbstractDeclarator_dArrSize2() {
	fmt.Println(exampleAST(187, "\U00100000 ( _Bool [ const static 'a' ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 6,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '[',
	// · Token2: STATIC "static",
	// · Token3: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_dArr2() {
	fmt.Println(exampleAST(188, "\U00100000 ( _Bool [ const ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 7,
	// · Token: '[',
	// · Token2: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclaratorOpt_case0() {
	fmt.Println(exampleAST(189, "\U00100000 ( _Bool [") == (*DirectAbstractDeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleDirectAbstractDeclaratorOpt_case1() {
	fmt.Println(exampleAST(190, "\U00100000 ( _Bool ( ) ["))
	// Output:
	// &cc.DirectAbstractDeclaratorOpt{
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 1,
	// · · Token: '(',
	// · · Token2: ')',
	// · },
	// }
}

func ExampleDirectDeclarator_paren() {
	fmt.Println(exampleAST(144, "\U00100001 ( a ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorParen,
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · StorageDuration: StorageDurationAutomatic,
	// · · Embedded: true,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectDeclarator_identList() {
	fmt.Println(exampleAST(146, "\U00100001 a ( ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorIdentList,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectDeclarator_paramList() {
	fmt.Println(exampleAST(148, "\U00100001 a ( auto ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorParamList,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: 1,
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Token: AUTO "auto",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleDirectDeclarator_arraySize() {
	fmt.Println(exampleAST(149, "\U00100001 a [ static 'b' ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorArraySize,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '[',
	// · Token2: STATIC "static",
	// · Token3: ']',
	// }
}

func ExampleDirectDeclarator_arraySize2() {
	fmt.Println(exampleAST(150, "\U00100001 a [ const static 'b' ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorArraySize2,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '[',
	// · Token2: STATIC "static",
	// · Token3: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_arrayVar() {
	fmt.Println(exampleAST(151, "\U00100001 a [ * ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorArrayVar,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · Token: '[',
	// · Token2: '*',
	// · Token3: ']',
	// }
}

func ExampleDirectDeclarator_array() {
	fmt.Println(exampleAST(152, "\U00100001 a [ ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorArray,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Case: DirectDeclaratorIdent,
	// · · Token: IDENTIFIER "a",
	// · },
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleDirectDeclarator_ident() {
	fmt.Println(exampleAST(153, "\U00100001 a ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: DirectDeclaratorIdent,
	// · Token: IDENTIFIER "a",
	// }
}

func ExampleEnumSpecifier_tag() {
	fmt.Println(exampleAST(131, "\U00100001 enum a ("))
	// Output:
	// &cc.EnumSpecifier{
	// · Token: ENUM "enum",
	// · Token2: IDENTIFIER "a",
	// }
}

func ExampleEnumSpecifier_define() {
	fmt.Println(exampleAST(132, "\U00100001 enum { a } ("))
	// Output:
	// &cc.EnumSpecifier{
	// · Case: 1,
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Enumerator: &cc.Enumerator{
	// · · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · Token: ENUM "enum",
	// · Token2: '{',
	// · Token3: '}',
	// }
}

func ExampleEnumerationConstant_case0() {
	fmt.Println(exampleAST(3, "\U00100001 enum { a ,"))
	// Output:
	// &cc.EnumerationConstant{
	// · Token: IDENTIFIER "a",
	// }
}

func ExampleEnumerator_base() {
	fmt.Println(exampleAST(135, "\U00100001 enum { a ,"))
	// Output:
	// &cc.Enumerator{
	// · EnumerationConstant: &cc.EnumerationConstant{
	// · · Token: IDENTIFIER "a",
	// · },
	// }
}

func ExampleEnumerator_init() {
	fmt.Println(exampleAST(136, "\U00100001 enum { a = 'b' ,"))
	// Output:
	// &cc.Enumerator{
	// · Case: 1,
	// · ConstExpr: &cc.ConstExpr{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · EnumerationConstant: &cc.EnumerationConstant{
	// · · Token: IDENTIFIER "a",
	// · },
	// · Token: '=',
	// }
}

func ExampleEnumeratorList_case0() {
	fmt.Println(exampleAST(133, "\U00100001 enum { a ,"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleEnumeratorList_case1() {
	fmt.Println(exampleAST(134, "\U00100001 enum { a , b ,"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Case: 1,
	// · · Enumerator: &cc.Enumerator{
	// · · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · · Token: IDENTIFIER "b",
	// · · · },
	// · · },
	// · · Token: ',',
	// · },
	// }
}

func ExampleExpr_preInc() {
	fmt.Println(exampleAST(8, "\U00100000 ++ 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPreInc,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: INC,
	// }
}

func ExampleExpr_preDec() {
	fmt.Println(exampleAST(9, "\U00100000 -- 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPreDec,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: DEC,
	// }
}

func ExampleExpr_alignofType() {
	fmt.Println(exampleAST(10, "\U00100000 __alignof__ ( _Bool )"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAlignofType,
	// · Token: ALIGNOF "__alignof__",
	// · Token2: '(',
	// · Token3: ')',
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpr_alignofExpr() {
	fmt.Println(exampleAST(11, "\U00100000 __alignof__ 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAlignofExpr,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: ALIGNOF "__alignof__",
	// }
}

func ExampleExpr_sizeofType() {
	fmt.Println(exampleAST(12, "\U00100000 sizeof ( _Bool )"))
	// Output:
	// &cc.Expr{
	// · Case: ExprSizeofType,
	// · Token: SIZEOF "sizeof",
	// · Token2: '(',
	// · Token3: ')',
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpr_sizeofExpr() {
	fmt.Println(exampleAST(13, "\U00100000 sizeof 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprSizeofExpr,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: SIZEOF "sizeof",
	// }
}

func ExampleExpr_not() {
	fmt.Println(exampleAST(14, "\U00100000 ! 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprNot,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '!',
	// }
}

func ExampleExpr_addrof() {
	fmt.Println(exampleAST(15, "\U00100000 & 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAddrof,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '&',
	// }
}

func ExampleExpr_statement() {
	fmt.Println(exampleAST(16, "\U00100000 ( { } )"))
	// Output:
	// &cc.Expr{
	// · Case: ExprStatement,
	// · CompoundStmt: &cc.CompoundStmt{
	// · · Token: '{',
	// · · Token2: '}',
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleExpr_pExprList() {
	fmt.Println(exampleAST(17, "\U00100000 ( 'a' )"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPExprList,
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleExpr_compLit() {
	fmt.Println(exampleAST(18, "\U00100000 ( _Bool ) { }"))
	// Output:
	// &cc.Expr{
	// · Case: ExprCompLit,
	// · Token: '(',
	// · Token2: ')',
	// · Token3: '{',
	// · Token4: '}',
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpr_cast() {
	fmt.Println(exampleAST(19, "\U00100000 ( _Bool ) 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprCast,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '(',
	// · Token2: ')',
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpr_deref() {
	fmt.Println(exampleAST(20, "\U00100000 * 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprDeref,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '*',
	// }
}

func ExampleExpr_unaryPlus() {
	fmt.Println(exampleAST(21, "\U00100000 + 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprUnaryPlus,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '+',
	// }
}

func ExampleExpr_unaryMinus() {
	fmt.Println(exampleAST(22, "\U00100000 - 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprUnaryMinus,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '-',
	// }
}

func ExampleExpr_cpl() {
	fmt.Println(exampleAST(23, "\U00100000 ~ 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprCpl,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '~',
	// }
}

func ExampleExpr_char() {
	fmt.Println(exampleAST(24, "\U00100000 'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprChar,
	// · Token: CHARCONST "'a'",
	// }
}

func ExampleExpr_ne() {
	fmt.Println(exampleAST(25, "\U00100000 'a' != 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprNe,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: NEQ,
	// }
}

func ExampleExpr_modAssign() {
	fmt.Println(exampleAST(26, "\U00100000 'a' %= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprModAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: MODASSIGN,
	// }
}

func ExampleExpr_lAnd() {
	fmt.Println(exampleAST(27, "\U00100000 'a' && 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLAnd,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: ANDAND,
	// }
}

func ExampleExpr_andAssign() {
	fmt.Println(exampleAST(28, "\U00100000 'a' &= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAndAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: ANDASSIGN,
	// }
}

func ExampleExpr_mulAssign() {
	fmt.Println(exampleAST(29, "\U00100000 'a' *= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprMulAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: MULASSIGN,
	// }
}

func ExampleExpr_postInc() {
	fmt.Println(exampleAST(30, "\U00100000 'a' ++"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPostInc,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: INC,
	// }
}

func ExampleExpr_addAssign() {
	fmt.Println(exampleAST(31, "\U00100000 'a' += 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAddAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: ADDASSIGN,
	// }
}

func ExampleExpr_postDec() {
	fmt.Println(exampleAST(32, "\U00100000 'a' --"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPostDec,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: DEC,
	// }
}

func ExampleExpr_subAssign() {
	fmt.Println(exampleAST(33, "\U00100000 'a' -= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprSubAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: SUBASSIGN,
	// }
}

func ExampleExpr_pSelect() {
	fmt.Println(exampleAST(34, "\U00100000 'a' -> b"))
	// Output:
	// &cc.Expr{
	// · Case: ExprPSelect,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: ARROW,
	// · Token2: IDENTIFIER "b",
	// }
}

func ExampleExpr_divAssign() {
	fmt.Println(exampleAST(35, "\U00100000 'a' /= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprDivAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: DIVASSIGN,
	// }
}

func ExampleExpr_lsh() {
	fmt.Println(exampleAST(36, "\U00100000 'a' << 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLsh,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: LSH,
	// }
}

func ExampleExpr_lshAssign() {
	fmt.Println(exampleAST(37, "\U00100000 'a' <<= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLshAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: LSHASSIGN,
	// }
}

func ExampleExpr_le() {
	fmt.Println(exampleAST(38, "\U00100000 'a' <= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLe,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: LEQ,
	// }
}

func ExampleExpr_eq() {
	fmt.Println(exampleAST(39, "\U00100000 'a' == 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprEq,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: EQ,
	// }
}

func ExampleExpr_ge() {
	fmt.Println(exampleAST(40, "\U00100000 'a' >= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprGe,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: GEQ,
	// }
}

func ExampleExpr_rsh() {
	fmt.Println(exampleAST(41, "\U00100000 'a' >> 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprRsh,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: RSH,
	// }
}

func ExampleExpr_rshAssign() {
	fmt.Println(exampleAST(42, "\U00100000 'a' >>= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprRshAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: RSHASSIGN,
	// }
}

func ExampleExpr_xorAssign() {
	fmt.Println(exampleAST(43, "\U00100000 'a' ^= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprXorAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: XORASSIGN,
	// }
}

func ExampleExpr_orAssign() {
	fmt.Println(exampleAST(44, "\U00100000 'a' |= 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprOrAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: ORASSIGN,
	// }
}

func ExampleExpr_lOr() {
	fmt.Println(exampleAST(45, "\U00100000 'a' || 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLOr,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: OROR,
	// }
}

func ExampleExpr_mod() {
	fmt.Println(exampleAST(46, "\U00100000 'a' % 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprMod,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '%',
	// }
}

func ExampleExpr_and() {
	fmt.Println(exampleAST(47, "\U00100000 'a' & 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAnd,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '&',
	// }
}

func ExampleExpr_call() {
	fmt.Println(exampleAST(48, "\U00100000 'a' ( )"))
	// Output:
	// &cc.Expr{
	// · Case: ExprCall,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleExpr_mul() {
	fmt.Println(exampleAST(49, "\U00100000 'a' * 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprMul,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '*',
	// }
}

func ExampleExpr_add() {
	fmt.Println(exampleAST(50, "\U00100000 'a' + 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAdd,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '+',
	// }
}

func ExampleExpr_sub() {
	fmt.Println(exampleAST(51, "\U00100000 'a' - 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprSub,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '-',
	// }
}

func ExampleExpr_select() {
	fmt.Println(exampleAST(52, "\U00100000 'a' . b"))
	// Output:
	// &cc.Expr{
	// · Case: ExprSelect,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: '.',
	// · Token2: IDENTIFIER "b",
	// }
}

func ExampleExpr_div() {
	fmt.Println(exampleAST(53, "\U00100000 'a' / 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprDiv,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '/',
	// }
}

func ExampleExpr_lt() {
	fmt.Println(exampleAST(54, "\U00100000 'a' < 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLt,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '<',
	// }
}

func ExampleExpr_assign() {
	fmt.Println(exampleAST(55, "\U00100000 'a' = 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprAssign,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '=',
	// }
}

func ExampleExpr_gt() {
	fmt.Println(exampleAST(56, "\U00100000 'a' > 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprGt,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '>',
	// }
}

func ExampleExpr_cond() {
	fmt.Println(exampleAST(57, "\U00100000 'a' ? 'b' : 'c'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprCond,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'c'",
	// · },
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: '?',
	// · Token2: ':',
	// }
}

func ExampleExpr_index() {
	fmt.Println(exampleAST(58, "\U00100000 'a' [ 'b' ]"))
	// Output:
	// &cc.Expr{
	// · Case: ExprIndex,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleExpr_xor() {
	fmt.Println(exampleAST(59, "\U00100000 'a' ^ 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprXor,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '^',
	// }
}

func ExampleExpr_or() {
	fmt.Println(exampleAST(60, "\U00100000 'a' | 'b'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprOr,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Expr2: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// · Token: '|',
	// }
}

func ExampleExpr_float() {
	fmt.Println(exampleAST(61, "\U00100000 1.97"))
	// Output:
	// &cc.Expr{
	// · Case: ExprFloat,
	// · Token: FLOATCONST "1.97",
	// }
}

func ExampleExpr_ident() {
	fmt.Println(exampleAST(62, "\U00100001 a { b %"))
	// Output:
	// &cc.Expr{
	// · Scope: &cc.Scope{
	// · },
	// · Case: ExprIdent,
	// · Token: IDENTIFIER "b",
	// }
}

func ExampleExpr_int() {
	fmt.Println(exampleAST(63, "\U00100000 97"))
	// Output:
	// &cc.Expr{
	// · Case: ExprInt,
	// · Token: INTCONST "97",
	// }
}

func ExampleExpr_lChar() {
	fmt.Println(exampleAST(64, "\U00100000 L'a'"))
	// Output:
	// &cc.Expr{
	// · Case: ExprLChar,
	// · Token: LONGCHARCONST "L'a'",
	// }
}

func ExampleExpr_lString() {
	fmt.Println(exampleAST(65, "\U00100000 L\"a\""))
	// Output:
	// &cc.Expr{
	// · Case: ExprLString,
	// · Token: LONGSTRINGLITERAL "L\"a\"",
	// }
}

func ExampleExpr_string() {
	fmt.Println(exampleAST(66, "\U00100000 \"a\""))
	// Output:
	// &cc.Expr{
	// · Case: ExprString,
	// · Token: STRINGLITERAL "\"a\"",
	// }
}

func ExampleExprList_case0() {
	fmt.Println(exampleAST(69, "\U00100000 ( 'a' )"))
	// Output:
	// &cc.ExprList{
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// }
}

func ExampleExprList_case1() {
	fmt.Println(exampleAST(70, "\U00100000 ( 'a' , 'b' )"))
	// Output:
	// &cc.ExprList{
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · ExprList: &cc.ExprList{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · · Token: ',',
	// · },
	// }
}

func ExampleExprListOpt_case0() {
	fmt.Println(exampleAST(71, "\U00100001 a { ;") == (*ExprListOpt)(nil))
	// Output:
	// true
}

func ExampleExprListOpt_case1() {
	fmt.Println(exampleAST(72, "\U00100001 a { 'b' )"))
	// Output:
	// &cc.ExprListOpt{
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// }
}

func ExampleExprOpt_case0() {
	fmt.Println(exampleAST(67, "\U00100000 ( _Bool [ ]") == (*ExprOpt)(nil))
	// Output:
	// true
}

func ExampleExprOpt_case1() {
	fmt.Println(exampleAST(68, "\U00100001 a [ 'b' ]"))
	// Output:
	// &cc.ExprOpt{
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// }
}

func ExampleExprStmt_case0() {
	fmt.Println(exampleAST(221, "\U00100001 a { ; !"))
	// Output:
	// &cc.ExprStmt{
	// · Token: ';',
	// }
}

func ExampleExternalDeclaration_decl() {
	fmt.Println(exampleAST(235, "\U00100001 auto ;"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// }
}

func ExampleExternalDeclaration_func() {
	fmt.Println(exampleAST(236, "\U00100001 a { }"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: 1,
	// · FunctionDefinition: &cc.FunctionDefinition{
	// · · Case: 1,
	// · · Declarator: &cc.Declarator{
	// · · · FunctionDefinition: &cc.FunctionDefinition{ /* recursive/repetitive pointee not shown */ },
	// · · · Linkage: LinkageNone,
	// · · · StorageDuration: StorageDurationAutomatic,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · FunctionBody: &cc.FunctionBody{
	// · · · CompoundStmt: &cc.CompoundStmt{
	// · · · · BlockItemListOpt: &cc.BlockItemListOpt{
	// · · · · · BlockItemList: &cc.BlockItemList{
	// · · · · · · BlockItem: &cc.BlockItem{
	// · · · · · · · Declaration: &cc.Declaration{
	// · · · · · · · · Scope: &cc.Scope{
	// · · · · · · · · · Parent: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · },
	// · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · Case: 1,
	// · · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · · · · Case: 3,
	// · · · · · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · · · · · Token: CONST "const",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · · · · · Case: 3,
	// · · · · · · · · · · Token: STATIC "static",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · · · · · Case: 1,
	// · · · · · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · · · · · },
	// · · · · · · · · · · · · · Token: '[',
	// · · · · · · · · · · · · · Token2: ']',
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · · · · · Case: 1,
	// · · · · · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · · · · · Case: ExprString,
	// · · · · · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Token: '=',
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · Token: ';',
	// · · · · · · · },
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · · Token: '{',
	// · · · · Token2: '}',
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExternalDeclarationList_case0() {
	fmt.Println(exampleAST(233, "\U00100001 auto ;"))
	// Output:
	// &cc.ExternalDeclarationList{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleExternalDeclarationList_case1() {
	fmt.Println(exampleAST(234, "\U00100001 auto ; auto ;"))
	// Output:
	// &cc.ExternalDeclarationList{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// · ExternalDeclarationList: &cc.ExternalDeclarationList{
	// · · Case: 1,
	// · · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · · Declaration: &cc.Declaration{
	// · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: 1,
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Token: AUTO "auto",
	// · · · · · },
	// · · · · },
	// · · · · Token: ';',
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleFunctionBody_case0() {
	fmt.Println(exampleAST(242, "\U00100001 a { }"))
	// Output:
	// &cc.FunctionBody{
	// · CompoundStmt: &cc.CompoundStmt{
	// · · BlockItemListOpt: &cc.BlockItemListOpt{
	// · · · BlockItemList: &cc.BlockItemList{
	// · · · · BlockItem: &cc.BlockItem{
	// · · · · · Declaration: &cc.Declaration{
	// · · · · · · Scope: &cc.Scope{
	// · · · · · · },
	// · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · Case: 1,
	// · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · Case: 2,
	// · · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · · Case: 3,
	// · · · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · · · Token: CONST "const",
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · · · Case: 3,
	// · · · · · · · · Token: STATIC "static",
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · · · Case: 1,
	// · · · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · · · },
	// · · · · · · · · · · · Token: '[',
	// · · · · · · · · · · · Token2: ']',
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · · · Case: 1,
	// · · · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · · · Case: ExprString,
	// · · · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · · Token: '=',
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · },
	// · · · · · · Token: ';',
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · · Token: '{',
	// · · Token2: '}',
	// · },
	// }
}

func ExampleFunctionDefinition_spec() {
	fmt.Println(exampleAST(238, "\U00100001 auto a { }"))
	// Output:
	// &cc.FunctionDefinition{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: 1,
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Token: AUTO "auto",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · FunctionDefinition: &cc.FunctionDefinition{ /* recursive/repetitive pointee not shown */ },
	// · · Linkage: LinkageNone,
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// · FunctionBody: &cc.FunctionBody{
	// · · CompoundStmt: &cc.CompoundStmt{
	// · · · BlockItemListOpt: &cc.BlockItemListOpt{
	// · · · · BlockItemList: &cc.BlockItemList{
	// · · · · · BlockItem: &cc.BlockItem{
	// · · · · · · Declaration: &cc.Declaration{
	// · · · · · · · Scope: &cc.Scope{
	// · · · · · · · · Parent: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · },
	// · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · Case: 1,
	// · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · Case: 2,
	// · · · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · · · Case: 3,
	// · · · · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · · · · Token: CONST "const",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · · · · Case: 3,
	// · · · · · · · · · Token: STATIC "static",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · · · · Case: 1,
	// · · · · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Token: '[',
	// · · · · · · · · · · · · Token2: ']',
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · · · · Case: 1,
	// · · · · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · · · · Case: ExprString,
	// · · · · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Token: '=',
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Token: ';',
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: '{',
	// · · · Token2: '}',
	// · · },
	// · },
	// }
}

func ExampleFunctionDefinition_int() {
	fmt.Println(exampleAST(240, "\U00100001 a { }"))
	// Output:
	// &cc.FunctionDefinition{
	// · Case: 1,
	// · Declarator: &cc.Declarator{
	// · · FunctionDefinition: &cc.FunctionDefinition{ /* recursive/repetitive pointee not shown */ },
	// · · Linkage: LinkageNone,
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// · FunctionBody: &cc.FunctionBody{
	// · · CompoundStmt: &cc.CompoundStmt{
	// · · · BlockItemListOpt: &cc.BlockItemListOpt{
	// · · · · BlockItemList: &cc.BlockItemList{
	// · · · · · BlockItem: &cc.BlockItem{
	// · · · · · · Declaration: &cc.Declaration{
	// · · · · · · · Scope: &cc.Scope{
	// · · · · · · · · Parent: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · },
	// · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · Case: 1,
	// · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · Case: 2,
	// · · · · · · · · · · DeclarationSpecifiersOpt: &cc.DeclarationSpecifiersOpt{
	// · · · · · · · · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · · · · · · · · Case: 3,
	// · · · · · · · · · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · · · · · · · · · Case: 2,
	// · · · · · · · · · · · · · Token: CHAR "char",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · TypeQualifier: &cc.TypeQualifier{
	// · · · · · · · · · · · Token: CONST "const",
	// · · · · · · · · · · },
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · · · · Case: 3,
	// · · · · · · · · · Token: STATIC "static",
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · InitDeclaratorListOpt: &cc.InitDeclaratorListOpt{
	// · · · · · · · · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · · · · · · · · InitDeclarator: &cc.InitDeclarator{
	// · · · · · · · · · · Case: 1,
	// · · · · · · · · · · Declarator: &cc.Declarator{
	// · · · · · · · · · · · Linkage: LinkageNone,
	// · · · · · · · · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · · · · · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · Case: DirectDeclaratorArray,
	// · · · · · · · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · · · · · · · Case: DirectDeclaratorIdent,
	// · · · · · · · · · · · · · Token: IDENTIFIER "__func__",
	// · · · · · · · · · · · · },
	// · · · · · · · · · · · · Token: '[',
	// · · · · · · · · · · · · Token2: ']',
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Initializer: &cc.Initializer{
	// · · · · · · · · · · · Case: 1,
	// · · · · · · · · · · · Expr: &cc.Expr{
	// · · · · · · · · · · · · Case: ExprString,
	// · · · · · · · · · · · · Token: STRINGLITERAL "\"a\"",
	// · · · · · · · · · · · },
	// · · · · · · · · · · },
	// · · · · · · · · · · Token: '=',
	// · · · · · · · · · },
	// · · · · · · · · },
	// · · · · · · · },
	// · · · · · · · Token: ';',
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: '{',
	// · · · Token2: '}',
	// · · },
	// · },
	// }
}

func ExampleFunctionSpecifier_case0() {
	fmt.Println(exampleAST(140, "\U00100001 inline ("))
	// Output:
	// &cc.FunctionSpecifier{
	// · Token: INLINE "inline",
	// }
}

func ExampleIdentifierList_case0() {
	fmt.Println(exampleAST(170, "\U00100001 a ( b )"))
	// Output:
	// &cc.IdentifierList{
	// · Token: IDENTIFIER "b",
	// }
}

func ExampleIdentifierList_case1() {
	fmt.Println(exampleAST(171, "\U00100001 a ( b , c )"))
	// Output:
	// &cc.IdentifierList{
	// · IdentifierList: &cc.IdentifierList{
	// · · Case: 1,
	// · · Token: ',',
	// · · Token2: IDENTIFIER "c",
	// · },
	// · Token: IDENTIFIER "b",
	// }
}

func ExampleIdentifierListOpt_case0() {
	fmt.Println(exampleAST(172, "\U00100001 a ( )") == (*IdentifierListOpt)(nil))
	// Output:
	// true
}

func ExampleIdentifierListOpt_case1() {
	fmt.Println(exampleAST(173, "\U00100001 a ( b )"))
	// Output:
	// &cc.IdentifierListOpt{
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: IDENTIFIER "b",
	// · },
	// }
}

func ExampleIdentifierOpt_case0() {
	fmt.Println(exampleAST(174, "\U00100001 struct {") == (*IdentifierOpt)(nil))
	// Output:
	// true
}

func ExampleIdentifierOpt_case1() {
	fmt.Println(exampleAST(175, "\U00100001 enum a {"))
	// Output:
	// &cc.IdentifierOpt{
	// · Token: IDENTIFIER "a",
	// }
}

func ExampleInitDeclarator_base() {
	fmt.Println(exampleAST(86, "\U00100001 a auto b ,"))
	// Output:
	// &cc.InitDeclarator{
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "b",
	// · · },
	// · },
	// }
}

func ExampleInitDeclarator_init() {
	fmt.Println(exampleAST(87, "\U00100001 auto a = 'b' ,"))
	// Output:
	// &cc.InitDeclarator{
	// · Case: 1,
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// · Initializer: &cc.Initializer{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: '=',
	// }
}

func ExampleInitDeclaratorList_case0() {
	fmt.Println(exampleAST(82, "\U00100001 auto a ,"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: LinkageNone,
	// · · · StorageDuration: StorageDurationAutomatic,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleInitDeclaratorList_case1() {
	fmt.Println(exampleAST(83, "\U00100001 auto a , b ,"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: LinkageNone,
	// · · · StorageDuration: StorageDurationAutomatic,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · Case: 1,
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: LinkageNone,
	// · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: ',',
	// · },
	// }
}

func ExampleInitDeclaratorListOpt_case0() {
	fmt.Println(exampleAST(84, "\U00100001 auto ;") == (*InitDeclaratorListOpt)(nil))
	// Output:
	// true
}

func ExampleInitDeclaratorListOpt_case1() {
	fmt.Println(exampleAST(85, "\U00100001 auto a ;"))
	// Output:
	// &cc.InitDeclaratorListOpt{
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: LinkageNone,
	// · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: IDENTIFIER "a",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleInitializer_compLit() {
	fmt.Println(exampleAST(191, "\U00100001 auto a = { } ,"))
	// Output:
	// &cc.Initializer{
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleInitializer_expr() {
	fmt.Println(exampleAST(192, "\U00100001 auto a = 'b' ,"))
	// Output:
	// &cc.Initializer{
	// · Case: 1,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'b'",
	// · },
	// }
}

func ExampleInitializerList_case0() {
	fmt.Println(exampleAST(193, "\U00100000 ( _Bool ) { ,") == (*InitializerList)(nil))
	// Output:
	// true
}

func ExampleInitializerList_case1() {
	fmt.Println(exampleAST(194, "\U00100000 ( _Bool ) { 'a' ,"))
	// Output:
	// &cc.InitializerList{
	// · Case: 1,
	// · Initializer: &cc.Initializer{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'a'",
	// · · },
	// · },
	// }
}

func ExampleInitializerList_case2() {
	fmt.Println(exampleAST(195, "\U00100001 auto a = { . b = 'c' ,"))
	// Output:
	// &cc.InitializerList{
	// · Case: 2,
	// · Designation: &cc.Designation{
	// · · DesignatorList: &cc.DesignatorList{
	// · · · Designator: &cc.Designator{
	// · · · · Token: '.',
	// · · · · Token2: IDENTIFIER "b",
	// · · · },
	// · · },
	// · · Token: '=',
	// · },
	// · Initializer: &cc.Initializer{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'c'",
	// · · },
	// · },
	// }
}

func ExampleInitializerList_case3() {
	fmt.Println(exampleAST(196, "\U00100001 auto a = { , 'b' ,"))
	// Output:
	// &cc.InitializerList{
	// · Case: 3,
	// · Initializer: &cc.Initializer{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: ',',
	// }
}

func ExampleInitializerList_case4() {
	fmt.Println(exampleAST(197, "\U00100001 auto a = { , . b = 'c' ,"))
	// Output:
	// &cc.InitializerList{
	// · Case: 4,
	// · Designation: &cc.Designation{
	// · · DesignatorList: &cc.DesignatorList{
	// · · · Designator: &cc.Designator{
	// · · · · Token: '.',
	// · · · · Token2: IDENTIFIER "b",
	// · · · },
	// · · },
	// · · Token: '=',
	// · },
	// · Initializer: &cc.Initializer{
	// · · Case: 1,
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'c'",
	// · · },
	// · },
	// · Token: ',',
	// }
}

func ExampleIterationStmt_do() {
	fmt.Println(exampleAST(225, "\U00100001 a { do ; while ( 'b' ) ; !"))
	// Output:
	// &cc.IterationStmt{
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: DO "do",
	// · Token2: WHILE "while",
	// · Token3: '(',
	// · Token4: ')',
	// · Token5: ';',
	// }
}

func ExampleIterationStmt_forDecl() {
	fmt.Println(exampleAST(226, "\U00100001 a { for ( auto ; ; ) ; !"))
	// Output:
	// &cc.IterationStmt{
	// · Case: 1,
	// · Declaration: &cc.Declaration{
	// · · Scope: &cc.Scope{
	// · · · Parent: &cc.Scope{
	// · · · },
	// · · },
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: FOR "for",
	// · Token2: '(',
	// · Token3: ';',
	// · Token4: ')',
	// }
}

func ExampleIterationStmt_for() {
	fmt.Println(exampleAST(227, "\U00100001 a { for ( ; ; ) ; !"))
	// Output:
	// &cc.IterationStmt{
	// · Case: 2,
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: FOR "for",
	// · Token2: '(',
	// · Token3: ';',
	// · Token4: ';',
	// · Token5: ')',
	// }
}

func ExampleIterationStmt_while() {
	fmt.Println(exampleAST(228, "\U00100001 a { while ( 'b' ) ; !"))
	// Output:
	// &cc.IterationStmt{
	// · Case: 3,
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: WHILE "while",
	// · Token2: '(',
	// · Token3: ')',
	// }
}

func ExampleJumpStmt_break() {
	fmt.Println(exampleAST(229, "\U00100001 a { break ; !"))
	// Output:
	// &cc.JumpStmt{
	// · Token: BREAK "break",
	// · Token2: ';',
	// }
}

func ExampleJumpStmt_continue() {
	fmt.Println(exampleAST(230, "\U00100001 a { continue ; !"))
	// Output:
	// &cc.JumpStmt{
	// · Case: 1,
	// · Token: CONTINUE "continue",
	// · Token2: ';',
	// }
}

func ExampleJumpStmt_goto() {
	fmt.Println(exampleAST(231, "\U00100001 a { goto b ; !"))
	// Output:
	// &cc.JumpStmt{
	// · Case: 2,
	// · Token: GOTO "goto",
	// · Token2: IDENTIFIER "b",
	// · Token3: ';',
	// }
}

func ExampleJumpStmt_return() {
	fmt.Println(exampleAST(232, "\U00100001 a { return ; !"))
	// Output:
	// &cc.JumpStmt{
	// · Case: 3,
	// · Token: RETURN "return",
	// · Token2: ';',
	// }
}

func ExampleLabeledStmt_switchCase() {
	fmt.Println(exampleAST(209, "\U00100001 a { case 'b' : ; !"))
	// Output:
	// &cc.LabeledStmt{
	// · ConstExpr: &cc.ConstExpr{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: CASE "case",
	// · Token2: ':',
	// }
}

func ExampleLabeledStmt_default() {
	fmt.Println(exampleAST(210, "\U00100001 a { default : ; !"))
	// Output:
	// &cc.LabeledStmt{
	// · Case: 1,
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: DEFAULT "default",
	// · Token2: ':',
	// }
}

func ExampleLabeledStmt_label() {
	fmt.Println(exampleAST(211, "\U00100001 a { b : ; !"))
	// Output:
	// &cc.LabeledStmt{
	// · Case: 2,
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: IDENTIFIER "b",
	// · Token2: ':',
	// }
}

func ExampleLabeledStmt_label2() {
	fmt.Println(exampleAST(212, "\U00100001 a { typedef name : ; !"))
	// Output:
	// TODO: example212.c:1:19: unexpected ':', expected one of [',', ';', '=']
}

func ExampleParameterDeclaration_abstract() {
	fmt.Println(exampleAST(168, "\U00100001 a ( auto )"))
	// Output:
	// &cc.ParameterDeclaration{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: 1,
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Token: AUTO "auto",
	// · · },
	// · },
	// }
}

func ExampleParameterDeclaration_declarator() {
	fmt.Println(exampleAST(169, "\U00100001 a ( auto b )"))
	// Output:
	// &cc.ParameterDeclaration{
	// · Case: 1,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · Case: 1,
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Token: AUTO "auto",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · Scope: &cc.Scope{
	// · · },
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "b",
	// · · },
	// · },
	// }
}

func ExampleParameterList_case0() {
	fmt.Println(exampleAST(166, "\U00100001 a ( auto )"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterList_case1() {
	fmt.Println(exampleAST(167, "\U00100001 a ( auto , auto )"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · Case: 1,
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Token: AUTO "auto",
	// · · · },
	// · · },
	// · },
	// · ParameterList: &cc.ParameterList{
	// · · Case: 1,
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: ',',
	// · },
	// }
}

func ExampleParameterTypeList_base() {
	fmt.Println(exampleAST(162, "\U00100001 a ( auto )"))
	// Output:
	// &cc.ParameterTypeList{
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterTypeList_dots() {
	fmt.Println(exampleAST(163, "\U00100001 a ( auto , ... )"))
	// Output:
	// &cc.ParameterTypeList{
	// · Case: 1,
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · Case: 1,
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Token: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: ',',
	// · Token2: DDD,
	// }
}

func ExampleParameterTypeListOpt_case0() {
	fmt.Println(exampleAST(164, "\U00100000 ( _Bool ( )") == (*ParameterTypeListOpt)(nil))
	// Output:
	// true
}

func ExampleParameterTypeListOpt_case1() {
	fmt.Println(exampleAST(165, "\U00100000 ( _Bool ( auto )"))
	// Output:
	// &cc.ParameterTypeListOpt{
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · Case: 1,
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Token: AUTO "auto",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExamplePointer_base() {
	fmt.Println(exampleAST(154, "\U00100001 * ("))
	// Output:
	// &cc.Pointer{
	// · Token: '*',
	// }
}

func ExamplePointer_ptr() {
	fmt.Println(exampleAST(155, "\U00100001 * * ("))
	// Output:
	// &cc.Pointer{
	// · Case: 1,
	// · Pointer: &cc.Pointer{
	// · · Token: '*',
	// · },
	// · Token: '*',
	// }
}

func ExamplePointerOpt_case0() {
	fmt.Println(exampleAST(156, "\U00100001 (") == (*PointerOpt)(nil))
	// Output:
	// true
}

func ExamplePointerOpt_case1() {
	fmt.Println(exampleAST(157, "\U00100001 * ("))
	// Output:
	// &cc.PointerOpt{
	// · Pointer: &cc.Pointer{
	// · · Token: '*',
	// · },
	// }
}

func ExampleSelectionStmt_ifElse() {
	fmt.Println(exampleAST(222, "\U00100001 a { if ( 'b' ) ; else ; !"))
	// Output:
	// &cc.SelectionStmt{
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Stmt2: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: IF "if",
	// · Token2: '(',
	// · Token3: ')',
	// · Token4: ELSE "else",
	// }
}

func ExampleSelectionStmt_if() {
	fmt.Println(exampleAST(223, "\U00100001 a { if ( 'b' ) ; !"))
	// Output:
	// &cc.SelectionStmt{
	// · Case: 1,
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: IF "if",
	// · Token2: '(',
	// · Token3: ')',
	// }
}

func ExampleSelectionStmt_switch() {
	fmt.Println(exampleAST(224, "\U00100001 a { switch ( 'b' ) ; !"))
	// Output:
	// &cc.SelectionStmt{
	// · Case: 2,
	// · ExprList: &cc.ExprList{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'b'",
	// · · },
	// · },
	// · Stmt: &cc.Stmt{
	// · · Case: 1,
	// · · ExprStmt: &cc.ExprStmt{
	// · · · Token: ';',
	// · · },
	// · },
	// · Token: SWITCH "switch",
	// · Token2: '(',
	// · Token3: ')',
	// }
}

func ExampleSpecifierQualifierList_qualifier() {
	fmt.Println(exampleAST(121, "\U00100000 ( const ("))
	// Output:
	// &cc.SpecifierQualifierList{
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: CONST "const",
	// · },
	// }
}

func ExampleSpecifierQualifierList_specifier() {
	fmt.Println(exampleAST(122, "\U00100000 ( _Bool ("))
	// Output:
	// &cc.SpecifierQualifierList{
	// · Case: 1,
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Token: BOOL "_Bool",
	// · },
	// }
}

func ExampleSpecifierQualifierListOpt_case0() {
	fmt.Println(exampleAST(123, "\U00100000 ( const (") == (*SpecifierQualifierListOpt)(nil))
	// Output:
	// true
}

func ExampleSpecifierQualifierListOpt_case1() {
	fmt.Println(exampleAST(124, "\U00100000 ( const _Bool ("))
	// Output:
	// &cc.SpecifierQualifierListOpt{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: 1,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Token: BOOL "_Bool",
	// · · },
	// · },
	// }
}

func ExampleStmt_block() {
	fmt.Println(exampleAST(203, "\U00100001 a { { } !"))
	// Output:
	// &cc.Stmt{
	// · CompoundStmt: &cc.CompoundStmt{
	// · · Token: '{',
	// · · Token2: '}',
	// · },
	// }
}

func ExampleStmt_expr() {
	fmt.Println(exampleAST(204, "\U00100001 a { ; !"))
	// Output:
	// &cc.Stmt{
	// · Case: 1,
	// · ExprStmt: &cc.ExprStmt{
	// · · Token: ';',
	// · },
	// }
}

func ExampleStmt_iter() {
	fmt.Println(exampleAST(205, "\U00100001 a { while ( 'b' ) ; !"))
	// Output:
	// &cc.Stmt{
	// · Case: 2,
	// · IterationStmt: &cc.IterationStmt{
	// · · Case: 3,
	// · · ExprList: &cc.ExprList{
	// · · · Expr: &cc.Expr{
	// · · · · Case: ExprChar,
	// · · · · Token: CHARCONST "'b'",
	// · · · },
	// · · },
	// · · Stmt: &cc.Stmt{
	// · · · Case: 1,
	// · · · ExprStmt: &cc.ExprStmt{
	// · · · · Token: ';',
	// · · · },
	// · · },
	// · · Token: WHILE "while",
	// · · Token2: '(',
	// · · Token3: ')',
	// · },
	// }
}

func ExampleStmt_jump() {
	fmt.Println(exampleAST(206, "\U00100001 a { break ; !"))
	// Output:
	// &cc.Stmt{
	// · Case: 3,
	// · JumpStmt: &cc.JumpStmt{
	// · · Token: BREAK "break",
	// · · Token2: ';',
	// · },
	// }
}

func ExampleStmt_labeled() {
	fmt.Println(exampleAST(207, "\U00100001 a { default : ; !"))
	// Output:
	// &cc.Stmt{
	// · Case: 4,
	// · LabeledStmt: &cc.LabeledStmt{
	// · · Case: 1,
	// · · Stmt: &cc.Stmt{
	// · · · Case: 1,
	// · · · ExprStmt: &cc.ExprStmt{
	// · · · · Token: ';',
	// · · · },
	// · · },
	// · · Token: DEFAULT "default",
	// · · Token2: ':',
	// · },
	// }
}

func ExampleStmt_select() {
	fmt.Println(exampleAST(208, "\U00100001 a { if ( 'b' ) ; !"))
	// Output:
	// &cc.Stmt{
	// · Case: 5,
	// · SelectionStmt: &cc.SelectionStmt{
	// · · Case: 1,
	// · · ExprList: &cc.ExprList{
	// · · · Expr: &cc.Expr{
	// · · · · Case: ExprChar,
	// · · · · Token: CHARCONST "'b'",
	// · · · },
	// · · },
	// · · Stmt: &cc.Stmt{
	// · · · Case: 1,
	// · · · ExprStmt: &cc.ExprStmt{
	// · · · · Token: ';',
	// · · · },
	// · · },
	// · · Token: IF "if",
	// · · Token2: '(',
	// · · Token3: ')',
	// · },
	// }
}

func ExampleStorageClassSpecifier_auto() {
	fmt.Println(exampleAST(88, "\U00100001 auto ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Token: AUTO "auto",
	// }
}

func ExampleStorageClassSpecifier_extern() {
	fmt.Println(exampleAST(89, "\U00100001 extern ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 1,
	// · Token: EXTERN "extern",
	// }
}

func ExampleStorageClassSpecifier_register() {
	fmt.Println(exampleAST(90, "\U00100001 register ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 2,
	// · Token: REGISTER "register",
	// }
}

func ExampleStorageClassSpecifier_static() {
	fmt.Println(exampleAST(91, "\U00100001 static ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 3,
	// · Token: STATIC "static",
	// }
}

func ExampleStorageClassSpecifier_typedef() {
	fmt.Println(exampleAST(92, "\U00100001 typedef ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 4,
	// · Token: TYPEDEF "typedef",
	// }
}

func ExampleStructDeclaration_base() {
	fmt.Println(exampleAST(119, "\U00100001 struct { _Bool a ; }"))
	// Output:
	// &cc.StructDeclaration{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: 1,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Token: BOOL "_Bool",
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: LinkageNone,
	// · · · · Scope: &cc.Scope{
	// · · · · },
	// · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: IDENTIFIER "a",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: ';',
	// }
}

func ExampleStructDeclaration_anon() {
	fmt.Println(exampleAST(120, "\U00100001 struct { _Bool ; }"))
	// Output:
	// &cc.StructDeclaration{
	// · Case: 1,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: 1,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Token: BOOL "_Bool",
	// · · },
	// · },
	// · Token: ';',
	// }
}

func ExampleStructDeclarationList_case0() {
	fmt.Println(exampleAST(117, "\U00100001 struct { _Bool ; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · Case: 1,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// }
}

func ExampleStructDeclarationList_case1() {
	fmt.Println(exampleAST(118, "\U00100001 struct { _Bool ; _Bool ; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · Case: 1,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · · Token: ';',
	// · },
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · Case: 1,
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · Case: 1,
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: 1,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Token: BOOL "_Bool",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator_base() {
	fmt.Println(exampleAST(127, "\U00100001 struct { _Bool a ,"))
	// Output:
	// &cc.StructDeclarator{
	// · Declarator: &cc.Declarator{
	// · · Linkage: LinkageNone,
	// · · Scope: &cc.Scope{
	// · · },
	// · · StorageDuration: StorageDurationAutomatic,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Case: DirectDeclaratorIdent,
	// · · · Token: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator_bits() {
	fmt.Println(exampleAST(128, "\U00100001 struct { _Bool : 'a' ,"))
	// Output:
	// &cc.StructDeclarator{
	// · Case: 1,
	// · ConstExpr: &cc.ConstExpr{
	// · · Expr: &cc.Expr{
	// · · · Case: ExprChar,
	// · · · Token: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: ':',
	// }
}

func ExampleStructDeclaratorList_case0() {
	fmt.Println(exampleAST(125, "\U00100001 struct { _Bool a ,"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: LinkageNone,
	// · · · Scope: &cc.Scope{
	// · · · },
	// · · · StorageDuration: StorageDurationAutomatic,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleStructDeclaratorList_case1() {
	fmt.Println(exampleAST(126, "\U00100001 struct { _Bool a , b ,"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: LinkageNone,
	// · · · Scope: &cc.Scope{
	// · · · },
	// · · · StorageDuration: StorageDurationAutomatic,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Case: DirectDeclaratorIdent,
	// · · · · Token: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · Case: 1,
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: LinkageNone,
	// · · · · Scope: &cc.Scope{ /* recursive/repetitive pointee not shown */ },
	// · · · · StorageDuration: StorageDurationAutomatic,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Case: DirectDeclaratorIdent,
	// · · · · · Token: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: ',',
	// · },
	// }
}

func ExampleStructOrUnion_struct() {
	fmt.Println(exampleAST(115, "\U00100001 struct {"))
	// Output:
	// &cc.StructOrUnion{
	// · Token: STRUCT "struct",
	// }
}

func ExampleStructOrUnion_union() {
	fmt.Println(exampleAST(116, "\U00100001 union {"))
	// Output:
	// &cc.StructOrUnion{
	// · Case: 1,
	// · Token: UNION "union",
	// }
}

func ExampleStructOrUnionSpecifier_tag() {
	fmt.Println(exampleAST(109, "\U00100001 struct a ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: STRUCT "struct",
	// · },
	// · Token: IDENTIFIER "a",
	// }
}

func ExampleStructOrUnionSpecifier_empty() {
	fmt.Println(exampleAST(111, "\U00100001 struct { } ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: 1,
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: STRUCT "struct",
	// · },
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleStructOrUnionSpecifier_define() {
	fmt.Println(exampleAST(114, "\U00100001 struct { _Bool ; } ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: 2,
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · Case: 1,
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · Case: 1,
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Token: BOOL "_Bool",
	// · · · · },
	// · · · },
	// · · · Token: ';',
	// · · },
	// · },
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: STRUCT "struct",
	// · },
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleTypeName_case0() {
	fmt.Println(exampleAST(176, "\U00100000 ( _Bool )"))
	// Output:
	// &cc.TypeName{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · Case: 1,
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Token: BOOL "_Bool",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifier_const() {
	fmt.Println(exampleAST(137, "\U00100001 const !"))
	// Output:
	// &cc.TypeQualifier{
	// · Token: CONST "const",
	// }
}

func ExampleTypeQualifier_restrict() {
	fmt.Println(exampleAST(138, "\U00100001 restrict !"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: 1,
	// · Token: RESTRICT "restrict",
	// }
}

func ExampleTypeQualifier_volatile() {
	fmt.Println(exampleAST(139, "\U00100001 volatile !"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: 2,
	// · Token: VOLATILE "volatile",
	// }
}

func ExampleTypeQualifierList_case0() {
	fmt.Println(exampleAST(158, "\U00100001 * const !"))
	// Output:
	// &cc.TypeQualifierList{
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: CONST "const",
	// · },
	// }
}

func ExampleTypeQualifierList_case1() {
	fmt.Println(exampleAST(159, "\U00100001 * const const !"))
	// Output:
	// &cc.TypeQualifierList{
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: CONST "const",
	// · },
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · Case: 1,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifierListOpt_case0() {
	fmt.Println(exampleAST(160, "\U00100001 * (") == (*TypeQualifierListOpt)(nil))
	// Output:
	// true
}

func ExampleTypeQualifierListOpt_case1() {
	fmt.Println(exampleAST(161, "\U00100001 * const !"))
	// Output:
	// &cc.TypeQualifierListOpt{
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleTypeSpecifier_bool() {
	fmt.Println(exampleAST(93, "\U00100001 _Bool ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Token: BOOL "_Bool",
	// }
}

func ExampleTypeSpecifier_complex() {
	fmt.Println(exampleAST(94, "\U00100001 _Complex ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 1,
	// · Token: COMPLEX "_Complex",
	// }
}

func ExampleTypeSpecifier_char() {
	fmt.Println(exampleAST(95, "\U00100001 char ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 2,
	// · Token: CHAR "char",
	// }
}

func ExampleTypeSpecifier_double() {
	fmt.Println(exampleAST(96, "\U00100001 double ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 3,
	// · Token: DOUBLE "double",
	// }
}

func ExampleTypeSpecifier_float() {
	fmt.Println(exampleAST(97, "\U00100001 float ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 4,
	// · Token: FLOAT "float",
	// }
}

func ExampleTypeSpecifier_int() {
	fmt.Println(exampleAST(98, "\U00100001 int ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 5,
	// · Token: INT "int",
	// }
}

func ExampleTypeSpecifier_long() {
	fmt.Println(exampleAST(99, "\U00100001 long ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 6,
	// · Token: LONG "long",
	// }
}

func ExampleTypeSpecifier_short() {
	fmt.Println(exampleAST(100, "\U00100001 short ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 7,
	// · Token: SHORT "short",
	// }
}

func ExampleTypeSpecifier_signed() {
	fmt.Println(exampleAST(101, "\U00100001 signed ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 8,
	// · Token: SIGNED "signed",
	// }
}

func ExampleTypeSpecifier_unsigned() {
	fmt.Println(exampleAST(102, "\U00100001 unsigned ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 9,
	// · Token: UNSIGNED "unsigned",
	// }
}

func ExampleTypeSpecifier_void() {
	fmt.Println(exampleAST(103, "\U00100001 void ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 10,
	// · Token: VOID "void",
	// }
}

func ExampleTypeSpecifier_enum() {
	fmt.Println(exampleAST(104, "\U00100001 enum a ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 11,
	// · EnumSpecifier: &cc.EnumSpecifier{
	// · · Token: ENUM "enum",
	// · · Token2: IDENTIFIER "a",
	// · },
	// }
}

func ExampleTypeSpecifier_struct() {
	fmt.Println(exampleAST(105, "\U00100001 struct a ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 12,
	// · StructOrUnionSpecifier: &cc.StructOrUnionSpecifier{
	// · · StructOrUnion: &cc.StructOrUnion{
	// · · · Token: STRUCT "struct",
	// · · },
	// · · Token: IDENTIFIER "a",
	// · },
	// }
}

func ExampleTypeSpecifier_name() {
	fmt.Println(exampleAST(106, "\U00100001 typedef int foo; foo bar;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 13,
	// · Token: TYPEDEF_NAME "foo",
	// }
}

func ExampleTypeSpecifier_typeofExpr() {
	fmt.Println(exampleAST(107, "\U00100001 typeof ( 'a' ) ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 14,
	// · Expr: &cc.Expr{
	// · · Case: ExprChar,
	// · · Token: CHARCONST "'a'",
	// · },
	// · Token: TYPEOF "typeof",
	// · Token2: '(',
	// · Token3: ')',
	// }
}

func ExampleTypeSpecifier_typeof() {
	fmt.Println(exampleAST(108, "\U00100001 typeof ( _Bool ) ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 15,
	// · Token: TYPEOF "typeof",
	// · Token2: '(',
	// · Token3: ')',
	// · TypeName: &cc.TypeName{
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · Case: 1,
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Token: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}
