#ifndef KEYTAB_H_
#define KEYTAB_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *keytab_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/keytab.h,v 1.1 2005/05/28 22:27:51 beebe Exp $";
#endif
#endif /* RCSID */

#include "ccmd.h"

/* These functions have argument data types defined in the command
   parser package, ccmd. */

extern char *parse_keyword ARGS((keytab *kt_, int nothing_));
extern int parse_sequence ARGS((const char *def_, fdb *chn_, fdb **altused_));
extern keytab *keylist_to_keytab ARGS((keylist kl_));
extern keytab *mk_alias_keys ARGS((void));
extern time_t datimetogmt ARGS((datime *d_));
extern void brkch ARGS((brktab *p_, unsigned char *s_, unsigned char *s2_));
extern void printfdb ARGS((fdb *fdbs_));
extern void unbrk ARGS((brktab *p_, unsigned char *s_));

#endif /* KEYTAB_H_ */
