#include "args.h"

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/hname.c,v 1.1 2005/05/28 22:27:51 beebe Exp $";
#endif

/*
 * hname - return the local hostname
 *
 */

#include "mm.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#ifdef MMHOSTNAME
char *
hname ()
{
    return (char *) MMHOSTNAME;
}

int
isourhost (host)
char *host;
{
    return (ustrcmp (host, MMHOSTNAME) == 0);
}
#else

#ifdef GETHOSTNAME
#include <netdb.h>
struct hostent *gethostbyname()

char *
hname ()
{
    char name[MAXHOSTNAMELEN], *result;
    struct hostent *h;

    gethostname(name, sizeof name);
    if (h = gethostbyname(name)) {	/* get host entry */
	result = (char*)malloc (strlen (h->h_name) +1);
	if (result)
	    strcpy (result, h->h_name);
	else
	    panic ("hname: no space\n");
    }

    return result;
}

/*
 * This is too expensive--needs to be redone.
 */
int
isourhost (host)
char *host;
{
    char name[MAXHOSTNAMELEN];
    struct hostent *h;
    char **aliases;

    /* don't bother the nameserver if we don't have to */
    if (ustrcmp (host, ourhostname) == 0)
	return true;

    if (h = gethostbyname (host)) {
	if (ustrcmp (h->h_name, ourhostname) == 0)
	    return true;
    }

    return false;
}
#else
#ifdef DOUNAME
/*
 * XXX - not tested
 */
#include <sys/utsname>

char *
hname ()
{
    char *result;
    struct utsname name;

    uname (&name);
    result = (char*)malloc (strlen (name.nodename) + 4);
    if (result)
	strcpy (result, name.nodename);
    else
	panic ("hname: no space\n");
    return result;
}

int
isourhost (host)
char *host;
{
    return (ustrcmp (host, ourhostname) == 0);
}
#endif /* !DOUNAME */
#endif /* !GETHOSTNAME */
#endif /* !defined (MMHOSTNAME) */
