#ifndef CMFIL_H_
#define CMFIL_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

 Author: Howie Kaye
*/
/*
 * CMFIL.h:
 * symbols for filename parsing
 */


#define REGEXCHARS "$^.*+?[]\\"
#define REGEXQCHARS "|()123456789"

/*
 * internal filename parser symbols
 */
#define FIL_MAT 0x0001			/* a match so far */
#define FIL_NOR 0x0002			/* ignorable */
#define FIL_INV 0x0004			/* invisible */
#define FIL_EXA 0x0008			/* exact match (for wilds) */
#define FIL_ARD	0x0010			/* readable file */
#define FIL_AWR 0x0020			/* writable file */
#define FIL_AEX 0x0040			/* executable file */
#define FIL_ADR 0x0080			/* directory */
#define FIL_ASY 0x0100			/* system file */
#define FIL_AHD 0x0200			/* hidden file */
#define FIL_ALK 0x0400			/* symbolic link */
#define FIL_ASRCH 0x0800		/* directory execute */
#define FIL_STAT 0x1000			/* internal.  already stat'ed */
#define FIL_ARW	0x2000			/* readable abd writable */

#endif /* CMFIL_H_ */
