/*
  $Id:$
 */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#ifdef M_HAVE_READLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif

#include "minami.h"
#include "scene.h"
#include "item.h"
#include "version.h"

You you;
Minami minami[MAX_SCENE + 1];

void
ChangeFlag(int scene, int n, int onoff)
{
    if(onoff){
	minami[scene].flags |= (1U << (n%32));
	if(you.f_debug)
	    fmtmsg("**DEBUG FLAG:%d,%d 0->1\n", scene, n);
    }
    else{
	minami[scene].flags &= ~(1U << (n%32));
	if(you.f_debug)
	    fmtmsg("**DEBUG FLAG:%d,%d 1->0\n", scene, n);
    }
}

int
GetMoney(int cost)
{
    you.gold += cost;
    return you.gold;
}

int
GetItem(int item)
{
    you.items[item].flag[0] |= I_HAVE;

    return 1;
}

int
LostAllItem()
{
    int i;

    for(i=0 ; i<NUM_ITEMS ; ++i){
	you.items[i].flag[0] &= ~I_HAVE;
	you.items[i].flag[0] &= ~I_DROP;
    }

    return 1;
}
int
DropItem(int item)
{
    you.items[item].flag[0] |= I_DROP;

    return 1;
}

int
UseItem(int item, int onoff)
{
    if(onoff)
	you.items[item].flag[0] |= I_USE;
    else
	you.items[item].flag[0] &= ~I_USE;

    return 1;
}

int
NewScene(int scene)
{
/*    you.oscene = you.scene;*/
    you.scene = scene;

    return MIN_OK;
}

int
WieldItem(int item, int onoff)
{
    ItemTab *itab = ItemByNum(item);

    if(!itab || !I_Have(item)){
	fmtmsg("Ͻʤ\n");
	return MIN_OK;
    }

    if(!itab)
	return MIN_OK;
    if(!I_Have(item))
	return MIN_OK;

    if(onoff){
	if(I_Use(item)){
	    fmtmsg("⤦%sˤƤ\n", itab->name);
	    return MIN_OK;
	}
	else if(I_Use(you.wield)){
	    fmtmsg("ܤƱ˻Ȥʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] |= I_USE;
	    you.wield = item;
	}
    }
    else{
	if(!I_Use(item)){
	    fmtmsg("%sƤʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] &= ~I_USE;
	    you.wield = 0;
	}
    }

    return MIN_CONT;
}


int
PutonItem(int item, int onoff)
{
    ItemTab *itab = ItemByNum(item);

    if(!itab || !I_Have(item)){
	fmtmsg("Ͻʤ\n");
	return MIN_OK;
    }

    if(!itab)
	return MIN_OK;
    if(!I_Have(item))
	return MIN_OK;

    if(onoff){
	if(I_Wear(item)){
	    fmtmsg("⤦%säƤ\n", itab->name);
	    return MIN_OK;
	}
	else if(I_Wear(you.puton)){
	    fmtmsg("Ťͤ뤳ȤϽʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] |= I_WEAR;
	    you.puton = item;
	}
    }
    else{
	if(!I_Wear(item)){
	    fmtmsg("%säƤʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] &= ~I_WEAR;
	    you.puton = 0;
	}
    }

    return MIN_CONT;
}

int
WearItem(int item, int onoff)
{
    ItemTab *itab = ItemByNum(item);

    if(!itab || !I_Have(item)){
	fmtmsg("Ͻʤ\n");
	return MIN_OK;
    }

    if(onoff){
	if(I_Wear(item)){
	    fmtmsg("⤦%sƤ\n", itab->name);
	    return MIN_OK;
	}
	else if(I_Wear(you.wear)){
	    fmtmsg("νŤϽʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] |= I_WEAR;
	    you.wear = item;
	}
    }
    else{
	if(!I_Wear(item)){
	    fmtmsg("%sƤʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] &= ~I_WEAR;
	    you.wear = 0;
	}
    }

    return MIN_CONT;
}

int
WearItemS(int item, int onoff)
{
    ItemTab *itab = ItemByNum(item);

    if(!itab || !I_Have(item)){
	fmtmsg("Ͻʤ\n");
	return MIN_OK;
    }

    if(onoff){
	if(I_Wear(item)){
	    fmtmsg("⤦%sƤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.shirt){
	    fmtmsg("ĤνŤϽʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.wear){
	    fmtmsg("ξ夫饷Ĥʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] |= I_WEAR;
	    you.shirt = item;
	}
    }
    else{
	if(!I_Wear(item)){
	    fmtmsg("%sƤʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.wear){
	    fmtmsg("æʤȥĤæʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] &= ~I_WEAR;
	    you.shirt = 0;
	}
    }

    return MIN_CONT;
}

int
WearItemU(int item, int onoff)
{
    ItemTab *itab = ItemByNum(item);

    if(!itab || !I_Have(item)){
	fmtmsg("Ͻʤ\n");
	return MIN_OK;
    }

    if(!itab)
	return MIN_OK;
    if(!I_Have(item))
	return MIN_OK;

    if(onoff){
	if(I_Wear(item)){
	    fmtmsg("⤦%sƤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.under){
	    fmtmsg("νŤϽʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.shirt){
	    fmtmsg("Ĥξ夫鲼ʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.wear){
	    fmtmsg("ξ夫鲼ʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] |= I_WEAR;
	    you.under = item;
	}
    }
    else{
	if(!I_Wear(item)){
	    fmtmsg("%sƤʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.shirt){
	    fmtmsg("ĤæʤȲæʤ\n", itab->name);
	    return MIN_OK;
	}
	else if(you.wear){
	    fmtmsg("æʤȲæʤ\n", itab->name);
	    return MIN_OK;
	}
	else{
	    you.items[item].flag[0] &= ~I_WEAR;
	    you.under = 0;
	}
    }

    return MIN_CONT;
}

int
I_Use(int item)
{
    return you.items[item].flag[0] & I_USE;
}

int
I_Wear(int item)
{
    return you.items[item].flag[0] & I_WEAR;
}

int
I_Have(int item)
{
    Inventory *i;

    i = &(you.items[item]);

    return (i->flag[0] & I_HAVE) && !(i->flag[0] &  I_DROP);
}

int
I_Useup(int item)
{
    Inventory *i;

    i = &(you.items[item]);

    return (i->flag[0] & I_DROP);
}

int
I_Got(int item)
{
    Inventory *i;

    i = &(you.items[item]);

    return (i->flag[0] & I_HAVE);
}

int
HaveItemByName(const char *name)
{
    return I_Have(ItemByName(name)->n);
}

void
BuyItem(int n)
{
    ItemTab *itab = ItemByNum(n);

    if(itab){
	if(I_Have(n))
	    fmtmsg("⤦%säƤ롣", itab->name);
	else if(itab->price > you.gold)
	    fmtmsg("%sˤϤ⤬­ʤ", itab->name);
	else if(itab->price > 0){
	    fmtmsg("%s", itab->name);
	    GetItem(n);
	    GetMoney(-itab->price);
	}
    }
    return;
}

void
rawmsg(const char *s)
{
    while(*s){
	if(*s == '')
	    More();
	else if((*s == '')){
	    if(!status.f_nowait)
		sleep(1);
	}
	else if((*s == '')){
	    if(!status.f_nowait)
		usleep(200000);
	}
	else if((*s & 0x80)== 0){
	    fputc(*s, stderr);
	}
	else{
	    fputc(*s, stderr);
	    ++s;
	    fputc(*s, stderr);
	    if(!status.f_nowait){
		if(s[-1] == ""[0] && s[0] == ""[1] 
		   && s[1] == ""[0] && s[2] == ""[1] )
		    usleep(200000);
		else if(s[-1] == ""[0] && s[0] == ""[1] 
		   && s[1] == ""[0] && s[2] == ""[1] )
		    usleep(200000);
	    }
	}
	++s;
    }
}

int
min_vasprintf(char **b, const char *fmt, va_list ap)
{
    int ret = 0;
    int sz;
    char *p;

    sz = BUFSIZ;
    
    while(1){
	p = malloc(sz);
	if(!p)
	    break;
	ret = vsnprintf(p, sz, fmt, ap);
	if(ret < sz - 1)
	    break;


	free(p);
	sz *= 2;
    }
    *b = p;
    return ret;
}

void
fmtmsg(const char *fmt, ...)
{
    char *tmpbuf;
    char *tmpbuf2;
    char *s;
    char *p;
    extern char *term_mr, *term_me;
    va_list ap;

    va_start(ap, fmt);
    min_vasprintf(&tmpbuf, fmt, ap);
    va_end(ap);

    s = tmpbuf;
    p = tmpbuf2 = malloc(strlen(tmpbuf) + BUFSIZ);

    while(*s){
	if(*s == '$'){
	    ++s;
	    if(*s == '$')
		*(p++) = '$';
	    else if(*s == 'P'){
		*(p++) = '';
	    }
	    else if(*s == 'b'){
		p += sprintf(p, "%s", term_mr);
	    }
	    else if(*s == 'n'){
		p += sprintf(p, "%s", term_me);
	    }
/*
	    else if(*s == 'v'){
		p += sprintf(p, "%s", term_vb);
	    }
*/
	    else if(*s == 'W'){
		*(p++) = '';
	    }
	    else if(*s == 'w'){
		*(p++) = '';
	    }
	    else if(*s == 'M'){
		p += sprintf(p, "%s", you.name);
	    }
	    else if(*s == 'G'){
		p += sprintf(p, "%s", you.friend);
	    }
	    else if(*s == 'N'){
		p += sprintf(p, "%s", you.nemesis);
	    }
	    else if(*s == 'C'){
		p += sprintf(p, "%d", minami[you.scene].cntdown - 1);
	    }
	    else if(*s == 's'){
		p += sprintf(p, "/");
	    }
	    else if(*s == 'c'){
		p += sprintf(p, "c");
	    }
	    ++s;
	}
	else
	    *(p++) = *(s++);
    }
    *p = '\0';

    rawmsg(tmpbuf2);

    free(tmpbuf);
    free(tmpbuf2);
}

void
msg(const char *s)
{
    fmtmsg("%s", s);
}

char *
rot13_47(const unsigned char *s)
{
    char *rotstr, *p;

    p = rotstr = malloc(strlen(s) + 1);
    while(*s){
	if(*s >= 'a' && *s <= 'z')
	    *p = ((*s - 'a' + 13) % 26) + 'a';
	else if(*s >= 'A' && *s <= 'Z')
	    *p = ((*s - 'A' + 13) % 26) + 'A';
	else if(*s >= 0xa1 && *s <= 0xfe)
	    *p = ((*s - 0xa1 + 47) % 94) + 0xa1;
	else
	    *p = *s;
	++s;
	++p;
    }
    *p = '\0';
    return rotstr;
}

void
rotmsg(const char *s)
{
    char *p = rot13_47(s);
    msg(p);
    free(p);
}

static int
DebugScene(int scene, const char *verb, const char *obj)
{
    int i;
    int begin, end;

    if(!*obj){
	i = scene;
	fmtmsg("%d %s %s\n", i, sceneTab[i].name, sceneTab[i].sym);
    }
    else if(EQ(obj, "all")){
	for(i=0 ; i<VOID; ++i)
	    fmtmsg("%d %s %s\n", i, sceneTab[i].name, sceneTab[i].sym);
    }
    else if(sscanf(obj, "%d,%d", &begin, &end)==2){
	for(i=begin ; i<=end; ++i)
	    fmtmsg("%d %s %s\n", i, sceneTab[i].name, sceneTab[i].sym);
    }
    else if(*obj >= '0' && *obj <= '9'){
/*	fmtmsg("%dذư\n", atoi(obj));*/
	NewScene(atoi(obj));
    }
    else{
	for(i=0 ; i<VOID ; ++i)
	    if(EQ(sceneTab[i].sym, obj)){
/*		fmtmsg("%sذư\n", obj);*/
		NewScene(i);
		break;
	    }
    }

    return MIN_OK;
}

static int
DebugFlag(int scene, const char *verb, const char *obj)
{
    int s;
    int i = 0;
    Minami *m;

    if(!*obj){
	s = scene;
	m = &minami[s];
	fmtmsg("\n%03d %4d %4d", s, m->times, m->cnt);
	for(i=0 ; i < 32; ++i){
	    if(i%8 == 0)
		fmtmsg(" ");
	    fmtmsg("%d", !!IsSetFlag(s, i));
	}
    }
    else if(EQ(obj, "all")){
	for(s=1 ; s < VOID ; ++s){
	    m = &minami[s];
	    fmtmsg("\n%03d %4d %4d", s, m->times, m->cnt);
	    for(i=0 ; i < 32; ++i){
		if(i%8 == 0)
		    fmtmsg(" ");
		fmtmsg("%d", !!IsSetFlag(s, i));
	    }
	}
    }
    else if(*obj >= '0' && *obj <= '9'){
	int n, n2;
	char *idx;

	idx = index(obj, ',');
	if(idx){
	    n = atoi(obj);
	    n2 = atoi(idx+1);
	}
	else{
	    n = scene;
	    n2 = atoi(obj);
	}

	ChangeFlag(n, n2, !IsSetFlag(n, n2));
    }

    fmtmsg("\n");
    return MIN_OK;
}

int
DebugYou(int scene, const char *verb, const char *obj)
{
    scene = you.scene;

    fmtmsg("scene: %d(%s,%s)\n", scene, sceneTab[scene].name, sceneTab[scene].sym);
    fmtmsg("name: %s\n", you.name);
    fmtmsg("friend: %s\n", you.friend);
    fmtmsg("nemesis: %s\n", you.nemesis);
    fmtmsg("female: %d\n", you.f_female);
    fmtmsg("ignore_talk: %d\n", you.f_ignore_talk);

    return MIN_OK;
}

static int
Save(int scene, const char *verb, const char *obj)
{
    char *home;
    char *filename;
    int fd;

    if(obj && *obj)
	filename = strdup(obj);
    else{
	home = getenv("HOME");
	filename = malloc(strlen(home) + 16);
	strcpy(filename, home);
	strcat(filename, "/.minamisave");
    }
    
    fd = creat(filename, 0600);
    if(fd < 0){
	perror(filename);
	return MIN_CONT;
    }
    write(fd, &you, sizeof(You));
    write(fd, minami, sizeof(Minami) * MAX_SCENE);
    close(fd);
    
    free(filename);
    fmtmsg("ִλ\n줵ޤǤ\n");

    NewScene(GAMEOVER);
    return MIN_OK;
}

static int
Load(int scene, const char *verb, const char *obj)
{
    char *home;
    char *filename;
    int fd;

    if(obj && *obj)
	filename = strdup(obj);
    else{
	home = getenv("HOME");
	filename = malloc(strlen(home) + 16);
	strcpy(filename, home);
	strcat(filename, "/.minamisave");
    }
    
    fd = open(filename, O_RDONLY);
    if(fd < 0)
	return 0;

    read(fd, &you, sizeof(You));
    read(fd, minami, sizeof(Minami) * MAX_SCENE);
    close(fd);
    
    if(!obj || !*obj)
	unlink(filename);

    free(filename);
    fmtmsg("ɴλ\n$P");

    return MIN_OK;
}

void
chop(char *str)
{
    int len = strlen(str);

    if(len > 0 && str[len-1] == '\n')
	str[len-1] = '\0';
}

static int
LoadRc()
{
    char *home;
    char *filename;
    FILE *fp;
    char buf[BUFSIZ];

    home = getenv("HOME");

    filename = malloc(strlen(home) + 16);
    strcpy(filename, home);
    strcat(filename, "/.minamirc");
    
    if((fp = fopen(filename, "r")) == NULL){
	free(filename);
	return MIN_OK;
    }
/*
ǤʸĹΥå򤷤Ƥʤ(Τˡ)
 */
    while(fgets(buf, BUFSIZ, fp) != NULL){
	chop(buf);
	if(EQN(buf, "name=", 5))
	    strcpy(you.name, buf + 5);
	else if(EQN(buf, "friend=", 7))
	    strcpy(you.friend, buf + 7);
	else if(EQN(buf, "nemesis=", 8))
	    strcpy(you.nemesis, buf + 8);
	else if(EQN(buf, "type=", 5))
	    ;
    }
    fclose(fp);
    free(filename);

    return MIN_NG;
}

int
DefaultAction(int scene, const char *verb, const char *obj, int map)
{
    extern const char *minami_help();
    ItemTab *itab = NULL;

    if(*obj)
	itab = ItemByName(obj);

    if(0)
	;
    else if(EQ(verb, "wait") && EQ(obj, "on")){
	fmtmsg("ȥ\n");
	status.f_nowait = 0;
	return MIN_OK;
    }
    else if(EQ(verb, "wait") && EQ(obj, "off")){
	fmtmsg("ȥ\n");
	status.f_nowait = 1;
	return MIN_OK;
    }
    else if(you.f_debug && EQ(verb, "flag")){
	return DebugFlag(scene, verb, obj);
    }
    else if(you.f_debug && EQ(verb, "scene")){
	return DebugScene(scene, verb, obj);
    }
    else if(you.f_debug && EQ(verb, "you")){
	return DebugYou(scene, verb, obj);
    }
    else if(you.f_debug && EQ(verb, "create")){
	if(EQ(obj, "all")){
	    int i;
	    for(i=1 ; i<NUM_ITEMS ; ++i)
		GetItem(i);
	    fmtmsg("**DEBUG ʤƥ\n");
	}
	else if(itab){
	    GetItem(itab->n);
	    fmtmsg("**DEBUG ʤ%s\n", itab->name);
	}
	else{
	    fmtmsg("**DEBUG %s¸ߤʤ\n", obj);
	}
	return MIN_OK;
    }
    else if(you.f_debug && EQ(verb, "dbgflag")){
	return DebugFlag(scene, verb, obj);
    }
    else if(EQ(verb, "save")){
	return Save(scene, verb, obj);
    }
    else if(EQ(verb, "load")){
	return Load(scene, verb, obj);
    }
    else if(EQ(verb, "map") || EQ(verb, "m")){
	if(map == 0){
	    fmtmsg("ưǽϤʤ\n");
	    return MIN_OK;
	}
	else{
	    fmtmsg("ưǽ\n");
	    if(map & MAP_n)
		fmtmsg("$bN$north, ");
	    if(map & MAP_s)
		fmtmsg("$bS$nouth, ");
	    if(map & MAP_e)
		fmtmsg("$bE$nast, ");
	    if(map & MAP_w)
		fmtmsg("$bW$nest, ");
	    if(map & MAP_u)
		fmtmsg("$bU$np, ");
	    if(map & MAP_d)
		fmtmsg("$bD$nown, ");
	    if(map & MAP_enter)
		fmtmsg("Enter, ");
	    if(map & MAP_exit)
		fmtmsg("Exit, ");
	    
	    fmtmsg("\n\nʡ\n");
	    return MIN_OK;
	}
    }
    else if(EQ(verb, "n") ||EQ(verb, "north") ||
	    EQ(verb, "e") ||EQ(verb, "east") ||
	    EQ(verb, "w") ||EQ(verb, "west") ||
	    EQ(verb, "s") ||EQ(verb, "south") ||
	    EQ(verb, "d") ||EQ(verb, "down") ||
	    EQ(verb, "u") ||EQ(verb, "up")){
	fmtmsg("˰ư뤳ȤϤǤʤ\n");
	return MIN_OK;
    }
    else if(EQ(verb, "version")){
	fmtmsg("ɥɥ٥㡼 Ver. %s, Build at %s\n", 
	       MINAMI_VERSION, MINAMI_BUILD);
	return MIN_OK;
    }
    else if(EQ(verb, "copyright")){
	fmtmsg("MINAMI SHINJUKU ADBENTURE\n(C)2001, Issei Numata and ASCII COPRPORATION.");
	return MIN_OK;
    }

    fmtmsg("ϤǤʤ\n");
    return MIN_OK;
}

void
sig_handler(int sig)
{
    int ans;

    fprintf(stderr, "%d\n", sig);
    if(sig == SIGINT){
	ans = Yn("롩(y or n)");
	if(ans == 'y'){
	    fmtmsg("\n");
	    SceneHandler(SIGNAL, "msg", "");
	    fmtmsg("\n");
	    exit(0);
	}
	fmtmsg("\n³ޤ");
    }
} 

int
SceneHandler(int scene, const char *verb, const char *obj)
{
    int contflg = MIN_CONT;
    ActionTab *a;
    VerbTab *v;

    a = actionTab;
    if(!*verb)
	verb = "msg";

    while(a->scene){
	if(a->scene == scene){
	    contflg = a->action(scene, verb, obj);
	    if(contflg != MIN_CONT)
		return contflg;
	}
	++a;
    }
    if((contflg = action_ITEM(ITEM, verb, obj)) != MIN_CONT)
	return contflg;

    v = verbTab;
    while(v->verb){
	if(EQ(v->verb, verb)){
	    contflg = v->action(scene, verb, obj);
	    if(contflg != MIN_CONT)
		return contflg;
	}
	++v;
    }

    if((contflg = DefaultAction(scene, verb, obj, CheckMove(scene))))
	return contflg;
    
    if(contflg == MIN_CONT)
	fmtmsg("ޥɤ㤤ޤ");

    return contflg;
}

void
usage()
{
    fprintf(stderr, "minami [-n] [save file]\n");
    exit(1);
}

int
main(int argc, char **argv)
{
    char verb[BUFSIZ];
    char obj[BUFSIZ];
    extern char *optarg;
    extern int optind;
    int ch;

    fmtmsg("ɥɥ٥㡼 Ver. %s, Build at %s\n\n\n", 
	   MINAMI_VERSION, MINAMI_BUILD);
/*
    while((ch = getopt(argc, argv, "nd")) != -1){
*/
    while((ch = getopt(argc, argv, "n")) != -1){
	switch(ch){
	case 'n':
	    status.f_nowait = 1;
	    break;
	case 'd':
	    status.f_debug = 1;
	    break;
	case '?':
	default:
	    usage();
	    exit(0);
	    break;
	}
    }
    argc -= optind;
    argv += optind;

    signal(SIGINT, sig_handler);

#ifdef M_HAVE_READLINE
    using_history();
#endif
    InitTerm();

    LoadRc();

    Load(0, "", "");

    if(you.scene == 0 && argc >= 1)
	Load(0, "", argv[0]);

    if(you.f_debug){
	if(you.scene == 0 && argc >= 1){
	    DebugScene(0, NULL, argv[0]);
	    you.gold = 40000;
	    you.maxhp = you.hp = 40;
	    GetItem(ITEM_HAWAIIAN_SHIRT);
	    WearItemS(ITEM_HAWAIIAN_SHIRT, 1);
	}
    }

    if(you.scene == 0){
	you.scene = 1;
	you.gold = 40000;
	you.maxhp = you.hp = 40;
	GetItem(ITEM_HAWAIIAN_SHIRT);
	WearItemS(ITEM_HAWAIIAN_SHIRT, 1);
    }

    if(you.name[0] == '\0')
	strcpy(you.name, "̥ޥ");
    if(you.friend[0] == '\0')
	strcpy(you.friend,"");
    if(you.nemesis[0] == '\0')
	strcpy(you.nemesis, "Ĺ");

    verb[0] = '\0';
    obj[0] = '\0';

    while(1){
	while(1){
	    you.oscene = you.scene;
	    SceneHandler(you.scene, verb, obj);
	    if(you.scene < 0)
		goto GameOver;
	    if(you.scene != you.oscene){
		fmtmsg("\n");
		strcpy(verb, "msg");
		strcpy(obj, "");
		minami[you.scene].tmpcnt = 0;
		continue;
	    }
	    break;
	}
	minami[you.scene].times++;
	if(minami[you.scene].cntdown > 0)
	    minami[you.scene].cntdown--;

	if(Q_Talk(you.scene) == MIN_FALSE)
	    you.f_ignore_talk = 1;
	else
	    you.f_ignore_talk = 0;

	while(Prompt(verb, obj) < 0)
	    ;

	if(!*verb)
	    continue;
    }
 GameOver:

    fmtmsg("$P\n");
    return 0;
}
