// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: stats.proto

package stats

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	_ "google.golang.org/protobuf/types/known/durationpb"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Stats struct {
	// The sum of all wall time spent in the querier to execute the query.
	WallTime time.Duration `protobuf:"bytes,1,opt,name=wall_time,json=wallTime,proto3,stdduration" json:"wall_time"`
	// The number of series fetched for the query
	FetchedSeriesCount uint64 `protobuf:"varint,2,opt,name=fetched_series_count,json=fetchedSeriesCount,proto3" json:"fetched_series_count,omitempty"`
	// The number of bytes of the chunks fetched for the query, after any deduplication
	FetchedChunkBytes uint64 `protobuf:"varint,3,opt,name=fetched_chunk_bytes,json=fetchedChunkBytes,proto3" json:"fetched_chunk_bytes,omitempty"`
	// The number of chunks fetched for the query, after any deduplication
	FetchedChunksCount uint64 `protobuf:"varint,4,opt,name=fetched_chunks_count,json=fetchedChunksCount,proto3" json:"fetched_chunks_count,omitempty"`
	// The number of sharded queries executed. 0 if sharding is disabled or the query can't be sharded.
	ShardedQueries uint32 `protobuf:"varint,5,opt,name=sharded_queries,json=shardedQueries,proto3" json:"sharded_queries,omitempty"`
	// The number of split partial queries executed. 0 if splitting is disabled or the query can't be split.
	SplitQueries uint32 `protobuf:"varint,6,opt,name=split_queries,json=splitQueries,proto3" json:"split_queries,omitempty"`
	// The number of index bytes fetched on the store-gateway for the query
	FetchedIndexBytes uint64 `protobuf:"varint,7,opt,name=fetched_index_bytes,json=fetchedIndexBytes,proto3" json:"fetched_index_bytes,omitempty"`
	// The estimated number of series to be fetched for the query
	EstimatedSeriesCount uint64 `protobuf:"varint,8,opt,name=estimated_series_count,json=estimatedSeriesCount,proto3" json:"estimated_series_count,omitempty"`
	// The sum of durations that the query spent in the queue, before it was handled by querier.
	QueueTime time.Duration `protobuf:"bytes,9,opt,name=queue_time,json=queueTime,proto3,stdduration" json:"queue_time"`
	// The time spent at the frontend encoding the query's final results. Does not include time spent serializing results at the querier.
	EncodeTime time.Duration `protobuf:"bytes,10,opt,name=encode_time,json=encodeTime,proto3,stdduration" json:"encode_time"`
}

func (m *Stats) Reset()      { *m = Stats{} }
func (*Stats) ProtoMessage() {}
func (*Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4756a0aec8b9d44, []int{0}
}
func (m *Stats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stats.Merge(m, src)
}
func (m *Stats) XXX_Size() int {
	return m.Size()
}
func (m *Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_Stats.DiscardUnknown(m)
}

var xxx_messageInfo_Stats proto.InternalMessageInfo

func (m *Stats) GetWallTime() time.Duration {
	if m != nil {
		return m.WallTime
	}
	return 0
}

func (m *Stats) GetFetchedSeriesCount() uint64 {
	if m != nil {
		return m.FetchedSeriesCount
	}
	return 0
}

func (m *Stats) GetFetchedChunkBytes() uint64 {
	if m != nil {
		return m.FetchedChunkBytes
	}
	return 0
}

func (m *Stats) GetFetchedChunksCount() uint64 {
	if m != nil {
		return m.FetchedChunksCount
	}
	return 0
}

func (m *Stats) GetShardedQueries() uint32 {
	if m != nil {
		return m.ShardedQueries
	}
	return 0
}

func (m *Stats) GetSplitQueries() uint32 {
	if m != nil {
		return m.SplitQueries
	}
	return 0
}

func (m *Stats) GetFetchedIndexBytes() uint64 {
	if m != nil {
		return m.FetchedIndexBytes
	}
	return 0
}

func (m *Stats) GetEstimatedSeriesCount() uint64 {
	if m != nil {
		return m.EstimatedSeriesCount
	}
	return 0
}

func (m *Stats) GetQueueTime() time.Duration {
	if m != nil {
		return m.QueueTime
	}
	return 0
}

func (m *Stats) GetEncodeTime() time.Duration {
	if m != nil {
		return m.EncodeTime
	}
	return 0
}

func init() {
	proto.RegisterType((*Stats)(nil), "stats.Stats")
}

func init() { proto.RegisterFile("stats.proto", fileDescriptor_b4756a0aec8b9d44) }

var fileDescriptor_b4756a0aec8b9d44 = []byte{
	// 394 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xb1, 0x4e, 0xc2, 0x40,
	0x18, 0xc7, 0x7b, 0x0a, 0x08, 0x87, 0x68, 0xac, 0xc4, 0x54, 0x86, 0x83, 0xe8, 0x20, 0x53, 0x31,
	0xea, 0xe6, 0x62, 0x0a, 0x8b, 0xa3, 0xe0, 0xe4, 0xd2, 0x94, 0xf6, 0x28, 0x8d, 0xa5, 0x07, 0xbd,
	0x6b, 0xd4, 0xcd, 0x47, 0x70, 0x34, 0xf1, 0x05, 0x7c, 0x14, 0x46, 0x46, 0x26, 0x95, 0xb2, 0x38,
	0xf2, 0x08, 0xe6, 0xee, 0x5a, 0x02, 0x4e, 0x6c, 0xbd, 0xef, 0xf7, 0xfd, 0xee, 0xff, 0xe5, 0xbe,
	0xc2, 0x22, 0x65, 0x16, 0xa3, 0xfa, 0x30, 0x24, 0x8c, 0xa8, 0x59, 0x71, 0xa8, 0x94, 0x5d, 0xe2,
	0x12, 0x51, 0x69, 0xf0, 0x2f, 0x09, 0x2b, 0xc8, 0x25, 0xc4, 0xf5, 0x71, 0x43, 0x9c, 0xba, 0x51,
	0xaf, 0xe1, 0x44, 0xa1, 0xc5, 0x3c, 0x12, 0x48, 0x7e, 0xf2, 0x91, 0x81, 0xd9, 0x0e, 0xf7, 0xd5,
	0x1b, 0x58, 0x78, 0xb2, 0x7c, 0xdf, 0x64, 0xde, 0x00, 0x6b, 0xa0, 0x06, 0xea, 0xc5, 0x8b, 0x63,
	0x5d, 0xda, 0x7a, 0x6a, 0xeb, 0xad, 0xc4, 0x36, 0xf2, 0xe3, 0xaf, 0xaa, 0xf2, 0xfe, 0x5d, 0x05,
	0xed, 0x3c, 0xb7, 0xee, 0xbd, 0x01, 0x56, 0xcf, 0x61, 0xb9, 0x87, 0x99, 0xdd, 0xc7, 0x8e, 0x49,
	0x71, 0xe8, 0x61, 0x6a, 0xda, 0x24, 0x0a, 0x98, 0xb6, 0x55, 0x03, 0xf5, 0x4c, 0x5b, 0x4d, 0x58,
	0x47, 0xa0, 0x26, 0x27, 0xaa, 0x0e, 0x0f, 0x53, 0xc3, 0xee, 0x47, 0xc1, 0xa3, 0xd9, 0x7d, 0x61,
	0x98, 0x6a, 0xdb, 0x42, 0x38, 0x48, 0x50, 0x93, 0x13, 0x83, 0x83, 0xd5, 0x04, 0xd1, 0x9f, 0x26,
	0x64, 0xd6, 0x12, 0x84, 0x90, 0x24, 0x9c, 0xc1, 0x7d, 0xda, 0xb7, 0x42, 0x07, 0x3b, 0xe6, 0x28,
	0x12, 0xc9, 0x5a, 0xb6, 0x06, 0xea, 0xa5, 0xf6, 0x5e, 0x52, 0xbe, 0x93, 0x55, 0xf5, 0x14, 0x96,
	0xe8, 0xd0, 0xf7, 0xd8, 0xb2, 0x2d, 0x27, 0xda, 0x76, 0x45, 0x31, 0x6d, 0x5a, 0x99, 0xd7, 0x0b,
	0x1c, 0xfc, 0x9c, 0xcc, 0xbb, 0xb3, 0x36, 0xef, 0x2d, 0x27, 0x72, 0xde, 0x2b, 0x78, 0x84, 0x29,
	0xf3, 0x06, 0x16, 0xfb, 0xff, 0x26, 0x79, 0xa1, 0x94, 0x97, 0x74, 0xf5, 0x55, 0x0c, 0x08, 0x47,
	0x11, 0x8e, 0xb0, 0x5c, 0x45, 0x61, 0xf3, 0x55, 0x14, 0x84, 0x26, 0x76, 0xd1, 0x82, 0x45, 0x1c,
	0xd8, 0xc4, 0x49, 0x2e, 0x81, 0x9b, 0x5f, 0x02, 0xa5, 0xc7, 0x6f, 0x31, 0xae, 0x27, 0x33, 0xa4,
	0x4c, 0x67, 0x48, 0x59, 0xcc, 0x10, 0x78, 0x8d, 0x11, 0xf8, 0x8c, 0x11, 0x18, 0xc7, 0x08, 0x4c,
	0x62, 0x04, 0x7e, 0x62, 0x04, 0x7e, 0x63, 0xa4, 0x2c, 0x62, 0x04, 0xde, 0xe6, 0x48, 0x99, 0xcc,
	0x91, 0x32, 0x9d, 0x23, 0xe5, 0x41, 0xfe, 0x90, 0xdd, 0x9c, 0x48, 0xb9, 0xfc, 0x0b, 0x00, 0x00,
	0xff, 0xff, 0xa6, 0x97, 0xf0, 0x6e, 0xad, 0x02, 0x00, 0x00,
}

func (this *Stats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Stats)
	if !ok {
		that2, ok := that.(Stats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.WallTime != that1.WallTime {
		return false
	}
	if this.FetchedSeriesCount != that1.FetchedSeriesCount {
		return false
	}
	if this.FetchedChunkBytes != that1.FetchedChunkBytes {
		return false
	}
	if this.FetchedChunksCount != that1.FetchedChunksCount {
		return false
	}
	if this.ShardedQueries != that1.ShardedQueries {
		return false
	}
	if this.SplitQueries != that1.SplitQueries {
		return false
	}
	if this.FetchedIndexBytes != that1.FetchedIndexBytes {
		return false
	}
	if this.EstimatedSeriesCount != that1.EstimatedSeriesCount {
		return false
	}
	if this.QueueTime != that1.QueueTime {
		return false
	}
	if this.EncodeTime != that1.EncodeTime {
		return false
	}
	return true
}
func (this *Stats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&stats.Stats{")
	s = append(s, "WallTime: "+fmt.Sprintf("%#v", this.WallTime)+",\n")
	s = append(s, "FetchedSeriesCount: "+fmt.Sprintf("%#v", this.FetchedSeriesCount)+",\n")
	s = append(s, "FetchedChunkBytes: "+fmt.Sprintf("%#v", this.FetchedChunkBytes)+",\n")
	s = append(s, "FetchedChunksCount: "+fmt.Sprintf("%#v", this.FetchedChunksCount)+",\n")
	s = append(s, "ShardedQueries: "+fmt.Sprintf("%#v", this.ShardedQueries)+",\n")
	s = append(s, "SplitQueries: "+fmt.Sprintf("%#v", this.SplitQueries)+",\n")
	s = append(s, "FetchedIndexBytes: "+fmt.Sprintf("%#v", this.FetchedIndexBytes)+",\n")
	s = append(s, "EstimatedSeriesCount: "+fmt.Sprintf("%#v", this.EstimatedSeriesCount)+",\n")
	s = append(s, "QueueTime: "+fmt.Sprintf("%#v", this.QueueTime)+",\n")
	s = append(s, "EncodeTime: "+fmt.Sprintf("%#v", this.EncodeTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringStats(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Stats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	n1, err1 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.EncodeTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.EncodeTime):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintStats(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0x52
	n2, err2 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.QueueTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.QueueTime):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintStats(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x4a
	if m.EstimatedSeriesCount != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.EstimatedSeriesCount))
		i--
		dAtA[i] = 0x40
	}
	if m.FetchedIndexBytes != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedIndexBytes))
		i--
		dAtA[i] = 0x38
	}
	if m.SplitQueries != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.SplitQueries))
		i--
		dAtA[i] = 0x30
	}
	if m.ShardedQueries != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.ShardedQueries))
		i--
		dAtA[i] = 0x28
	}
	if m.FetchedChunksCount != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedChunksCount))
		i--
		dAtA[i] = 0x20
	}
	if m.FetchedChunkBytes != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedChunkBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.FetchedSeriesCount != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.FetchedSeriesCount))
		i--
		dAtA[i] = 0x10
	}
	n3, err3 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.WallTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.WallTime):])
	if err3 != nil {
		return 0, err3
	}
	i -= n3
	i = encodeVarintStats(dAtA, i, uint64(n3))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	offset -= sovStats(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Stats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.WallTime)
	n += 1 + l + sovStats(uint64(l))
	if m.FetchedSeriesCount != 0 {
		n += 1 + sovStats(uint64(m.FetchedSeriesCount))
	}
	if m.FetchedChunkBytes != 0 {
		n += 1 + sovStats(uint64(m.FetchedChunkBytes))
	}
	if m.FetchedChunksCount != 0 {
		n += 1 + sovStats(uint64(m.FetchedChunksCount))
	}
	if m.ShardedQueries != 0 {
		n += 1 + sovStats(uint64(m.ShardedQueries))
	}
	if m.SplitQueries != 0 {
		n += 1 + sovStats(uint64(m.SplitQueries))
	}
	if m.FetchedIndexBytes != 0 {
		n += 1 + sovStats(uint64(m.FetchedIndexBytes))
	}
	if m.EstimatedSeriesCount != 0 {
		n += 1 + sovStats(uint64(m.EstimatedSeriesCount))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.QueueTime)
	n += 1 + l + sovStats(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.EncodeTime)
	n += 1 + l + sovStats(uint64(l))
	return n
}

func sovStats(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Stats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Stats{`,
		`WallTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.WallTime), "Duration", "durationpb.Duration", 1), `&`, ``, 1) + `,`,
		`FetchedSeriesCount:` + fmt.Sprintf("%v", this.FetchedSeriesCount) + `,`,
		`FetchedChunkBytes:` + fmt.Sprintf("%v", this.FetchedChunkBytes) + `,`,
		`FetchedChunksCount:` + fmt.Sprintf("%v", this.FetchedChunksCount) + `,`,
		`ShardedQueries:` + fmt.Sprintf("%v", this.ShardedQueries) + `,`,
		`SplitQueries:` + fmt.Sprintf("%v", this.SplitQueries) + `,`,
		`FetchedIndexBytes:` + fmt.Sprintf("%v", this.FetchedIndexBytes) + `,`,
		`EstimatedSeriesCount:` + fmt.Sprintf("%v", this.EstimatedSeriesCount) + `,`,
		`QueueTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.QueueTime), "Duration", "durationpb.Duration", 1), `&`, ``, 1) + `,`,
		`EncodeTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.EncodeTime), "Duration", "durationpb.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringStats(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Stats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WallTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.WallTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedSeriesCount", wireType)
			}
			m.FetchedSeriesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedSeriesCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedChunkBytes", wireType)
			}
			m.FetchedChunkBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedChunkBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedChunksCount", wireType)
			}
			m.FetchedChunksCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedChunksCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardedQueries", wireType)
			}
			m.ShardedQueries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardedQueries |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitQueries", wireType)
			}
			m.SplitQueries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SplitQueries |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedIndexBytes", wireType)
			}
			m.FetchedIndexBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedIndexBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EstimatedSeriesCount", wireType)
			}
			m.EstimatedSeriesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EstimatedSeriesCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueueTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.QueueTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodeTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.EncodeTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthStats
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)
