---
description: Release notes for Grafana Mimir version 2.5
menuTitle: V2.5 release notes
title: Grafana Mimir version 2.5 release notes
weight: 300
---

# Grafana Mimir version 2.5 release notes

Grafana Labs is excited to announce version 2.5 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For the complete list of changes, see the [changelog](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

- **Alertmanager Discord support**
  Alertmanager can now be configured to send alerts in Discord channels.

- **Configurable TLS minimum version and cipher suites**
  We added the flags `-server.tls-min-version` and `-server.tls-cipher-suites` that can be used to define the minimum TLS version and the supported cipher suites in all HTTP and gRPC servers in Mimir.

- **Lower memory usage in store-gateway, ingester and alertmanager**
  We made various changes related to how index lookups are performed and how the active series custom trackers are implemented, which results in better performance and lower overall memory usage in the store-gateway and ingester.
  We also optimized the alertmanager, which results in a 50% reduction in memory usage in use cases with larger numbers of tenants.

- **Improved Mimir dashboards**
  We added two new dashboards named `Mimir / Overview resources` and `Mimir / Overview networking`. Furthermore, we have made various improvements to the following existing dashboards:
  - `Mimir / Overview`: Add "remote read", "metadata", and "exemplar" queries.
  - `Mimir / Writes`: Add optional row about the distributor's new forwarding feature.
  - `Mimir / Tenants`: Add insights into the read path.

### Helm chart improvements

- **Zone aware replication**
  Helm now supports deploying the ingesters and store-gateways as different availability zones. The replication is also zone-aware, therefore multiple instances of one zone can fail without any service interruption and roll outs can be performed faster because many instances of each zone can be restarted together, as opposed to them all restarting in sequence.

  **This is a breaking change**, [for details on how to upgrade please review the Helm changelog](https://github.com/grafana/mimir/blob/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

- **Running without root privileges**
  All Mimir, GEM and Agent processes now don't require root privileges to run anymore.

- **Unified reverse proxy (`gateway`) configuration for Mimir and GEM**
  This change allows for an easier upgrade path from Mimir to GEM, without any downtime. The unified configuration also makes it possible to autoscale the GEM gateway pods and it supports OpenShift Route. The change also deprecates the `nginx` section in the configuration. The section will be removed in release `7.0.0`.

- **Updated MinIO**
  The MinIO sub-chart was updated from `4.x` to `5.0.0`, note that this update **inherits a breaking change** because the MinIO gateway mode was removed.

- **Updated sizing plans**
  We updated our sizing plans to make them reflect better how we recommend running Mimir and GEM in production. Note that this includes a **breaking change** for users of the "small" plan, more details can be found in the [Helm changelog](https://github.com/grafana/mimir/blob/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

- **Various quality of life improvements**
  - Rollout strategies without downtime
  - Read path and compactor configuration refresh, providing better default settings
  - OTLP ingestion support in the Nginx configuration
  - A default configuration for alertmanager, so the user interface and the sending of alerts from the ruler works out of the box

## Bug fixes

- Flusher: Added `Overrides` as a dependency to prevent panics when starting with `-target=flusher`. [PR 3151](https://github.com/grafana/mimir/pull/3151)
- Query-frontend: properly close gRPC streams to the query-scheduler to stop memory and goroutines leak. [PR 3302](https://github.com/grafana/mimir/pull/3302)
- Ruler: persist evaluation delay configured in the rulegroup. [PR 3392](https://github.com/grafana/mimir/pull/3392)
- Fix panics in OTLP ingest path when parse errors occur. [PR 3538](https://github.com/grafana/mimir/pull/3538)
