---
title: "Grafana Mimir Helm chart version 5.2 release notes"
menuTitle: "V5.2 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.2"
weight: 300
---

# Grafana Mimir Helm chart version 5.2 release notes

Grafana Labs is excited to announce version 5.2 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.11 or Grafana Enterprise Metrics (GEM) v2.11. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

## Important changes

- The default timeout used for index-queries caches is increased from `200ms` to `450ms` to reduce the number of connections opened under increased load.
- The default `clusterDomain` is changed from `cluster.local` to `cluster.local.` to reduce the number of DNS lookups performed.

## Features and enhancements

Notable enhancements are as follows:

- The lifecycle management of persistent volumes belonging to compactor, ingester, store-gateway and alertmanager components can now be configured via the parameters `enableRetentionPolicy`, `whenScaled` and `whenDeleted`.
- The chart now supports the option to use a plain `Ingress` resource instead of a gateway service.

## Bug fixes

### 5.2.1

- [PR 7199](https://github.com/grafana/mimir/pull/7199): Revert [PR 6999](https://github.com/grafana/mimir/pull/6999), introduced in 5.2.0, which broke installations relying on the default value of `blocks_storage.backend: s3`. If `mimir.structuredConfig.blocks_storage.backend: s3` wasn't explicitly set, then Mimir would fail to connect to S3 and will instead try to read and write blocks to the local filesystem.

### 5.2.2

- [PR 7555](https://github.com/grafana/mimir/pull/7555): Update GEM to v2.11.2

### 5.2.3

- [PR 7632](https://github.com/grafana/mimir/pull/7632): Fix crashloop in GEM admin-cache container
