#! /bin/sh
# '@(#)$Id: version.sh,v 1.9 1992/01/30 22:20:41 jromine Exp jromine $'

# patch by takada@seraph.ntt.jp and hayashi@kuic.kyoto-u.ac.jp  -- 92/12/21
# modified by the assistance of shigeya@foretune.co.jp		-- 93/01/29
# modified by MH-plus project

case $# in
  0) set "6.6";;
  2) flag="$1"; shift;;
esac

OFS="$IFS" IFS=:

for A in rprompt hostname uname who
do
    for D in $PATH
    do
	if [ ! -f $D/$A ]; then
	    continue
	fi
	case $A in
	    rprompt)    LOCAL=`$A %h`
			;;
	    hostname)   LOCAL=`$A`
			;;
	    uname)	LOCAL=`$A -n`
			;;
	    who)	LOCAL=`$A am i | sed -e 's%^\(.*\)!.*$%\1%'`
			;;
	esac
	break
    done
    if [ "x$LOCAL" != x ]; then
	break
    fi
done

IFS=" "

if test "${LANG+set}" = set; then LANG=C; export LANG; fi
if test "${LC_ALL+set}" = set; then LC_ALL=C; export LC_ALL; fi
if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
if test "${LC_CTYPE+set}" = set; then LC_CTYPE=C; export LC_CTYPE; fi

Patch="../Patchlevel"

if [ ! -r version  ]; then echo "0" > version; fi
if [ ! -r ${Patch} ]; then Patch="" ; fi

rm -f version.c

echo "#ifndef JAPAN" > version.c
cp /dev/null version.c.tmp

cat version ${Patch} |\
awk -F. '
BEGIN	{ split ("'"${1}"'", ver, ".");\
	  major = ver[1]; minor = ver[2]; patch = ver[3]} \
NR == 1 { local = $(NF) } ;\
NR == 2 { patch = $(NF) } ;\
END	{ local++;\
	  if (patch > 0) {\
	  printf "char *version = \"@(#)MH %s.%s.%s #%d[UCI]", \
		major, minor, patch, local > "version.c.tmp"; \
	  printf ".ds MH %s.%s.%s #%d[UCI]\n", \
		major, minor, patch, local > "../doc/version.rf"; \
	  printf "MH %s.%s.%s #%d[UCI]\n", major, minor, patch, local ;\
	} else {\
	  printf "char *version = \"@(#)MH %s.%s #%d[UCI] ", \
		major, minor, local > "version.c.tmp"; \
	  printf ".ds MH %s.%s #%d[UCI]\n", \
		major, minor, local > "../doc/version.rf"; \
	  printf "MH %s.%s #%d[UCI]\n", major, minor, local ;\
	}\
	  printf "%s.%s.%s.%d\n", major, minor, patch, local > "_version";\
}' && mv _version version
cat version.c.tmp >>version.c
rm -f version.c.tmp
case x${flag} in
    x) echo ' ('$LOCAL') of '`date`'";' >> version.c ;;
  x-n) echo '";' >> version.c ;;
esac

echo "#else /* JAPAN */" >> version.c

JPPatch="../JPPatchlevel"
if [ ! -r ${JPPatch} ]; then JPPatch="" ; fi

cp /dev/null version.c.tmp
cat version ${Patch} ${JPPatch} |\
awk -F. '
BEGIN	{ split ("'"${1}"'", ver, ".");\
	  major = ver[1]; minor = ver[2]; patch = ver[3]} \
NR == 1 { local = $(NF) } ;\
NR == 2 { patch = $(NF) } ;\
NR == 3 { jppatch = $0 } ;\
END	{ if (patch > 0) {\
	  printf "char *version = \"@(#)MH %s.%s.%s.JP-%s #%d[UCI]", \
	      major, minor, patch, jppatch, local >> "version.c.tmp"; \
	  } else {\
	  printf "char *version = \"@(#)MH %s.%s.JP-%s #%d[UCI] ", \
	      major, minor, jppatch, local >> "version.c.tmp"; \
	  }\
	  printf "Japanization Plus %s\n", jppatch ; \
}'
cat version.c.tmp >>version.c
rm -f version.c.tmp
case x${flag} in
    x) echo ' ('$LOCAL') of '`date`'";' >> version.c ;;
  x-n) echo '";' >> version.c ;;
esac
echo "#endif /* JAPAN */" >> "version.c"
