/*

 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994-1999 Koji Suzuki (suz@at.sakura.ne.jp)
 *
 * --- Sorry. Current version is not licensed.
 *      You can * NOT * distribute binary of this.
 *	And you can use only to demo and/or test MGL.
 *
 *  Koji Suzuki   : suz@at.sakura.ne.jp
 */

#if 0
static char *icon_mgui="\
#MGR000200160016
+**************+
**............**
*..............*
*....@@@@@.....*
*...@.....@....*
*..@..ddd..@...*
*.@..d@@@d..@..*
*.@.d@...@d.@..*
*.@.d@...@d.@..*
*.@.d@...@d.@..*
*.@..d@@@d..@..*
*..@..ddd..@...*
*...@.....@....*
*....@@@@@.....*
**............**
+**************+
";
#else
static char *icon_mgui="\
#MGR000200160016
+**************+
**............**
*.......yd.y...*
*.......yd.y...*
*.......yd.y...*
*...yyyyyd.y...*
*..yy...yd.y...*
*.yy.....yy....*
*.y.......y....*
*.y.......y....*
*.y.y.....y....*
*.yyy....yy....*
*..yyy..yy.....*
*..yyyyyy......*
**.yy.........**
+**************+
";
#endif

#define COLOR		// 顼б
#define CHOICE_UP	// פ 2dot popup 
#undef  CHOICE_BOX	// פ ȤǰϤ


/* original: cui.c,v 1.25 1996/08/06 17:24:30 suz Exp */
#define QUICK_LOG "netmaj.ql"

#include "mgl2.h"
#include "pai.h"
#include "global.h"
#include "ruledef.h"
#include "result.h"

extern struct screen *physical_screen;
#define mgl_color_model (physical_screen->type & ST_KINDMASK)

#ifdef COLOR
#include "mglcol.h"
#define COLOR_PAIRED	   packMC(0,10,10)	// פ()
#define COLOR_REDPAIRED	   packMC(0,10,15)	// פ()
#define COLOR_TAKUGREEN	   packMC(4,10,10)	// 
#define COLOR_TAKUGREEN2   packMC(3,10,10)	// ()
#define COLOR_PAIGREEN	   packMC(4,5,5)	// פ
#define COLOR_PAIBLUE	   packMC(7,10,10)	// פ/
#define COLOR_LIGHTPINK	   packMC(0,5,15)	// ԥ
#define COLOR_LIGHTVIOLET  packMC(8,5,15)	// 
#else
#define COLOR_TAKUGREEN	   COLOR_LIGHTGRAY
#define COLOR_TAKUGREEN2   COLOR_LIGHTGRAY
#define COLOR_LIGHTPINK	   COLOR_WHITE
#define COLOR_LIGHTVIOLET  COLOR_WHITE
#endif

/* Refresh -- key_select ڤľ refresh */

#define Refresh		refresh

char *esc_str = "";
char *tie_str = "";
char *pon_str = "ݥ";
char *kan_str = "";
char *ron_str = "";
char *reach_str = "꡼";
char *tumo_str = "ĥ";
char *mt_rest_str = "";
#ifdef WCE_VERSION
char *title_str[] = {"եߥ꡼","for Windows CE"};
char *version = "version 1.0 1999/11/15";
#else
char *title_str[] = {"  ",  "    for MGL"};
char *version = "version 2.07-1.6";
#endif


#define UI_CONNECTING	"\
\n\
   Ф³Ǥ  \n\
"

#define UI_CONNECT	"\
\n\
   Ф³Ǥޤ  \n\
"

#define UI_DISCONNECT	"\
\n\
   ̿Ǥޤ  \n\
"

char talk_messages[9][60] = {
    "ͤޤ",
    "Ϥ䤯Ƥ",
    "äȤޤäƤ",
    "ä",
    "ޤä",
    "ä",
    "ޤä",
    "Ϲ!",
    "㡼",
};

extern FILE *log;
extern int play_speed;
extern int auto_stop;
extern int auto_play;
extern int auto_after_reach;
void ui_term();
char *msgGets();
char *analize_message();

extern int readable_socket;
extern int readable_key;


extern int rv_fixed;
extern pai_t *cur_hand;
extern int view_river_all;

int xself = 0;
#define who2pos(who) ((who - xself + 4)%4)

int prog_kind;
int in_choice;
int in_result;
int in_res;
int help_index;
#define HELP_PLAY	5
#define HELP_CHOICE	10
#define HELP_RES	15

int key_mac[100];
int key_mac_cnt=0;

#define P2WIDTH		(12*6+8)
#define P2HEIGHT	(12+8)

int p2posx[4];
int p2posy[4];

#define GT_TATE		1
#define GT_YOKO		2
#define GT_YOKO_SMALL	3

int gb_type;
int gb_width,gb_height;
int gb_xoff,gb_yoff;
int t_xoff,t_yoff;
#define GB_TYPE	    gb_type
#define GB_WIDTH    gb_width
#define GB_HEIGHT   gb_height
#define GB_XOFF     gb_xoff
#define GB_YOFF     gb_yoff
#define T_XOFF      t_xoff
#define T_YOFF      t_yoff

int in_gb = 0;

#define USE_VIRTUAL_KEY


static int istrlen(a) int *a; {
	int ret = 0;
	while (*a) { a++; ret++; }
	return ret;
}

static void istrcpy(a,b) int *a,*b; {
	while (b) {
		*(a++) = *(b++);
	}
}

ungetstrx(str) u_char *str; {
	int len;
	int i;
	u_char *p;

	len = strlen(str);
	p = str;
	for (i=0; i<len; i++) {
		key_mac[key_mac_cnt++] = *p++;
	}
}

ungetstri(str) int *str; {
	int len;
	int i;
	int *p;

	len = istrlen(str);
	p = str;
	for (i=0; i<len; i++) {
		key_mac[key_mac_cnt++] = *p++;
	}
}

getchx() {
	fd_set fds;
	int fd;
	int buf[100];
	int buf2[100];
	int buf_len;
	int ret,i,c;

retry:
	if (key_mac_cnt) {
		ret = key_mac[0];
		key_mac_cnt--;
		for (i=0; i<key_mac_cnt; i++)
			key_mac[i] = key_mac[i+1];
		return ret;
	}
	buf_len = 0;
check:
	buf[buf_len++] = get_key(-1);
	buf[buf_len] = 0;
	switch(match_mac(buf,buf2)) {
	case 0: /* not match */
		ungetstri(buf);
		goto retry;
	case 1: /* to be continue */
		FD_ZERO( &fds );
		FD_SET(0, &fds);
		if (key_select( 1, &fds, 400) == 1) {
			goto check;
		} else {
			ungetstri(buf);
			goto retry;
		}
	case 2: /* match */
		ungetstri(buf2);
		goto retry;
	}
}

match_mac(str,ret_str) int *str,*ret_str; {
	static int *macs[10];
	static int *macs_val[10];
	static int macs_num=-1;
	int i,j,n,ret;
	int len;
	len = istrlen(str);
	if (macs_num == -1) {
		macs_num=0;
	}
	
	ret = 0;
	for (i=0;i<macs_num;i++) {
		for (j=0; j<len; j++) {
			if (macs[i][j] != str[j]) break;
		}
		if (j == len) {
			ret = 1;
			if (istrlen(macs[i]) == len) {
				istrcpy(ret_str,macs_val[i]);
				return 2;
			}
		}
	}
	return ret;
}

#define PAI_W 16
#define PAI_H 21

#include "pai0.h"
#include "pai1.h"
#include "pai2.h"
#include "pai3.h"
#include "misc.h"

struct screen *s1;
struct screen *s2;
struct screen *s3;
struct screen *s4;
struct screen *s5;

struct screen *pai_bak;

int pai_map[] = {
	37,38,39,39, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
	 3, 3, 3, 3, 9, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6,
	 7, 7, 7, 7, 8, 8, 8, 8, 10,10,10,10, 11,11,11,11,
	12,12,12,12, 13,13,13,13, 19,14,14,14, 15,15,15,15,
	16,16,16,16, 17,17,17,17, 18,18,18,18, 20,20,20,20,
	21,21,21,21, 22,22,22,22, 23,23,23,23, 29,24,24,24,
	25,25,25,25, 26,26,26,26, 27,27,27,27, 28,28,28,28,
	30,30,30,30, 31,31,31,31, 32,32,32,32, 33,33,33,33,
	34,34,34,34, 35,35,35,35, 36,36,36,36,
};

#define ABS(a) (((a)<0) ? -(a) : (a))
#define MIN(a,b) (((a)<(b))?(a):(b))

#define DPAI_W	(PAI_W-2)
#define DPAI_H	(PAI_H-2)

conv_xy(dir,xp,yp) int *xp,*yp; {
	int x,y;
	int toff = 0;
	int yoff = 0;
	x = *xp;
	y = *yp;

	if (GB_TYPE == GT_TATE) {
		toff = 22;
	} else {
		yoff = 22;
	}

	switch(dir) {
	case 0: *xp += yoff; *yp = (GB_HEIGHT -1) - y; break;
	case 2: *xp = (GB_WIDTH -1) - x - yoff; break;
	case 1: *xp = (GB_WIDTH -1) - y; *yp = (GB_HEIGHT -1) - x - toff; break;
	case 3: *xp = y; *yp = x + toff; break;
	}
}

conv_bitblt(dir,dst,dx,dy,src,sx,sy,xsize,ysize,op) struct screen *dst,*src; {
	int cdx,cdy;
	int cxsize,cysize;

	if (dir & 1) {
		cxsize = ysize; cysize = xsize;
	} else {
		cxsize = xsize; cysize = ysize;
	}
	cdx = dx;
	cdy = dy;
	conv_xy(dir,&cdx,&cdy);
	switch(dir) {
	case 0: cdy -= (cysize-1); break;
	case 2: cdx -= (cxsize-1); break;
	case 1: cdx -= (cxsize-1); cdy -= (cysize-1); break;
	case 3: break;
	}
	bitblt(dst,cdx,cdy,src,sx,sy,cxsize,cysize,op);
}

conv_fillrect(dir,dx,dy,xsize,ysize) {
	int cdx,cdy;
	int cxsize,cysize;

	if (dir & 1) {
		cxsize = ysize; cysize = xsize;
	} else {
		cxsize = xsize; cysize = ysize;
	}
	cdx = dx;
	cdy = dy;
	conv_xy(dir,&cdx,&cdy);
	switch(dir) {
	case 0: cdy -= (cysize-1); break;
	case 2: cdx -= (cxsize-1); break;
	case 1: cdx -= (cxsize-1); cdy -= (cysize-1); break;
	case 3: break;
	}
	fill_rect(cdx,cdy,cxsize,cysize);
}

conv_drawrect(dir,dx,dy,xsize,ysize) {
	int cdx,cdy;
	int cxsize,cysize;

	if (dir & 1) {
		cxsize = ysize; cysize = xsize;
	} else {
		cxsize = xsize; cysize = ysize;
	}
	cdx = dx;
	cdy = dy;
	conv_xy(dir,&cdx,&cdy);
	switch(dir) {
	case 0: cdy -= (cysize-1); break;
	case 2: cdx -= (cxsize-1); break;
	case 1: cdx -= (cxsize-1); cdy -= (cysize-1); break;
	case 3: break;
	}
	draw_rect(cdx,cdy,cxsize,cysize);
}

conv_drawline(dir,x,y,dx,dy) {
	int cdx,cdy;
	int cx,cy;

	cx = x;
	cy = y;
	cdx = dx;
	cdy = dy;
	conv_xy(dir,&cx,&cy);
	conv_xy(dir,&cdx,&cdy);
	draw_line(cx,cy,cdx,cdy);
}

/* mode = 1 : first , mode = 2 , after rch */
draw_pai(xp,yp,dir,pai,mode) int *xp,*yp; {
	int x,y,px,py;
	int i;
	int dx,dy,pai_w,pai_h;
	int odir = dir;
	struct screen *s;
	int ami = pai & 0x100;
	int rch = pai & 0x200;

	pai &= 0xff;
	x = *xp;
	y = *yp;

	if (rch) dir = (dir + 1)%4;
	dx =((dir & 1)?PAI_H:PAI_W);
	dy =((dir & 1)?PAI_W:PAI_H);
	if (rch) {
		pai_w = PAI_H; pai_h = PAI_W;
	} else {
		pai_w = PAI_W; pai_h = PAI_H;
	}
	i = pai_map[pai];
	px = (i % 10) * dx + 1;
	py = (i / 10) * dy + 1;

	switch (dir) {
	case 0: s=s1;
		break; 
	case 1: s=s2;
		break; 
	case 2: s=s3;
		break; 
	case 3: s=s4; 
		break; 
	}
	set_color(COLOR_TAKUGREEN);
	conv_fillrect(odir,x,y-1,pai_w-1,PAI_H);
	conv_bitblt(odir,NULL,x,y,s,px,py,pai_w-2,pai_h-2,0);
	if (ami) 
	conv_bitblt(odir,NULL,x,y,s,8*dx,3*dy,pai_w-2,pai_h-2
			,BLT_MASKING|COLOR_LIGHTGRAY);
	x -= 1; y -= 1;
	if (mode&1 && rch) conv_drawline(odir,x,y+pai_w-1,x,y+pai_h-2);
	set_color(COLOR_BLACK);
	if ((!mode&1) && rch) conv_drawline(odir,x,y+pai_w-2,x,y+pai_h-2);
	if (mode&1) conv_drawline(odir,x,y+1,x,y+pai_h-2);
	if (mode&2) conv_drawline(odir,x,y+pai_w-2,x,y+pai_h-2);
	conv_drawline(odir,x+1,y+pai_h-1,x+pai_w-2,y+pai_h-1);
	conv_drawline(odir,x+pai_w-1,y+1,x+pai_w-1,y+pai_h-2);
	conv_drawline(odir,x+1,y,x+pai_w-2,y);
	*xp += pai_w - 2;
}

conv_color(int x,int y,int xs,int ys,int from,int to) {
	int i,j;
	int buf[1024];

	for (i=0; i<ys; i++) {
		get_pixstream(x,y,buf,xs,DIR_NORTH,BLT_MASKING|from);
		for (j=0; j<xs; j++) {
			if (buf[j] == COLOR_TRANSPARENT) {
				buf[j] = to;
			}
		}
		put_pixstream(x,y,buf,xs,DIR_NORTH);
		y++;
	}
}

conv_pai_color(int x,int y,int xs,int ys,int from,int to,int dir) {
	int w,h;
	w = PAI_W;	
	h = PAI_H;
	if (dir & 1) {
		w = PAI_H;
		h = PAI_W;
	}
	conv_color(x*w,y*h,xs*w,ys*h,from,to);
}

fix_borders(int dir) {
	int w,h;
	int i,j;
	w = PAI_W;	
	h = PAI_H;
	if (dir & 1) {
		w = PAI_H;
		h = PAI_W;
	}
	for (i=0;  i<4; i++) {
		for (j=0; j<10; j++) {
			set_color(COLOR_DARKGRAY);
			draw_rect(j*w,i*h,w,h);
			set_color(COLOR_WHITE);
			draw_pixel(j*w,i*h);
			draw_pixel(j*w+w-1,i*h);
			draw_pixel(j*w,i*h+h-1);
			draw_pixel(j*w+w-1,i*h+h-1);
		}
	}

}

#ifdef COLOR
conv_colors() {
	int i;
	struct screen *s;
	for (i=0; i<4; i++) {
		switch(i) {
		case 0: s = s1; break;
		case 1: s = s2; break;
		case 2: s = s3; break;
		case 3: s = s4; break;
		}
		push_screen(s);
		/* dark red */
		conv_pai_color(0,0,9,3,COLOR_DARKGRAY,COLOR_PAIRED,i);
		conv_pai_color(5,3,1,1,COLOR_DARKGRAY,COLOR_PAIRED,i);
		/* red 5 */
		conv_pai_color(9,0,1,3,COLOR_DARKGRAY,COLOR_REDPAIRED,i);
		/* green */
		conv_pai_color(0,2,9,1,COLOR_BLACK,COLOR_PAIGREEN,i);
		conv_pai_color(5,3,1,1,COLOR_BLACK,COLOR_PAIGREEN,i);
		/* pai rev */
		conv_pai_color(7,3,2,1,COLOR_DARKGRAY,COLOR_PAIBLUE,i);
		fix_borders(i);
		pop_screen();
	}
}
#endif

struct screen *comment_mem;
struct textscreen *comment_scr;


static int vkeys[4] = {MK_LEFT,MK_RIGHT,033,'c'&0x1f};
static char *vicons[4] ={"","","",""};

ui_init(global_t *gp, int kind, char *board) {
	int i;
	int xs,ys;
	int xoff;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v;
#endif

	if (board == NULL) {
		SCREEN_WIDTH = 640;
		SCREEN_HEIGHT = 240;
	} else if (!strcmp("ppc",board)) { 
		SCREEN_WIDTH = 240;
		SCREEN_HEIGHT = 320;
	} else if (!strcmp("hpc",board)) { 
		SCREEN_WIDTH = 640;
		SCREEN_HEIGHT = 240;
	} else if (!strcmp("hpc_mini",board)) { 
		SCREEN_WIDTH = 480;
		SCREEN_HEIGHT = 240;
	} else if (sscanf(board,"%dx%d",&xs,&ys)==2) {
		SCREEN_WIDTH = xs;
		SCREEN_HEIGHT = ys;
	}
	if (!open_graph()) {
		exit(1);
	}
	if ((SCREEN_HEIGHT >= 320-24) && (SCREEN_WIDTH < 480) ) {
		GB_TYPE = GT_TATE;
	} else if ((SCREEN_WIDTH >= 640) && (SCREEN_HEIGHT >= 240-24)) {
		GB_TYPE = GT_YOKO;
	} else if ((SCREEN_WIDTH >= 480) && (SCREEN_HEIGHT >= 240-24)) {
		GB_TYPE = GT_YOKO_SMALL;
	} else {
		printf("screen is too small\n");
		exit(1);
	}

	if (GB_TYPE == GT_TATE) {/* for PsPC */
		//SCREEN_WIDTH = 240;
		//SCREEN_HEIGHT = 320-24;
	
		GB_HEIGHT = 270;
		GB_WIDTH = 240;
		GB_XOFF = (SCREEN_WIDTH - 240)/2;
		GB_YOFF = (SCREEN_HEIGHT - (270 + 24)) / 2;
		T_XOFF  = GB_XOFF;
		T_YOFF = GB_YOFF + GB_HEIGHT;
	} else {
	    if (GB_TYPE == GT_YOKO_SMALL) {/* 480x240 */
		//SCREEN_WIDTH = 480;
		GB_WIDTH = 284;
	    } else {
		//SCREEN_WIDTH = 640;
		GB_WIDTH = 320 /*284*/;
	   }
	   if (SCREEN_HEIGHT > GB_WIDTH) {
		GB_HEIGHT = GB_WIDTH;
	   } else if (SCREEN_HEIGHT >= 224) {
	    	GB_HEIGHT = SCREEN_HEIGHT;
	   }
	   GB_XOFF = 0;
	   GB_YOFF = (SCREEN_HEIGHT - GB_HEIGHT)/2;
	   T_XOFF  = GB_XOFF + GB_WIDTH;
	   T_YOFF = GB_YOFF;
	}

	p2posx[0] = (GB_WIDTH-P2WIDTH)/2;
	p2posx[1] = GB_WIDTH-P2WIDTH-32;
	p2posx[2] = (GB_WIDTH-P2WIDTH)/2;
	p2posx[3] = 32;

	p2posy[0] = GB_HEIGHT-P2HEIGHT-88;
	p2posy[1] = (GB_HEIGHT-P2HEIGHT)/2;
	p2posy[2] = 88;
	p2posy[3] = (GB_HEIGHT-P2HEIGHT)/2;

	set_color(COLOR_TAKUGREEN);
	clear_screen();
	/* draw title */

	s1 = conv_screen_from_v1(&pai0,STK_NATIVE);
	s2 = conv_screen_from_v1(&pai1,STK_NATIVE);
	s3 = conv_screen_from_v1(&pai2,STK_NATIVE);
	s4 = conv_screen_from_v1(&pai3,STK_NATIVE);
	s5 = conv_screen_from_v1(&misc,STK_NATIVE);

#ifdef CHOICE_UP
	pai_bak = create_memscreen(PAI_W+1,PAI_H+3,NULL,STK_NATIVE,0);
#endif
#ifdef COLOR
	if (mgl_color_model != STK_GENERIC_4COLOR) {
		conv_colors();
	}
#endif
#if 1	/* create icon for test */
{
	struct screen *x;
	int px,py,i;

	px = 0 * PAI_W; 
	py = 1 * PAI_H;

	x = create_memscreen(PAI_W,PAI_H,NULL,STK_GENERIC_192COLOR,0);
	bitblt(x,0,0,s1,px,py,PAI_W,PAI_H,0);
	write_screen_mgr("aaa",x,2);
	free_screen(x);
}
#endif

	set_icon(icon_mgui,"netmaj");
	xoff = 0;
	if (GB_TYPE == GT_TATE) {
		//set_color(COLOR_WHITE);
		//fill_rect(T_XOFF+4,T_YOFF+5,70-4,26-10);
#ifdef USE_VIRTUAL_KEY
		v = create_virtual_key(T_XOFF+4,T_YOFF+5,70-4,26-10,MK_F1);
		vk_attach(NULL,v);
#endif
		xoff += 70;
	}
	set_color(COLOR_BLACK);
	set_font(12,FA_BOLD);
	draw_string(T_XOFF+xoff+2,T_YOFF+1,title_str[0],DIR_NORTH);
	set_font(12,FA_ITALIC);
	draw_string(T_XOFF+xoff+4,T_YOFF+13,title_str[1],DIR_NORTH);
	if (GB_TYPE == GT_TATE) {
		xoff = (GB_XOFF + GB_WIDTH - T_XOFF) - 80 - 3;
	} else {
		xoff = (SCREEN_WIDTH - T_XOFF) - 80 - 3;
	}
#ifdef USE_VIRTUAL_KEY
	for (i=0; i<4; i++) {
		set_color(COLOR_WHITE);
		fill_rect(T_XOFF+xoff+3+i*20,T_YOFF+5,16,16);
		set_font(16,FA_BOLD);
		set_color(COLOR_BLACK);
		draw_string(T_XOFF+xoff+3+i*20,T_YOFF+5,vicons[i],DIR_NORTH);
		v = create_virtual_key(T_XOFF+xoff+3+i*20,T_YOFF+5
				,16,16,vkeys[i]);
		vk_attach(NULL,v);
	}
#endif
	if (GB_TYPE == GT_YOKO_SMALL) {
		//set_color(COLOR_WHITE);
		//fill_rect(T_XOFF+xoff+9,T_YOFF+26+5,70-4,26-10);
#ifdef USE_VIRTUAL_KEY
		v = create_virtual_key(T_XOFF+xoff+9,T_YOFF+26+5,70-4,26-10,MK_F1);
		vk_attach(NULL,v);
#endif
	}

	/* message win */
	if (GB_TYPE == GT_TATE) {
	} else {
		comment_scr = create_textscreen(NULL,
				GB_XOFF+GB_WIDTH+4,
				GB_YOFF+15*9,
				SCREEN_WIDTH-(GB_XOFF+GB_WIDTH)-8,
				GB_HEIGHT-15*9,TS_BORDER|TS_BLINE);
		ts_clear(comment_scr);
		ts_goto(comment_scr,0,0);
	}
	set_font(12,0);

	pf_param_strn(gp,"talk_1",talk_messages[0],50);
	pf_param_strn(gp,"talk_2",talk_messages[1],50);
	pf_param_strn(gp,"talk_3",talk_messages[2],50);
	pf_param_strn(gp,"talk_4",talk_messages[3],50);
	pf_param_strn(gp,"talk_5",talk_messages[4],50);
	pf_param_strn(gp,"talk_6",talk_messages[5],50);
	pf_param_strn(gp,"talk_7",talk_messages[6],50);
	pf_param_strn(gp,"talk_8",talk_messages[7],50);
	pf_param_strn(gp,"talk_9",talk_messages[8],50);
	ui_draw(gp,1);

	prog_kind = kind;
#if 0
	auto_play = 1;
#endif
	play_speed = 3;
	auto_after_reach = 0;
	if (prog_kind == PROG_NETMAJ1) {
		sel_load();
	}
}

void ui_term() {
}

ui_key() {
	int ret;
retry:
	ret = getchx();
	if (ret == ('L' & 0x1f)) {
		goto retry;
	}
	return ret;
}

ui_event_wait(gp,time_out) global_t *gp; {
	fd_set fds;
	int fd,fd2;
	int maxfd;

	if (key_mac_cnt) {
		readable_key = 1;
		return;
	}

	fd = callback_fd(gp);
	fd2 = callback_fd2(gp);

	if (readable_socket) {
		return;	
	}
	if (fd == -1) {
		return 1;
	}

	FD_ZERO( &fds );
	FD_SET(0, &fds);
	maxfd = 0;
	if (fd >= 0) {
		FD_SET(fd, &fds);
		maxfd = fd;
	}
	if (fd2 >= 0) {
		FD_SET(fd2, &fds);
		if (maxfd < fd2) maxfd = fd2;
	}
	if (time_out >= 0) {
		time_out *= 100;
	}
	key_select(maxfd+1, &fds, time_out);
	if (FD_ISSET( 0, &fds)) 
		readable_key = 1;
	if ( (fd>0 && FD_ISSET( fd, &fds)) || (fd2>0 && FD_ISSET( fd2, &fds)))
		readable_socket = 1;
}

ui_message_connect() {
	/*cleanup_wstack();*/
	popup(UI_CONNECT,20);
}

ui_message_connecting() {
	popup(UI_CONNECTING,50);
}

ui_message_disconnect() {
	popup(UI_DISCONNECT,20);
}

ui_message_naki(i,kind) {
	char *str = "";
	if (kind == 0) str = tie_str;
	else if (kind == 1) str = pon_str;
	else if (kind == 2) str = kan_str;
	popup2(i,str,7);
}

ui_message_reach(i) {
	popup2(i,reach_str,7);
}

ui_message_tumo(i) {
	popup2(i,tumo_str,20);
}

ui_message_ron(i) {
	popup2(i,ron_str,20);
}

ui_message_play(gp) global_t *gp; {
	help_index = HELP_PLAY;
	xself = self;
	if (comment_scr) {
		ts_clear(comment_scr);
		ts_goto(comment_scr,0,0);
	}
}

ui_message_gend(gp) global_t *gp; {
	int i,c;
	int pup = 0;
	char buf[1024];
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v;

	v = create_virtual_key3(GB_XOFF,GB_YOFF,GB_WIDTH,GB_HEIGHT
				,MK_V1,MK_V0,MK_V0);
	vk_attach(NULL,v);
#endif

	if (comment_scr == NULL) {
		pup = 1;
		comment_scr = create_textscreen(NULL
			,GB_XOFF+24,GB_YOFF+22+42*3
			,96*2,100
			,TS_SAVE|TS_BORDER|TS_BLINE);
	}
	ts_clear(comment_scr);
	ts_goto(comment_scr,0,0);
	sprintf(buf,"  %-10s %4s %2s %6s\n\n"
			,"NAME","POINT","C","TOTAL");

	for (i=0; i<4; i++) {
		sprintf(buf+strlen(buf),"  %-10s %5d %2d %6d\n"
			,player[i].name,player[i].rpoint,player[i].tpoint
			,player[i].rpoint * 100 + player[i].tpoint * 500);
	}
	c = comment(5,1,buf,auto_play?play_speed*5:(-1));
	if (c == 'l') {
		FILE *fp;
		fp = fopen(QUICK_LOG,"a");
		if (fp) {
			log_game(gp,fp);
			fclose(fp);
		}
	}
	if (log) log_game(gp,log);
	if (pup) {
		free_textscreen(comment_scr);
		comment_scr = NULL;
	}
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
}

ui_message_player(gp) global_t *gp; {
	if (GB_TYPE == GT_TATE) {
		popup_player(gp,0);
	} else {
		int i;
		char buf[1024];

		sprintf(buf," --- player list --- \n\n");
		for (i=0; i<4; i++) {
			sprintf(buf+strlen(buf),"   %10s  \n"
				,player[i].name);
		}
		popup(buf,20);
	}
}

ui_key_wto(time_out) {
	fd_set fds;
	int ret = 0;

	if (time_out == 0) return ret;
	if (key_mac_cnt) {
		return ui_key();
	}
	FD_ZERO( &fds );
	FD_SET(0, &fds);
	if (time_out >= 0) {
		time_out *= 100;
	}
	key_select( 1, &fds, time_out);
	if (FD_ISSET( 0, &fds)) ret = ui_key();
	return ret;
}

ui_menu(gp,c) global_t *gp; int c; {
	char buf[256];
	char *args[20];
	char sbuf[32];
	int ret;

	if (c == 'q') { /* quick advice */
		ungetstrx("\033jjjjjj\n");
		return 1;
	}
	else if (c == 't') { /* quick talk */
		ungetstrx("\033\n");
		return 1;
	}
	else if (c == 'r') { /* quick run auto */
		ungetstrx("\033j\n\n");
		return 1;
	} else if (c == MK_F1 || c == 'p') { /* popup player */
		popup_player(gp,0);
		return 1;
	} else if ('1' <= c && c <= '9') {
		strcpy(buf,"\033\n");
		strcat(buf,talk_messages[c - '1']);
		ungetstrx(buf);
		return 1;
	}
	else if (c == ('d'&0x1f) || c == ('r'&0x1f)) { 
		do_disconnect(gp);
		return 1;
	}

	if ((c != 033) && (c != MK_F1)) return 0;

#define MENU_LINE ""
	if (prog_kind == PROG_NETMAJ1) {
		args[0] = auto_play
			 ?" ư     "
			 :" ư⡼   ";
		args[1] = " ԡ   ";
		sprintf(sbuf
			,"     %2d    ",play_speed);

		args[2] = sbuf;
		args[3] = MENU_LINE;
		args[4] = " ɥХ   ";
		args[5] = " إ       ";
		args[6] = " 롼       ";
		args[7] = MENU_LINE;
		args[8]= "          ";
		args[9]= " λ         ";
retry:
		ret = menu(0,0,10,args,0);
		if (ret == -2) {
			ret = -1;
		} else if (ret < 0 || ret >= 10) goto retry;

		switch(ret) {
		case 0:
			auto_play = !auto_play;
			break;
		case 1:
			play_speed ++;
			if (play_speed >= 9) play_speed = 9;
			sprintf(sbuf,"     %2d    ",play_speed);
			goto retry;
		case 2:
			play_speed --;
			if (play_speed < 1) play_speed = 1;
			sprintf(sbuf,"     %2d    ",play_speed);
			goto retry;
		case 4: /* advice */
			execute_advice(gp);
			break;
		case 5: /* help */
			execute_help(gp);
			break;
		case 6: /* rule */
			//popup(rule_message(),-1);
			popup_rule(gp);
			break;
		case 8: /* info */
			popup_player(gp,1);
			break;
		case 9:
			term();
			break;
		}
	} else if (prog_kind == PROG_NETMAJ) {
		args[0] = " ȡ       ";
		args[1] = " auto ¹    ";
		args[2] = " ƥ     ";
		args[3] = MENU_LINE;
		args[4] = auto_play
			 ?" ư     "
			 :" ư⡼   ";
		args[5] = " ԡ   ";
		sprintf(sbuf
			,"     %2d    ",play_speed);

		args[6] = sbuf;
		args[7] = MENU_LINE;
		args[8] = " ɥХ   ";
		args[9] = " إ       ";
		args[10]= " 롼       ";
		args[11]= MENU_LINE;
		args[12]="          ";
		args[13]=" λ         ";
retry2:
		ret = menu(0,0,14,args,0);
		if (ret == -2) {
			ret = -1;
		} else if (ret < 0 || ret >= 14) goto retry2;

		switch(ret) {
		case 0:
			comment(self,0,buf,0);
			msgTalk(gp,buf);
			break;
		case 1:
			comment(self,0,buf,0);
			execute_auto(buf);
			break;
		case 2:
//printf("do disconnect\n");
			do_disconnect(gp);
			break;
		case 4:
			auto_play = !auto_play;
			break;
		case 5:
			play_speed ++;
			if (play_speed >= 9) play_speed = 9;
			sprintf(sbuf,"     %2d    ",play_speed);
			goto retry2;
		case 6:
			play_speed --;
			if (play_speed < 1) play_speed = 1;
			sprintf(sbuf,"     %2d    ",play_speed);
			goto retry2;
		case 8: /* advice */
			execute_advice(gp);
			break;
		case 9: /* help */
			execute_help(gp);
			break;
		case 10: /* rule */
			popup(rule_message(),-1);
			break;
		case 12: /* info */
			popup_player(gp,1);
			break;
		case 13:
			term();
			break;
		}
	}
	return 1;
}

ui_draw(gp,redraw) global_t *gp; {
	int i,j;
	struct screen *gb;

	if (redraw) {
		int c=pen_color;
		set_color(COLOR_TAKUGREEN);
		fill_rect(GB_XOFF,GB_YOFF,GB_WIDTH,GB_HEIGHT);
		set_color(COLOR_WHITE);
		fill_rect(GB_XOFF+88,GB_YOFF+88
			,GB_WIDTH-88*2-1,GB_HEIGHT-88*2-1);
		if (GB_TYPE == GT_TATE) {
			//set_color(COLOR_WHITE);
			//fill_rect(T_XOFF+4,T_YOFF+5,70-4,26-10);
		}
		if (GB_TYPE == GT_YOKO_SMALL) {
			//set_color(COLOR_WHITE);
			//fill_rect(SCREEN_WIDTH-80+9,T_YOFF+26+5,70-4,26-10);
		}
		set_color(c);
		ch_play = 1;
	}
	if ((GB_TYPE == GT_TATE) || (GB_TYPE == GT_YOKO_SMALL)) {
		draw_player0(gp,vself);
	}
	if (GB_TYPE == GT_YOKO) {
		for (i=0; i<4; i++) {
			draw_player(gp,i);
		}
	}
	gb = create_subscreen(NULL,GB_XOFF,GB_YOFF,GB_WIDTH,GB_HEIGHT);
	push_screen(gb);
	in_gb = 1;

	if (ch_play) {
	}
	draw_status(gp);
	for (i=0; i<4; i++) {
		draw_river(gp,i);
		draw_hand(gp,i);
	}
	ch_point = 0;
	ch_play = 0;

	in_gb = 0;
	pop_screen();
	free_screen(gb);
	refresh();
}

draw_status(gp) global_t *gp; {
	int x,y;
	int i,pai;
	char buf[256];

	if (!ch_dora && !ch_play) return;
	ch_dora = 0;

	/* set dora (0-3) position */
	if (GB_TYPE==GT_TATE) {
		x = 88 + 4;
		y = 88 + 22 + 3;
	} else if (GB_TYPE==GT_YOKO_SMALL) {
		x = 88 - 22 + DPAI_W * 3 + 4;
		y = 88 + 3 + 22;
	} else {
		x = 88 + 16 - 22;
		y = 88 + 3;
	}
	
	for(i=0;i<4;i++) {
		pai= mt_dora(gp,i);
		draw_pai(&x,&y,0,pai,i==0);
	}
	/* set ura_dora (0-3) position */
	if (GB_TYPE==GT_TATE) {
		x = 88 + 4;
		y = 88 + 3;
	} else if (GB_TYPE==GT_YOKO_SMALL) {
		x = 88 - 22 + DPAI_W * 3 + 4;
		y = 88 + 3;
	} else {
		x = 88 + 16 - 22 + DPAI_W * 4 + 10;
		y = 88 + 3;
	}
	for(i=0;i<4;i++) {
		pai= mt_uradora(gp,i);
		draw_pai(&x,&y,0,pai,i==0);
	}
	
	if ((pai = mt_dora(gp,4)) >= 4) {
		pai= mt_dora(gp,4);
		if (GB_TYPE==GT_TATE) {
			x = 88 + 14*3 + 4;
			y = 88 + +22*3 + 3;
		} else if (GB_TYPE==GT_YOKO_SMALL) {
			x = 88 - 22 + DPAI_W * 6 + 10;
			y = 88 + 3 - 22;
		} else {
			x = 88 + 16 - 22 + DPAI_W * 7 + 10;
			y = 88 + 3 - 22;
		}
		draw_pai(&x,&y,0,pai,1);
	}
	if ((pai = mt_uradora(gp,4)) >= 4) {
		pai= mt_uradora(gp,4);
		if (GB_TYPE==GT_TATE) {
			x = 88 + 14*3 + 4;
			y = 88 + +22*2 + 3;
		} else if (GB_TYPE==GT_YOKO_SMALL) {
			x = 88 - 22 + DPAI_W * 6 + 10;
			y = 88 + 3 - 22*2;
		} else {
			x = 88 + 16 - 22 + DPAI_W * 7 + 10;
			y = 88 + 3 - 22*2;
		}
		draw_pai(&x,&y,0,pai,1);
	}
	set_font(12,0);
	set_color(COLOR_BLACK);
	if (GB_TYPE==GT_TATE) {
		x = 88+8;
		y = 88+4;
	} else if (GB_TYPE==GT_YOKO_SMALL) {
		x = 88+2;
		y = 88+2;
	} else {
		x = 88+8;
		y = 88+2;
	}
	sprintf(buf,"%s%2d%s",bturn_names[big_turn]
		,small_turn+1,sturn_sfx);
	draw_string(x,y,buf,DIR_NORTH);
	if (GB_TYPE==GT_TATE) {
		x = 88+8;
		y = 88+14+4;
	} else if (GB_TYPE==GT_YOKO_SMALL) {
		x = 88+2;
		y = 88+2 +14;
	} else {
		x = 88+8+6*8;
		y = 88+2;
	}
	sprintf(buf,"%d %s",small_turn_cnt,sturn_cnt_sfx);
	draw_string(x,y,buf,DIR_NORTH);

	if (GB_TYPE==GT_TATE) {
		x = 88+8;
		y = 88+14*2+4;
	} else if (GB_TYPE==GT_YOKO_SMALL) {
		x = 88+2;
		y = 88+2 +14*2;
	} else {
		x = 88+8+6*8 + 6*8;
		y = 88+2;
	}
	sprintf(buf,"%s%2d",rest_str,rest_point/1000);
	set_color(COLOR_WHITE);
	fill_rect(x,y,strlen(buf)*6,12);
	set_color(COLOR_BLACK);
	draw_string(x,y,buf,DIR_NORTH);
}

draw_player0(gp,who) global_t *gp; {
	int i;
	int pp;
	int pos;
	char buf[256];

	if (!ch_play && !ch_point) return;

	pp = pplayer[who];
	pos = (who - vself + 4)%4;

	if (GB_TYPE==GT_TATE || GB_TYPE == GT_YOKO_SMALL) {
	    if (who == vself) {
		set_color(COLOR_WHITE);
		if (GB_TYPE==GT_TATE)
			fill_rect(T_XOFF+4,T_YOFF+5,70-4,26-10);
		if (GB_TYPE==GT_YOKO_SMALL)
			fill_rect(SCREEN_WIDTH-80+9,T_YOFF+26+5,70-4,26-10);
		sprintf(buf,"%s%6d",home_names[vself],player[pp].gpoint);
		set_color(COLOR_BLACK);
		if (GB_TYPE==GT_TATE)
			draw_string(T_XOFF+6,T_YOFF+7,buf,DIR_NORTH);
		if (GB_TYPE==GT_YOKO_SMALL)
			draw_string(SCREEN_WIDTH-80+11,T_YOFF+26+7,buf,DIR_NORTH);
	    }
	}
}

#define DP_XSIZE	100
#define DP_YSIZE	36

draw_player(gp,who) global_t *gp; {
	int i;
	int pp;
	int x,y,w;
	int pos;
	char buf[256];

	if (!ch_play && !ch_point) return;

	pp = pplayer[who];
	pos = (who - vself + 4)%4;

	set_font(12,0);

	w = ( SCREEN_WIDTH - (GB_XOFF + GB_WIDTH) ) /2 ;
	switch(pos) {
	case 0: x = w - DP_XSIZE/2;  y = DP_YSIZE*2; break;
	case 1: x = w;               y = DP_YSIZE; break;
	case 2: x = w - DP_XSIZE/2;  y = 0;    break;
	case 3: x = w - DP_XSIZE;    y = DP_YSIZE; break;
	}
	x += GB_XOFF + GB_WIDTH;
	y += GB_YOFF + 26;

	set_color(COLOR_BLACK);
	draw_rect(x,y,DP_XSIZE,DP_YSIZE);
	set_color(COLOR_WHITE);
	if ((player[pp].ppoint) < 0) {
		set_color(COLOR_LIGHTPINK);
	} else if ((player[pp].ppoint) > 0) {
		set_color(COLOR_LIGHTVIOLET);
	}
	fill_rect(x+1,y+1,DP_XSIZE-2,DP_YSIZE-2);
	set_color(COLOR_BLACK);
	sprintf(buf,"%s",home_names[who]);
	draw_string(x+2,y+2,buf,DIR_NORTH);
	if ((who + small_turn)%4 == 0)
		bitblt(NULL,x+DP_XSIZE-26,y+2,s5,0,12,24,12
			,BLT_MASKING|COLOR_WHITE);

	sprintf(buf,"%10s",player[pp].name);
	draw_string(x+2,y+10,buf,DIR_NORTH);

	sprintf(buf,"%7d %7d",player[pp].gpoint,player[pp].ppoint);
	draw_string(x+2,y+22,buf,DIR_NORTH);
}

popup_player(gp,mode) global_t *gp; {
	struct textscreen *ts[4],*info_scr;
	int i,c;
	int pos;
	int x,y;
	int xs,ys;
	int pup = 0;
	int pp;

	if (mode) {
		if (!comment_scr) {
			info_scr = create_textscreen(NULL
				,GB_XOFF+24,GB_YOFF+22+42*3
				,96*2,100
				,TS_SAVE|TS_BORDER|TS_BLINE);
			pup = 1;
		} else {
			info_scr = comment_scr;
		}

		ts_clear(info_scr);
		ts_goto(info_scr,0,0);
		ts_put_string(info_scr,"\n   ",0);
		set_font(12,FA_BOLD);
		ts_put_string(info_scr,title_str[0],0);
		ts_put_string(info_scr,"\n      ",0);
		set_font(12,FA_ITALIC);
		ts_put_string(info_scr,title_str[1],1);
		ts_put_string(info_scr,"\n\n   ",0);
		set_font(12,0);
		ts_put_string(info_scr,version,0);
	}
	if ((GB_TYPE == GT_TATE) || mode == 0) {
	    for (i=0; i<4; i++) {
		pos = (i - vself + 4)%4;
		x = GB_WIDTH/2 - 96 + GB_XOFF;
		x = (x+3)& ~3;
		y = GB_YOFF+22;
		switch(pos) {
		case 3: x += 0; y+= 42; break;
		case 2: x += 96/2; y+= 0; break;
		case 1: x += 96; y+= 42; break;
		case 0: x += 96/2; y+= 42*2; break;
		}
		ts[i] = create_textscreen(NULL,x,y,96,42
			,TS_SAVE|TS_BORDER|TS_BLINE);
		pp = pplayer[i];
		if ((player[pp].ppoint) < 0) {
			ts_set_bgcolor(ts[i],COLOR_LIGHTPINK);
		} else if ((player[pp].ppoint) > 0) {
			ts_set_bgcolor(ts[i],COLOR_LIGHTVIOLET);
		}
		tsdraw_player(gp,ts[i],i);
Refresh();
	    }
	}
	if ((GB_TYPE == GT_TATE) || mode == 0) {
		c = ui_key_wto(20);
		for (i=0; i<4; i++) {
			free_textscreen(ts[i]);
		}
	}
	if (pup) free_textscreen(info_scr);
refresh();
}

tsdraw_player(gp,ts,who) global_t *gp; struct textscreen *ts; int who; {
	int pp;
	char buf[65];

	pp = pplayer[who];

	set_font(12,0);
	set_color(COLOR_WHITE);
	
	ts_clear(ts);
	set_color(COLOR_BLACK);
	
	ts_goto(ts,2,2);
	ts_put_string(ts,home_names[who],1);
	ts_put_string(ts," ",1);
	ts_put_string(ts,player[pp].name,1);

	ts_goto(ts,2,2+14);
	sprintf(buf,"%6d %5d",player[pp].gpoint,player[pp].ppoint);
	ts_put_string(ts,buf,1);
}

draw_river(gp,who) global_t *gp; {
	int i,pai;
	int pp;
	int max;
	int inix,x,y;
	int pos;
	int rf,r,t;
	int mode;
	extern int rv_fixed;

	if (!ch_river[who] && !ch_play) return;
	ch_river[who] = 0;

	for (max=0; max <RIVER_MAX; max++) {
		if (!rv[who][max].in && !rv[who][max].out)
			break;
	}
	pos = (who - vself + 4)%4;
	pp = pplayer[who];
	if ((pos == 0) || (pos == 2)) {
		inix = GB_WIDTH - (GB_TYPE==GT_TATE?0:22*2);
	} else {
		inix = GB_HEIGHT - (GB_TYPE==GT_TATE?22*2:0);
	}
	x = inix = (inix -(13 * DPAI_W)/2)/2;
	y = 22 * 3 +1;

	for (i=0; i< max; i++) {
		mode = 0;
		if (i%6 == 0) {
			rf = 0;
			if (i<18) mode = 1;
			if (i!=0 && i<18) {
				x = inix;
				y -= 22;
			}
		}
		if (&rv[who][i] == rvp && !rv_fixed) {
			rf = 0;
			x += 2;
		}
		pai = rv[who][i].out;
		if (pai && (pai == rv[who][i].in)) {
			set_color(COLOR_DARKGRAY);
			conv_drawline(pos,x+3,y-2,x+8,y-2);
			set_color(COLOR_BLACK);
		}
		r = R_GET(rv[who][i].attr);
		t = T_GET(rv[who][i].attr);
		if (r == R_TIE || r == R_PON || r == R_KAN
			|| t == T_HN_TSM || t == T_HN_KAN_C || t == T_HN_KAN)
			pai |= 0x100;
		if (t == T_RV_RCH)
			pai |= 0x200;
		if (rf) mode |= 2;
		rf = 0;
		if (&rv[who][i] == rvp && !rv_fixed) {
			int d;
			d = (mode & 1)?1:0;
			set_color(COLOR_LIGHTGRAY);
			conv_fillrect(pos,x+1-2-d,y-1,2+d,PAI_H);
			set_color(COLOR_BLACK);
			mode |= 1;
		}
		draw_pai(&x,&y,pos,pai,mode);
		if (&rv[who][i] == rvp && rv_fixed) {
		    set_color(COLOR_TAKUGREEN2);
		    conv_fillrect(pos,x+1,y-1,2,PAI_H);
		    set_color(COLOR_BLACK);
		    if (r == R_TIE || r == R_PON || r == R_KAN || r == R_RON) {
			set_color(COLOR_REVERSE);
			conv_fillrect(pos,x-DPAI_W,y,DPAI_W,DPAI_H);
Refresh();
xsleep(1);
			conv_fillrect(pos,x-DPAI_W,y,DPAI_W,DPAI_H);
Refresh();
xsleep(1);
			set_color(COLOR_BLACK);
		    }
		}
		if (t == T_RV_RCH)
			rf = 1;
	}
}

draw_hand(gp,who) global_t *gp; {
	int i,j,k,n,x,y;
	int pp,pai,naki;
	int pos;
	int width;
	int nw,w;
	int npos;
	int rf=0,mode;
	int minoff;

	if (!ch_hand[who] && !ch_play) return;
	ch_hand[who] = 0;

	pp = pplayer[who];

	nw = 1;
	for (j=3; j>=0; j--) {
		switch(hand[who].opened_kind[j]) {
		case H_TIE:
		    nw += 1 + 2*DPAI_W + DPAI_H;
		    break;
		case H_PON:
		    nw += 1 + 2*DPAI_W + DPAI_H;
		    break;
		case H_KAN_OPENED:
		    nw += 1 + 3*DPAI_W + DPAI_H;
		    break;
		case H_KAN_CLOSED:
		    nw += 1 + 4*DPAI_W;
		    break;
		}
	}

	pos = (who - vself +4)%4;
	x = 1;
	y = 1;
#if 0
	width = 240-24;
	if ((GB_TYPE == GT_TATE) && ((pos == 0) || (pos == 2)) ) {
		width = 240;
	}
#else
	if (GB_TYPE == GT_TATE) {
	    if ((pos == 0) || (pos == 2)) {
		width = GB_WIDTH;
	    } else {
		width = GB_HEIGHT - 22 * 2;
	    }
	} else {
	    if ((pos == 0) || (pos == 2)) {
		width = GB_WIDTH - 22 * 2;
	    } else {
		width = GB_HEIGHT;
	    }
	}
#endif

	x += width-nw-1;
	minoff = 1 + ((hand[who].closed_num /3) * 3 + 2) * DPAI_W + 4;

	if (x < minoff) {
		x = minoff;
	}

	for (j=3; j>=0; j--) {
		if (hand[who].opened_kind[j]) {
		    npos = -1;
		    if (hand[who].opened_kind[j] == H_PON
		     ||  hand[who].opened_kind[j] == H_KAN_OPENED) {
			int f = hand[who].opened_from[j];
			if (f == (who + 1)%4)
				npos = 2;
			if (f == (who + 2)%4)
				npos = 1;
			if (f == (who + 3)%4)
				npos = 0;
		    }
		    if (hand[who].opened_kind[j] == H_TIE)
			npos = 0;
		    x += 1;
		    rf = 0;
		    for (k=0; k<4; k++) {
			if (k==3 && (hand[who].opened_kind[j] == H_TIE 
				    || hand[who].opened_kind[j] == H_PON))
				break;
			pai = hand[who].opened[j][k];
			if (hand[who].opened_kind[j] == H_KAN_CLOSED) {
			    if (k==1 || k==2) pai = P_INV;
			}
			mode = (k==0)?1:0;
			if (rf) mode |= 2;
			rf = 0;
			if (k==npos) pai |= 0x200;
			draw_pai(&x,&y,pos,pai,mode);
			if (k==npos) rf=1;
		    }
		}
	}

	x = 1;
	y = 1;

	w = 1+hand[who].closed_num*DPAI_W +1;

	for (i=0; i< hand[who].closed_num; i++) {
		draw_pai(&x,&y,pos,hand[who].closed[i],i==0);
#ifdef CHOICE_UP
#else
		if (cur_hand == &hand[who].closed[i]) {
		    set_color(COLOR_REVERSE);
#ifdef CHOICE_BOX
		    conv_drawrect(pos,x-(DPAI_W)-1,y-(DPAI_H-1)+1,PAI_W,PAI_H);
#else
		    conv_fillrect(pos,x-(DPAI_W),y-(DPAI_H-1),DPAI_W,DPAI_H);
#endif
		    set_color(COLOR_BLACK);
		}
#endif
	}
	x += 1;
	set_color(COLOR_TAKUGREEN2);
	conv_fillrect(pos,x,y-1,width-w-nw,PAI_H);
	set_color(COLOR_BLACK);
}

imageref(buf,s,x,y,xs,ys) char *buf; struct screen *s; {
	sprintf(buf,"\\img(%08x,%04x,%04x,%04x,%04x)",s,x,y,xs,ys);
}

getimage(buf,s,x,y,xs,ys) char *buf; struct screen **s; int *x,*y,*xs,*ys; {
	return (sscanf(buf,"\\img(%08x,%04x,%04x,%04x,%04x)",s,x,y,xs,ys) == 5);
}


ui_res(gp,howp) global_t *gp; int *howp; {
	int c,i,j,n,ret,pai;
	char *args[25];
	int pais[25];
	char *args1[5];
	int save,res,how;
	char buf[1024],*bufp;

	args1[0] = esc_str;
	args1[1] = tie_str;
	args1[2] = pon_str;
	args1[3] = kan_str;
	args1[4] = ron_str;

	save = help_index;
	help_index = HELP_RES;
	n = hand[vself].closed_num;
retry:
	*howp = 0;
	c = 0;

	if (auto_stop) {
		result_t y;
		if (hand[vself].reach) {
			res = analize_res(gp,&how);
			if (res == R_RON) c = ' ';
		}
		if (!hand[vself].reach
			&& (T_GET(rvp->attr)!=T_HN_KAN )
			&& (T_GET(rvp->attr)!=T_HN_KAN_C)) {
			if (hand_can_pon(gp,vself,rvp->out)
			 || (hand_can_kan(gp,vself,rvp->out) == 2)
			 || ((cur_player+1)%4==vself
			      && hand_can_tiex(gp,vself,rvp->out)))
				c = ' ';
		}
		if (c == 0) {
			hand_insert(gp,vself,rvp->out);
			if (result_calc_yaku(gp,vself,&y) > 0)
			    c = ' ';
			hand_delete(gp,vself,rvp->out,0);
		}
	} 
	if (c != ' ') {
		c = ui_key_wto(play_speed);
	}

	if (c == 0 || c != ' ') {
		help_index = save;
		return R_ACK;
	}
	in_res = 1;
	ret = choice(gp,5,args1,0,-1 * n);
	in_res = 0;
	switch(ret) {
		case 0:
			help_index = save;
			return R_ACK;
		case 1:
			break;
		case 2:
			help_index = save;
			return R_PON;
		case 3:
			help_index = save;
			return R_KAN;
		case 4:
			help_index = save;
			return R_RON;
	}
	if ((cur_player+1)%4 != vself) goto retry;

	args[0] = esc_str;
	i = 1;
	bufp = buf;
	for (j=0; j<n; j++) {
		pai = hand[vself].closed[j];
		if (i != 1 && P_KIND(pai) == P_KIND(pais[i-1]))
			continue;
		if (hand_can_tie(gp,vself,rvp->out,pai)) {
			int x,px,py;

			pais[i] = pai;
			x = pai_map[pai];
			px = (x % 10) * PAI_W; 
			py = (x / 10) * PAI_H;
			imageref(bufp,s1,px,py,PAI_W,PAI_H);
			args[i] = bufp;
			bufp += strlen(bufp)+1;
			i++;
		}
	}
	if (i == 1) goto retry;
	if (i == 2) {
		*howp = pais[1];
		help_index = save;
		return R_TIE;
	}
	in_res = 1;
	ret = choice(gp,i,args,0,-1 * n);
	in_res = 0;
	if (ret == 0) goto retry;
	*howp = pais[ret];
	help_index = save;
	return R_TIE;
}

ui_choice(gp) global_t *gp; {
	int i,j,n,ret,pai,oldpai,kan,sel;
	char *args[25];
	int pais[25];
	int mode = 0;
	int save;
	struct textscreen *st_win;
	int xbeg,ybeg,xs,ys;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v;
#endif

	if (auto_stop && hand[vself].reach) {
		result_t y;
		//ask_pai = hand[vself].closed[hand[vself].closed_num-1];
		if (!((result_calc_yaku(gp,vself,&y) > 0) 
		       || hand_can_kan(gp,vself,ask_pai) )) {
			ask_attr = T_RV;
			xsleep(play_speed);
			return;
		}
	}

	xbeg = GB_XOFF + ((GB_TYPE==GT_TATE)?0:22);
	ybeg = GB_YOFF + GB_HEIGHT - 22 - 14;
	xs = 64;
	ys = 14;

#ifdef USE_VIRTUAL_KEY
	v = create_virtual_key(xbeg,ybeg,24,ys,'a');
	vk_attach(NULL,v);
#endif
	st_win = create_textscreen(NULL,xbeg,ybeg,xs,ys,TS_SAVE);
	ts_set_bgcolor(st_win,COLOR_TAKUGREEN);
	ts_clear(st_win);
	ts_goto(st_win,0,0);
	ts_put_image(st_win,s5,0,12,24,12,BLT_MASKING|COLOR_WHITE);

	save = help_index;
	help_index = HELP_CHOICE;
loop:
	n = hand[vself].closed_num;
	for (i=0; i<n; i++) {
		args[i] = pai2str(hand[vself].closed[i]);
	}
	args[i++] = reach_str;
	args[i++] = kan_str;
	args[i++] = tumo_str;
	in_choice = 1;
	sel = n-1;
	if (hand[vself].reach) {
		sel = n;
	}
	ret = choice(gp,n+3,args,sel, n);

	in_choice = 0;
	if (ret < n) {
		ask_pai = hand[vself].closed[ret];
	}
	else if (ret == n) {
		mode = (mode==1)?0:1;
		ts_clear(st_win);
		ts_goto(st_win,0,0);
		ts_put_image(st_win,s5,0,12,24,12,BLT_MASKING|COLOR_WHITE);
		if (mode==1) ts_put_string(st_win,"R",1);
		ask_attr = (mode==1)?T_RV_RCH:T_RV;
		goto loop;
	}
	else if (ret == n+1) {
		args[0] = esc_str;
		oldpai = -1;
		n = hand[vself].closed_num;
		i = 1;
		for (j=0; j<n; j++) {
			pai = hand[vself].closed[j];
			kan = hand_can_kan(gp,vself,pai);
			if ((kan == 3 || kan == 1)
				 && P_KIND(pai) != oldpai) {
				pais[i] = pai;
				args[i] = pai2str(pai);
				i++;
				oldpai = P_KIND(pai);
			}
		}
		if (i == 1) goto loop;
		if (i == 2) {
			ask_attr = T_HN_KAN;
			ask_pai  = pais[1];
			help_index = save;
			goto ret;
		}
		ts_clear(st_win);
		ts_goto(st_win,0,0);
		ts_put_image(st_win,s5,0,12,24,12,BLT_MASKING|COLOR_WHITE);
		ts_put_string(st_win,"K",1);
		ret = choice(gp,i,args,0,-1 * n);
		if (ret == 0) goto loop;
		ask_pai = pais[ret];
		ask_attr = T_HN_KAN;
		help_index = save;
		goto ret;
	}
	else if (ret == n+2) {
		ask_attr = T_HN_TSM;
	}
	help_index = save;

ret:
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	free_textscreen(st_win);
}


ui_result(gp) global_t *gp; {
	int p,i,c=0;
	int quick_log=0;
	int iy[4];
	char buf[1024];
	char ybuf[12][40];
	struct textscreen *ts[4];
	int pos;
	int x,y;
	int pup = 0;
	int hide = 0;
	int pp;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v,*v1;
#endif
	xsleep(play_speed);
	in_result = 1;
	if (comment_scr == NULL) {
		v = create_virtual_key3(GB_XOFF,GB_YOFF
			,GB_WIDTH,GB_HEIGHT,MK_V2,MK_V0,MK_V0);
		v1 = create_virtual_key3(GB_XOFF+24,GB_YOFF+22+42*3
			,96*2,100,MK_V1,MK_V0,MK_V0);
		vk_attach(v,v1);
	} else {
		v = create_virtual_key3(GB_XOFF+GB_WIDTH+4, 15*9
			,SCREEN_WIDTH-(GB_XOFF+GB_WIDTH)-8
			,SCREEN_HEIGHT-15*9,MK_V1,MK_V0,MK_V0);
	}
	vk_attach(NULL,v);
retry:
	if (comment_scr == NULL) {
		pup = 1;
		for (i=0; i<4; i++) {
			pos = (i - vself + 4)%4;
			x = GB_WIDTH/2 - 96 + GB_XOFF;
			x = (x+3)&~3;
			y = GB_YOFF+22;
			switch(pos) {
			case 3: x += 0; y+= 42; break;
			case 2: x += 96/2; y+= 0; break;
			case 1: x += 96; y+= 42; break;
			case 0: x += 96/2; y+= 42*2; break;
			}
			ts[i] = create_textscreen(NULL,x,y,96,42
			,TS_SAVE|TS_BORDER|TS_BLINE);
			pp = pplayer[i];
			if ((player[pp].ppoint) < 0) {
				ts_set_bgcolor(ts[i],COLOR_LIGHTPINK);
			} else if ((player[pp].ppoint) > 0) {
				ts_set_bgcolor(ts[i],COLOR_LIGHTVIOLET);
			}
		tsdraw_player(gp,ts[i],i);
			tsdraw_player(gp,ts[i],i);
		}
		comment_scr = create_textscreen(NULL
			,GB_XOFF+24,GB_YOFF+22+42*3
			,96*2,100
			,TS_SAVE|TS_BORDER|TS_BLINE);
	}

	for (p=0; p<4; p++) if (result[p].flag) {
		ts_clear(comment_scr);
		ts_goto(comment_scr,0,0);
		result_cvt_to_int(result+p,iy);
		sprintf(buf,"%s",result_names[result[p].flag]);
		if (result[p].fan) {
			sprintf(buf+strlen(buf),"   %d %s %d %s"
				,result[p].fu,fu_sfx
				,result[p].fan,fan_sfx);
		}
		ts_put_string(comment_scr,buf,1);
		for (i=0; i<20; i++) {
			ybuf[i][0] = 0;
		}
		y = 0;
		for (i=0; i<Y_MAX;i++) if (result_str[i] && Y_GET(iy,i)) {
			sprintf(ybuf[y++]," %-14s",result_str[i]);
			if (y >= 12) goto ovflow;
		}
		if (result[p].dora) {
			sprintf(ybuf[y++]," %-12s%2d"
				,dora_str,result[p].dora);
			if (y >= 12) goto ovflow;
		}
		if (result[p].uradora) {
			sprintf(ybuf[y++]," %-12s%2d"
				,uradora_str,result[p].uradora);
			if (y >= 12) goto ovflow;
		}
		if (result[p].akadora) {
			sprintf(ybuf[y++]," %-12s%2d"
				,akadora_str,result[p].akadora);
		}
ovflow:
		buf[0] = 0;
		for (i=0; i<6; i++) {
			strcat(buf,ybuf[i]);
			strcat(buf,ybuf[i+6]);
			strcat(buf,"\n");
		}
		c = comment(5,1,buf,auto_play?play_speed*5:(-1));
		if (c =='l') quick_log = 1;
		if (c == 'a' || c == MK_V2) {
			hide = 1;
		}
		if (c == 033) {
			ui_menu(gp,033);
			goto retry;
		}
	}
	if (quick_log) {
		FILE *fp;
		fp = fopen(QUICK_LOG,"a");
		if (fp) {
			log_play(gp,fp);
			fclose(fp);
		}
	}
	if (log) log_play(gp,log);
	if (pup) {
		for (i=0; i<4; i++) {
			free_textscreen(ts[i]);
		}
		free_textscreen(comment_scr);
		comment_scr = NULL;
		if (hide) {
Refresh();
			c = ui_key();
			hide = 0;
			goto retry;
		}
	}
	if (!key_mac_cnt) {
		key_mac_cnt++;
	}
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	in_result = 0;
}


/*-----------------*/
#define MAXINPUT 128

comment(who,mode,buf,timeout) u_char *buf; {
	u_char *p;
	int c;
	int pup = 0;
	int ret = 0;

	if (comment_scr == NULL) {
		pup = 1;
		comment_scr = create_textscreen(NULL
			,GB_XOFF+24,GB_YOFF+22+42*3
			,96*2,100
			,TS_SAVE|TS_BORDER|TS_BLINE);
		ts_clear(comment_scr);
	}
	if (mode) {
#ifdef USE_VIRTUAL_KEY
		struct virtual_key *v;
		if (pup) {
			v = create_virtual_key3(GB_XOFF+24,GB_YOFF+22+42*3
					,96*2,100 ,' ',MK_V0,MK_V0);
			vk_attach(NULL,v);
		}
#endif
		ts_put_string(comment_scr,"\n",1);
		if (who < 4) 
		    ts_put_image(comment_scr,s5,16*who2pos(who),0,16,12
				,BLT_MASKING|COLOR_WHITE);
		if (who == 4) 
		    ts_put_image(comment_scr,s5,0,0,16,12
				,BLT_MASKING|COLOR_WHITE);
		ts_put_string(comment_scr,buf,1);
		ts_put_string(comment_scr,"\n",1);
Refresh();
		ret = ui_key_wto(timeout);
#ifdef USE_VIRTUAL_KEY
		if (pup) {
			vk_detach(v,1);
		}
#endif
		goto out;
	} else {
		int xpos[MAXINPUT];
		int ypos[MAXINPUT];
		int idx = 0;
		p = buf;
		ts_put_string(comment_scr,"> ",0);
		xpos[idx] = comment_scr->xpos;
		ypos[idx] = comment_scr->ypos;
Refresh();
		while((c=ui_key())!='\n') {
			if (c == '\r') break;
			if (c == '\b' || c == 0177) {
				if (p != buf) {
					p--;
				}
				if ((*p & 0x80) && p!=buf) {
					p--;
				}
				idx --;
				ts_goto(comment_scr,xpos[idx],ypos[idx]);
				ts_put_string(comment_scr,"  ",0);
				ts_goto(comment_scr,xpos[idx],ypos[idx]);
			} else if (c >= 0x20) {
				char ib[3];
				if (idx +1 >= MAXINPUT) continue;
				*p++ = c;
				ib[0] = c;
				ib[1] = 0;
				if (c & 0x80) {
					c = ui_key();
					*p++ = c;
					ib[1] = c;
					ib[2] = 0;
				}
				xpos[idx] = comment_scr->xpos;
				ypos[idx] = comment_scr->ypos;
				ts_put_string(comment_scr,ib,0);
				idx++;
				xpos[idx] = comment_scr->xpos;
				ypos[idx] = comment_scr->ypos;
			}
Refresh();
		}
		*p++ = 0;
	}
out:
	if (pup) {
		free_textscreen(comment_scr);
		comment_scr = NULL;
	}
refresh();
	return ret;
}

popup(buf,time_out) u_char *buf; {
	struct textscreen *msg_win;
	int i,j,max_j,c;
	int xsize,ysize,xbeg,ybeg;
	u_char *p;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v;
#endif

	i=1; max_j=0; j=0;
	p = buf;
	while(c = *p++) {
		if (c == '\n') {
			i++;
			if (j > max_j) max_j = j;
			j=0;
		}
		else
			j++;
	}
	if (i>15) i=15;

	xsize = (max_j+1)/2*2 *6 +8;
	ysize = i*12 +8;
	xsize = (xsize + 7) & ~7;
	xbeg = (SCREEN_WIDTH-xsize) /2;
	ybeg = (SCREEN_HEIGHT-ysize) /2;

#ifdef USE_VIRTUAL_KEY
	v = create_virtual_key3(xbeg,ybeg,xsize,ysize,' ',MK_V0,MK_V0);
	vk_attach(NULL,v);
#endif
	msg_win = create_textscreen(NULL,xbeg,ybeg,xsize,ysize
			,TS_SAVE|TS_BORDER|TS_BLINE);
	ts_clear(msg_win);

	ts_put_string(msg_win,buf,1);
Refresh();
	c = ui_key_wto(time_out);
	free_textscreen(msg_win);
refresh();
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	return c;
}

popup2(who,buf,time_out) u_char *buf; {
	struct textscreen *msg_win;
	int i,j,max_j,c;
	int xsize,ysize,xbeg,ybeg;
	u_char *p;
	int pos;

	pos = who2pos(who);

	xsize = P2WIDTH;
	ysize = P2HEIGHT;

	xbeg = p2posx[pos];
	ybeg = p2posy[pos];
	if (in_gb == 0) {
		xbeg += GB_XOFF;
		ybeg += GB_YOFF;
	}

	msg_win = create_textscreen(NULL,xbeg,ybeg,xsize,ysize
			,TS_SAVE|TS_BORDER|TS_BLINE);
	ts_clear(msg_win);

	ts_put_string(msg_win,buf,1);
Refresh();
	c = ui_key_wto(time_out);
	free_textscreen(msg_win);
	return c;
}

choice(gp,argc,argv,choiced,n) global_t *gp; int argc; u_char *argv[]; {
	int xsize,ysize,xbeg,ybeg;
	int i,j,c;
	int sc = -1;
	int up = 0;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v,*p;
#endif

	if (n<0) n=0;
	xsize = 12*4 + 8;
	ysize = (argc-n) * 12 + 8;
	xbeg = GB_XOFF + ((GB_TYPE==GT_TATE)?0:22)
		 + hand[vself].closed_num*DPAI_W +1;
	xbeg = GB_XOFF + ( (xbeg+3) & ~3 ); /* align 4 */
	ybeg = GB_YOFF + GB_HEIGHT - 22 - ysize;
	if (xbeg + xsize > GB_XOFF+GB_WIDTH) {
		xbeg = GB_XOFF+GB_WIDTH - xsize;
	}

#ifdef USE_VIRTUAL_KEY
//printf("virtual key num =%d\n",n);
	v = create_virtual_key(GB_XOFF+((GB_TYPE==GT_TATE)?0:22)
				,GB_YOFF+GB_HEIGHT-22
					,DPAI_W * 14,22,MK_V0);
	for (i=0; i<n; i++) {
		p = create_virtual_key(DPAI_W*i,0,DPAI_W,22,MK_V1+i);
		vk_attach(v,p);
		
	}
	vk_attach(NULL,v);

#endif
	while(1) {
	    if (choiced >= n) {
		int c;
esc_retry:
		c = menu(xbeg,ybeg,argc-n,argv+n,choiced-n);
		if (c == -2) {
			if (in_choice) in_choice = 2;
			ui_menu(gp,033);
			if (in_choice == 2) in_choice = 1;
			goto esc_retry;
		}
		choiced = c;
		if (choiced < 0) {
			if (sc >= 0)
				choiced = sc;
			else if (n == 0) {
				choiced = 0;
				break;
			} else {
				choiced = n-1;
			}
		}
		else if (choiced >= argc-n)
			choiced = n-1;
		else {
			choiced += n;
			break;
		}
		sc = -1;
 	    } else {
#ifdef CHOICE_UP
		if (!up) {
		    int x,y;
		    x = GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +1+DPAI_W*choiced;
		    y = GB_YOFF+GB_HEIGHT-22+1;

		    bitblt(pai_bak,0,0,NULL,x-1,y-3,PAI_W,PAI_H+2,0);
		    bitblt(NULL,x,y-2,NULL,x,y,DPAI_W,PAI_H,0);
		    draw_line(x+1,y+DPAI_H,x+DPAI_W,y+DPAI_H);
		    up = 1;
		}
#else
		set_color(COLOR_REVERSE);
#ifdef CHOICE_BOX
		draw_rect( GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +DPAI_W*choiced
				,GB_YOFF+GB_HEIGHT-22,PAI_W,PAI_H);
#else
		fill_rect( GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +1+DPAI_W*choiced
				,GB_YOFF+GB_HEIGHT-22+1,DPAI_W,DPAI_H);
#endif
#endif
		set_color(COLOR_BLACK);
		refresh();
retry:
		ui_event_wait(gp,-1);
		if (readable_socket) {
			callback(gp);
			goto retry;
		}
		if (!readable_key) {
			goto retry;
		}
		readable_key = 0;
		c=ui_key();

		if (ui_menu(gp,c)) {
			goto retry;
		}
#ifdef CHOICE_UP
		if (up) {
		    int x,y;
		    x = GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +1+DPAI_W*choiced;
		    y = GB_YOFF+GB_HEIGHT-22+1;
		    bitblt(NULL,x-1,y-3,pai_bak,0,0,PAI_W,PAI_H+2,0);
		    up = 0;
		}
#else
		set_color(COLOR_REVERSE);
#ifdef CHOICE_BOX
		draw_rect( GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +DPAI_W*choiced
				,GB_YOFF+GB_HEIGHT-22,PAI_W,PAI_H);
#else
		fill_rect( GB_XOFF+((GB_TYPE==GT_TATE)?0:22) +1+DPAI_W*choiced
				,GB_YOFF+GB_HEIGHT-22+1,DPAI_W,DPAI_H);
#endif
#endif
		set_color(COLOR_BLACK);

		if (c == MK_UP || c == '\n' || c == ' ' ) {
			break;
		}
		else if (c == MK_DOWN || c == 'a') { /* action menu */
			sc = choiced;
	    		choiced = n;
		}
		else if (c == MK_RIGHT || c == 'k' ) {
			choiced = (choiced + 1)%argc;
		}
		else if (c == MK_LEFT || c == 'j' ) {
			choiced = (choiced - 1 + argc)%argc;
		}
#ifdef USE_VIRTUAL_KEY
		else if ((MK_V1 <= c) && (c < MK_V1+n)) {
			choiced = c - MK_V1;
			break;
		}
#endif
	    }
	}
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	return choiced;
}

static int is_separater(p) char *p; {
	static char *zen = "";

	if (!p || (*p == 0)) return 0;
	while (*p) {
		if (*p == '-') {
			p++;
		} else if ((*p == zen[0]) && (p[1] == zen[1])) {
			p+=2;
		} else {
			break;
		}
	}
	if (*p == 0) {
		return 1;
	} 
	return 0;
}

menu(xbeg,ybeg,argc,argv,choiced) int argc; u_char *argv[]; {
	struct textscreen *msg_win;
	int xsize,ysize;
	int i,j,c,max;
	int x,y,xs,ys;
	struct screen *s;
	int ypos[20];
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v,*p;
#endif

	max = 0;
	ysize = 0;
	for (i=0; i<argc; i++) {
		if (getimage(argv[i],&s,&x,&y,&xs,&ys)) {
			ysize += ys;
			if (xs > max)
				max = xs;
		} else {
			if (strlen(argv[i])*6 > max)
				max = strlen(argv[i])*6;
			ysize += 12;
		}
	}
	ysize += 8;
	xsize = max + 8;
	xsize = (xsize + 7)& ~7;
	if (ybeg + ysize > GB_YOFF + GB_HEIGHT) {
		ybeg = GB_YOFF+GB_HEIGHT-ysize;
	}
	msg_win = create_textscreen(NULL,xbeg,ybeg,xsize,ysize
				,TS_SAVE|TS_BORDER|TS_BLINE);

	ts_clear(msg_win);
#ifdef USE_VIRTUAL_KEY
	v = create_virtual_key(xbeg,ybeg,xsize,ysize,MK_V0);
	vk_attach(NULL,v);
#endif
	for (i=0; i<argc; i++) {
		ypos[i] = msg_win->ypos;
		if (getimage(argv[i],&s,&x,&y,&xs,&ys)) {
			ts_put_image(msg_win,s,x,y,xs,ys,0);
		} else {
			ts_put_string(msg_win,argv[i],1);
		}
		ts_put_string(msg_win,"\n",1);
#ifdef USE_VIRTUAL_KEY
		if (!is_separater(argv[i])) {
		    p = create_virtual_key(0,ypos[i]+4,xsize
				,msg_win->ypos - ypos[i],MK_V1+i);
		    vk_attach(v,p);
		}
#endif
	}
	ypos[i] = msg_win->ypos;
	while(1) {
		if (choiced < 0 || choiced >= argc) break;
		set_color(COLOR_REVERSE);
		fill_rect(xbeg+4,ybeg+4+ypos[choiced],xsize-8
					,ypos[choiced+1]-ypos[choiced]);
		set_color(COLOR_BLACK);
Refresh();
		c=ui_key();
		set_color(COLOR_REVERSE);
		fill_rect(xbeg+4,ybeg+4+ypos[choiced],xsize-8
					,ypos[choiced+1]-ypos[choiced]);
		set_color(COLOR_BLACK);
		if ((c == 033) || (c == MK_F1)) {
			choiced = -2;
			break;
		}
		else if (c == MK_RIGHT || c == '\n' || c == ' ') {
			break;
		}
		else if (c == MK_LEFT || c == 'a') {
			c = 'a';
			choiced = -1;
			break;
		}
		else if (c == MK_DOWN || c == 'j') {
			choiced++;
		if (choiced < 0 || choiced >= argc) break;
			if ((choiced < argc)&&is_separater(argv[choiced])) {
				choiced++;
			}
		}
		else if (c == MK_UP || c == 'k') {
			choiced --;
			if ((choiced > 0) && is_separater(argv[choiced])) {
				choiced --;
			}
		}
#ifdef USE_VIRTUAL_KEY
		else if ((MK_V1 <= c) && (c < MK_V1 + argc)) {
			choiced = c - MK_V1;
			break;
		}
#endif
	}
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	free_textscreen(msg_win);
refresh();
	return choiced;
}

/* [] [] [뢭] ";*/

static char *help_message1 =  "\
 ============ ץ⡼=========\n\
å\n\
 Τפ        פ򥿥å\n\
 ˥塼  򥿥å\n\
 (꡼,,ĥ)\n\
 ɽ  򥿥å\n\
\n\
\n\
       ˥塼\n\
            \n\
˰ư   ˰ư\n\
            \n\
            \n\
F1: ɽ\
";

static char *help_message2 =  "\
 ========== ץ⡼ 2 ========\n\
å\n\
 ܤ    ܤ򥿥å\n\
\n\
\n\
          ˰ư\n\
            \n\
         \n\
            \n\
          ˰ư\n\
\n\
꡼ξ\n\
 2֤ȥ󥻥Ǥޤ\n\
\
";

static char *help_message3 =  "\
 ======= ˥塼 =====\n\
å\n\
 ܤ    ܤ򥿥å\n\
\n\
\n\
          ˰ư\n\
            \n\
         \n\
            \n\
          ˰ư\n\
\n\
ξ\n\
  פǤäȤ⾮\n\
  Ӥޤ\n\
\
";

static char *help_message4 =  "\
 ========== ɽλ ==============\n\
å\n\
 ˿ʤ  򥦥ɡ򥿥å\n\
 򥦥ɡ򱣤/Ф\n\
       򥦥ɡʳ򥿥å\n\
\n\
\n\
          򥦥ɡ򱣤/Ф\n\
            \n\
           \n\
            \n\
          ˿ʤ\n\
\n\
\n\
\
"; 



execute_help(gp) global_t *gp; {
	if (in_choice == 1) {
		popup(help_message1,-1);
	} else if (in_choice == 2) {
		popup(help_message2,-1);
	} else if (in_res) {
		popup(help_message3,-1);
	} else if (in_result) {
		popup(help_message4,-1);
	}
}


execute_advice(gp) global_t *gp; {
	char buf[256];
	int pup = 0;
	int c;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v;
	v = create_virtual_key3(GB_XOFF,GB_YOFF,GB_WIDTH,GB_HEIGHT
				,' ',MK_V0,MK_V0);
	vk_attach(NULL,v);
#endif
	if (comment_scr == NULL) {
		pup = 1;
		comment_scr = create_textscreen(NULL
			,GB_XOFF+24,GB_YOFF+22+42*3
			,96*2,100
			,TS_SAVE|TS_BORDER|TS_BLINE);
		ts_clear(comment_scr);
	}
retry:
	if (in_choice) {
		int save,ask;
		int i,px,py;

		save = ask_attr;
		analize(gp,vself);
		ask = ask_attr;
		ask_attr = save;
		if (T_GET(ask) == T_HN_TSM) {
			sprintf(buf,"   %s\n",tumo_str);
			ts_put_string(comment_scr,buf,1);
		} else {
			i = pai_map[ask_pai];
			px = (i % 10) * PAI_W; 
			py = (i / 10) * PAI_H;
			ts_put_image(comment_scr,s1,px,py,PAI_W,PAI_H,0);
			if (T_GET(ask) == T_RV_RCH) {
				sprintf(buf," %s ",reach_str);
				ts_put_string(comment_scr,buf,1);
			}
			ts_put_string(comment_scr,"\n",1);
		}
		ts_put_string(comment_scr,analize_message(gp),1);
Refresh();
	}
	else if (in_res) {
		int ask,how;
		int save;
		int i,px,py;

		save = ask_attr;
		ask = analize_res(gp,&how);
		ask_attr = save;

		if (ask == R_TIE) {
			sprintf(buf,"   %s ",tie_str);
			ts_put_string(comment_scr,buf,1);
			i = pai_map[how];
			px = (i % 10) * PAI_W; 
			py = (i / 10) * PAI_H;
			ts_put_image(comment_scr,s1,px,py,PAI_W,PAI_H,0);
			ts_put_string(comment_scr,"\n",1);
		}
		else if (ask == R_RON) {
			sprintf(buf,"   %s \n",ron_str);
			ts_put_string(comment_scr,buf,1);
		}
		else if (ask == R_PON) {
			sprintf(buf,"   %s \n",pon_str);
			ts_put_string(comment_scr,buf,1);
		}
		else if (ask == R_KAN) {
			sprintf(buf,"   %s \n",kan_str);
			ts_put_string(comment_scr,buf,1);
		}
		else {
			sprintf(buf,"   %s \n",esc_str);
			ts_put_string(comment_scr,buf,1);
		}
		ts_put_string(comment_scr,analize_message(gp),1);
Refresh();
	}
	if (pup) {
		c = ui_key();
		if (c == 033) {
			ui_menu(gp,033);
			goto retry;
		}
		free_textscreen(comment_scr);
		comment_scr = NULL;
refresh();
	}
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
}

#if 0 /* display time version for debug */
static double dtime() {
	struct timeval now;
	gettimeofday(&now,0);
	return ((double)now.tv_sec + now.tv_usec * 0.000001);
}

xsleep(time_out) {
	fd_set fds;
	double s,e;

	FD_ZERO( &fds );
	s = dtime();
	key_select( 1, &fds, time_out * 100);
	e = dtime();
	printf("key_select %4d ms -> %d ms\n"
		,time_out * 100,(int)((e-s)*1000.0));
#else

xsleep(time_out) {
	fd_set fds;

	FD_ZERO( &fds );
	key_select( 1, &fds, time_out * 100);
}

#endif

#if 1
char *rule_form = "\
%0     %     ޤ%1       %\n\
&        30000 ֤\n\
\n\
ʤ%2 % ֥ɥ%3 %\n\
ԥť%4 % 󥦥%5 %\n\
Ȥ%6 %     Ȣ׻%7 %\n\
Ƭϥ%8 %   %9         %\n\
304ݤӰ%10  %\n\
ؤ%11% ʥѥ %12%\n\
\n\
˵ $ 祪( # )\n\
ȯ˵%13% ɥ˵%14%\n\
֥ɥ˵%15%\n\
֥ɥ˵%16        %\n\
륹%17          %";

struct selbox {
	int id;
	int x,y,w;
} selbox[30];
int sb_val[30];

sel_reverse(ts,id,v) struct textscreen *ts; {
	int c;
	int bg;

	bg = ts->bgcolor;
	c = pen_color;
	set_color(COLOR_LIGHTGRAY);
	ts->bgcolor = COLOR_BLACK;
	sel_print(ts,id,v);
	set_color(c);
	ts->bgcolor = bg;
}

sel_print(ts,id,v) struct textscreen *ts; {
	char *p = 0,buf[20];

	ts_goto(ts,selbox[id].x*6,selbox[id].y*12);
	switch (id) {
	case 0:
		p = (v)?"  ":"";
		break;
	case 2: case 3: case 4: case 5: case 6: case 11:
		p = (v)?"ʤ":"";
		break;
	case 7: case 8: case 12: case 13: case 14: case 15:
		p = (v)?"":"ʤ";
		break;
	case 10:
		p = (v)?"  ":"ʤ";
		break;
	case 1:
		switch (v) {
		default:
		case 0: p = "ġ  "; break;
		case 1: p = "󥹥꡼"; break;
		case 2: p = "åȡ  "; break;
		case 3: p = ""; break;
		case 4: p = "ߥ  "; break;
		case 5: p = "ʤ      "; break;
		}
		break;
	case 9:
		switch (v) {
		default:
		case 0: p = "ȥ󤢤"; break;
		case 1: p = "¤ʤ  "; break;
		case 2: p = "¤  "; break;
		}
		break;
	case 16: 
		p = (v)?"Τ    ":"ʤƤդ";
		break;
	case 17:
		p = (v)?"ʤ          ":"åף";
		break;
	case 18:
		p = buf;
		sprintf(buf,"%5d",(v*1000)+20000);
		break;
	case 19:
		p = buf;
		sprintf(buf,"%2d ",v);
		break;
		
	}
	if (!p) return;
	ts_put_string(ts,p,0);
	if (id == 19) {
		ts_goto(ts,selbox[id+1].x*6,selbox[id+1].y*12);
		p = buf;
		sprintf(buf,"%2d ",v*3/2);
		ts_put_string(ts,p,0);
	}
}


static uma_set(a,b) uma_t a,b; {
	int i;
	for (i=0; i<12; i++) {
		a[i] = b[i];
	}
}

static uma_cmp(a,b) uma_t a,b; {
	int i;
	for (i=0; i<12; i++) {
		if (a[i] != b[i]) return 1;
	}
	return 0;
}

sel_load() {
	sb_val[0]  = tonpu;
	sb_val[2]  = RL_NONAKITAN;
	sb_val[3]  = RL_NOAKADORA;
	sb_val[4]  = RL_NOPINTUMO;
	sb_val[5]  = RL_NOKANURA;
	sb_val[6]  = RL_NOFLY;
	sb_val[7]  = RL_UNDER;
	sb_val[8]  = RL_ATAMAHANE;
	if (RL_NOSANCYAHO)
		sb_val[9]  = RL_ATAMAHANE;
	else 
		sb_val[9] = 2;
	sb_val[10] = RL_77MANGAN;
	sb_val[11] = RL_NOKUIKAE;
	sb_val[12] = RL_PAO;

	sb_val[13] = RLC_IPPATU;
	sb_val[14] = RLC_URADORA;
	sb_val[15] = RLC_AKADORA;
	sb_val[16] = RLC_NONAKIAKA;
	sb_val[17] = RLC_NOALLSTARS;
	sb_val[18] = (RL_STARTPOINT - 20000)/1000;
	sb_val[19] = RLC_YAKUMAN;
        if (!uma_cmp(uma,RLU_10_20)) sb_val[1] = 0;
        if (!uma_cmp(uma,RLU_10_30)) sb_val[1] = 1;
        if (!uma_cmp(uma,RLU_5_10))  sb_val[1] = 2;
        if (!uma_cmp(uma,RLU_7_5_3)) sb_val[1] = 3;
        if (!uma_cmp(uma,RLU_UNDER)) sb_val[1] = 4;
        if (!uma_cmp(uma,RLU_NONE))  sb_val[1] = 5;
}

sel_store() {
	tonpu = sb_val[0];
	RL_NONAKITAN = sb_val[2];
	RL_NOAKADORA = sb_val[3];
	RL_NOPINTUMO = sb_val[4];
	RL_NOKANURA = sb_val[5];
	RL_NOFLY = sb_val[6];
	RL_UNDER = sb_val[7];
	RL_ATAMAHANE = sb_val[8];
	if (sb_val[9] == 2) {
		RL_NOSANCYAHO = 0;
	} else {
		RL_NOSANCYAHO = 1;
		//RL_ATAMAHANE = sb_val[9];
	}
	RL_77MANGAN = sb_val[10];
	RL_NOKUIKAE = sb_val[11];
	RL_PAO = sb_val[12];

	RLC_IPPATU = sb_val[13];
	RLC_URADORA = sb_val[14];
	RLC_AKADORA = sb_val[15];
	RLC_NONAKIAKA = sb_val[16];
	RLC_NOALLSTARS = sb_val[17];
	RL_STARTPOINT = sb_val[18] * 1000 + 20000;
	RLC_YAKUMAN = sb_val[19];
	switch(sb_val[1]) {
        case  0: uma_set(uma,RLU_10_20);        break;
        case  1: uma_set(uma,RLU_10_30);        break;
        case  2: uma_set(uma,RLU_5_10);         break;
        case  3: uma_set(uma,RLU_7_5_3);        break;
        case  4: uma_set(uma,RLU_UNDER);        break;
        case  5: uma_set(uma,RLU_NONE);         break;
	}
}

sel_change(ts,id) struct textscreen *ts; {
	int sb_max = 1;
	switch(id) {
	case 1: sb_max = 5; break;
	case 9: sb_max = 2; break;
	case 18: sb_max = 10; break;
	case 19: sb_max = 4; break;
	}
	sb_val[id]++;
	if (sb_val[id] > sb_max) sb_val[id] = 0;
	sel_print(ts,id,sb_val[id]);
}

popup_rule(gp) global_t *gp; {
	struct textscreen *msg_win;
	int i,j,max_j,c;
	int w,id;
	int xsize,ysize,xbeg,ybeg;
	u_char *p;
	int cur_id,old_id;
#ifdef USE_VIRTUAL_KEY
	struct virtual_key *v,*vv;
#endif

	i=1; max_j=0; j=0;
	p = rule_form;
	while(c = *p++) {
		if (c == '\n') {
			i++;
			if (j > max_j) max_j = j;
			j=0;
		}
		else {
			id = -1;
			if (c == '%') {
				if ('0' <= (*p) && (*p) <= '9') {
					id = *p - '0';
					if ('0' <= (p[1]) && (p[1]) <= '9') {
						id *= 10;
						id += p[1] - '0';
					}
				}
			}
			if (id >= 0) {
				for (w = 1; w < 20; w++) {
					if (p[w+1] == '\n') break;
					if (p[w] == '%') break;
				}
				w += 2;
				selbox[id].x = j;
				selbox[id].y = i-1;
				selbox[id].w = w;
			}
			if (c == '&') {
				selbox[18].x = j;
				selbox[18].y = i-1;
				selbox[18].w = 5;
			}
			if (c == '$') {
				selbox[19].x = j-1;
				selbox[19].y = i-1;
				selbox[19].w = 3;
			}
			if (c == '#') {
				selbox[20].x = j-1;
				selbox[20].y = i-1;
				selbox[20].w = 3;
			}
			j++;
		}
	}
	if (i>15) i=15;

	xsize = (max_j+1)/2*2 *6 +8;
	ysize = i*12 +8;
	xsize = (xsize + 7) & ~7;
	xbeg = (SCREEN_WIDTH-xsize) /2;
	ybeg = (SCREEN_HEIGHT-ysize) /2;

#ifdef USE_VIRTUAL_KEY
	v = create_virtual_key(xbeg+4,ybeg+4,xsize-8,ysize-8,MK_V0);
	for (i=0; i<20; i++) {
	    vv = create_virtual_key(selbox[i].x*6
				,selbox[i].y*12
				,selbox[i].w*6,12
				,MK_V1+i);
	    vk_attach(v,vv);
	}
	vk_attach(NULL,v);
#endif
	msg_win = create_textscreen(NULL,xbeg,ybeg,xsize,ysize
			,TS_SAVE|TS_BORDER|TS_BLINE);
	ts_clear(msg_win);

	ts_put_string(msg_win,rule_form,1);
	for (i=0; i<20; i++) {
		sel_print(msg_win,i,sb_val[i]); 
	}
	cur_id = 20;
	for (;;) {
Refresh();
		old_id = cur_id;
		c = ui_key_wto(-1);
		if ((MK_V1 <= c) && (c <= MK_V1 + 20)) {
			sel_change(msg_win,c - MK_V1);
			continue;
		}
		if (c == MK_DOWN || c == 'j') {
			cur_id ++;
			if (cur_id > 20) {
				cur_id = 0;
			}
		}
		if (c == MK_UP || c == 'k') {
			cur_id --;
			if (cur_id < 0) {
				cur_id = 20;
			}
		}
		if (old_id != cur_id) {
			if (old_id < 20)
				 sel_print(msg_win,old_id,sb_val[old_id]);
			if (cur_id < 20)
				sel_reverse(msg_win,cur_id,sb_val[cur_id]);
		}
		if (c == MK_RIGHT || c == ' ' || c == '\n') {
			sel_change(msg_win,cur_id);
			sel_reverse(msg_win,cur_id,sb_val[cur_id]);
		}
		if (c == MK_LEFT || c == 033) {
			break;
		}
	}
	if (prog_kind == PROG_NETMAJ1) {
		sel_store();
	}
	free_textscreen(msg_win);
refresh();
#ifdef USE_VIRTUAL_KEY
	vk_detach(v,1);
#endif
	return c;
}
#endif
