/*
 * NINE -- the alternative keyboard function using mouse or touchpad
 *    (keycode is determined by the order passing unvisible NINE buttons)
 *
 * Copyright (C) 2000, 2001
 *	Kazuma Arino (kazuma@sola.c.u-tokyo.ac.jp)
 *      
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KAZUMA ARINO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include "mtostr.h"
#include "mgl2.h"
#include "nine.h"


#define SEQ_LEN 1024

char *sequence = NULL;

#define OFFSET 24

#ifndef NULL
#define NULL (void *)0
#endif

#define MOUSE_DOWN MK_V1
#define MOUSE_MOVE MK_V1+1
#define MOUSE_UP MK_V1+2

#include "keycode.h"



void mouse_down(int x,int y);
void mouse_up(int x, int y);
void mouse_move(int x, int y);

void mouse_up_normal(int x, int y);
void mouse_up_num(int x, int y); /* num_mode */
void mouse_up_special(int x, int y);/* special_mode */

void press_shift();
void unshift();

void press_alt();
void unalt();

void press_ctrl();
void unctrl();

void press_num();
void unnum();

void after_presskey();

int translate_normal(char *string);

void press_key(int keycode){
   int key = 
      (mgl_modifier_status & MGL_SKS_NUM_LOCKED) ? (keycode+KEYCODE_OFFSET) \
	 : keycode;
   if(mgl_modifier_status & MGL_SKS_NUM_LOCKED){
      fprintf(stderr,"deb,numlocked!\n");
   }
   mgl_put_key_raw(key,0);
   mgl_put_key_raw(key,1);
   after_presskey();
}

#define PRESS_SHIFT_KEY(key) mgl_put_key_raw(KEYCODE_SHIFT,0); \
                             press_key(key); \
                             mgl_put_key_raw(KEYCODE_SHIFT,1); \




#define NORMAL_STATE 0x01
#define NUM_STATE 0x02
#define NLOCK_STATE 0x04
#define SHIFT_STATE 0x08
#define CAPS_STATE 0x10
#define SPECIAL_STATE 0x20
#define CTRL_STATE 0x40
#define ALT_STATE 0x80

static int state = NORMAL_STATE;

#define TONUM 1
#define SPACE 2
#define BS 3
#define RET 4
#define RIGHT 5
#define LEFT 6
#define UP 7
#define DOWN 8
#define SHIFT 9
#define ESC 10
#define ALT 11
#define CTRL 12

/*#define TEST*/


int nine_get_sequence(char *buf){
   static int i = 0;
   if(!(*sequence)){
      return 0;
   }
   strcpy(buf,sequence);
   return strlen(buf);
}


int nine_callback(int ev,int x, int y){
   switch(ev){
   case MOUSE_DOWN:
      mouse_down(x,y);
      break;
   case MOUSE_UP:
      mouse_up(x,y);
      break;
   case MOUSE_MOVE:
      mouse_move(x,y);
      break;
   default:
      fprintf(stderr,"what's event?%d\n",ev);
      break;
   }
   return 0;
};

int nine_initialized;
int gp_proc(int ev,int x, int y) {
	if (!nine_initialized) {
		nine_initialized = 1;
		nine_init();
	}
	return nine_callback(ev,x,y);
}


struct virtual_key *vk_nine;


int nine_init(){

   vk_nine = create_virtual_key3(0,0,SCREEN_WIDTH,SCREEN_HEIGHT,
				 MOUSE_DOWN,MOUSE_MOVE,MOUSE_UP);
   if (!vk_nine) exit(0);
   vk_nine->callback = nine_callback;
   
   mgl_set_keymap(KEYCODE_A,"a","A","asciicircum");/* ^ */
   mgl_set_keymap(KEYCODE_B,"b","B","braceright");/* } */
   mgl_set_keymap(KEYCODE_C,"c","C","parenleft");/* ( */
   mgl_set_keymap(KEYCODE_D,"d","D","d");
   mgl_set_keymap(KEYCODE_E,"e","E","braceleft"); /* { */
   mgl_set_keymap(KEYCODE_F,"f","F","f");
   mgl_set_keymap(KEYCODE_G,"g","G","g");
   mgl_set_keymap(KEYCODE_H,"h","H","numbersign"); /* # */
   mgl_set_keymap(KEYCODE_I,"i","I","apostrophe");/* ' */
   mgl_set_keymap(KEYCODE_J,"j","J","j");
   mgl_set_keymap(KEYCODE_K,"k","K","plus"); /* + */
   mgl_set_keymap(KEYCODE_L,"l","L","l");
   mgl_set_keymap(KEYCODE_M,"m","M","m");
   mgl_set_keymap(KEYCODE_N,"n","N","quotedbl"); /* " */
   mgl_set_keymap(KEYCODE_O,"o","O","at"); /* @ */
   mgl_set_keymap(KEYCODE_P,"p","P","p");
   mgl_set_keymap(KEYCODE_Q,"q","Q","q");
   mgl_set_keymap(KEYCODE_R,"r","R","r");
   mgl_set_keymap(KEYCODE_S,"s","S","dollar"); /* $ */
   mgl_set_keymap(KEYCODE_T,"t","T","question"); /* ? */
   mgl_set_keymap(KEYCODE_U,"u","U","u");
   mgl_set_keymap(KEYCODE_V,"v","V","v");
   mgl_set_keymap(KEYCODE_W,"w","W","w");
   mgl_set_keymap(KEYCODE_X,"x","X","asterisk"); /* * */
   mgl_set_keymap(KEYCODE_Y,"y","Y","ampersand"); /* & */
   mgl_set_keymap(KEYCODE_Z,"z","Z","equal"); /* = */

/*
0,o
1,i
2,z
3,b
4,l
5,s?
6,g
7,f
8,y?
9,nothing
*/


/*

percent %

backslash \
grave `
parenright )
exclam !
bracketleft [
bracketright ]
semicolon ;
period .

greater >
slash /

asciitilde 
*/
   mgl_set_keymap(KEYCODE_ASCIITILDE,"asciitilde","asciitilde","asciitilde");
   mgl_set_keymap(KEYCODE_GRAVE,"grave","grave","grave");
   mgl_set_keymap(KEYCODE_SLASH,"slash","slash","slash");
   mgl_set_keymap(KEYCODE_GREATER,"greater","greater","greater");
   mgl_set_keymap(KEYCODE_PERIOD,"period","period","period");
   mgl_set_keymap(KEYCODE_SEMICOLON,"semicolon","semicolon","semicolon");
   mgl_set_keymap(KEYCODE_BRACKETRIGHT,"bracketright","bracketright","bracketright");
 mgl_set_keymap(KEYCODE_BRACKETLEFT,"bracketleft","bracketleft","bracketleft");
   
   mgl_set_keymap(KEYCODE_PARENRIGHT,"parenright","parenright","parenright");
   mgl_set_keymap(KEYCODE_BACKSLASH,"backslash","backslash","backslash");
   

   mgl_set_keymap(KEYCODE_0,"0","parenright","0");
   mgl_set_keymap(KEYCODE_1,"1","exclam","1");
   mgl_set_keymap(KEYCODE_2,"2","at","2");
   mgl_set_keymap(KEYCODE_3,"3","numbersign","3");
   mgl_set_keymap(KEYCODE_4,"4","dollar","4");
   mgl_set_keymap(KEYCODE_5,"5","percent","5");
   mgl_set_keymap(KEYCODE_6,"6","asciicircum","6");
   mgl_set_keymap(KEYCODE_7,"7","ampersand","7");
   mgl_set_keymap(KEYCODE_8,"8","asterisk","8");
   mgl_set_keymap(KEYCODE_9,"9","parenleft","9");
   

   mgl_set_keymap(KEYCODE_SHIFT,"shift","shift","exclam");
   mgl_set_keymap(KEYCODE_ALT,"alt","alt","alt");
   mgl_set_keymap(KEYCODE_CTRL,"ctrl","ctrl","less");
   mgl_set_keymap(KEYCODE_CAPS,"caps","caps","caps");
   mgl_set_keymap(KEYCODE_RIGHT,"right","right","underscore");
   mgl_set_keymap(KEYCODE_LEFT,"left","left","left");
   mgl_set_keymap(KEYCODE_UP,"up","up","bar");
   mgl_set_keymap(KEYCODE_DOWN,"down","down","colon");
   mgl_set_keymap(KEYCODE_BACKSPACE,"backspace","backspace","backspace");
   mgl_set_keymap(KEYCODE_RET,"return","return","comma");
   mgl_set_keymap(KEYCODE_TAB,"tab","tab","tab");
   mgl_set_keymap(KEYCODE_ESC,"escape","escape","escape");
   mgl_set_keymap(KEYCODE_SPACE,"space","space","minus");
   mgl_set_keymap(KEYCODE_NUMLOCK,"numlock","numlock","backslash");
   return 0;
}

int nine_is_on = 0;

void nine_toggle(){
   if(nine_is_on){
      nine_is_on = 0;
      nine_off();
   }
   else{
      nine_is_on = 1;
      nine_on();
   }
}

void nine_on(){
   printf("attach!\n");
   vk_attach(NULL,vk_nine);
}

void nine_off(){
   printf("detach!\n");
   vk_detach(vk_nine,0);
}

void mouse_up(int x, int y){
   printf("deb,mouseup\n");
   return mouse_up_normal(x,y);
}

void mouse_up_normal(int x, int y){
   int i;
   
   mtostr_finish(x,y);
   sequence = mtostr_translate();
   if(!(strcmp(sequence,"5"))){
      if(!(state & ALT_STATE)){
	 printf("SpecialMode1\n");
	 state |= ALT_STATE ;
	 mgl_put_key_raw(KEYCODE_ALT,0);
	 return;
      }
      else{
	 printf("DoubleClick!\n");
	 state &= ~ALT_STATE;
	 mgl_put_key_raw(KEYCODE_ALT,1);
      }
      return;
   }

   i = translate_normal(sequence);
   fprintf(stderr,"translate %d\n",i);
   switch(i){
   case KEYCODE_NUMLOCK:
      fprintf(stderr,"num!\n");
      press_num();
      break;
   case KEYCODE_SHIFT:
      press_shift();
      break;
   case KEYCODE_CTRL:
      press_ctrl();
      break;
   case KEYCODE_ALT:
      press_alt();
      break;
   default:
      press_key(i);
      break;
   }

   return ;
}

extern int yylex();

int translate_normal(char *string){
   int i;
   

   fprintf(stderr,"string=%s,%c,%c\n",string,string[0],string[1]);
   return yylex();
}


void mouse_move(int x, int y){
   mtostr_record(x,y);
}

void mouse_down(int x, int y){
   printf("mousedown\n");
   mtostr_init(x,y);
}

void press_shift(){
   if(state & CAPS_STATE){
      unshift();
      state &= ~CAPS_STATE;
      return ;
   }
   if(state & SHIFT_STATE){
      state |= CAPS_STATE;
      return;
   }
   state |= SHIFT_STATE;
   mgl_put_key_raw(KEYCODE_SHIFT,0);
}


void unshift(){
   state &= ~SHIFT_STATE;
   mgl_put_key_raw(KEYCODE_SHIFT,1);
}

void press_alt(){
   if(state & ALT_STATE){
      return unalt();
   }
   state |= ALT_STATE;
   mgl_put_key_raw(KEYCODE_ALT,0);
}
void unalt(){
   state &= ~ALT_STATE;
   mgl_put_key_raw(KEYCODE_ALT,1);
}

void press_ctrl(){
   if(state & CTRL_STATE){
      return unctrl();
   }
   state |= CTRL_STATE;
   mgl_put_key_raw(KEYCODE_CTRL,0);
}

void unctrl(){
   state &= ~CTRL_STATE;
   mgl_put_key_raw(KEYCODE_CTRL,1);
}

void unnum(){
   state &= ~NUM_STATE;
   mgl_put_key_raw(KEYCODE_NUMLOCK,0);
   mgl_put_key_raw(KEYCODE_NUMLOCK,1);
   if(mgl_modifier_status & MGL_SKS_NUM_LOCKED){
      fprintf(stderr,"why?modifier unchanged\n");
   }
}


void press_num(){
   if(state & ALT_STATE){
      press_key(KEYCODE_NUMLOCK);
      return ;
   }
   if(!(state & NUM_STATE)){
      state |= NUM_STATE;
      mgl_put_key_raw(KEYCODE_NUMLOCK,0);
      mgl_put_key_raw(KEYCODE_NUMLOCK,1);
      return ;
   }
   if(state & NLOCK_STATE){
      unnum();
      state &= ~NLOCK_STATE;
      return ;
   }
   state |= NLOCK_STATE;
}


void after_presskey(){
   if((state & SHIFT_STATE) && !(state & CAPS_STATE)){
      unshift();
   }
   if((state & NUM_STATE) && !(state & NLOCK_STATE)){
      fprintf(stderr,"deb,here!,unnum!\n");
      unnum();
   }
   if(state & ALT_STATE){
      unalt();
   }
   if(state & CTRL_STATE){
      unctrl();
   }
}

#ifdef TEST
int main ()
{
	char buf[256];
	struct textscreen *t;
	int ret;
	int i;

	open_graph();
	set_font(12,0);
	set_color(COLOR_WHITE);
	clear_screen();
	nine_init();
	nine_start();
	t = create_textscreen(NULL,20,20,600,12*10+8,TS_BORDER|TS_BLINE);
	i = 0;
	set_color(COLOR_BLACK);
	while (1) {
		ret = get_key_im(-1);
		if (!(ret & 0x80)) {
			buf[0] = ret;
			buf[1] = 0;
			ts_put_string(t,buf,0);
			if(ret & 0x80){
			   printf("here!\n");
			}
			if (ret == 033 || ret == ('c'&0x1f)){
			   printf("press c or esc!,%x,%x,%x\n",
				  ret,033,'c'&0x1f);
			   break;
			}
		} else {
			buf[0] = ret;
			ret = get_key_im(-1);
			buf[1] = ret;
			buf[2] = 0;
			ts_put_string(t,buf,0);
		}
refresh();
	}
	close_graph();
}
#endif
