/*
 * MIL -- MobileGear Image Loader -
 * Copyright (C) 1998, 1999
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

char *icon_mil ="\
#MGR000200160016
+ooooooooooooo++
ooooooooooooooo+
ooEEEoooooooooo+
oooooEEoooooooo+
ooooooooooooooo+
ooEEEoooooooooo+
oooooEEoooooooo+
ooooooooEoEoooo+
ooEEEoooEoEoooo+
oooooEEoEoEoooo+
ooooooooEoEooEo+
oooooooEEoEoEoo+
ooooooEoooEEooo+
ooooooooooooooo+
+ooooooooooooo++
++++++++++++++++
";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#ifdef USE_JPEG
#  include "jpeglib.h"
#endif /* USE_JPEG */
#ifdef USE_GIF
#  include "gif_lib.h"
#endif /* USE_GIF */
#ifdef USE_PNG
#  include "png.h"
#endif /* USE_PNG */
#if defined (USE_JPEG) || defined (USE_PNG)
#  include <setjmp.h>
#endif /* USE_JPEG || USE_PNG */
#include "mgl2.h"
#include "mglcol.h"

#define  MIL_VER     "0.4"
#define  DEBUG       0

#define  CTRL(c)     ((c) & 037)

#define  G_FWD       CTRL('n')
#define  G_FWD2      ' '
#define  G_BWD       CTRL('p')
#define  G_BWD2      0x7f

#define  G_UP        'k'
#define  G_DOWN      'j'
#define  G_RIGHT     'l'
#define  G_LEFT      'h'

#define  SCREEN_UP     CTRL('k')
#define  SCREEN_DOWN   CTRL('j')
#define  SCREEN_RIGHT  CTRL('l')
#define  SCREEN_LEFT   CTRL('h')

#define  HALF_UP       'K'
#define  HALF_DOWN     'J'
#define  HALF_RIGHT    'L'
#define  HALF_LEFT     'H'

#define  G_HOME      MK_HOME
#define  G_END       'G'
#define  G_END2      MK_END

int check_mgr(char *f);
int read_file(char *f, int *w, int *h, struct screen **image);
int cont_jpeg(FILE *fd, int *w, int *h, struct screen **image);


#ifndef STK_MIL
#define STK_MIL STK_GENERIC_FULLCOLOR
#endif
/* ̾򤹤ȡFULLCOROR Ǥʤȱʤ롣
 * ͥʤ顢STK_NATIVE ȤˤƤɤ
 */
#ifndef MAKE_BITMAP_LIMIT
#define MAKE_BITMAP_LIMIT  (800*600)
#endif
/* ̾Ѥ screen 뤫ɤ
 * ͥʤ顢0 ˤƤ褤
 */


#define MAX_MAGNITUDE   9
#define INIT_MAG	4
int magnitude = INIT_MAG;
int magnitude_tab[] = {250, 353,  500,  707,  1000
			,  1414, 2000,  2828, 4000, 5657};
#define MAG(x) ((x) * magnitude_tab[magnitude]/1000)
#define RMAG(x) ((x) * 1000/magnitude_tab[magnitude])
/* ̾Ψ magnitude_tab ǷƤ롣
   ŬѹƤ⡢֤ư
*/

static int from_main = 0;
#ifdef MINI
#define  MINI_SX     (480 + 3)
#define  MINI_SY     (8 + 2)
#define  MINI_WD     (160 - 6)
static int mini_hi = 224 - 5;
#define  MINI_HI     (mini_hi)
#define  MINI_KEY_SX 480
#define  MINI_KEY_SY 8
#define  MINI_KEY_WD (160 - 1)
static int mini_key_hi = 224 -1;
#define  MINI_KEY_HI (mini_key_hi)

#define  MIL_FIFO    "MIL_PIPE"
#define  MIL_FILE    "/tmp/.mil_fifo"

#define  MIL_MSG1    "MobileGear Image Loader"
#define  MIL_MSG2    "(version %s)"
#define  MIL_MSG3    "%s support"

#define  SUP_MGR     "MGR"
#define  SUP_JPEG    "JPEG"
#define  SUP_GIF     "GIF"
#define  SUP_PNG     "PNG"

#define  MAX_SUP     (4 + 1)

void mini_mil(int c);
void mil_message(void);

#ifdef EXECUTABLE_MINI
#undef  MINI_SX 
#undef  MINI_SY 
#define  MINI_SX     (3)
#define  MINI_SY     (2)

main() {
	int c;
	mgl_apli_type = AT_MINIAPLI;
	open_graph();
	if (!mgl_client) {
		printf("server not running \n");
		exit(2);
	}
	set_icon(icon_mil,"mil");

	mini_mil(-2);
	for (;;) {
		c = get_key(10);
		mini_mil(c);
	}
}
#endif

static init = 1;
static i_exist = 0;
static key_in = 0;
static int fd = -1;
static int sx, sy;
static int dx, dy;
static int dw, dh;
static int w, h;
static struct screen *st;
static char *image = NULL;
static char fifo[MAXPATHLEN];
static char img_file[MAXPATHLEN];
static char *sup_list[MAX_SUP + 1];

void mil_message(void)
{
    int i;
    int fnt = 12;
    int mx, my;
    int rx, ry, rw, rh;
    char buff[32];

    /* Title */
    set_color(COLOR_BLACK);
    set_font(fnt, FA_ITALIC | FA_BOLD);
    mx = MINI_SX + (MINI_WD - strlen(MIL_MSG1) * fnt / 2) / 2;
    my = MINI_SY + 5;
    draw_string(mx, my, MIL_MSG1,DIR_NORTH);

    rx = MINI_SX + (mx - MINI_SX) / 2;
    ry = MINI_SY + 2;
    rw = MINI_WD - (mx - MINI_SX);

    sprintf(buff, MIL_MSG2, MIL_VER);
    mx = MINI_SX + (MINI_WD - strlen(buff) * fnt / 2) / 2;
    my = MINI_SY + 5 + fnt + 5;
    draw_string(mx, my, buff,DIR_NORTH);

    rh = my + fnt + 2 - ry;

    set_color(COLOR_DARKGRAY);
    draw_rect(rx, ry, rw, rh);

    /* support format list */
    set_color(COLOR_BLACK);
    set_font(fnt, FA_NORMAL);
    strcpy(buff, "supported format");
    mx = MINI_SX + (MINI_WD - strlen(buff) * fnt / 2) / 2;
    my = MINI_SY + 5 + (fnt + 5) * 2 + 5;
    draw_string(mx, my, buff,DIR_NORTH);

    my = MINI_SY + 5 + (fnt + 5) * 3 + 5;
    for(i = 0 ; sup_list[i] ; i++){
#if 0
        sprintf(buff, MIL_MSG3, sup_list[i]);
        mx = MINI_SX + (MINI_WD - strlen(buff) * fnt / 2) / 2;
        mx = MINI_SX + fnt / 2 * 2;
#else
        sprintf(buff, "%s", sup_list[i]);
        mx = MINI_SX + (MINI_WD - strlen(buff) * fnt / 2) / 2;
#endif
        draw_string(mx, my, buff,DIR_NORTH);
        my = MINI_SY + 5 + (fnt + 5) * 3 + 5 + (fnt + 3) * (i + 1);
    }

    return;
}

void mini_mil(int c)
{
    fd_set fds;
    int i;
    int ret;
    char buff[MAXPATHLEN];

    if(init){
        if(getenv(MIL_FIFO)){
            strcpy(fifo, (const char *)getenv(MIL_FIFO));
        }else{
            strcpy(fifo, MIL_FILE);
        }
#if DEBUG
        printf("fifo [%s]\n", fifo);
#endif

#ifdef USE_MKNOD
        if(mknod(fifo, S_IFIFO | 0666, 0) < 0){
            if(errno != EEXIST){
                perror("mknod");
                return;
            }
        }
#else
        if(mkfifo(fifo, 0666) < 0){
            if(errno != EEXIST){
                perror("mknod");
                return;
            }
        }
#endif
        fd = open(fifo, O_RDONLY | O_NDELAY);
        if(fd == -1){
            perror("open");
            return;
        }

        for(i = 0 ; i < MAX_SUP ; i++){
            sup_list[i] = NULL;
        }

        i = 0;
        /* Check support format */
        sup_list[i] = SUP_MGR;
        i++;

#ifdef USE_JPEG
        sup_list[i] = SUP_JPEG;
        i++;
#endif /* USE_JPEG */

#ifdef USE_PNG
        sup_list[i] = SUP_PNG;
        i++;
#endif /* USE_PNG */

#ifdef USE_GIF
        sup_list[i] = SUP_GIF;
        i++;
#endif /* USE_GIF */

        init = 0;
    }

    FD_ZERO(&fds);
    FD_SET(fd,&fds);
#if 0
    ret = key_select(fd + 1, &fds, 500);
#else
{
    struct timeval tv;

    tv.tv_sec  = 0;
    tv.tv_usec = 500 * 1000;

    ret = select(fd + 1, &fds, NULL, NULL, &tv);
}
#endif
    if(ret < 0){
        return;
    }
    if(FD_ISSET(fd, &fds)){
        /* File Name Read */
        memset(buff, 0x00, MAXPATHLEN);
        if(read(fd, buff, MAXPATHLEN - 1) > 0){
            if(buff[strlen(buff) - 1] == '\n'){
                buff[strlen(buff) - 1] = 0x00;
            }
            strcpy(img_file, buff);
#if DEBUG
            printf("img_file [%s]\n", img_file);
#endif

            /* File Access */
            ret = access(img_file, R_OK);
            if(ret){
                perror("access");
                return;
            }

            if(i_exist){
                /* Screen Clear */
                set_color(COLOR_WHITE);
                fill_rect(MINI_SX, MINI_SY, MINI_WD, MINI_HI);

                free_screen(st);
                if(image) free(image);
                image = NULL;
                i_exist = 0;
            }

            st = read_screen_mgr(img_file);
            if(st){
                w = st->width;
                h = st->height;
            }else{
#if defined (USE_JPEG) || defined (USE_GIF) || defined (USE_PNG)
                ret = read_file(img_file, &w, &h, &st);
                if(ret != 0){
                    mil_message();
                    return;
                }
#else
                mil_message();
                return;
#endif
            }

            canvas_set(st,MINI_SX, MINI_SY, MINI_WD, MINI_HI);
            refresh();
            i_exist = 1;
        }else{
        }
    }else{
    }

    switch(c){
    case MK_UP:
    case G_UP:
        if(i_exist){
	    canvas_change_xy(0,-8);
            refresh();
        }
        break;
    case MK_DOWN:
    case G_DOWN:
        if(i_exist){
	    canvas_change_xy(0,+8);
            refresh();
        }
        break;
    case MK_RIGHT:
    case G_RIGHT:
        if(i_exist){
	    canvas_change_xy(+8,0);
            refresh();
        }
        break;
    case MK_LEFT:
    case G_LEFT:
        if(i_exist){
	    canvas_change_xy(-8,0);
            refresh();
        }
        break;
    case MK_PAGE_UP:
    case SCREEN_UP: /* Ctrl-k */
        if(i_exist){
	    canvas_change_xy(0,-MINI_HI);
            refresh();
        }
        break;
    case MK_PAGE_DOWN:
    case SCREEN_DOWN: /* Ctrl-j */
        if(i_exist){
	    canvas_change_xy(0,+MINI_HI);
            refresh();
        }
        break;
    case SCREEN_RIGHT: /* Ctrl-l */
        if(i_exist){
	    canvas_change_xy(+MINI_WD,0);
            refresh();
        }
        break;
    case SCREEN_LEFT: /* Ctrl-h */
        if(i_exist){
	    canvas_change_xy(-MINI_WD,0);
            refresh();
        }
        break;
    case HALF_UP: /* Shift-k */
        if(i_exist){
	    canvas_change_xy(0,-MINI_HI/2);
            refresh();
        }
        break;
    case HALF_DOWN: /* Shift-j */
        if(i_exist){
	    canvas_change_xy(0,+MINI_HI/2);
            refresh();
        }
        break;
    case HALF_RIGHT: /* Shift-l */
        if(i_exist){
	    canvas_change_xy(+MINI_WD/2,0);
            refresh();
        }
        break;
    case HALF_LEFT: /* Shift-h */
        if(i_exist){
	    canvas_change_xy(-MINI_WD/2,0);
            refresh();
        }
        break;
    case G_HOME:
        if(i_exist){
	    canvas_change_xy(0,-10000);
            refresh();
        }
        break;
    case G_END:
    case G_END2:
        if(i_exist){
	    canvas_change_xy(0,+10000);
            refresh();
        }
        break;
    case '<': /* Shrink */
        if(i_exist){
	    canvas_change_mag(-1);
            refresh();
        }
        break;
    case '>': /* Expand */
        if(i_exist){
	    canvas_change_mag(1);
            refresh();
        }
        break;
    case '?': /* Help */
        set_color(COLOR_WHITE);
        fill_rect(MINI_SX, MINI_SY, MINI_WD, MINI_HI);

        mil_message();
        refresh();
        break;
    case (-1):
        break;
    case (-2):
	if (SCREEN_HEIGHT < 224) {
		MINI_HI = SCREEN_HEIGHT - 5;
		MINI_KEY_HI = SCREEN_HEIGHT - 1;
		if (!from_main) {
			MINI_HI -= 16;
			MINI_KEY_HI -= 16;
		}

	}
        if(i_exist){
            set_color(COLOR_WHITE);
            fill_rect(MINI_SX, MINI_SY, MINI_WD, MINI_HI);
            bitblt(NULL, sx, sy, st, dx, dy, dw, dh, 0);
        }else{
            set_color(COLOR_WHITE);
            fill_rect(MINI_SX, MINI_SY, MINI_WD, MINI_HI);

            /* No Image */
            mil_message();
        }
        refresh();
        return;
    case (-3):
        key_in = 1;
        set_color(COLOR_BLACK);
        draw_rect(MINI_KEY_SX, MINI_KEY_SY, MINI_KEY_WD, MINI_KEY_HI);
        refresh();
        return;
    case (-4):
        key_in = 0;
        set_color(COLOR_LIGHTGRAY);
        draw_rect(MINI_KEY_SX, MINI_KEY_SY, MINI_KEY_WD, MINI_KEY_HI);
        refresh();
        return;
    }

    return;
}
#else  /* non MINI */

int main(int argc, char **argv)
{
    int ret = 0;
    int sx, sy;
    int dw, dh;
    int w = 0, h = 0;
    int i;
    int loop = 1;
    int file_num = 1;
    struct screen *st = NULL;
    struct screen *new_st;
    int *image = NULL;
#if defined (USE_JPEG) || defined (USE_GIF) || defined (USE_PNG)
    int new_w, new_h;
    int *new_image = NULL;
#endif

    if ((argc >= 2) && (!strcmp("-m",argv[1]))) {
	mgl_apli_type = AT_MINIAPLI;
	argc--;
	argv++;
    }
    if(argc == 1) {
        fprintf(stderr, "Usage: %s file...\n", argv[0]);
        exit(1);
    }

    /* Init mgl */
    SCREEN_WIDTH = 480;
    SCREEN_HEIGHT = 320;
    if(open_graph() != 1){
        fprintf(stderr, "Cannot initialize mgl\n");
        exit(1);
    }
    set_color(COLOR_WHITE);
    clear_screen();
    set_icon(icon_mil,"mil");

    {
        for(i = 1 ; i < argc ; i++){
            ret = check_mgr(argv[i]);
            if(!ret){
                file_num = i;
                break;
            }else{
#if defined (USE_JPEG) || defined (USE_GIF) || defined (USE_PNG)
                ret = read_file(argv[i], &w, &h, &st);
                if(ret){
                    continue;
                }
                file_num = i;
                break;
#else
            fprintf(stderr, "%s: unsupported format\n", argv[i]);
            continue;
#endif
            }
        }
    }
    if(ret){
        exit(1);
    }

    if (!st) {
    	st = read_screen_mgr(argv[file_num]);
	if(st){
            w = st->width;
            h = st->height;
	}
    }

    canvas_set(st,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
    refresh();

    while (loop) {
        ret = get_key(10);
        if(ret == -1){
            continue;
        }
        switch(ret){
        case MK_UP:
        case G_UP:
	    canvas_change_xy(0,-8);
            break;
        case MK_DOWN:
        case G_DOWN:
	    canvas_change_xy(0,+8);
            break;
        case MK_RIGHT:
        case G_RIGHT:
	    canvas_change_xy(+8,0);
            break;
        case MK_LEFT:
        case G_LEFT:
	    canvas_change_xy(-8,0);
            break;
        case SCREEN_UP: /* Ctrl-k */
	    canvas_change_xy(0,-SCREEN_HEIGHT);
            break;
        case SCREEN_DOWN: /* Ctrl-j */
	    canvas_change_xy(0,+SCREEN_HEIGHT);
            break;
        case SCREEN_RIGHT: /* Ctrl-l */
	    canvas_change_xy(+SCREEN_WIDTH,0);
            break;
        case SCREEN_LEFT: /* Ctrl-h */
	    canvas_change_xy(-SCREEN_WIDTH,0);
            break;
        case HALF_UP: /* Shift-k */
	    canvas_change_xy(0,-SCREEN_HEIGHT/2);
            break;
        case HALF_DOWN: /* Shift-j */
	    canvas_change_xy(0,+SCREEN_HEIGHT/2);
            break;
        case HALF_RIGHT: /* Shift-l */
	    canvas_change_xy(+SCREEN_WIDTH/2,0);
            break;
        case HALF_LEFT: /* Shift-h */
	    canvas_change_xy(-SCREEN_WIDTH/2,0);
            break;
        case G_HOME:
	    canvas_change_xy(0,-10000);
            break;
        case G_END:
        case G_END2:
	    canvas_change_xy(0,+10000);
            break;
        case G_FWD:  /* Next */
        case G_FWD2: /* Next */
	    magnitude = INIT_MAG;
            if(file_num + 1 < argc){
                file_num++;
                new_st = read_screen_mgr(argv[file_num]);
                if(new_st){
                    free_screen(st);
                    st = new_st;
                    w = st->width;
                    h = st->height;
                }else{
#if defined (USE_JPEG) || defined (USE_GIF) || defined (USE_PNG)
                    ret = read_file(argv[file_num], &new_w, &new_h, &new_st);
                    if(ret != 0){
                        continue;
                    }
#if 0
fprintf(stderr, "FWD [%d]\n", file_num);
#endif

                    free_screen(st);
                    st = new_st;
                    w = new_w;
                    h = new_h;
#else
                    fprintf(stderr, "%s: unsupported format\n", argv[file_num]);
                    continue;
#endif
                }
		canvas_set(st,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
            }
            break;
        case G_BWD:  /* Pre */
        case G_BWD2: /* Pre */
	    magnitude = INIT_MAG;
            if(file_num - 1 >= 1){
                file_num--;
                new_st = read_screen_mgr(argv[file_num]);
                if(new_st){
                    free_screen(st);
                    st = new_st;
                    w = st->width;
                    h = st->height;
                }else{
#if defined (USE_JPEG) || defined (USE_GIF) || defined (USE_PNG)
                    ret = read_file(argv[file_num], &new_w, &new_h, &new_st);
                    if(ret != 0){
                        continue;
                    }
#if 0
fprintf(stderr, "BWD [%d]\n", file_num);
#endif
                    free_screen(st);
                    st = new_st;
                    w = new_w;
                    h = new_h;

#else
                    fprintf(stderr, "%s: unsupported format\n", argv[file_num]);
                    continue;
#endif
                }
		canvas_set(st,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
            }
            break;
        case 'q':
            loop = 0;
            break;
#if 0 /*def DUMP_SUPPORT */
        case MK_F8:
	    write_screen_mgr("tmp1",NULL,STK_GENERIC_4COLOR);
	    write_screen_mgr("tmp2",NULL,STK_GENERIC_192COLOR);
	    write_screen_mgr("tmp3",NULL,STK_GENERIC_FULLCOLOR);
	    break;
        case MK_F7:
	    write_screen_mgr("tmp1",st,STK_GENERIC_4COLOR);
	    write_screen_mgr("tmp2",st,STK_GENERIC_192COLOR);
	    write_screen_mgr("tmp3",st,STK_GENERIC_FULLCOLOR);
	    break;
#endif
	case '<': /* Shrink */
		canvas_change_mag(-1);
            break;
	case '>': /* Expand */
		canvas_change_mag(1);
            break;
        }
#if DEBUG
    printf("[0%o][0x%x]\n", ret, ret);
    printf("sx [%d]\n",sx);
    printf("sy [%d]\n",sy);
    printf("dx [%d]\n",dx);
    printf("dy [%d]\n",dy);
    printf("dw [%d]\n",dw);
    printf("dh [%d]\n",dh);
#endif
        refresh();
    }
    free_screen(st);
    if(image) free(image);

    exit(0);
}
#endif /* MINI */

int check_mgr(char *f)
{
    int fd;
    char buf[MGR_HEADER_SIZE + 1];

    /* file open */
    fd = open(f, O_RDONLY);
    if(fd == -1){
        return(-1);
    }

    /* read header */
    if(read(fd, buf, MGR_HEADER_SIZE) != MGR_HEADER_SIZE){
        close(fd);
        return(1);
    }
    close(fd);

    buf[MGR_HEADER_SIZE] = '\0';

    if(strncmp(buf, "#MGR", 4)){
        return(1);
    }

    return(0);
}

#ifdef USE_GIF
static int intcompare(i, j)
int *i;
int *j;
{
    if (*i > *j)
        return (1);
    if (*i < *j)
        return (-1);
    return (0);
}

extern int _GifError;

/* The way Interlaced image should. */
static int InterlacedOffset[] = { 0, 4, 2, 1 };
/* be read - offsets and jumps... */
static int InterlacedJumps[] = { 8, 8, 4, 2 };
static int ColorMapSize = 0;
static int BackGround = 0;
static ColorMapObject *ColorMap;

gif_put_pixstream(int x,int y,GifRowType buf,int length) {
	GifColorType *ColorMapEntry;
	int i;
	int r,g,b;

	if ((length < 0) || ( length > 4096)) {
		return;
	}
    {
	int mgl_image[length];
	for (i=0; i< length; i++) {
        	ColorMapEntry = &ColorMap->Colors[*buf++];
		r = (int)ColorMapEntry->Red >> 4;
		g = (int)ColorMapEntry->Green >> 4;
		b = (int)ColorMapEntry->Blue >> 4;
		mgl_image[i] = mc_from_rgb(packRGB(r,g,b)) | COLOR_DITHER;
	}
	put_pixstream(x,y,mgl_image,length,DIR_NORTH);
    }
}

int read_gif_file(char *f, int *w, int *h, struct screen **image)
{
    int Width,Height,Col,Row,ExtCode;
    GifFileType *GifFile;
    GifRowType  gif_image;
    GifRecordType RecordType;
    GifByteType *Extension;
    char *p;
    int i, j;
    int width,height;

    /* Gif File Check */
    GifFile = DGifOpenFileName(f);
    if(!GifFile){
        return -1;
    }

    *w = width =  GifFile->SWidth;
    *h = height = GifFile->SHeight;
    gif_image = (GifRowType)malloc(width * sizeof(GifPixelType));
    *image = create_memscreen(width,height,NULL,STK_MIL,0);
    if (!image) {
    	*image = create_memscreen(width,height,NULL,STK_NATIVE,0);
    }


    if (*image) push_screen(*image);

    if (!(*image) || !gif_image) {
err:
	if (*image) {
		pop_screen();
		free_screen(*image);
	}
	if (gif_image) free(gif_image);
        if(DGifCloseFile(GifFile) == GIF_ERROR){
                PrintGifError();
        }
	return -1;
    }

    /* Scan the content of the GIF file and load the image(s) in: */
    do {
        if(DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR) {
		goto err;
        }
        switch(RecordType){
        case IMAGE_DESC_RECORD_TYPE:
            if(DGifGetImageDesc(GifFile) == GIF_ERROR){
		goto err;
            }
            /* Image Position relative to Screen.  */

            Row = GifFile->Image.Top;
            Col = GifFile->Image.Left;
            Width = GifFile->Image.Width;
            Height = GifFile->Image.Height;
	    BackGround = GifFile->SBackGroundColor;
    	    ColorMap = GifFile->Image.ColorMap ? GifFile->Image.ColorMap
                			: GifFile->SColorMap;
    			ColorMapSize = ColorMap->ColorCount;
            if((Col + Width> width) || (Row + Height > height)) {
                fprintf(stderr,
                       "Image is not confined to screen dimension, aborted.\n");
		goto err;
            }
            if(GifFile->Image.Interlace){
                /* Need to perform 4 passes on the images: */
                for(i = 0; i < 4; i++){
                    for(j = Row + InterlacedOffset[i];
                        j < Row + Height; j += InterlacedJumps[i]){
                        if(DGifGetLine(GifFile, gif_image,Width) == GIF_ERROR){
			    goto err;
                        }
			gif_put_pixstream(Col,j,gif_image,Width);
                    }
                }
            } else{
                for(i = 0; i < Height; i++){
                    if(DGifGetLine(GifFile, gif_image,Width) == GIF_ERROR) {
			goto err;
                    }
		    gif_put_pixstream(Col,Row++,gif_image,Width);
                }
            }
            break;
        case EXTENSION_RECORD_TYPE:
            /* Skip any extension blocks in file: */
            if(DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR){
		goto err;
            }
            while(Extension != NULL) {
                if(DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR){
			goto err;
                }
            }
            break;
        case TERMINATE_RECORD_TYPE:
            break;
        default:    /* Should be traps by DGifGetRecordType. */
            break;
        }
    } while(RecordType != TERMINATE_RECORD_TYPE);



    pop_screen();
    free(gif_image);

    return 0;
}
#endif /* USE_GIF */

#ifdef USE_JPEG
int read_jpeg_file(char *f, int *w, int *h, struct screen **image)
{
    FILE *fd;
    int ret;

    /* File Open */
    fd = fopen(f, "rb");
    if(fd == (FILE *)NULL){
        fprintf(stderr, "open %s failed.\n", f);
        return -1;
    }

    /* File Read */
    ret = cont_jpeg(fd, w, h, image);
    if(!ret){
        fclose(fd);
        return -1;
    }
    fclose(fd);

    return 0;
}
#endif /* USE_JPEG */

#ifdef USE_PNG

#define MAGIC_OFFSET 4

int read_png_file(char *f, int *w, int *h, struct screen **image)
{
    FILE *fp;
    char buf[MAGIC_OFFSET];
    int ret;
    int i, y;
    int r, g, b, mc;
    png_structp png_ptr;
    png_infop info_ptr, end_info;
    png_bytep *row_pointers = (png_bytep *)0;
    png_bytep png_image, p;
    int *mgl_image;

    /* File Check */
    fp = fopen(f, "rb");
    if(fp == (FILE *)NULL){
        fprintf(stderr, "open %s failed.\n", f);
        return -1;
    }

    if(fread(buf, 1, MAGIC_OFFSET, fp) != MAGIC_OFFSET){
        fprintf(stderr, "read %s failed.\n", f);
        fclose(fp);
        return -1;
    }

    if(png_sig_cmp(buf, 0, MAGIC_OFFSET)){
        fclose(fp);
        return -1;
    }

    /* memory allocate */
    png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,
                                     (png_voidp)NULL, (png_error_ptr)NULL,
                                     (png_error_ptr)NULL);
    if(!png_ptr){
        fclose(fp);
        return -1;
    }

    info_ptr = png_create_info_struct(png_ptr);
    if(!info_ptr){
        png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
        fclose(fp);
        return -1;
    }

    end_info = png_create_info_struct(png_ptr);
    if(!end_info){
        png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
        fclose(fp);
        return -1;
    }

    /* error handling */
    if(setjmp(png_ptr->jmpbuf)){
        png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
        fclose(fp);
        return -1;
    }

    /* File Pointer Set */
    png_init_io(png_ptr, fp);

    /* File Pointer Offset */
    png_set_sig_bytes(png_ptr, MAGIC_OFFSET);

    /* read the file information */
    png_read_info(png_ptr, info_ptr);

    /* 1, 2, 4bit -> 8bit */
    if(info_ptr->bit_depth < 8){
        png_set_packing(png_ptr);
    }

    /* 8bit with colormap -> 24bit */
    if(info_ptr->color_type == PNG_COLOR_TYPE_PALETTE &&
       info_ptr->bit_depth <= 8){
        /* png_set_palette_to_rgb(png_ptr); */
        png_set_expand(png_ptr);
    }

#if 0
    /* gray -> 8bit */
    if(info_ptr->color_type == PNG_COLOR_TYPE_GRAY &&
       info_ptr->bit_depth < 8){
        /* png_set_gray_1_2_4_to_8(png_ptr); */
        png_set_expand(png_ptr);
    }
#endif

    /* gray -> 24bit */
    if(info_ptr->color_type == PNG_COLOR_TYPE_GRAY ||
       info_ptr->color_type == PNG_COLOR_TYPE_GRAY_ALPHA){
          png_set_gray_to_rgb(png_ptr);
    }

#if 0
    /* ??? */
    if(png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS)){
        /* png_set_tRNS_to_alpha(png_ptr); */
        png_set_expand(png_ptr);
    }

    /* Cut alpha channel */
    if(info_ptr->color_type & PNG_COLOR_MASK_ALPHA){
        /* png_set_invert_alpha(png_ptr); */
        png_set_strip_alpha(png_ptr);
    }
#endif

    /* 16bit -> 8bit/color */
    if(info_ptr->bit_depth == 16){
        png_set_strip_16(png_ptr);
    }

    /* RGB -> RGBA */
#if 0
    if((info_ptr->color_type == PNG_COLOR_TYPE_PALETTE ||
       info_ptr->color_type == PNG_COLOR_TYPE_RGB) &&
       info_ptr->bit_depth <= 8){
        png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);
    }
#endif
    if(info_ptr->pixel_depth != 32){
        png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);
    }

    /* Update info structure */
    png_read_update_info(png_ptr, info_ptr);

    *w  =  (int)info_ptr->width;
    *h  = (int)info_ptr->height;

    png_image = (png_bytep)malloc(info_ptr->rowbytes * info_ptr->height);
    if(!png_image){
        png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
        fclose(fp);
        return -1;
    }

    /* File Read */
    row_pointers = (png_bytep *)malloc(info_ptr->height * sizeof(png_bytep *));
    if(!row_pointers){
        png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
        free(png_image);
        fclose(fp);
        return -1;
    }
    for(i = 0; i < info_ptr->height; ++i){
        row_pointers[i] = png_image + i * info_ptr->rowbytes;
    }

    png_read_image(png_ptr, row_pointers);

    /* Read End */
    png_read_end(png_ptr, end_info);

#if 0
printf("width            [%d]\n", info_ptr->width);
printf("height           [%d]\n", info_ptr->height);
printf("rowbytes         [%d]\n", info_ptr->rowbytes);
printf("bit_depth        [%d]\n", info_ptr->bit_depth);
printf("num_palette      [%d]\n", info_ptr->num_palette);
printf("color_type       [%d]\n", info_ptr->color_type);
printf("compression_type [%d]\n", info_ptr->compression_type);
printf("filter_type      [%d]\n", info_ptr->filter_type);
printf("interlace_type   [%d]\n", info_ptr->interlace_type);
printf("pixel_depth      [%d]\n", info_ptr->pixel_depth);
#endif

    /* File Close */
    fclose(fp);

    /* Clear */
    png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
    free(row_pointers);

    /* mgl2 image */
    *image = create_memscreen(*w, *h, NULL,STK_MIL,0);
    if(!(*image)){
        *image = create_memscreen(*w, *h, NULL,STK_NATIVE,0);
    }
    if(!(*image)){
        free(png_image);
        return -1;
    }

    mgl_image = (int *)malloc(*w * sizeof(int));
    if(!mgl_image){
        free(png_image);
		free_screen(*image);
        return -1;
    }

    push_screen(*image);

    p = png_image;
    for(y = 0 ; y < *h ; y++){
        for(i = 0 ; i < *w ; i++) {
            r = (*p++) & 0xff;
            g = (*p++) & 0xff;
            b = (*p++) & 0xff;
            r >>= 4;
            g >>= 4;
            b >>= 4;
            mgl_image[i] = mc_from_rgb(packRGB(r, g, b)) | COLOR_DITHER;
            *p++;
        }
        put_pixstream(0, y, mgl_image, *w, DIR_NORTH);
    }

    pop_screen();

    /* free the structures */
    free(png_image);
    free(mgl_image);

    return 0;
}
#endif /* USE_PNG */

/* image  : 8bit Gray */
/* bitmap : 2bit Gray */
int read_file(char *f, int *w, int *h, struct screen **image)
{
    int ret = -1;

#if defined (USE_GIF)
    ret = read_gif_file(f, w, h, image);
    if(!ret){
        return(ret);
    }
#endif /* USE_GIF */

#if defined (USE_PNG)
    ret = read_png_file(f, w, h, image);
    if(!ret){
        return(ret);
    }
#endif /* USE_PNG */

#if defined (USE_JPEG)
    ret = read_jpeg_file(f, w, h, image);
    if(!ret){
        return(ret);
    }
#endif /* USE_JPEG */

    return(ret);
}

int img_width;
int img_height;
struct screen *img;
struct screen *img_org;
int off_x,off_y;	/* offset from center */
int canvas_off_x,canvas_off_y;
int canvas_width,canvas_height;

canvas_set(struct screen *st,int x,int y,int xsize,int ysize) {

	if (img) {
		free_screen(img);
		img = NULL;
	}
	img_org = st;
	img_width = st->width;
	img_height = st->height;

	canvas_off_x = x;
	canvas_off_y = y;
	canvas_width = xsize;
	canvas_height = ysize;

	magnitude = INIT_MAG;
	off_x = 0;
	off_y = 0;
        set_color(COLOR_WHITE);
	fill_rect(canvas_off_x,canvas_off_y,canvas_width,canvas_height);
        //clear_screen();
	canvas_show();
}

canvas_change_xy(int dx,int dy) {
	off_x += dx;
	off_y += dy;
	canvas_show();
}

canvas_change_mag(int dmag) {
	int x,y;
	if (dmag == 0) return;
	if (magnitude + dmag < 0) return;
	if (magnitude + dmag > MAX_MAGNITUDE) return;

	if (magnitude != INIT_MAG) {
		if (img) free_screen(img);
		img = NULL;
	}
	x = RMAG(off_x);
	y = RMAG(off_y);
	magnitude += dmag;
	off_x = MAG(x);
	off_y = MAG(y);
	img_width = MAG(img_org->width);
	img_height = MAG(img_org->height);

	if (magnitude == INIT_MAG) {
		if (img) free_screen(img);
		img = NULL;
	} else if (img_width*img_height < MAKE_BITMAP_LIMIT) {
		img = create_memscreen(img_width,img_height,NULL,STK_MIL,0);
		if (!img) {
			img = create_memscreen(img_width,img_height,NULL,STK_NATIVE,0);
		}
		if (img)
		bitblt_conv(img,0,0,img_width,img_height
			,img_org,0,0,img_org->width,img_org->height);
	}
        set_color(COLOR_WHITE);
	fill_rect(canvas_off_x,canvas_off_y,canvas_width,canvas_height);
        //clear_screen();
	canvas_show();
}

canvas_show() {
	int dx,dy,sx,sy;
	int xsize,ysize;
	

	if (img_width <= canvas_width) {
		xsize = img_width;
		dx = (canvas_width - img_width)/2;
		sx = 0;
	} else {
		xsize = canvas_width;
		dx = 0;
		sx = (img_width - canvas_width)/2 + off_x;
		if (sx < 0) {
			sx = 0;
			off_x = -(img_width - canvas_width)/2; 
		}
		if (sx + canvas_width > img_width) {
			sx = img_width - canvas_width;
			off_x = (img_width - canvas_width)/2; 
		}
	}
	if (img_height <= canvas_height) {
		ysize = img_height;
		dy = (canvas_height - img_height)/2;
		sy = 0;
	} else {
		ysize = canvas_height;
		dy = 0;
		sy = (img_height - canvas_height)/2 + off_y;
		if (sy < 0) {
			sy = 0;
			off_y = -(img_height - canvas_height)/2; 
		}
		if (sy + canvas_height > img_height) {
			sy = img_height - canvas_height;
			off_y = (img_height - canvas_height)/2; 
		}
	}
	if (magnitude == INIT_MAG) {
		bitblt(NULL,canvas_off_x+dx,canvas_off_y+dy
			,img_org,sx,sy,xsize,ysize,0);
	} else if (img) {
		bitblt(NULL,canvas_off_x+dx,canvas_off_y+dy
			,img,sx,sy,xsize,ysize,0);
	} else {
		bitblt_conv(NULL,canvas_off_x+dx,canvas_off_y+dy,xsize,ysize
			,img_org,RMAG(sx),RMAG(sy),RMAG(xsize),RMAG(ysize));
	}
}

#ifdef USE_JPEG
#include <setjmp.h>

struct return_error_mgr{
  struct jpeg_error_mgr pub;
  jmp_buf setjmp_buffer;
};

typedef struct return_error_mgr * return_error_ptr;

void error_return (j_common_ptr cinfo)
{
  /* cinfo->err really points to a return_error_mgr struct, so coerce pointer */
  return_error_ptr returnerr = (return_error_ptr) cinfo->err;

  /* Always display the message. */
  /* We could postpone this until after returning, if we chose. */
  (*cinfo->err->output_message) (cinfo);

  /* Return control to the setjmp point */
  longjmp(returnerr->setjmp_buffer, 1);
}

int cont_jpeg(FILE *fd, int *w, int *h, struct screen **image)
{
    JSAMPROW buffer[1];
    int row_stride;
    struct jpeg_decompress_struct cinfo;
    struct return_error_mgr jerr;
    JSAMPLE *jpeg_image,*p;
    int *mgl_image;
    int  pl,width,height;
    int i,y;

    cinfo.err = jpeg_std_error(&jerr.pub);
#if 1
    cinfo.err->error_exit = error_return;

    if(setjmp(jerr.setjmp_buffer)){
       jpeg_destroy_decompress(&cinfo);
       return 0;
    }
#endif

    jpeg_create_decompress(&cinfo);

    jpeg_stdio_src(&cinfo, fd);

    /* header read */
    jpeg_read_header(&cinfo, TRUE);

#if DEBUG
    /* Width and height of image */
    printf("image_width     [%d]\n",cinfo.image_width);
    printf("image_height    [%d]\n",cinfo.image_height);
    /* Number of color components */
    printf("num_components  [%d]\n",cinfo.num_components);
    /* Colorspace of image */
    printf("jpeg_color_space[%d]\n",cinfo.jpeg_color_space);
#endif

    cinfo.out_color_space = JCS_RGB;
    cinfo.dither_mode = JDITHER_NONE;
    cinfo.quantize_colors = FALSE;

    jpeg_calc_output_dimensions(&cinfo);

#if DEBUG
    /* Actual dimensions of output image. */
    printf("output_width        [%d]\n",cinfo.output_width);
    printf("output_height       [%d]\n",cinfo.output_height);
    /* Number of color components in out_color_space. */
    printf("out_color_components[%d]\n",cinfo.out_color_components);
    /* Number of color components returned. */
    printf("output_components   [%d]\n",cinfo.output_components);
    /* Recommended height of scanline buffer. */
    printf("rec_outbuf_height   [%d]\n",cinfo.rec_outbuf_height);
#endif

    row_stride = cinfo.output_width * cinfo.output_components;

    *w  = width =  (int)cinfo.output_width;
    *h  = height = (int)cinfo.output_height;
    pl  = (int)cinfo.output_components;
    *image = create_memscreen(width, height, NULL,STK_MIL,0);
    if (!image) {
        *image = create_memscreen(width, height, NULL,STK_NATIVE,0);
    }

    mgl_image = (int *)malloc(width * sizeof(int));
    jpeg_image = (JSAMPLE *)malloc(width * pl);

    if(!jpeg_image || !(*image) || !mgl_image) {
//printf("%x %x %x\n",jpeg_image,mgl_image,*image);
        perror("malloc");
        /* End */
        jpeg_finish_decompress(&cinfo);
        jpeg_destroy_decompress(&cinfo);

	if (*image) {
		free_screen(*image);
	}
	if (mgl_image) {
		free(mgl_image);
	}
        return 0;
    }

    /* Start decompressor */
    jpeg_start_decompress(&cinfo);

    buffer[0] = (JSAMPROW) jpeg_image;
    push_screen(*image);
    y = 0;
    while(cinfo.output_scanline < cinfo.output_height) {
	jpeg_read_scanlines(&cinfo, buffer, (JDIMENSION)1);
	{
		int r,g,b,mc;
		p = jpeg_image;
		for (i=0; i< width; i++) {
			r = (*p++) & 0xff;
			g = (*p++) & 0xff;
			b = (*p++) & 0xff;
			r >>= 4;
			g >>= 4;
			b >>= 4;
			mgl_image[i] = mc_from_rgb(packRGB(r,g,b)) | COLOR_DITHER;
		}
	}
	put_pixstream(0,y++,mgl_image,width,DIR_NORTH);
    }
    pop_screen();

    /* End */
    jpeg_finish_decompress(&cinfo);
    jpeg_destroy_decompress(&cinfo);

    free(jpeg_image);
    return 1;
}
#endif /* USE_JPEG */

/*
̾

dst ΰ׻ߤդƸͤ­

   +----------+----------+----------+
   |          |          |          |
   |      +-------------------+     |
   |      | 1 |    4     | 7  |     |
   +------|---+----------+----|-----+
   |      |   |          |    |     |
   |      | 2 |    5     | 8  |     |
   |      |   |          |    |     |
   +------|---+----------+----|-----+
   |      | 3 |    6     | 9  |     |
   |      +-------------------+     |
   |          |          |          |
   +----------+----------+----------+

֤̯ʳ̾Ǥ⤦ޤưȻפ
ǥդβϡǥ礷ƤޤΤǡ
 screen  FULLCOLOR ˤ褤

   +----------+----------+----------+
   |  +--+    |          |          |
   |  |10|    |          |          |
   |  +--+    |  +-----+ |          |
   +----------+--|-----|-+----------+
   |          |  |     | |          |
   |          |  +-----+ |          |
   |          |          |          |
   +----------+----------+----------+
   |      +-----+        |          |
   |      |   | |        |          |
   |      +-----+        |          |
   +----------+----------+----------+

ΥϡޤưʤΤǡ( 10 ν)

ʤߤˡhue ϡ̯ʷ׻򤷤Ƥʤ


------------

ꥸʥϡΤ褦ʹ¤򤷤Ƥơ
ʤ˺٤ǤȤ褦˥塼˥󥰤Ƥߤ

   each (y) {
     each (x) {
	 get_pixel()  (岼˽Ťʤ꤬)

         push_screen()
         put_pixel(x,y)
         pop_screen()
     }
   }
       
̾ convert (570,398) -> (402,281) -   9.06/(dot)
 convert (570,398) -> (805,562) -   7.61/(dot)


OPT1

ޤx  x+1 ǤνŤʤʬŬ
(7)(8)(9) η׻ΤȤ˼ (1)(2)(3) ĤǤˤˡ


### convert (570,398) -> (402,281) -   7.51/(dot)
### convert (570,398) -> (805,562) -   6.35/(dot)

ǰʤ龯᤯ʤʤ

OPT2

1 dot  push_screen/pop_screen ǡput_pixel ƤΤǡ
put_pixstream ǰ쵤˽񤯤Ȥˤ

### convert (570,398) -> (402,281) -   5.06/(dot)
### convert (570,398) -> (805,562) -   3.91/(dot)

֤᤯ʤäꥸʥ ܤˤϤʤäƤʤ
⤦᤯Ȥ

OPT3

ˡget_pixel Ŭ뤳Ȥˤ
Ϥϡ1 line ǤϺѤޤʤΤǡ2 Υå뤳Ȥˤ
(y  3dot 餤ɬ)

### convert (570,398) -> (402,281) -   2.33/(dot)
### convert (570,398) -> (805,562) -   2.00/(dot)

®줿3 ʾ᤯ʤäƤ롣

*/

#define LINE_CACHE_OUT_SIZE   1024
#define LINE_CACHE_IN_SIZE    4096
#define LINE_CACHE_IN_MAXYS   16

#define OPT1
#define OPT2
#define OPT3


#define SCALE 16
#define MASK 0xf
#define SHFT 4

extern struct screen *current_screen;
extern long long millitime();

#ifdef OPT3
#define c_get_pixel(x,y)	((in_lc_miny <= y) && (y <= in_lc_maxy))\
					?in_lc[y - in_lc_miny][x]\
					:get_pixel(x,y,0)
#else
#define c_get_pixel(x,y)	get_pixel(x,y,0)
#endif
int bitblt_conv(struct screen *dst,int dx,int dy,int dxs,int dys
		,struct screen *src,int sx,int sy,int sxs,int sys) {
	struct screen *new,*org;
	int h,w;
	int x,y;
	int c,i,j;
	int xx0,yy0;
	int xx1,yy1;
	int x0,y0;
	int x1,y1;
	int dx0,dy0;
	int dx1,dy1;
	int hue,sat,bri;
	int o_hue,o_sat,o_bri;
	int area;
	int t_bri,t_sat;
	int t_area;
	int xc,yc;
	long long s_time,e_time;
#ifdef OPT1
	int mod_area = 0;
	int m_area;
	int mod_bri;
	int mod_sat;
#endif
#ifdef OPT2
	int out_lc[LINE_CACHE_OUT_SIZE];
	int out_lc_on = 0;
#endif
#ifdef OPT3
	int in_lc_buf[LINE_CACHE_IN_SIZE];
	int *in_lc[LINE_CACHE_IN_MAXYS];
	int *tmp,n;
	int in_lc_ys = 0;
	int in_lc_miny = -1;
	int in_lc_maxy = -1;
#endif

	if (dst == NULL) dst= current_screen;
	if (src == NULL) src= current_screen;

	new = create_subscreen(dst,dx,dy,dxs,dys);
	org = create_subscreen(src,sx,sy,sxs,sys);

	if (!org || !new) {
		if (new) free_screen(new);
		if (org) free_screen(org);
		return;
	}
	w = new->width;
	h = new->height;
#ifdef OPT2
	if (w < LINE_CACHE_OUT_SIZE) {
		out_lc_on = 1;
	}
#endif
#ifdef OPT3
	in_lc_ys = LINE_CACHE_IN_SIZE / org->width;
	if (in_lc_ys > LINE_CACHE_IN_MAXYS)
		in_lc_ys = LINE_CACHE_IN_MAXYS;
	for (i=0; i< in_lc_ys; i++) {
		in_lc[i] = &in_lc_buf[i * org->width];
	}
#endif
	push_screen(org);

	s_time = millitime();
	for (y = 0; y < h; y++) {
	    yy0 = (y * org->height * SCALE)/h;
	    yy1 = ((y+1) * org->height * SCALE)/h;
	    y0 = yy0 >> SHFT;
	    y1 = yy1 >> SHFT;
	    dy0 = yy0 & MASK;
	    dy1 = yy1 & MASK;

#ifdef OPT3
	    if (in_lc_ys) {
		n = (y1 - y0 + 1);
		if (n > in_lc_ys)
			n = in_lc_ys;
		
		for (i=0; i<n; i++) {
		    if ((in_lc_miny <= (y0+i)) && ((y0+i) <= in_lc_maxy)) {
			j = (y0+i) - in_lc_miny;
			tmp = in_lc[i];
			in_lc[i] = in_lc[j];
			in_lc[j] = tmp;
		    } else if (y0+i < org->height) {
			get_pixstream(0,y0+i,in_lc[i],org->width,DIR_NORTH,0);
		    }
		}
		in_lc_miny = y0;
		in_lc_maxy = y0 + n - 1;
	    }
#endif
	    for (x=0; x < w; x++) {
		xx0 = (x * org->width * SCALE)/w;
		xx1 = ((x+1) * org->width * SCALE)/w;
		x0 = xx0 >> SHFT;
		x1 = xx1 >> SHFT;
		dx0 = xx0 & MASK;
		dx1 = xx1 & MASK;
		t_bri = t_area = t_sat = 0;

		if (dx0) {
#ifdef OPT1
		    if ((x != 0) && mod_area) {
			t_bri += mod_bri;
			t_sat += mod_sat;
			t_area += mod_area;
		    } else
#endif
		    {
			/* 1 */
			if (dy0) {
				c = c_get_pixel(x0,y0);
				unpackMC(c,hue,sat,bri);
				area = (SCALE-dx0)*(SCALE-dy0);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			   }
			/* 2 */
			for (i=y0+1; i < y1; i++) {
				c = c_get_pixel(x0,i);
				unpackMC(c,hue,sat,bri);
				area = (SCALE-dx0)*(SCALE);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			}
			/* 3 */
			if (dy1) {
				c = c_get_pixel(x0,y1);
				unpackMC(c,hue,sat,bri);
				area = (SCALE-dx0)*(dy1);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			}
		    }
		}
		if (dy0) {
			/* 4 */
			for (i=x0+1; i < x1; i++) {
				c = c_get_pixel(i,y0);
				unpackMC(c,hue,sat,bri);
				area = (SCALE)*(SCALE-dy0);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			}
		}
		/* 5 */
		for (i=y0+1; i < y1; i++) {
			for (j=x0+1; j < x1; j++) {
				c = c_get_pixel(j,i);
				unpackMC(c,hue,sat,bri);
				area = (SCALE)*(SCALE);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			}
		}
		if (dy1) {
			/* 6 */
			for (i=x0+1; i < x1; i++) {
				c = c_get_pixel(i,y1);
				unpackMC(c,hue,sat,bri);
				area = (SCALE)*(dy1);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
			}
		}
#ifdef OPT1
		mod_area = mod_bri = mod_sat = 0;
#endif
		if (dx1) {
			/* 7 */
			if (dy0) {
				c = c_get_pixel(x1,y0);
				unpackMC(c,hue,sat,bri);
				area = (dx1)*(SCALE-dy0);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
#ifdef OPT1
				m_area = (SCALE-dx1)*(SCALE-dy0);
				mod_bri += bri * m_area;
				mod_sat += sat * m_area;
				mod_area += m_area;
#endif
			}
			/* 8 */
			for (i=y0+1; i < y1; i++) {
				c = c_get_pixel(x1,i);
				unpackMC(c,hue,sat,bri);
				area = (dx1)*(SCALE);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
				m_area = (SCALE-dx1)*(SCALE);
				mod_bri += bri * m_area;
				mod_sat += sat * m_area;
				mod_area += m_area;
			}
			/* 9 */
			if (dy1) {
				c = c_get_pixel(x1,y1);
				unpackMC(c,hue,sat,bri);
				area = (dx1)*(dy1);
				t_bri += bri * area;
				t_sat += sat * area;
				t_area += area;
				m_area = (SCALE-dx1)*(dy1);
				mod_bri += bri * m_area;
				mod_sat += sat * m_area;
				mod_area += m_area;
			}
		}
		/* 10 */
		if (t_area == 0) {
			c = c_get_pixel(x0,y0);
			unpackMC(c,hue,sat,bri);
			area = (SCALE)*(SCALE);
			t_bri += bri * area;
			t_sat += sat * area;
			t_area += area;
		}
		o_bri = (t_bri + SCALE/2)/ t_area;
		o_sat = (t_sat + SCALE/2)/ t_area;
		xc = (xx0+xx1)>>(SHFT+1);
		yc = (yy0+yy1)>>(SHFT+1);
		c = c_get_pixel(xc,yc);
		unpackMC(c,hue,sat,bri);
		o_hue = hue;

#ifdef OPT2
		if (out_lc_on) {
			out_lc[x] = c;
		} else 
#endif
		{
		    push_screen(new);
		    put_pixel(x,y,c);
		    pop_screen();
		}
	    }
#ifdef OPT2
	    if (out_lc_on) {
		push_screen(new);
		put_pixstream(0,y,out_lc,w,DIR_NORTH);
		pop_screen();
	    }
#endif
	}
	e_time = millitime();
#if 0
	printf("### convert (%d,%d) -> (%d,%d) - %d dots/sec\n"
		,org->width,org->height
		,w,h
		,(int)((double)(w*h)*1000.0/(e_time - s_time))   );
#endif

	pop_screen();

	free_screen(new);
	free_screen(org);
}
