/*
 * MGTERM -- Terminal Emulator for MobileGear -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef MGL1
char *icon_mgterm="\
#MGR000200160016
+.............++
...............+
...*********...+
..*VVVVVVVVV*..+
..*VjjVVVjjV*..+
..*VjVjVjVjV*..+
..*VjVVjVVjV*..+
..*VjVVVVVjV*..+
..*VVVVVVVVV*..+
.*************.+
.*8.8.8.8.8.8*.+
.*.8.8.8.8.8.*.+
.*************.+
...............+
+.............++
++++++++++++++++
";
#endif

#ifndef MGL1
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#if defined (__linux__)
#  include <termio.h>
#else
#  include <termios.h>
#endif
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <utmp.h>

#if defined(USE_PTMX) && ! defined(__CYGWIN__) 
#include <sys/resource.h>
#include <sys/stropts.h>
#endif

#if ! defined (__linux__) && ! defined(__CYGWIN__)
#include <ttyent.h>
#endif

#include <grp.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/time.h>
#ifndef MGL1
#include "mgl2.h"
#else
#include "mgl.h"
#define mgl_getenv	getenv
char mgl_display[]="MGL";
#endif

#ifdef GET_KEY_IM
#define GET_KEY	get_key_im
#else
#define GET_KEY get_key
#endif

extern void     VtInit(void);
extern void     VtStart(int reverse);
extern void     VtEmu(const char*, int nchars);

void child();
void mod_init();
int  mod_in();
void terminal_in();
void terminal_out();

int inherit_tty = 1;

int ptyfd = -1;
int ttyfd = -1;
char orgttyname[64];
char myttyname[64];
struct termios ttysave;
int ttyf=0;

int childid;
int font_size=12;
int whole_screen = 0;
int reverse_mode = 0;
int screen_width;
int screen_height;
int exit_req = 0;
struct utmp wtmp;
int ttid;
struct group *ttgrp;

char *org_tty,*my_tty;

struct textscreen *ts;

char *cmdline;

char font_args[64];
int font_size_list[10];
int font_size_num;
int cur_font_size;

void send_hangup(close) {
	if (childid) kill(childid,SIGHUP);
}

void sigchld(sig) int sig; {
	int st;
	int ret;
	ret = wait(&st);
	if (ret == childid || ret == ECHILD) {
		exit_req = 1;
	} else {
		signal(SIGCHLD,sigchld);
	}
}

void mgt_cleanup() {
	int fd;
printf("mgt_cleanup pid = %d\n",getpid());
    if (geteuid() == 0) {
printf("close utmp\n");
#if defined(__linux__)
	wtmp.ut_type = DEAD_PROCESS;
	memset(wtmp.ut_line,0,UT_LINESIZE);
	wtmp.ut_time = 0;
	memset(wtmp.ut_host,0,UT_HOSTSIZE);
	memset(wtmp.ut_name,0,UT_NAMESIZE);
	setutent();
	pututline(&wtmp);
	endutent();
#endif
#if defined(__FreeBSD__) || defined(__NetBSD__)
	if (ttid > 0) {
	    memset(wtmp.ut_line,0,UT_LINESIZE);
	    wtmp.ut_time = 0;
	    memset(wtmp.ut_host,0,UT_HOSTSIZE);
	    memset(wtmp.ut_name,0,UT_NAMESIZE);

	    if ((fd = open(_PATH_UTMP, O_WRONLY|O_CREAT, 0644)) >= 0) {
               	lseek(fd, (off_t)(ttid*sizeof(struct utmp)), SEEK_SET);
               	write(fd, &wtmp, sizeof(struct utmp));
               	close(fd);
	    }
	}
#endif
    }
#ifndef __CYGWIN__
    chmod(myttyname,0666);
#endif
    close_graph();
}

int font_width;
int font_height;

int main(argc,argv) char **argv; {
	int c,i,ret;
	char buf[256];
	extern char *optarg;
	int cols,lines;
	int x,y,xs,ys,outocr;
	int soft_key = 0;
	struct virtual_key *vk;

	while ((c = getopt(argc,argv,"iwf:ms:e:o:r"))!=EOF) {
		switch(c) {
		case 'i': inherit_tty = 0;
			break;
		case 'w':
			whole_screen = 1; 
			SCREEN_WIDTH = 640;
			break;
		case 'f':
			strncpy(font_args,optarg,63);
			break;
#ifndef MGL1
		case 's':	/* soft key option */
			if (sscanf(optarg,"%d",&soft_key) != 1) {
				soft_key = 0;
			}
			break;
		case 'm':
			mgl_apli_type = AT_MINIAPLI;
			break;
#endif
		case 'e':
			cmdline = optarg;
			break;
		case 'o':	/* other option (for debug)*/
			if (!strcmp("cga",optarg)) {
				SCREEN_HEIGHT = 200;
			}
			break;
		case 'r':	/* reverse video */
			reverse_mode = 1;
			break;
		}
	}

	if (0 /*inherit_tty*/) {
		ret = tcgetattr(0, &ttysave);
		if (ret == 0) {
			ttysave.c_iflag |= INLCR | ICRNL;
			ttysave.c_lflag |= ICANON | ECHO;
			ttyf = 1;
		}
	}
	if (!open_graph()) {
		fprintf(stderr, "Cannot initialize mgl\n");
		exit(1);
	}
	if (font_args[0]) {
		set_font_list(font_args);
	}
#ifndef MGL1
	mgl_set_keysym("switch_window",MK_F9);
	mgl_set_keysym("switch_focus",MK_F10);
#endif
	atexit(mgt_cleanup);
#ifdef USE_EXTRANSLATED
	mgl_set_keymode(MGL_SK_EXTRANSLATED);
#endif
#ifndef MGL1
	if ((SCREEN_WIDTH!=640) || (SCREEN_HEIGHT < 200-16)  || mgl_client) {
		whole_screen = 1; 
	}
#endif
	screen_width = SCREEN_WIDTH;
	screen_height = SCREEN_HEIGHT;
	if (!whole_screen) {
		screen_width -= 160;
	}
#ifndef MGL1
	if (soft_key) {
		im_impart_point(0,screen_height-soft_key,1);
		im_impart_point(screen_width-1,screen_height-1,0);
		screen_height -= soft_key;
	}
	set_icon(icon_mgterm,"mgterm");
#endif
#ifdef USE_PTMX
	ptyfd = open("/dev/ptmx", 2);
	if (ptyfd >= 0) {
		if (grantpt(ptyfd) != 0 || unlockpt(ptyfd) != 0) {
			close(ptyfd);
			ptyfd = -1;
		}
	}
	if (ptyfd >= 0) {
		char *p;
		extern char *ptsname(int);
		p = ptsname(ptyfd);
		if (p) {
			strcpy(myttyname,p);
			ttyfd = open(myttyname,2);
			if (ttyfd >= 0) {
#ifdef I_PUSH
				/* push STREAMS modules */
				ioctl(ttyfd, I_PUSH, "ptem");
				ioctl(ttyfd, I_PUSH, "ldterm");
				ioctl(ttyfd, I_PUSH, "ttcompat");
#endif
			} else {
				close(ptyfd);
				ptyfd = -1;
			}
		}
	} else {
		perror("open ptmx");
	}
#else
	for (i=0; i<32; i++) {
		sprintf(buf,"/dev/pty%c%x",'p'+i/16,i%16);
		ptyfd = open(buf,2);
		if (ptyfd >= 0) {
			sprintf(myttyname,"/dev/tty%c%x",'p'+i/16,i%16);
			ttyfd = open(myttyname,2);
			if (ttyfd >= 0) break;
			close(ptyfd);
			ptyfd = -1;
		}
	}
#endif
	if (ttyfd < 0) exit(1);

	set_color(COLOR_WHITE);
	clear_screen();
	if (font_size_num == 0) {
		font_size = 12;
		font_size_list[font_size_num++] = font_size;
	} else {
		cur_font_size = 0;
		font_size = font_size_list[0];
	}

	set_font(font_size,0);
	font_width = get_font_width()/2;
	font_height = get_font_height();
#ifndef MGL1
	if (mgl_apli_type == AT_MINIAPLI) {
		screen_width-=8;
		screen_height-=8;
		x = 4;
		y = 4;
	} else {
		x = 0;
		y = 0;
	}
#else
	x = 0;
	y = 0;
#endif
	cols = screen_width/font_width;
	lines = screen_height/font_height;
	xs = cols*font_width;
	ys = lines*font_height;

	ts = create_textscreen(NULL,x,y,xs,ys,0);
#ifndef MGL1
	if (mgl_apli_type == AT_MINIAPLI) {
		set_color(COLOR_DARKGRAY);
		draw_rect(2,2,SCREEN_WIDTH-4,SCREEN_HEIGHT-4);
	}
#endif
	ts_clear(ts);
	vk = create_virtual_key3(0, 0, xs, ys, MK_V1, MK_V0, MK_V2);
	if (vk) vk_attach(NULL, vk);

	child();
	VtInit();
	VtStart(reverse_mode);
	if (!whole_screen)
		mod_init();
	outocr = 0;
	for (;;) {
		fd_set fds;
		int max = 0;

		if (exit_req) {
			exit(0);
		}
		FD_ZERO(&fds);
		FD_SET(0,&fds);
		FD_SET(ptyfd,&fds);
		if (ptyfd > max) max = ptyfd;
		ret = key_select(max+1,&fds,1000);
		if (ret < 0) continue;
		if ((ret > 0) && FD_ISSET(ptyfd,&fds)) {
			terminal_out();
			if (outocr < 128) {
				outocr ++;
				continue;
			}
		}
		outocr = 0;
		if ((ret > 0) && FD_ISSET(0, &fds)) {
		    while ((c = GET_KEY(0)) >= 0) {
#ifdef MGL_SKM_NOTICE
			if (c & MGL_SKM_NOTICE)
				continue;
			c &= ~MGL_SKM_MASK;
#endif
			if (!whole_screen) {
				if (mod_in(c) == 0)
					terminal_in(c);
			} else {
				terminal_in(c);
			}
		    }
		}
		if (ret == 0) {
			if (!whole_screen)
				mod_in(-1);
		}
	}
	clear_screen();
}

extern char *strrchr();
extern char *getenv();

#ifdef USE_SPAWN
#ifndef HAS_SPAWN
static int spawnv(char *path, char *argv[]) {
	int pid;

	pid = fork();
	if (pid == 0) {
		execv(path,argv);
		exit(0);
	}
	return pid;
}
#endif
#endif

void child() {
	int i;
	char shell[128];
	char *shell_name;
	int fd;
	struct ttyent *ttyp;
	char *args[1024];
	char **ap = args;

	fflush(stdout);
	setpgid(0,0);

	if (geteuid() == 0) {
	    extern char mgl_display[];

#if defined(__linux__)
	    wtmp.ut_type = USER_PROCESS;
	    wtmp.ut_pid = getpid();
	    strcpy(wtmp.ut_line,myttyname+strlen("/dev/"));
	    if (!strncmp(myttyname,"/dev/pts/",8)) {
		int x = 0;
		sscanf(myttyname+8,"%d",&x);
		sprintf(wtmp.ut_id,"vt%02x", x & 0xff);
	    } else {
	        strcpy(wtmp.ut_id,myttyname+strlen("/dev/tty"));
	    }
	    time(&wtmp.ut_time);
	    memset(wtmp.ut_host,0,UT_HOSTSIZE);
	    strncpy(wtmp.ut_host,mgl_display,UT_HOSTSIZE);
	    strcpy(wtmp.ut_user, getpwuid(getuid())->pw_name);
	    wtmp.ut_addr = 0;
	    setutent();
	    pututline(&wtmp);
	    endutent();
#endif
#if defined(__FreeBSD__) || defined(__NetBSD__)
	    strcpy(wtmp.ut_line,myttyname+strlen("/dev/"));
	    time(&wtmp.ut_time);
	    memset(wtmp.ut_host,0,UT_HOSTSIZE);
	    strncpy(wtmp.ut_host,mgl_display,UT_HOSTSIZE);
	    strcpy(wtmp.ut_name, getpwuid(getuid())->pw_name);

	    setttyent();
	    ttid = 1;
	    while ((ttyp = getttyent()) != NULL) {
		if (!strcmp(ttyp->ty_name,wtmp.ut_line)) {
			break;
		}
		ttid++;
	    }
	    endttyent();
	    if ((ttid > 0) && 
		((fd = open(_PATH_UTMP, O_WRONLY|O_CREAT, 0644)) >= 0)) {
               	    lseek(fd, (off_t)(ttid*sizeof(struct utmp)), SEEK_SET);
                    write(fd, &wtmp, sizeof(struct utmp));
                    close(fd);
	    }
#endif
	}
#ifdef USE_SPAWN
{

	setenv("TERM","mgterm",1);
	dup2(ttyfd,0);
	dup2(ttyfd,1);
	dup2(ttyfd,2);
	if (getenv("SHELL")) {
	    strcpy(shell,getenv("SHELL"));
	} else {
	    strcpy(shell,"/bin/sh");
	}
	shell_name = shell;
	if (shell[0] == '/') {
	    shell_name = strrchr(shell,'/') + 1;
	}
	*ap++ = shell_name;
	if (cmdline) {
		*ap++ = "-c";
		*ap++ = cmdline;
	}
	*ap++ = NULL;

	childid = spawnv(shell,args);
	signal(SIGCHLD,sigchld);
}
#else
	if ((childid = fork())) {
	    signal(SIGCHLD,sigchld);
	    return;
	}
#ifndef MGL1
	mgl_ignore_auto_close();
#endif
	for (i=0; i<NSIG; i++) {
		signal(i,SIG_DFL);
	}
	setenv("TERM","mgterm",1);

	ttyfd = open(myttyname,2);
	if (ttyfd < 0) exit(3);
	close(ptyfd);

	/* same as login_tty(3) */
	setsid();
#ifndef __CYGWIN__
	ioctl(ttyfd, TIOCSCTTY, (char *)0);
#endif
	dup2(ttyfd,0);
	dup2(ttyfd,1);
	dup2(ttyfd,2);
	if (ttyfd > 2)
		close(ttyfd);
	/* end same */
#ifndef __CYGWIN__
	setgrent();
#endif
	if (ttyf) tcsetattr(0, TCSANOW, &ttysave);
#ifndef __CYGWIN__
	while ((ttgrp = getgrent()) != NULL) {
		if (!strcmp(ttgrp->gr_name,"tty")) break;
	}
	endgrent();
	if (ttgrp) {
		chown(myttyname,getuid(),ttgrp->gr_gid);
	} else {
		chown(myttyname,getuid(),0);
	}
	chmod(myttyname,0620);
	setegid(getgid());
	seteuid(getuid());
#endif

	if (getenv("SHELL")) {
		strcpy(shell,getenv("SHELL"));
	} else {
		strcpy(shell,"/bin/sh");
	}
	shell_name = shell;
	if (shell[0] == '/') {
		shell_name = strrchr(shell,'/') + 1;
	}
	*ap++ = shell_name;
	if (cmdline) {
		*ap++ = "-c";
		*ap++ = cmdline;
	}
	*ap++ = NULL;
	execv(shell,args);
	exit(1);
#endif
}

extern int mdate();

int (*mod_func[30])();
void *mod_fd[30];
int mod_c = 0;
int mod_sel;

#ifdef APP_DYNAMIC
void loadapp(name) char *name; {
	extern void *dlopen(),*dlsym();
	int i;
	char path[256];
	char sym[256];

	if (strchr(name,'/')) {
		fprintf(stderr,"security checked: -- mgtapp %s\n",name);
		return;
	}
	strcpy(path,MGLDIR);
	strcat(path,"/");
	strcat(path,name);
	strcat(path,".so");
	sym[0] = 0;
#if defined(SYM_PREFIX)
	strcat(sym,"_");
#endif
	strcat(sym,name);
#if 0
printf("loading %s\n",path);
#endif

	for (i=0; i<30; i++) {
		if (!mod_func[i]) {
			mod_fd[i] = dlopen(path,0);
			if (mod_fd[i]) {
				mod_func[i] = dlsym(mod_fd[i],sym);
				if (!mod_func[i]) {
					dlclose(mod_fd[i]);
					mod_fd[i] = NULL;
				}
			}
			break;
		}
	}
}
#endif

void loadapps() {
#ifdef APP_DYNAMIC
	extern char *getenv();
	char name[256],*p,*q;

	p = mgl_getenv("MGTAPP");
	if (!p) return;

	while (*p) {
		q = name;
		while (*p == ':') p++;
		while (*p && *p != ':' ) {
			*q++ = *p++;
		}
		*q = 0;
		loadapp(name);
	}
#endif
}

void mod_init() {
	mod_func[0] = mdate;
	loadapps();
	mod_func[mod_c](-2);
	refresh();
}


int mod_in(c) {
	if (c == MK_F9) {
		if (mod_sel) mod_func[mod_c](-4);
		mod_c++;
		if ((mod_c >= 30) || !mod_func[mod_c]) mod_c = 0;
		mod_func[mod_c](-2);
		if (mod_sel) mod_func[mod_c](-3);
		refresh();
		return 1;
	}
	if (c == MK_F10) {
		if (mod_sel) mod_func[mod_c](-4);
		mod_sel = (mod_sel+1) % 2;
		if (mod_sel) mod_func[mod_c](-3);
		refresh();
		return 1;
	}
	if (c == -1 || mod_sel) {
		mod_func[mod_c](c);
		refresh();
		return 1;
	}
	return 0;
}

void terminal_in(c) {
	extern int send_mouse;

	if (c < MK_F1) {
		write(ptyfd, &c, 1);
	} else {
		char *buf = NULL;
		char mouse[10];
		switch(c) {
		case MK_F1: buf = "\033[M"; break;
		case MK_F2: buf = "\033[N"; break;
		case MK_F3: buf = "\033[O"; break;
		case MK_F4: buf = "\033[P"; break;
		case MK_F5: buf = "\033[Q"; break;
		case MK_F6: buf = "\033[R"; break;
		case MK_F7: buf = "\033[S"; break;
		case MK_F8: 
			if (font_size_num > 1) {
				change_font(); 
				return;
			} else {
				buf = "\033[T";
			}
			break;
		case MK_F9: buf = "\033[U"; break;
		case MK_F10: buf = "\033[V"; break;
		case MK_F11: buf = "\033[W"; break;
		case MK_F12: buf = "\033[X"; break;
		case MK_UP: buf = "\033[A"; break;
		case MK_DOWN: buf = "\033[B"; break;
		case MK_LEFT: buf = "\033[D"; break;
		case MK_RIGHT: buf = "\033[C"; break;
		case MK_HOME: buf = "\033[H"; break;
		case MK_END: buf = "\033[F"; break;
		case MK_PAGE_UP: buf = "\033[I"; break;
		case MK_PAGE_DOWN: buf = "\033[G"; break;
		case MK_INS: buf = "\033[E"; break;
		case MK_DEL: buf = "\033[L"; break;
		case MK_V1:
			if (send_mouse) {
			    sprintf(mouse,"\033[M%c%c%c"
				,' ' 
				,' ' + vk_x/font_width + 1
				,' ' + vk_y/font_height + 1);
			    buf = mouse;
			}
			break;
		case MK_V2:
			if (send_mouse) {
			    sprintf(mouse,"\033[M%c%c%c"
				,'#' 
				,' ' + vk_x/font_width + 1
				,' ' + vk_y/font_height + 1);
			     buf = mouse;
			}
			break;
		}
		if(buf){
			write(ptyfd,buf,strlen(buf));
		}
	}
}

char obuf[256];
int obuf_len;
void terminal_out() {
	int ret,i;
	int k=0,b=0;

	ret = read(ptyfd,obuf+obuf_len,255-obuf_len);
	obuf_len += ret;
	for (i=0; i<obuf_len; i++) {
		if (obuf[i] & 0x80) k = !k;
	}
	if (k) {
		b = obuf[obuf_len-1];
		obuf_len--;
	}
	obuf[obuf_len] = 0;
	VtEmu(obuf,obuf_len);
refresh();
	if (k) {
		obuf[0] = b;
		obuf_len = 1;
	} else {
		obuf_len = 0;
	}
	
}

set_font_list(char *arg) {
	int i,fs,fw;
	char font_file[32];
	char *p;
	i = 0;
	while ((p = strchr(arg,',')) || arg[0]) {
		if (p) *p = 0;
		if (sscanf(arg,"%dx%d",&fw,&fs) == 2) {
		    if (fs != 10 && fs != 16 && fs != 24) {
			sprintf(font_file,"k%dx%d.fnt",fw,fs);
			if (load_font(font_file,fw,fs)) {
				font_size_list[font_size_num++] = fs;
			} else {
				printf("can't load %s\n",font_file);
			}
		    }
		} else if (sscanf(arg,"%d",&fs) == 1) {
			switch(fs) {
			case 12: 
			case 16: 
			case 24: 
				font_size_list[font_size_num++] = fs;
				break;
			case 10:
				if (load_font("k12x10.fnt",12,10)) {
					font_size_list[font_size_num++] = fs;
				} else {
					printf("can't load k12x10.fnt\n");
				}
				break;
			case 8:
				if (load_font("k10x8.fnt",10,8)) {
					font_size_list[font_size_num++] = fs;
				} else {
					printf("can't load k10x8.fnt\n");
				}
				break;
			}
		}
		if (font_size_num > 5) break;
		if (!p) break;
		arg = p+1;
	}
}

change_font() {
	cur_font_size++;
	if (cur_font_size >= font_size_num) cur_font_size = 0;
printf("change font size to %d\n",font_size_list[cur_font_size]);
	VtChangeFont( font_size_list[cur_font_size]);
}
