#!/bin/sh

FILE_CAP=/usr/share/misc/termcap
FILE_INFO=/usr/share/terminfo
MGTERM=mgterm.cap

if [ "x$1" != "x" ] ; then
	MGTERM=$1;
fi

if [ -f $MGTERM ]; then
	echo installing mgterm.cap
else
	echo usage .. instcap.sh mgterm-capfile
	exit 1;
fi

# termcap
if [ -f $FILE_CAP ]; then
  echo remove old mgterm entry.
  # remove 1st
    if grep "^mgterm" $FILE_CAP > /dev/null ; then
    sed -e '/^#.*mgterm/d' $FILE_CAP | \
    sed -e '/^mgterm/,/[^\\]$/d' > $FILE_CAP.new
    mv $FILE_CAP $FILE_CAP.orig
    mv $FILE_CAP.new $FILE_CAP
  fi

  # add last

  echo add new mgterm entry.
  cat $MGTERM >> $FILE_CAP
  if [ -f /usr/bin/cap_mkdb -a -f $FILE_CAP.db ] ; then
    echo -n building database ...
    /usr/bin/cap_mkdb $FILE_CAP
    echo done.
  fi
fi

# terminfo
if [ -f /usr/bin/captoinfo -a -f /usr/bin/tic ]; then
	if [ -d $FILE_INFO ]; then
		echo build terminfo entry
		TERMINFO=$FILE_INFO
		export TERMINFO
		/usr/bin/captoinfo $MGTERM > /tmp/$$.src
		tic /tmp/$$.src
		rm -f /tmp/$$.src
	fi
fi
