/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <vga.h>
#include <vgamouse.h>

static int show_mouse=1;
const static int same_format=0;
#define MD_PUT_SCANSEGMENT(dst_y,dst_x,src,nbytes)

static int graph_mode = 8;
static int alloc_color();

static void MD_GRAPH_MODE() {
	vga_screenoff();
	vga_setmode(graph_mode);
	alloc_color();
	vga_screenon();
}

static void MD_TEXT_MODE() {
	vga_screenoff();
	vga_setmode(TEXT);
	vga_screenon();
}

static int MD_INIT() {
printf("md_svga init\n");
	vga_setmousesupport(1);
	vga_init();

	if ((SCREEN_WIDTH <= 240) && (SCREEN_HEIGHT > 240)) {
	    if (!vga_setmode(graph_mode=G320x240x256)) {
		SCREEN_WIDTH = 240;
		SCREEN_HEIGHT = 320;
		depth = 8; 
		rotated = 1;
		goto success;
	    }
	}
	if ((SCREEN_WIDTH > 320) && (SCREEN_HEIGHT >= 240)) {
	    if (!vga_setmode(graph_mode=G640x480x256)) {
		SCREEN_WIDTH = 640;
		SCREEN_HEIGHT = 480;
		depth = 8; 
		goto success;
	    }
printf("G640x480x256 not supported\n");
	    if (!vga_setmode(graph_mode=G640x480x16)) {
		SCREEN_WIDTH = 640;
		SCREEN_HEIGHT = 480;
		depth = 4; 
		goto success;
	    }
printf("G640x480x16 not supported\n");
	}
	if (!vga_setmode(graph_mode=G320x240x256)) {
		SCREEN_WIDTH = 320;
		SCREEN_HEIGHT = 240;
		depth = 8; 
		goto success;
	}
	return -1;
success:
	alloc_color();
	return 0;
}


static void MD_TERM() {
	vga_setmode(TEXT);
}


#define MD_SET_MOUSEXY	mouse_setposition
#define MD_MOUSE_EVENT	mouse_update
#define MD_MOUSE_X	mouse_getx
#define MD_MOUSE_Y	mouse_gety
static int  MD_MOUSE_BUTTON() {return (mouse_getbutton() & MOUSE_LEFTBUTTON);}

#define R_MAX	0xb8
#define R_MIN	0x17
#define G_MAX	0xcc
#define G_MIN	0x19
#define B_MAX	0xc3
#define B_MIN	0x14

static int alloc_color() {
    int i,j;
    int hue,sat,bri;
    int c,c2,r,g,b;
    int status; 
    int alloc_num = 0;

    if (depth == 4) {
	  vga_setpalette(0,0,0,0);
	  vga_setpalette(1,0x55,0x55,0x55);
	  vga_setpalette(2,0xaa,0xaa,0xaa);
	  vga_setpalette(3,0xff,0xff,0xff);
	  return 0;
    }
    for (i=0; i<192; i++) {
	  c = CONV_FROM_COL192(i);
	  unpackMC(c,hue,sat,bri);
	  c2 = mc_to_rgb(c);
	  unpackRGB(c2,r,g,b);

	  r |= r << 4;
	  g |= g << 4;
	  b |= b << 4;

	  vga_setpalette(i,r,g,b);
	  alloc_num++;
    }
    return 0;
}

static void MD_PUT_PIXSTREAM8(int x,int y,int *buf,int xs,int dir,int op) {
	int i,c;
	unsigned char obuf[1024];
	unsigned char *pcolor = obuf;
	for (i=0; i<=xs; i++,pcolor++) {
		c = (*buf++) & 0xfff;
              	*pcolor = CONV_TO_COL192(c);
	}
	vga_drawscansegment(obuf,x,y,xs);
}

static void MD_PUT_PIXSTREAM2(int x,int y,int *buf,int xs,int dir,int op) {
	int i,c;
	unsigned char obuf[1024];
	unsigned char *pcolor = obuf;
	for (i=0; i<=xs; i++,pcolor++) {
		c = (*buf++) & 0xfff;
              	*pcolor = CONV_TO_COL4(c);
	}
	vga_drawscansegment(obuf,x,y,xs);
}

static void MD_PUT_PIXSTREAM4(int x,int y,int *buf,int xs,int dir,int op) {
}

static void MD_PUT_PIXSTREAM16(int x,int y,int *buf,int xs,int dir,int op) {
}
