/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include "mgl2.h"
#include "mglcol.h"

extern struct screen *physical_screen,*current_screen;
extern char *base76_chars;

struct xpm_context {
    struct physical_col {
	char used;
	char id;
	short col;
	char rgb[8];
    } phys_col[76];
    int col_num;
    int used_col;
    short col_ind[256];
    short xpm_ind[256];
};

int write_screen_xpm(char *name, struct screen *ss) {
    struct xpm_context xc;
    struct screen *s;
    int i,j;
    int hue,sat,bri;
    int c,c2,r,g,b;
    int x,y,w,h;
    int need_free = 0;
    char *p;
    FILE *fp;
    char buf[256];

    strcpy(buf,name);
    strcat(buf,".xpm");
    fp = fopen(buf,"w");
    if (fp == NULL) return (-1);
    if (ss == NULL) ss = current_screen;
    push_screen(ss);
    c = get_pixel(0,0,0);
    pop_screen();
    if (c & COLOR_DITHER) {
	s = create_memscreen(ss->width,ss->height,NULL,STK_GENERIC_192COLOR,0);
	if (!s) return (-1);
	bitblt(s,0,0,ss,0,0,ss->width,ss->height,0);
        need_free = 1;
    } else {
	s = ss;
    }

    xc.used_col = 0;
    xc.col_num = 0;
    for (i=0; i<192; i++) {
	  c = CONV_FROM_COL192(i);
	  unpackMC(c,hue,sat,bri);
	  if ((sat == 0) && (hue != 0)) {
		continue;
	  }
	  if (sat > bri) {
		continue;
	  }
	  c2 = mc_to_rgb(c);
	  unpackRGB(c2,r,g,b);
	  r |= (r << 4);
	  g |= (g << 4);
	  b |= (b << 4);
	  sprintf(xc.phys_col[xc.col_num].rgb,"#%02x%02x%02x",r,g,b);
	  xc.phys_col[xc.col_num].used = 0;
	  xc.phys_col[xc.col_num].id = 0;
	  xc.col_ind[i] = xc.col_num;
	  xc.col_num++;
    }
    for (i=0; i<192; i++) {
	  c = CONV_FROM_COL192(i);
	  unpackMC(c,hue,sat,bri);
	  if ((sat == 0) && (hue != 0)) {
		hue = 0;
		c2 = packMC(hue,sat,bri);
		j = CONV_TO_COL192(c2);
		xc.col_ind[i] = xc.col_ind[j];
	  }
	  if (sat > bri) {
		sat = bri;
		c2 = packMC(hue,sat,bri);
		j = CONV_TO_COL192(c2);
		xc.col_ind[i] = xc.col_ind[j];
	  }
    }
    for (; i<256; i++) {
	xc.col_ind[i] = xc.col_ind[0];
    }
    p = base76_chars;
    for (i=0; i<xc.col_num; i++) {
	xc.phys_col[i].id = *p++;
   }
   /* scan_colors */
    h = s->height;
    w = s->width;
    push_screen(s);
    for (y=0; y<h; y++) for (x=0; x<w; x++) {
	c = get_pixel(x,y,0);
	c = CONV_TO_COL192(c) & 0xff;
	xc.phys_col[xc.col_ind[c]].used = 1;
    }
    for (i=0; i< xc.col_num; i++) {
	if (xc.phys_col[i].used) xc.used_col++;
    }
    fprintf(fp,"/* XPM */\n");
    fprintf(fp,"static char *%s_xpm[] = {\n",name);
    fprintf(fp,"\"%d %d %d 1\",\n",w,h,xc.used_col);
    for (i=0; i< xc.col_num; i++) {
	if (xc.phys_col[i].used) {
		fprintf(fp,"\"%c c %s\",\n",xc.phys_col[i].id
			,xc.phys_col[i].rgb);
	}
    }
    for (y=0; y<h; y++) {
	fprintf(fp,"\"");
    	for (x=0; x<w; x++) {
		c = get_pixel(x,y,0);
		c = CONV_TO_COL192(c) & 0xff;
		i = xc.col_ind[c];
		fprintf(fp,"%c",xc.phys_col[i].id);
	}
	fprintf(fp,"\",\n");
    }
    fprintf(fp,"};\n");
    pop_screen();
    fclose(fp);
    if (need_free)
    	free_screen(s);
    return 0;
}

struct screen * conv_screen_from_xpm(char *xpm[],int kind) {
   struct xpm_context xc;
   struct screen *s;
   int i,j,x,y,w,h,c,d,idx;
   int col,r,g,b;
   char *p;
   char rgb[32];

   for (c=0; c<256; c++) {
   	xc.xpm_ind[c] = 0;
   }
   idx = 0;
   if (!xpm[idx]) return NULL;
   if (sscanf(xpm[idx++],"%d %d %d %d",&w,&h,&xc.col_num,&c) != 4) {
	return NULL;
   }
   if ((c != 1) || (xc.col_num > 76)) return NULL;
   for (j=0; j<xc.col_num; j++) {
	if (!xpm[idx]) return NULL;
	if (sscanf(xpm[idx++],"%c %c %7s",&c,&d,&rgb) != 3) return NULL;
	if (d != 'c') return NULL;
	if ((strlen(rgb) != 7) || (rgb[0] != '#') ) return NULL;
	strcpy(xc.phys_col[j].rgb,rgb);
	rgb[2] = 0;
	rgb[0] = xc.phys_col[j].rgb[1];
	rgb[1] = xc.phys_col[j].rgb[2];
	if (sscanf(rgb,"%02x",&r) != 1) return NULL;
	rgb[0] = xc.phys_col[j].rgb[3];
	rgb[1] = xc.phys_col[j].rgb[4];
	if (sscanf(rgb,"%02x",&g) != 1) return NULL;
	rgb[0] = xc.phys_col[j].rgb[5];
	rgb[1] = xc.phys_col[j].rgb[6];
	if (sscanf(rgb,"%02x",&b) != 1) return NULL;
//printf("%c(%d) %02x%02x%02x\n",c,c,r,g,b);
	r >>= 4;
	g >>= 4;
	b >>= 4;
	col = packRGB(r,g,b);
	col = mc_from_rgb(col);

	xc.phys_col[j].id = c;
	xc.phys_col[j].col = col;

	xc.xpm_ind[c & 0xff] = j;
   }
   s = create_memscreen(w,h,NULL,kind,0);
   if (!s) return NULL;
   push_screen(s);
   for (y=0; y<h; y++) {
	if (!xpm[idx]) break;
	p = xpm[idx++];
	for (x=0; (x < w) && (*p) ; x++,p++) {
		col = xc.phys_col[xc.xpm_ind[*p & 0xff]].col;
		put_pixel(x,y,col);
        }
   }
//printf("read done w %d h %d\n",x,y);
   pop_screen();
   return s;
}

void write_screen_native(char *name, struct screen *ss) {
	int y,i;
	FILE *fp;
	char buf[256];
	char *bitmap;
	struct screen *s;

	if (ss == NULL) ss = current_screen;
	s = create_memscreen(ss->width,ss->height,NULL,STK_GENERIC_4COLOR,0);
	if (!s) return;
	bitblt(s,0,0,ss,0,0,ss->width,ss->height,0);

	strcpy(buf,name);
	strcat(buf,".h");
	fp = fopen(buf,"w");

	push_screen(s);
	fprintf(fp,"static struct screen %s = {\n",name);
	fprintf(fp,"%d,%d,%d,%d,\n",0,s->wbytes,s->width,s->height);
	for (y=0; y< s->height; y++) {
		fprintf(fp,"\"");
		for (i=0;i<s->wbytes;i++) {
			bitmap = (char *)s->bitmap;
			fprintf(fp,"\\x%02x",bitmap[s->wbytes*y+i] & 0xff);
		}
		fprintf(fp,"\"\n");
	}
	fprintf(fp,"};\n");
	pop_screen();
	fclose(fp);
	free_screen(s);
	return;
}

