/* 
pixel 

[0][1][2][3][4][5][6][7]

normal order
             MSB      LSB
p[0]         [3][2][1][0]
p[1]         [7][6][5][4]


reversed order
             MSB      LSB
p[0]         [0][1][2][3]
p[1]         [4][5][6][7]


normal color
	0  -> BALCK  15 -> WHITE
reversed color
	0  -> WHITE  15 -> BLACK
*/

#define ORD4_NORMAL	0
#define ORD4_REVERSE	1
#define COL4_NORMAL	0
#define COL4_REVERSE	1


static char fb4_ctable[256];
static char *fb4_base;
static int fb4_rowbytes;

static fb4_setup_ctable(int revord,int revcol) {
	int x,c;
	int in,out;
	for (in=0; in<256; in++) {
		out = 0;
		for (x=0; x<2; x++) {
			c = (in >> (x*4)) & 0x0f;
			if (revcol) c = 15 - c;
			if (revord) {
			    out <<= 4;
			    out |= c;
			} else {
			    out >>= 4;
			    out |= (c << 4);
			}
		}
		fb4_ctable[in] = out;
	}
        return;
}

static fb4_setup(char *base,int rowbytes,int revord,int revcol) {
	fb4_base = base;
	fb4_rowbytes = rowbytes;
	fb4_setup_ctable(revord,revcol);
}

static void fb4_put_pixstream(int x,int y,int *buf,int xs,int dir, int op) {
	char *pcolor;
	int i;
	int c1,c2;
	xs /= 2;
	pcolor = fb4_base + fb4_rowbytes * y + x/2;
	for (i=0; i< xs; i++,pcolor++) {
 		c1 = ((buf[0] & 0x0f)     )
		   | ((buf[1] & 0x0f) << 4);
		*pcolor = fb4_ctable[c1];
		buf += 2;
	}
}

#if 1
/* COL4_REVERSE */

/* for OPTIMIZE_FOR=OPTTYPE_ARM */
static inline void fb4_put_scansegment(int dst_y, int dst_x, char* src, int nbytes){
    int i;
    char* dp = fb4_base + fb4_rowbytes * dst_y + dst_x;
    char* sp = src;

    if(nbytes & 0x3){ nbytes--; *dp++ = ~ *sp++; }
    if(nbytes & 0x3){ nbytes--; *dp++ = ~ *sp++; }
    if(nbytes & 0x3){ nbytes--; *dp++ = ~ *sp++; }
    if((((int)sp | (int)dp) & 0x3)){
	char* end_p = sp + nbytes;
	while(end_p > sp){ *dp++ = ~ *sp++; }
    }else{
	int* dp_w  = (int *)dp;
	int* sp_w  = (int *)sp;
	int* end_p = (int *)(sp + nbytes);
	while(end_p > sp_w){ *dp_w++ = ~ *sp_w++; }
    }
}

#else
/* COL4_NORMAL */
static inline void fb4_put_scansegment(int dst_y, int dst_x, char* src, int nbytes){
    memcpy(fb4_base + fb4_rowbytes * dst_y + dst_x, src, nbytes);
}
#endif
