/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 *	SATO Kazumi (sato@netbsd.org)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <dev/wscons/wsksymdef.h>
static int
sym_convert(int sym) {
	switch(sym) {
		case KS_1:		return '1';
		case KS_2:		return '2';
		case KS_3:		return '3';
		case KS_4:		return '4';
		case KS_5:		return '5';
		case KS_6:		return '6';
		case KS_7:		return '7';
		case KS_8:		return '8';
		case KS_9:		return '9';
		case KS_0:		return '0';
		case KS_a:		return 'a';
		case KS_b:		return 'b';
		case KS_c:		return 'c';
		case KS_d:		return 'd';
		case KS_e:		return 'e';
		case KS_f:		return 'f';
		case KS_g:		return 'g';
		case KS_h:		return 'h';
		case KS_i:		return 'i';
		case KS_j:		return 'j';
		case KS_k:		return 'k';
		case KS_l:		return 'l';
		case KS_m:		return 'm';
		case KS_n:		return 'n';
		case KS_o:		return 'o';
		case KS_p:		return 'p';
		case KS_q:		return 'q';
		case KS_r:		return 'r';
		case KS_s:		return 's';
		case KS_t:		return 't';
		case KS_u:		return 'u';
		case KS_v:		return 'v';
		case KS_w:		return 'w';
		case KS_x:		return 'x';
		case KS_y:		return 'y';
		case KS_z:		return 'z';
		case KS_A:		return 'A';
		case KS_B:		return 'B';
		case KS_C:		return 'C';
		case KS_D:		return 'D';
		case KS_E:		return 'E';
		case KS_F:		return 'F';
		case KS_G:		return 'G';
		case KS_H:		return 'H';
		case KS_I:		return 'I';
		case KS_J:		return 'J';
		case KS_K:		return 'K';
		case KS_L:		return 'L';
		case KS_M:		return 'M';
		case KS_N:		return 'N';
		case KS_O:		return 'O';
		case KS_P:		return 'P';
		case KS_Q:		return 'Q';
		case KS_R:		return 'R';
		case KS_S:		return 'S';
		case KS_T:		return 'T';
		case KS_U:		return 'U';
		case KS_V:		return 'V';
		case KS_W:		return 'W';
		case KS_X:		return 'X';
		case KS_Y:		return 'Y';
		case KS_Z:		return 'Z';

		case KS_Caps_Lock:	return MGL_SKM_CAPS;
		case KS_Shift_L:	return MGL_SKM_SHIFT;
		case KS_Shift_R:	return MGL_SKM_RSHIFT;
		case KS_Alt_L:		return MGL_SKM_ALT;
		case KS_Alt_R:		return MGL_SKM_RALT;
		case KS_Control_L:	return MGL_SKM_CTRL;
		case KS_Control_R:	return MGL_SKM_RCTRL;
		case KS_Menu:		return MGL_SKM_MENU;

		case KS_exclam:		return '!';
		case KS_quotedbl:	return '"';
		case KS_numbersign:	return '#';
		case KS_dollar:		return '$';
		case KS_percent:	return '%';
		case KS_ampersand:	return '&';
		case KS_apostrophe:	return '\'';
		case KS_asterisk:	return '*';
		case KS_parenleft:	return '(';
		case KS_parenright:	return ')';
		case KS_minus:		return '-';
		case KS_plus:		return '+';
		case KS_equal:		return '=';
		case KS_asciicircum:	return '^';
		case KS_asciitilde:	return '~';
		case KS_at:		return '@';
		case KS_bracketleft:	return '[';
		case KS_bracketright:	return ']';
		case KS_braceleft:	return '{';
		case KS_braceright:	return '}';
		case KS_semicolon:	return ';';
		case KS_colon:		return ':';
		case KS_comma:		return ',';
		case KS_less:		return '<';
		case KS_period:		return '.';
		case KS_greater:	return '>';
		case KS_slash:		return '/';
		case KS_question:	return '?';
		case KS_space:		return ' ';
		case KS_bar:		return '|';
		case KS_backslash:	return '\\';
		case KS_underscore:	return '_';
		case KS_grave:		return '`';

		case KS_Escape:		return '\e';
		case KS_BackSpace:	return '\b';
		case KS_Tab:		return '\t';
		case KS_Return:		return '\r';

		case KS_F1:		return MK_F1;
		case KS_F2:		return MK_F2;
		case KS_F3:		return MK_F3;
		case KS_F4:		return MK_F4;
		case KS_F5:		return MK_F5;
		case KS_F6:		return MK_F6;
		case KS_F7:		return MK_F7;
		case KS_F8:		return MK_F8;
		case KS_F9:		return MK_F9;
		case KS_F10:		return MK_F10;
		case KS_F11:		return MK_F11;
		case KS_F12:		return MK_F12;

		case KS_f1:		return MK_F1;
		case KS_f2:		return MK_F2;
		case KS_f3:		return MK_F3;
		case KS_f4:		return MK_F4;
		case KS_f5:		return MK_F5;
		case KS_f6:		return MK_F6;
		case KS_f7:		return MK_F7;
		case KS_f8:		return MK_F8;
		case KS_f9:		return MK_F9;
		case KS_f10:		return MK_F10;
		case KS_f11:		return MK_F11;
		case KS_f12:		return MK_F12;

		case KS_Left:		return MK_LEFT;
		case KS_Right:		return MK_RIGHT;
		case KS_Up:		return MK_UP;
		case KS_Down:		return MK_DOWN;
		case KS_Insert:		return MK_INS;
		case KS_Delete:		return 0x7f;
		case KS_Prior:		return MK_PAGE_UP;
		case KS_Next:		return MK_PAGE_DOWN;

		case KS_KP_0:		return MKE_0;
		case KS_KP_1:		return MKE_1;
		case KS_KP_2:		return MKE_2;
		case KS_KP_3:		return MKE_3;
		case KS_KP_4:		return MKE_4;
		case KS_KP_5:		return MKE_5;
		case KS_KP_6:		return MKE_6;
		case KS_KP_7:		return MKE_7;
		case KS_KP_8:		return MKE_8;
		case KS_KP_9:		return MKE_9;
		case KS_KP_Add:		return MKE_PLUS;
		case KS_KP_Subtract:	return MKE_MINUS;
		case KS_KP_Multiply:	return MKE_MULT;
		case KS_KP_Divide:	return MKE_DIV;
#if 0
		case KS_Break:		return MKE_BREAK;
#endif
		case KS_Zenkaku_Hankaku: return MKE_HANZEN;
		case KS_Henkan:		return MKE_HENKAN;
		case KS_Muhenkan:	return MKE_MUHENKAN;
		case KS_Num_Lock:	return MK_NUMLOCK;
		case KS_Hold_Screen:	return MKE_SCRLOCK;
		case KS_Select:		return MKE_SELECT;
		case KS_KP_Delete:	return MK_DEL;
		case KS_KP_Home:	return MK_HOME;
		case KS_Print_Screen:	return MKE_PRINT;
		case KS_Pause:		return MKE_PAUSE;
		case KS_KP_End:		return MK_END;
		case KS_KP_Enter:	return MKE_RETURN;
		case KS_KP_Up:		return MK_UP;
		case KS_KP_Down:	return MK_DOWN;
		case KS_KP_Right:	return MK_RIGHT;
		case KS_KP_Left:	return MK_LEFT;
		case KS_KP_Prior:	return MK_PAGE_UP;
		case KS_KP_Next:	return MK_PAGE_DOWN;
		case KS_KP_Insert:	return MK_INS;
		case KS_Execute:	return MKE_EXECUTE;
		case KS_KP_Begin:	return MKE_BEGIN;

		case KS_F13:		return MKE_F13;
		case KS_F14:		return MKE_F14;
		case KS_F15:		return MKE_F15;
		case KS_F16:		return MKE_F16;
		case KS_F17:		return MKE_F17;
		case KS_F18:		return MKE_F18;
		case KS_F19:		return MKE_F19;
		case KS_F20:		return MKE_F20;
	}
	return MK_NONE;
}

sym_convert_cmd(int sym) {
	switch(sym) {
		case KS_Cmd_Screen0:		return MKE_CONSOLE_1;
		case KS_Cmd_Screen1:		return MKE_CONSOLE_2;
		case KS_Cmd_Screen2:		return MKE_CONSOLE_3;
		case KS_Cmd_Screen3:		return MKE_CONSOLE_4;
		case KS_Cmd_Screen4:		return MKE_CONSOLE_5;
		case KS_Cmd_Screen5:		return MKE_CONSOLE_6;
		case KS_Cmd_Screen6:		return MKE_CONSOLE_7;
		case KS_Cmd_Screen7:		return MKE_CONSOLE_8;
		case KS_Cmd_Screen8:		return MKE_CONSOLE_9;
		case KS_Cmd_Screen9:		return MKE_CONSOLE_10;
#ifdef KS_Cmd_BacklightToggle
		case KS_Cmd_BacklightToggle: 	return MKE_BACKLIGHT_TOGGLE;
#endif
#ifdef KS_Cmd_BrightnessUp
		case KS_Cmd_BrightnessUp:	return MKE_BRIGHTNESS_UP;
		case KS_Cmd_BrightnessDown:	return MKE_BRIGHTNESS_DOWN;
#endif
#ifdef KS_Cmd_ContrastUp
		case KS_Cmd_ContrastUp:		return MKE_CONTRAST_UP;
		case KS_Cmd_ContrastDown:	return MKE_CONTRAST_DOWN;
#endif
	}
	return MK_NONE;
}

static int create_keymap() {
	struct wskbd_map_data map;
	struct wscons_keymap keymap[512];
	int ret;
	int i,n;
	int sym1,sym2,sym3;
	int fd;

	mk_init();

	map.maplen = 512;
	map.map = keymap;

	if ((fd = open("/dev/wskbd0", O_WRONLY)) < 0) {
		ret = ioctl(mgl_keyboard_fd, WSKBDIO_GETMAP, &map);
	} else {
		printf("using /dev/wskbd0\n");
		ret = ioctl(fd, WSKBDIO_GETMAP, &map);
		close(fd);
	}
	if (ret < 0) {
		perror("WSKBDIO_GETMAP");
		return (-1);
        }
	
	for (i=0; i<= 128; i++) {
		sym1 = sym_convert(keymap[i].group1[0]);
		sym2 = sym_convert(keymap[i].group1[1]);
		if (sym2 == MK_NONE) sym2 = sym1;
		mgl_keymap[i][0] = sym1;
		mgl_keymap[i][1] = sym2;
		sym3 = sym_convert_cmd(keymap[i].command);
		if (sym3 != MK_NONE) {
			mgl_keymap[i][2] = sym3;
		}
	}
	for (; i<= map.maplen; i++) {
		if ((mgl_keymap[i&0x7f][0] != MK_NONE) 
		   || (mgl_keymap[i&0x7f][1] != MK_NONE))
			continue;
		sym1 = sym_convert(keymap[i].group1[0]);
		sym2 = sym_convert(keymap[i].group1[1]);
		if (sym2 == MK_NONE) sym2 = sym1;
		mgl_keymap[i&0x7f][0] = sym1;
		mgl_keymap[i&0x7f][1] = sym2;
	}
#if 0
mk_dump_keymap("xkeymap");
#endif
	mk_create_raw_keymap();
	modify_keymap_for_mglsvr();
#if 0
mk_dump_keymap("mglmap ");
#endif
}
