/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#define NPAI	(39)
#define PAI_W   16
#define PAI_H   21

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mgl2.h"
#include "pai0.h"
#include "pai1.h"
#include "pai2.h"
#include "pai3.h"

void show_bitmap(void);
void test1(void);
void draw_pai(int *xp,int *yp,int dir,int pai,int mode);

struct screen *s1;
struct screen *s2;
struct screen *s3;
struct screen *s4;

int main() {
	open_graph();
	set_color(COLOR_WHITE);
	clear_screen();

	s1 = conv_screen_from_v1(&pai0,STK_NATIVE);
	s2 = conv_screen_from_v1(&pai1,STK_NATIVE);
	s3 = conv_screen_from_v1(&pai2,STK_NATIVE);
	s4 = conv_screen_from_v1(&pai3,STK_NATIVE);
	show_bitmap();
refresh();
	get_key(-1);

	clear_screen();
	test1();
refresh();
	get_key(-1);

	
	printf("current_screen->need_clipping = %d\n",current_screen->need_clipping);
#if 0
	close_graph();
#else
	exit(0);
#endif
}


void show_bitmap() {
	bitblt(NULL,PAI_H*4,0,s1,0,0,-1,-1,0);
	bitblt(NULL,PAI_H*5+PAI_W*10,PAI_H*3,s2,0,0,-1,-1,0);
	bitblt(NULL,PAI_H*4,SCREEN_HEIGHT-PAI_H*4,s3,0,0,-1,-1,0);
	bitblt(NULL,PAI_H*5+PAI_W*10,PAI_H*7,s4,0,0,-1,-1,0);
}

int pai_map[] = {
	37,38,39,39,
	 0, 0, 0, 0,
	 1, 1, 1, 1,
	 2, 2, 2, 2,
	 3, 3, 3, 3,
	 9, 4, 4, 4,
	 5, 5, 5, 5,
	 6, 6, 6, 6,
	 7, 7, 7, 7,
	 8, 8, 8, 8,
	10,10,10,10,
	11,11,11,11,
	12,12,12,12,
	13,13,13,13,
	19,14,14,14,
	15,15,15,15,
	16,16,16,16,
	17,17,17,17,
	18,18,18,18,
	20,20,20,20,
	21,21,21,21,
	22,22,22,22,
	23,23,23,23,
	29,24,24,24,
	25,25,25,25,
	26,26,26,26,
	27,27,27,27,
	28,28,28,28,
	30,30,30,30,
	31,31,31,31,
	32,32,32,32,
	33,33,33,33,
	34,34,34,34,
	35,35,35,35,
	36,36,36,36,
};

void draw_pai(xp,yp,dir,pai,mode) int *xp,*yp;{
	int x,y,px,py;
	int i;
	int dx,dy;
	struct screen *s=s1;
	int ami = pai & ~0xff;

	pai &= 0xff;
	x = *xp;
	y = *yp;
	set_color(COLOR_BLACK);
	dx =((dir & 1)?PAI_H:PAI_W);
	dy =((dir & 1)?PAI_W:PAI_H);
	i = pai_map[pai];
	px = (i % 10) * dx + 1;
	py = (i / 10) * dy + 1;

	switch (dir) {
	case 0: s=s1; *xp += PAI_W -2;
		y -= PAI_H -2;
		break; 
	case 1: s=s2; *yp -= PAI_W -2;
		x -= PAI_H -2; y -= PAI_W - 2;
		break; 
	case 2: s=s3; *xp -= PAI_W -2;
		x -= PAI_W -2;
		break; 
	case 3: s=s4; *yp += PAI_W -2;
		break; 
	}
	bitblt(NULL,x,y,s,px,py,dx-2,dy-2,0);
	if (ami) 
	bitblt(NULL,x,y,s,8*dx,3*dy,dx-2,dy-2,BLT_MASKING|1);
	x -= 1; y -= 1;
	dy-=1; dx-=1;
	if (mode || dir != 0) {draw_line(x,y+1,x,y+dy-1);}
	if (mode || dir != 1) {draw_line(x+1,y+dy,x+dx-1,y+dy);}
	if (mode || dir != 2) {draw_line(x+dx,y+1,x+dx,y+dy-1);}
	if (mode || dir != 3) {draw_line(x+1,y,x+dx-1,y);}
}

int statposx[] = {480-50,480,480-50,480-100};
int statposy[] = {15*6,15*3,0,15*3};
char *housename[] = {"","","","̲"};
char *playername[] = {"suz","auto","auto","auto"};

char *title[] = {"Σţԣ","ͣʣ","for PocketBSD"};

struct textscreen *t;

void test1() {
	int a;
	int i;
	int x,y;
	int pai;


	set_color(COLOR_BLACK);
	set_font(12,FA_BOLD|FA_ITALIC);
	for(i=0; i<3; i++) {
		draw_string(640-8*12-4,i*14,title[i],DIR_NORTH);
	}

	set_font(12,0);
	for (i=0;i<4;i++) {
		x = statposx[i];
		y = statposy[i];
		draw_rect(x,y,100,15*3);
		draw_string(x+2,y+2,housename[i],DIR_NORTH);
		draw_string(x+2,y+2+14,playername[i],DIR_NORTH);
		draw_string(x+2,y+2+28,"25000",DIR_NORTH);
	}

	x = 25; y = 224 - 1;
	for (i=0; i<14; i++) {
		pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,0,pai,i==0);
	}
	for (a=0;a<3;a++) {
		x = 160-14*3; y = 223 - 1 - (a+1)*22;
		for (i=0; i<((a==0)?8:6); i++) {
			pai = (rand() & 0x7fffffff) % (34*4) + 4;
			draw_pai(&x,&y,0,pai,i==0);
		}
	}

	y = 1;
	x = 320 -25;
	pai = 0;
	for (i=0; i<14; i++) {
		pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,2,pai,i==0);
	}
	for (a=0;a<3;a++) {
		x = 160+14*3; y = 1 + (a+1)*22;
		for (i=0; i<((a==0)?8:6); i++) {
			pai = (rand() & 0x7fffffff) % (34*4) + 4;
			draw_pai(&x,&y,2,pai,i==0);
		}
	}
	y = 224 -1;
	x = 320 -1;
	pai = 0;
	for (i=0; i<14; i++) {
		pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,1,pai,i==0);
	}
	for (a=0;a<3;a++) {
		y = 112+14*3; x = 320 -2 - (a+1)*22;
		for (i=0; i<((a==0)?8:6); i++) {
			pai = (rand() & 0x7fffffff) % (34*4) + 4;
			draw_pai(&x,&y,1,pai,i==0);
		}
	}
	y = 1;
	x = 1;
	pai = 0;
	for (i=0; i<14; i++) {
		pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,3,pai,i==0);
	}
	for (a=0;a<3;a++) {
		y = 112-14*3; x = 1 + (a+1)*22;
		for (i=0; i<((a==0)?8:6); i++) {
			pai = (rand() & 0x7fffffff) % (34*4) + 4;
			draw_pai(&x,&y,3,pai,i==0);
		}
	}
	draw_rect(88,88,320-88-88-1,224-88-88-1);
#if 0
	draw_rect(88+2,88+2,320-88-88-4,224-88-88-4);
#endif
	y = 112-1; x = 320-88-14*5-5;
	for(i=0;i<5;i++) {
		pai=0;
		if (i==0) pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,0,pai,i==0);
	}
	y = 112+21-1; x = 320-88-14*5-5;
	for(i=0;i<5;i++) {
		pai=0;
		draw_pai(&x,&y,0,pai,i==0);
	}
	set_font(12,0);
	set_color(COLOR_BLACK);
	x = 88+3; y = 88+3;
	draw_string(x,y,"죱",DIR_NORTH);
	x = 88+3; y = 88+3+14;
        draw_string(x,y," 61",DIR_NORTH);
	x = 88+3; y = 88+3+14*2;
        draw_string(x,y," 1000",DIR_NORTH);

refresh();
	get_key(-1);
	y = 1;
	x = 1;
	pai = 0;
	for (i=0; i<14; i++) {
		pai = (rand() & 0x7fffffff) % (34*4) + 4;
		draw_pai(&x,&y,3,/*pai*/0,i==0);
	}
	for (a=0;a<3;a++) {
		y = 112-14*3; x = 1 + (a+1)*22;
		for (i=0; i<((a==0)?8:6); i++) {
			pai = (rand() & 0x7fffffff) % (34*4) + 4;
			draw_pai(&x,&y,3,pai|0x100,i==0);
		}
	}
refresh();
	get_key(-1);
	t = create_textscreen(NULL,320-24-12*4-8,224-24-12-8,12*4+8,12+8,TS_SAVE|TS_BORDER|TS_BLINE);
	ts_clear(t);
	ts_put_string(t,"",0);
refresh();
	get_key(-1);
	free_textscreen(t);
	t = create_textscreen(NULL,320+4,15*9,320-8,224-15*9,TS_BORDER|TS_BLINE);
	ts_clear(t);
	ts_put_string(t,
"ϡͥåȥޡ for PocketBSD Υʥåץå\n\
ʴΤ褿餤ʤȻפäƤޤ\n\
ϡϤǤʤȡ\n\
Canna ѤȤʤʤȤʤȤƤ.... sj3 Ϥ褯狼ʤ",0);

refresh();

	for (i=0; i<3; i++) {
	        sleep(1);
		ts_put_string(t, "ïɤǥ....",0);
refresh();
	}

#if 0
	while (fgets(buf,256,stdin)!= NULL) {
		ts_put_string(t,buf,0);
	}
	write_screen_xpm("netmaj",NULL);
	write_screen_native("pai0",s1);
	write_screen_native("pai1",s2);
	write_screen_native("pai2",s3);
	write_screen_native("pai3",s4);
#endif
}
