#include "main.h"
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#define BSIZE 1024*8

long *nptr;

void stdin_do_pipe();
int stdin_is_initialized=0;
int stdin_fork=0;

long stdin_get_value()
{
	if ( ! stdin_is_initialized )
	{
		int shmid;
		shmid = shmget( IPC_PRIVATE, sizeof(long), 0660);
		//IPC_CREAT & IPC_EXCL);

		if (shmid == -1) 
		{
			fprintf(stderr,"Cannot create shared memory.\n");
			exit(1);
		}

		nptr = shmat(shmid,NULL,SHM_RND);
		if (nptr==(long *)-1) 
		{
			fprintf(stderr,"Cannot attach shared memory.\n");
			exit(2);
		}

		*nptr = 0;

		shmctl(shmid,IPC_RMID,NULL); /* destroy on detach */

		stdin_fork = fork();
		if (stdin_fork==0)
		{
			stdin_do_pipe();
			signal(SIGINT,SIG_IGN);
		}

		stdin_is_initialized=1;
	}

	return *nptr;
}

void stdin_finalize()
{
	shmdt(nptr);
	kill (stdin_fork,SIGTERM);
}

/* TODO: capture exit value from father */
void stdin_do_pipe()
{
	char buf[BSIZE];
	long n,rval,wval;
	char *bp;

	while(1)
	{
		while((rval=read(0,buf,BSIZE)) > 0)
		{
			*nptr=*nptr+rval;
			n=rval;
			bp=buf;
			do
			{
				if ((wval = write(1,bp,n)) == -1) 
				{
					fprintf(stderr,"cannot write to stdout\n");
					exit(1);
				}
				bp+=wval;
			} while(n-=wval);
		}

		if (rval==0) break;
		if (rval<0)
		{
			fprintf(stderr,"Cannot read from stdin\n");
			exit(1);
		}
	}

	exit(0);
}
