/* Copyleft@2005 - pancake@phreaker.net */

#if HAVE_PCAP

#include "main.h"
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <pcap.h>

#define BUFSIZE 65540

void sniff_do_it();
int sniff_is_initialized = 0;
int sniff_fork = 0;
pcap_t *pd = NULL;

#if HAVE_GMP
void sniff_get_value(mpz_t* ptr)
#else
unsigned long sniff_get_value()
#endif
{
	int shmid;

	if ( ! sniff_is_initialized )
	{
		shmid = shmget( IPC_PRIVATE, sizeof(long), 0660);

		if (shmid==-1) 
		{
			fprintf(stderr,"Cannot create shared memory.\n");
			exit(1);
		}

		nptr=shmat(shmid,NULL,SHM_RND);
		if (nptr==(long *)-1) 
		{
			fprintf(stderr,"Cannot attach shared memory.\n");
			exit(2);
		}

		*nptr=0;

		shmctl(shmid,IPC_RMID,NULL); /* destroy on detach */

		sniff_fork = fork();
		if (sniff_fork==0)
		{
			sniff_do_it();
		}

		sniff_is_initialized=1;
	}

#if HAVE_GMP
	if (*nptr == -1) exit(1);
	mpz_set_d(*ptr,*nptr);
#else
	if (*nptr == -1) exit(1);
	return *nptr;
#endif
}

void sniff_do_it()
{
	const u_char *packet;
	char errbuf[PCAP_ERRBUF_SIZE];
	struct pcap_pkthdr header;
	bpf_u_int32 net;
	struct bpf_program filter;
	int ret;

	pd = pcap_open_live(iface,BUFSIZE,promisc,69,errbuf);
	if (pd == NULL)
	{
		fprintf(stderr,"cannot listen on iface %s (%s)\n",iface,errbuf);
		*nptr=-1;
	}
	//printf("Using : %s , %s\n\n",iface,target);

	ret = pcap_compile(pd, &filter, target,0,net);
	if (ret == -1)
	{
		fprintf(stderr,"pcap_error: %s\n",pcap_geterr(pd));
		*nptr=-1;
	}

	pcap_setfilter(pd, &filter);

	while(1)
	{
		packet = pcap_next(pd,&header);
		if (!packet) continue;
		*nptr = *nptr + header.len;
	}
}

void sniff_finalize()
{
	if (pd == NULL) return;
	pcap_close(pd);
	pd = NULL;
	atexit(NULL);
	exit(0);
}
#endif
