/* Copleft@2004,2005 - pancake@phreaker.net */

#include "main.h"
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <unistd.h>
#if !__linux__
#include <sys/user.h>
#include <kvm.h>
#if __FreeBSD__ || __APPLE__
#define KVM_NO_FILES O_RDONLY
#endif
#endif
/*
 * .text -> code (shared memory)
 * .data -> owned by every process
 * .stack -> owened by every process
 *
 */

long
mem_get_value()
{
	long total=0;

#if __linux__
	FILE *fd;
	char var[1024];
	long val,memtotal,memfree;

	fd=fopen("/proc/meminfo","r");
	if (!fd)
	{
		printf("Cannot open /proc/meminfo.");
		exit(1);
	}

	while(!feof(fd))
	{
		fscanf(fd,"%s %ld kB",var,&val);
		if (!strcmp(var,"MemTotal:"))
		{
			memtotal=val;
		}
		else if (!strcmp(var,"MemFree:"))
		{
			memfree=val;
		}
	}
	fclose(fd);

	total=memtotal-memfree;
	total*=1024;

#else
#if __FreeBSD__ || __APPLE__
	printf("Not yet supported on FreeBSD.\n");
	exit(1);
#else
	// NetBSD
	kvm_t *kd;
	struct kinfo_proc *kp;
	struct kinfo_proc2 *kp2;
	int i,cnt=0;

	//kd=kvm_openfiles(0,0,0,O_RDONLY,0);//uid=0
	kd=kvm_openfiles(0,0,0,KVM_NO_FILES,0);
	if (!kd)
		{
		printf("cannot ps\n");
		exit(1);
		}
	//kp=kvm_getprocs(kd,KERN_PROC_ALL,0,&cnt);//uid=0
	kp2=kvm_getproc2(kd,KERN_PROC_ALL,0,sizeof(struct kinfo_proc2),&cnt);
	//printf("MAX %d\n",cnt);
	total=0;
	for(i=0;i<cnt;i++)
		{
	//	printf("%d\n",kp2[i].p_vm_rssize);
		total+=kp2[i].p_vm_rssize;
		}
	//printf("TOTAL: %d\n",total);

	kvm_close(kd);
#endif
#endif
	return total;
}
