/* Copleft@2004,2005 - pancake@phreaker.net */

#include "main.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#if __FreeBSD__ || __APPLE__
#include <ifaddrs.h>
#endif
#if __NetBSD__ || __OpenBSD__
#include <ifaddrs.h>
#include <net/if_media.h>
#endif
#include <net/if.h>
#include <stdio.h>
#include "iface.h"

#if HAVE_GMP
void
iface_get_value(char *name,int type, mpz_t *size)
{
#else
unsigned long
iface_get_value(char *name,int type)
{    
	off_t size=0;
#endif
#if __linux__
	off_t null;
	char face[10];
	char buf[1025];
	char *ptr;
	FILE *fd;
#if HAVE_GMP
	mpz_t isize,osize,errors;

	mpz_init(*size);
	mpz_init(isize);
	mpz_init(osize);
	mpz_init(errors);
#else
	off_t isize,osize,errors;
#endif

	fd = fopen("/proc/net/dev","r");
	if (fd)
	{
		fgets(buf,1024,fd);
		do
		{
			fgets(buf,1024,fd);
			ptr = strchr(buf,':');
			if (ptr==0) continue;
			ptr[0] = 0; ptr = ptr+1;
			sscanf(buf,"%s",face);
#if HAVE_GMP
			gmp_sscanf(ptr,"%Zd %d %Zd %d %d %d %d %d %Zd",
				&isize,&null,&errors,&null, &null,&null,&null,&null,
				&osize);
#else
			sscanf(ptr,"%ld %ld %ld %ld %ld %ld %ld %ld %ld",
				&isize,&null,&errors,&null, &null,&null,&null,&null,
				&osize);
#endif
		} while(!feof(fd) && strcmp(face,name));


		if (feof(fd))
		{
			printf("No such network interface called '%s'.\n",name);
			fclose(fd);
			exit(1);
		}

		fclose(fd);

		switch(type)
		{
#if HAVE_GMP
		case IFACE_IN:
			mpz_set(*size,isize);
			break;
		case IFACE_OUT:
			mpz_set(*size,osize);	
			break;
		case IFACE_ERR:
			mpz_set(*size,errors);
			break;
#else
		case IFACE_IN:
			size=isize;
			break;
		case IFACE_OUT:
			size=osize;
			break;
		case IFACE_ERR:
			size=errors;
			break;
#endif
		}
	}
#else 
	/* BSD */
	struct ifaddrs *ifa=NULL;
	char *iface=0;
	struct ifmediareq ifmr;
	struct if_data *ifm;
	struct sockaddr *addr;
	int s;

#if HAVE_GMP
	mpz_init(*size);
#endif

    getifaddrs(&ifa);
    do {
       memset(&ifmr,0,sizeof(ifmr));
      strncpy(ifmr.ifm_name,ifa->ifa_name,sizeof(ifmr.ifm_name));
		addr=ifa->ifa_addr;

		if (addr->sa_family==AF_LINK)
		{
		ifm=ifa->ifa_data;

		if (!strcmp(ifa->ifa_name,name))
			{
			switch(type)
			{
#if HAVE_GMP
			case IFACE_OUT:
				mpz_set_d(*size, ifm->ifi_obytes);
				return;
			case IFACE_IN:
				mpz_set_d(*size, ifm->ifi_ibytes);
				return;
			case IFACE_ERR:
				mpz_set_d(*size, ifm->ifi_ierrors + ifm->ifi_oerrors);
				return;
#else
			case IFACE_OUT:
				return ifm->ifi_obytes;
			case IFACE_IN:
				return ifm->ifi_ibytes;
			case IFACE_ERR:
				return ifm->ifi_ierrors + ifm->ifi_oerrors;
#endif
			}
			}	
		}
        if (ifa)
            ifa=ifa->ifa_next;

    } while(ifa);
	printf("No such iface '%s'\n",name);
	exit(1);
	
#endif

#if !HAVE_GMP
	return size;
#endif
}

