/* Program  locator.cc     */
/* By Harald Stauss        */
/* Last change 29.07.2001  */

/* A few includes */
#include <iostream.h>
#include <string.h>
#include <stdio.h>

/* A few definitions */
#define VERSION "0.1"

/* Main program */
main(int argc, char *argv[]) {
  float c_long, c_lat;
  char  *locator;

  extern int GPStoLOCATOR(float gps_long, float gps_lat, char *locator);
  extern int LOCATORtoGPS(char *locator, float *gps_long, float *gps_lat);

  /* Initialization */
  cout << "Locator Ver. " VERSION " by H.M. Stauss, 2001 \n";
  locator=new char[7];
  strcpy(locator,"ZZZZZZ");

  if (argc != 2 && argc != 3) {
    cout << "Converts GPS coordinates to HAM locator or vica versa \n";
    cout << "Usage: locator XX##YY \n";
    cout << "       locator Long Lat (in decimal notation) \n";
    goto ende;
  }

  /* determine GPS coordinates */
  if (argc==2) {
    strncpy(locator,argv[1],6);
    locator[6]='\0';

    if(LOCATORtoGPS(locator, &c_long, &c_lat)!=0) {
      cout << "Locator >>> "<< locator << " <<< is not correct! \n";
      goto ende;
    }
    else {
      cout << "Locator    : " << locator << "\n";
      cout << "Coordinates: " <<
	"Long: ";
      if (c_long >0)
	cout << "(E) ";
      else
	cout << "(W) ";
      cout  << c_long << " : "<<
	"Lat : ";
      if (c_lat >0)
	cout << "(N) ";
      else
	cout << "(S) ";
      cout << c_lat << "\n";
    }
  }

  /* determine Locator */
  if (argc==3) {
    sscanf(argv[1],"%f", &c_long);
    sscanf(argv[2],"%f", &c_lat);

    if (GPStoLOCATOR(c_long, c_lat, locator)!=0) {
      cout << "GPS coordinates >>> " << c_long << " : " << c_lat << " <<< wrong! \n";
      goto ende;
    }
    else {
      cout << "GPS coordinates: " << c_long << " : " << c_lat << "\n";
      cout << "Locator        : " << locator << "\n";
    }
  }

 ende:
  delete[]locator;
  return(0);
} /* Ende von main */
