/*
 * Solaris thread mutex emulation.
 */

#include <assert.h>
#include <semaphore.h>
#include <ulocks.h>
#include <errno.h>
#include <stdio.h>
#include <sgidefs.h>
#include <mutex.h>
#include "sunthread.h"

mutex_init(mutex_t *mp, int type, void *arg)
{
	int	r;

	if (type == USYNC_PROCESS) {
		fprintf(stderr, "mutex_init: USYNC_PROCESS unsupported.\n");
		setoserror(EINVAL);
		return (-1);
	}
	mp->m_sp = (sem_t*)calloc(1, sizeof(sem_t));
	if (sem_init(mp->m_sp, 0, 1)) {
		perror("sem_open");
		return (-1);
	}
	mp->m_flags = type | _INITDONE;
	return (0);
}

static	int spins = 0;

mutex_spintime(int n)
{
	spins = n;
}

mutex_lock(mutex_t *mp) 
{
	for ( ;; ) {
		if (mp->m_flags) {
			if (mp->m_sp->psem_flags & _PSEM_FLAGS_SPINNER) {
				return (_sem_spinwait(mp->m_sp, spins));
			} else {
				return (sem_wait(mp->m_sp));
			}
		}
		if (test_and_set32(&mp->m_lock, 1) == 0) {
			if (mutex_init(mp, USYNC_THREAD, (void *)0)) {
				setoserror(EINVAL);
				mp->m_lock = 0;
				return (-1);
			}
			mp->m_lock = 0;
		}
	}
}

mutex_unlock(mutex_t *mp) 
{
	return (sem_post(mp->m_sp));
}

mutex_destroy(mutex_t *mp) 
{
	return (0);
}
