/*
 * Ostatnia aktualizacja:
 * 
 * - $Id: pubdir.c,v 1.8 2002/11/25 18:20:49 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "libtlen.h"

#define TS_NODE_STRING(tag, var) \
    { \
        xmlnode node = xmlnode_new_tag(tag); \
        char* data = tlen_encode(var); \
        xmlnode_insert_cdata(node, pstrdup(xmlnode_pool(node), data), -1); \
        xmlnode_insert_tag_node (query, node); \
        free(data); \
    }
#define TS_NODE_INT(tag, var) \
    { \
	xmlnode node = xmlnode_new_tag(tag); \
        char data[20]; \
	sprintf(data, "%d", var); \
	xmlnode_insert_cdata(node, pstrdup(xmlnode_pool(node), data), -1); \
	xmlnode_insert_tag_node (query, node); \
    }
#define TS_NODE_CLEAR(tag, var) \
    { \
        xmlnode node = xmlnode_new_tag(tag); \
        char* data = var; \
        xmlnode_insert_cdata(node, pstrdup(xmlnode_pool(node), data), -1); \
        xmlnode_insert_tag_node (query, node); \
        free(data); \
    }

/*
 * tlen_search()
 *
 * Inicjuje wyszukiwanie w katalogu publicznym
 *
 * - sesja - nasza sesja
 * - search - struktura opisujaca wyszukiwanie
 *
 * Uwagi do poniszego kodu:
 * + stringi s kopiowane za pomoc pstrdup i doczane do memory poola xmlnode'a,
 *   dziki czemu pamic po nich jest automatycznie zwalniana wraz z xmlnodem.
 * + stringi z liczbami nie s przepuszczane przez tlen_encode() bo to bez sensu
 * + pamitajcie e tlen_encode() robi kopi stringa, trzeba go potem zwolni
 * + xmlnode_insert_tag_node() docza memory pool potomka do poola rodzica,
 *   wic wystarczy xmlnode_free() na rodzicu aby zwolni pami caego drzewa.
 *   Zwalnianie pamici kadego node'a z osobna jest bez sensu i prowadzi do
 *   segfaultw.
 *
 */

int tlen_search(struct tlen_session *sesja, struct tlen_pubdir *search)
{
    xmlnode iq;
    xmlnode query;

    // przygotowanie glownych tagow
    iq = xmlnode_new_tag("iq");
    xmlnode_put_attrib(iq,"type","get");
    xmlnode_put_attrib(iq,"id","src");
    xmlnode_put_attrib(iq,"to","tuba");
    
    // przygotowujemy query
    query = xmlnode_new_tag("query");
    xmlnode_put_attrib(query,"xmlns","jabber:iq:search");
    
    // firstname
    if (search->firstname != NULL) TS_NODE_STRING("first", search->firstname);

    // lastname
    if (search->lastname != NULL) TS_NODE_STRING("last", search->lastname);

    // nick
    if (search->nick != NULL) TS_NODE_STRING("nick", search->nick);

    // email
    if (search->email != NULL) TS_NODE_STRING("email", search->email);

    // id
    if (search->id != NULL) TS_NODE_STRING("i", search->id);

    // city
    if (search->city != NULL) TS_NODE_STRING("c", search->city);

    // school
    if (search->school != NULL) TS_NODE_STRING("e", search->school);
    
    // gender
    if (search->gender != 0) TS_NODE_INT("s", search->gender);

    // status
    if (search->status != 0) TS_NODE_INT("m", search->status);

    // age_min
    if (search->age_min != 0) TS_NODE_INT("d", search->age_min);
    
    // age_max
    if (search->age_max != 0) TS_NODE_INT("u", search->age_max);

    // job
    if (search->job != 0) TS_NODE_INT("j", search->job);

    // look_for
    if (search->look_for != 0) TS_NODE_INT("r", search->look_for);

    // voice
    if (search->voice != 0) TS_NODE_INT("g", search->voice);

    // plans
    if (search->plans != 0) TS_NODE_INT("p", search->plans);

    // wpychamy do iq nasz query, i wysylamy
    xmlnode_insert_tag_node (iq, query);
    
    tlen_debug("Query to: %s\n",xmlnode2str(iq));

    tlen_socket_write_string(sesja,xmlnode2str(iq));

    xmlnode_free(iq);

    return 1;
}

/*
 * tlen_get_pubdir()
 *
 * Wysya prob o nasze dane z katalogu publicznego
 *
 * - sesja - nasza sesja
 *
 * Wraca zaraz po wysaniu zapytania
 *
 */

int tlen_get_pubdir (struct tlen_session *sesja)
{
    tlen_debug("Query sent\n");
    tlen_socket_write_string(sesja,"<iq type='get' id='tr' to='tuba'><query xmlns='jabber:iq:register'></query></iq>");
    return 1;
}

/*
 * tlen_change_pubdir()
 *
 * Wysya danie o zmian danych w katalogu publicznym
 *
 * - sesja - nasza sesja
 * - pubdir - struktura zawierajca nowe dane
 *
 * Wraca zaraz po wysaniu zapytania
 *
 */

int tlen_change_pubdir(struct tlen_session *sesja, struct tlen_pubdir *pubdir)
{
    xmlnode iq;
    xmlnode query;

    // przygotowanie glownych tagow
    iq = xmlnode_new_tag("iq");
    xmlnode_put_attrib(iq,"type","set");
    xmlnode_put_attrib(iq,"id","tw");
    xmlnode_put_attrib(iq,"to","tuba");
    
    // przygotowujemy query
    query = xmlnode_new_tag("query");
    xmlnode_put_attrib(query,"xmlns","jabber:iq:register");
    
    // firstname
    if (pubdir->firstname != NULL) TS_NODE_STRING("first", pubdir->firstname);

    // lastname
    if (pubdir->lastname != NULL) TS_NODE_STRING("last", pubdir->lastname);

    // nick
    if (pubdir->nick != NULL) TS_NODE_STRING("nick", pubdir->nick);

    // email
    if (pubdir->email != NULL) TS_NODE_STRING("email", pubdir->email);

    // city
    if (pubdir->city != NULL) TS_NODE_STRING("c", pubdir->city);

    // school
    if (pubdir->school != NULL) TS_NODE_STRING("e", pubdir->school);
    
    // gender
    TS_NODE_INT("s", pubdir->gender);

    // status visible
    TS_NODE_INT("v", pubdir->visible);

    // birthyear
    TS_NODE_INT("b", pubdir->birthyear);

    // job
    TS_NODE_INT("j", pubdir->job);

    // look_for
    TS_NODE_INT("r", pubdir->look_for);

    // voice
    TS_NODE_INT("g", pubdir->voice);

    // plans
    TS_NODE_INT("p", pubdir->plans);

    // wpychamy do iq nasz query, i wysylamy
    xmlnode_insert_tag_node (iq, query);
    
    tlen_debug("Query sent\n");

    tlen_socket_write_string(sesja,xmlnode2str(iq));

    xmlnode_free(iq);

    return 1;
}

/*
 * tlen_new_pubdir()
 *
 * Inicjuje struktur zawierajc dane typu katalog publiczny
 * (wyszukiwanie, itp.)
 *
 * - brak parametrw
 *
 * Zwraca now struktur tlen_pubdir
 *
 */

struct tlen_pubdir *tlen_new_pubdir ()
{
    struct tlen_pubdir *sercz;
    
    if (!(sercz = malloc (sizeof (*sercz))))
    {
	perror ("malloc");
	return NULL;
    }
    memset (sercz, 0, sizeof (*sercz));
    
    sercz->firstname = NULL;
    sercz->lastname = NULL;
    sercz->nick = NULL;
    sercz->gender = 0;
    sercz->city = NULL;
    sercz->email = NULL;
    sercz->age_min = 0;
    sercz->age_max = 0;
    sercz->age = 0;
    sercz->look_for = 0;
    sercz->school = NULL;
    sercz->job = 0;
    sercz->status = 0;
    sercz->voice = 0;
    sercz->id = NULL;
    sercz->plans = 0;
    sercz->visible = 0;
    sercz->birthyear = 0;
    
    return sercz;
}

/*
 * tlen_free_pubdir()
 *
 * Zwalnia pami po strukturze tlen_pubdir
 *
 * - pubdir - struktura, ktr chcemy zwolni
 *
 * Brak uwag dodatkowych
 *
 */

int tlen_free_pubdir (struct tlen_pubdir *pubdir)
{
    free(pubdir->firstname);
    free(pubdir->lastname);
    free(pubdir->nick);
    free(pubdir->city);
    free(pubdir->email);
    free(pubdir->school);
    free(pubdir->id);
    free(pubdir);

    tlen_debug("Pubdir struct freed\n");

    return 1;    
}
